/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.common;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.cob.exceptions.CustomJobParameterNotFoundException;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameter;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.stereotype.Component;

@Component
public class CustomJobParameterResolver {
    private final CustomJobParameterRepository customJobParameterRepository;
    protected Gson gson = GoogleGsonSerializerHelper.createSimpleGson();

    public void resolve(StepContribution contribution, ChunkContext chunkContext, String customJobParameterKey, String parameterNameInExecutionContext) {
        Set jobParameterDTOList = (Set)this.getCustomJobParameterSet(chunkContext.getStepContext().getStepExecution()).orElseThrow(() -> new CustomJobParameterNotFoundException("CUSTOM_JOB_PARAMETER_ID"));
        JobParameterDTO businessDateParameter = jobParameterDTOList.stream().filter(jobParameterDTO -> customJobParameterKey.equals(jobParameterDTO.getParameterName())).findFirst().orElseThrow(() -> new CustomJobParameterNotFoundException(customJobParameterKey));
        contribution.getStepExecution().getExecutionContext().put(parameterNameInExecutionContext, (Object)businessDateParameter.getParameterValue());
    }

    public Optional<Set<JobParameterDTO>> getCustomJobParameterSet(StepExecution stepExecution) {
        Long customJobParameterId = (Long)this.getJobParameters(stepExecution).get("CUSTOM_JOB_PARAMETER_ID");
        return this.customJobParameterRepository.findById(customJobParameterId).map(CustomJobParameter::getParameterJson).map(json -> (Set)this.gson.fromJson(json, new /* Unavailable Anonymous Inner Class!! */.getType()));
    }

    public Optional<String> getCustomJobParameterById(StepExecution stepExecution, String key) {
        return this.getCustomJobParameterSet(stepExecution).flatMap(paramterList -> paramterList.stream().filter(dto -> dto.getParameterName().equals(key)).findFirst()).map(JobParameterDTO::getParameterValue);
    }

    private Map<String, Object> getJobParameters(StepExecution stepExecution) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : stepExecution.getJobParameters().getParameters().entrySet()) {
            result.put((String)entry.getKey(), ((JobParameter)entry.getValue()).getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    @Generated
    public CustomJobParameterResolver(CustomJobParameterRepository customJobParameterRepository) {
        this.customJobParameterRepository = customJobParameterRepository;
    }
}

