/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.cob.data.LoanAccountLockResponseDTO;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans")
@Component
@Tag(name="Loan Account Lock", description="")
public class LoanAccountLockApiResource {
    private final LoanAccountLockService loanAccountLockService;

    @GET
    @Path(value="locked")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List locked loan accounts", description="Returns the locked loan IDs")
    public LoanAccountLockResponseDTO retrieveLockedAccounts(@QueryParam(value="page") Integer pageParam, @QueryParam(value="limit") Integer limitParam) {
        int page = Objects.requireNonNullElse(pageParam, 0);
        int limit = Objects.requireNonNullElse(limitParam, 50);
        return new LoanAccountLockResponseDTO(page, limit, this.loanAccountLockService.getLockedLoanAccountByPage(page, limit));
    }

    @Generated
    public LoanAccountLockApiResource(LoanAccountLockService loanAccountLockService) {
        this.loanAccountLockService = loanAccountLockService;
    }
}

