/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBConstant;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"test"})
@Component
@Path(value="/v1/internal/cob")
public class InternalCOBApiResource
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalCOBApiResource.class);
    private static final String DATETIME_PATTERN = "dd MMMM yyyy";
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ToApiJsonSerializer<List> toApiJsonSerializerForList;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    protected DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd MMMM yyyy");

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void afterPropertiesSet() throws Exception {
        log.warn("------------------------------------------------------------");
        log.warn("                                                            ");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("Internal client services mode is enabled");
        log.warn("DO NOT USE THIS IN PRODUCTION!");
        log.warn("                                                            ");
        log.warn("------------------------------------------------------------");
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="partitions/{partitionSize}")
    public String getCobPartitions(@Context UriInfo uriInfo, @PathParam(value="partitionSize") int partitionSize) {
        LocalDate businessDate = ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.BUSINESS_DATE);
        log.info("RetrieveLoanCOBPartitions is called with partitionSize {} for {}", (Object)partitionSize, (Object)businessDate);
        List loanCOBPartitions = this.retrieveLoanIdService.retrieveLoanCOBPartitions(LoanCOBConstant.NUMBER_OF_DAYS_BEHIND, businessDate, false, partitionSize);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerForList.serialize(settings, (Object)loanCOBPartitions);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="fast-forward-cob-date-of-loan/{loanId}")
    public void updateLoanCobLastDate(@Context UriInfo uriInfo, @PathParam(value="loanId") long loanId, String jsonBody) {
        JsonElement root = JsonParser.parseString((String)jsonBody);
        String lastClosedBusinessDate = root.getAsJsonObject().get("lastClosedBusinessDate").getAsString();
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(Long.valueOf(loanId));
        LocalDate localDate = LocalDate.parse(lastClosedBusinessDate, this.dateTimeFormatter);
        loan.setLastClosedBusinessDate(localDate);
        this.loanRepositoryWrapper.save(loan);
    }

    @Generated
    public InternalCOBApiResource(RetrieveLoanIdService retrieveLoanIdService, ApiRequestParameterHelper apiRequestParameterHelper, ToApiJsonSerializer<List> toApiJsonSerializerForList, LoanRepositoryWrapper loanRepositoryWrapper) {
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializerForList = toApiJsonSerializerForList;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
    }
}

