// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("test_query_in", "query,p0") {
    sql "SET enable_nereids_planner=true"
    sql "SET enable_fallback_to_original_planner=false"
    sql "use nereids_test_query_db"
    
    def tableName1 = "test"
    def tableName2 = "baseall"
    
    qt_in1 """select * from ${tableName1} where k1 in (1, -1, 5, 0.1, 3.000) order by k1, k2, k3, k4"""
    qt_in2 """select * from ${tableName1} where k6 in ("true") order by k1, k2, k3, k4"""
    qt_in3 """select * from ${tableName1} where k7 in ("wangjuoo4") order by k1, k2, k3, k4"""
    qt_in4 """select * from ${tableName1} where k7 in ("wjj") order by k1, k2, k3, k4"""
    qt_in5 """select * from ${tableName1} where k8 in (1, -1, 0.100, 0) order by k1, k2, k3, k4"""
    qt_in6 """select * from ${tableName1} where k9 in (-365, 100) order by k1, k2, k3, k4"""
    // Fow sql below, if all sql convert to string type, we will get empty result.
    qt_in7 """select * from ${tableName1} where k5 in
		    (123.123, 1243.5, 100, -654,6540, "0", "-0.1230")
		    order by k1, k2, k3, k4"""
    qt_in8 """select * from test where k4 in
		    (-9016414291091581975, -1, 100000000000000000000000000000000000) order by k1, k2, k3, k4"""
    qt_in9 """select * from ${tableName1} where k1 not in (1, -1, 5, 0.1, 3.000) order by k1, k2, k3, k4"""
    qt_in10 """select * from ${tableName1} where k6 not in ("true") order by k1, k2, k3, k4"""
    qt_in11 """select * from ${tableName1} where k7 not in ("wangjuoo4") order by k1, k2, k3, k4"""
    qt_in12 """select * from ${tableName1} where k7 not in ("wjj") order by k1, k2, k3, k4"""
    qt_in13 """select * from ${tableName1} where k8 not in (1, -1, 0.100, 0) order by k1, k2, k3, k4"""
    qt_in14 """select * from ${tableName1} where k9 not in (-365, 100) order by k1, k2, k3, k4"""
    qt_in15 """select * from ${tableName1} where k5 not in
		    (123.123, 1243.5, 100, -654,6540, "0", "-0.1230")
		    order by k1, k2, k3, k4"""
    qt_in16 """select * from test where k4 not in
		    (-9016414291091581975, -1, 100000000000000000000000000000000000) order by k1, k2, k3, k4"""
    qt_in17 """select NULL in (1, 2, 3)"""
    qt_in18 """select NULL in (1, NULL, 3)"""
    qt_in19 """select 1 in (2, NULL, 1)"""
    qt_in20 """select 1 in (1, NULL, 2)"""
    qt_in21 """select 1 in (2, NULL, 3)"""
    qt_in22 """select 1 in (2, 3, 4)"""
    qt_in23 """select NULL not in (1, 2, 3)"""
    qt_in24 """select NULL not in (1, NULL, 3)"""
    qt_in25 """select 1 not in (2, NULL, 1)"""
    qt_in26 """select 1 not in (1, NULL, 2)"""
    qt_in27 """select 1 not in (2, NULL, 3)"""
    qt_in28 """select 1 not in (2, 3, 4)"""
    qt_in29 """select * from ${tableName2} where k1 in (1,2,3,4) and k1 in (1)"""
    qt_in30 """select * from (select 'jj' as kk1, sum(k2) from ${tableName2} where k10 = '2015-04-02' group by kk1)tt
            where kk1 in ('jj')"""
    qt_in31 """select * from (select 'jj' as kk1, sum(k2) from ${tableName2} where k10 = '2015-04-02' group by kk1)tt
            where kk1 = 'jj'"""
    qt_in32 """select * from ${tableName1} where cast(k1 as char) in (1, -1, 5, 0.1, 3.000) order by k1, k2, k3, k4"""

    sql """DROP TABLE IF EXISTS                             table_200_undef_partitions2_keys3_properties4_distributed_by56""" 
    sql """
        CREATE TABLE `table_200_undef_partitions2_keys3_properties4_distributed_by56` (
        `col_int_undef_signed_not_null` int(11) NOT NULL,
        `col_date_undef_signed_not_null` date NOT NULL,
        `col_bigint_undef_signed_not_null` bigint(20) NOT NULL,
        `col_int_undef_signed` int(11) NULL,
        `col_bigint_undef_signed` bigint(20) NULL,
        `col_date_undef_signed` date NULL,
        `col_varchar_10__undef_signed` varchar(10) NULL,
        `col_varchar_10__undef_signed_not_null` varchar(10) NOT NULL,
        `col_varchar_1024__undef_signed` varchar(1024) NULL,
        `col_varchar_1024__undef_signed_not_null` varchar(1024) NOT NULL,
        `pk` int(11) NULL
        ) ENGINE=OLAP
        duplicate KEY(`col_int_undef_signed_not_null`, `col_date_undef_signed_not_null`, `col_bigint_undef_signed_not_null`)
        COMMENT 'OLAP'
        PARTITION BY RANGE(`col_int_undef_signed_not_null`, `col_date_undef_signed_not_null`)
        (PARTITION p VALUES [("-2147483648", '0000-01-01'), ("-1", '1997-12-11')),
        PARTITION p0 VALUES [("-1", '1997-12-11'), ("4", '2023-12-11')),
        PARTITION p1 VALUES [("4", '2023-12-11'), ("6", '2023-12-15')),
        PARTITION p2 VALUES [("6", '2023-12-15'), ("7", '2023-12-16')),
        PARTITION p3 VALUES [("7", '2023-12-16'), ("8", '2023-12-25')),
        PARTITION p4 VALUES [("8", '2023-12-25'), ("8", '2024-01-18')),
        PARTITION p5 VALUES [("8", '2024-01-18'), ("10", '2024-02-18')),
        PARTITION p6 VALUES [("10", '2024-02-18'), ("1147483647", '2056-12-31')),
        PARTITION p100 VALUES [("1147483647", '2056-12-31'), ("2147483647", '9999-12-31')))
        DISTRIBUTED BY HASH(`col_bigint_undef_signed_not_null`) BUCKETS 30
        PROPERTIES (
        "replication_allocation" = "tag.location.default: 1"
        );
    """
    sql """
        insert into table_200_undef_partitions2_keys3_properties4_distributed_by56(pk,col_int_undef_signed,col_int_undef_signed_not_null,col_bigint_undef_signed,col_bigint_undef_signed_not_null,col_date_undef_signed,col_date_undef_signed_not_null,col_varchar_10__undef_signed,col_varchar_10__undef_signed_not_null,col_varchar_1024__undef_signed,col_varchar_1024__undef_signed_not_null) values (0,-10,-10,null,858959258950266384,'2024-02-18','2027-01-09',null,'a','b','j'),(1,-10,7,null,6742353775637329154,'2023-12-12','2025-02-17','d','o','l','p'),(2,2,7,-5728564124670569750,1263875535185196830,'2023-12-12','2026-01-18','q','a','v','w'),(3,-10,1,7051047447732837092,2539536806670127406,'2023-12-09','2024-01-17','g','a',null,'q'),(4,7,7,-8634733270957194673,40291659134025903,'2024-01-17','2026-01-18','o','j','k','m'),(5,8,9,-8556392990684241659,8465118127227018191,'2024-01-09','2023-12-09',null,'d','e','j'),(6,8,3,null,-2017332532079385575,'2023-12-18','2023-12-16','d','y','h','b'),(7,9,9,5596192543704853388,267638791183929783,null,'2023-12-19',null,'d','t','l'),(8,5,-4,-6113554641783986996,-5658484838681634530,'2023-12-14','2023-12-19','i','c','a','k'),(9,null,-10,null,4991457615093257177,'2027-01-09','2023-12-19',null,'n','y','f'),(10,9,3,-7301049681081113761,-4781699936467294820,'2024-01-31','2024-01-09','u','d','c','n'),(11,-4,-4,-7086337865184828373,4315532519968709226,'2023-12-17','2023-12-10',null,'o',null,'u'),(12,0,9,-8757684043812948141,616531940395766973,null,'2024-01-31','h','d','l','y'),(13,2,-4,null,5554227672494943664,'2025-02-18','2023-12-14','q','w','f','p'),(14,-10,-10,-4561433444690964781,-8444020181581535329,'2023-12-12','2023-12-15','z','c','w','n'),(15,-10,7,-8802827632747131651,-5481795095278885584,'2023-12-17','2024-02-18','e','t','p','d'),(16,6,6,-5639219943760685155,490175745438454548,'2024-01-19','2025-06-18',null,'e','s','m'),(17,-4,6,1274523274892000841,-1666908142973027113,'2025-06-18','2025-02-18','m','j',null,'t'),(18,0,-10,-829309147977962633,-1448984827777801939,'2023-12-10','2025-06-18','q','f','p','d'),(19,4,-10,5017465451318631070,1485374261466392807,'2023-12-12','2024-02-18','o','u','n','r'),(20,-10,-4,null,-8472667734325532219,null,'2024-01-09',null,'l','t','s'),(21,-4,-10,4724543116023491216,3069741180880099025,'2026-02-18','2024-02-18','h','n','p','w'),(22,8,7,-8225548122477525987,-7403275139540774667,'2024-01-09','2026-01-18','w','u','z','y'),(23,7,4,-8308238561244451420,-4737114215802511670,'2023-12-09','2026-02-18','h','g',null,'j'),(24,8,0,-3445293753181337298,-4671072044529490912,'2025-06-18','2024-01-31','h','z',null,'h'),(25,9,3,-643703259719937453,-4467933225693972253,'2023-12-19','2026-02-18','h','k','a','p'),(26,-10,5,-4360065276518573247,6071515314723843321,'2024-02-18','2023-12-11','b','e','y','u'),(27,-10,5,7277432098525098029,7324870441313849762,'2023-12-16','2023-12-13',null,'o','d','m'),(28,4,1,null,-3401829705651503439,'2023-12-11','2024-01-19',null,'m','b','o'),(29,5,9,1595806217868219791,2396625106748754274,'2023-12-12','2026-01-18','y','i','v','k'),(30,8,-4,-8296263444527129454,-1200655730727433306,'2023-12-18','2023-12-16','x','w','e','g'),(31,8,9,null,-1057786787217140446,'2024-02-18','2025-02-18',null,'r',null,'n'),(32,2,6,null,-3794687203717519885,'2024-01-17','2023-12-11','s','o','o','p'),(33,8,-4,745035089749481716,6870210688431692264,'2023-12-16','2024-02-18','u','v','r','c'),(34,0,-4,-6725072017628066450,-8684294917367566361,'2023-12-18','2023-12-10','u','x','s','f'),(35,9,9,2062232271317540255,801582713562034622,'2023-12-12','2027-01-09','f','e','t','m'),(36,7,6,6833793247704001187,1810376613825059765,null,'2023-12-17','s','x',null,'c'),(37,3,-4,null,-5441663581149252353,'2023-12-19','2023-12-12','j','p','n','p'),(38,-4,2,null,-2168470328237974425,'2024-02-18','2026-02-18','l','y','z','z'),(39,1,-10,-2207119652858390693,2589212604181409488,null,'2023-12-11',null,'c','h','r'),(40,1,-4,-5120586939953271680,-5115443745232748649,'2025-06-18','2023-12-18',null,'z',null,'g'),(41,-4,9,-2705550486017092761,953166616065633786,null,'2024-01-08','d','u','z','k'),(42,1,8,528231752347363899,3778913804645926289,null,'2024-01-17','s','y','k','w'),(43,2,-10,null,2959039737583266404,'2023-12-12','2026-02-18','x','a','o','i'),(44,5,1,4479688968809054722,7900165947449530851,'2023-12-17','2023-12-19','o','m','m','k'),(45,null,3,null,3853519400061892820,'2023-12-19','2027-01-09',null,'m','j','u'),(46,null,2,-2308621156442800431,7150891722109935935,null,'2023-12-09','r','b','p','r'),(47,-10,7,null,-5384774129746079660,'2026-01-18','2026-02-18','i','y','f','l'),(48,7,-10,2518046378930975040,8009748340888023422,'2024-01-17','2023-12-14','a','y','m','r'),(49,0,1,-855757624678856701,6770116622679381583,'2023-12-11','2023-12-20','s','p','w','x'),(50,5,-4,null,-6219498513513783540,'2024-02-18','2023-12-09','l','d','y','a'),(51,null,9,-2453700456069426683,-82738410074789208,'2027-01-16','2023-12-10','o','w','f','w'),(52,-4,0,119899203407625900,-4661476900528916913,'2026-02-18','2023-12-10','j','u','g','g'),(53,1,2,-1453070963768828719,6267227367755586537,'2023-12-17','2023-12-10','o','l','o','f'),(54,0,-4,5021492283879788057,-8876089608130965603,'2025-02-17','2024-01-09','f','n','c','y'),(55,-4,1,1122238061013285565,308537169947542049,'2024-02-18','2023-12-12','f','z',null,'b'),(56,-4,2,-4640444469732044136,-5543784356823664941,null,'2024-01-19','j','w','z','e'),(57,5,-4,3373002253627578009,-1165501306547040863,'2027-01-09','2026-02-18','w','r','p','c'),(58,1,-4,8808393723467177119,-5346257761475098062,'2023-12-15','2024-02-18',null,'j','i','w'),(59,4,0,6552414885194925805,-3534775325743454515,'2026-01-18','2023-12-13','e','f',null,'r'),(60,6,-10,-4000277373668369461,-3111045443815568668,'2024-02-18','2025-06-18',null,'w','v','m'),(61,2,1,null,-8233172593971051412,'2023-12-18','2024-02-18','h','k','s','t'),(62,-10,0,null,-4491694283352502,'2023-12-17','2024-01-31','y','d','g','c'),(63,7,9,1464936785266490950,-2418183835907994133,'2025-06-18','2023-12-14',null,'z','y','m'),(64,3,5,-7706297176485718179,933626871060619190,'2023-12-20','2023-12-18','i','k','k','g'),(65,4,5,-8995970132111077734,8154004529141856099,null,'2025-06-18','w','n','j','w'),(66,9,-10,2294807974922328614,5767191679135413635,'2025-06-18','2025-02-17','w','j','f','l'),(67,-4,-10,587090899228213425,3507177411126691631,null,'2023-12-20','w','z','t','b'),(68,-10,-10,-4926187957454428492,-8376602544614160532,'2023-12-17','2026-02-18','x','u','k','z'),(69,-10,0,null,8496150289250370341,'2026-02-18','2026-01-18',null,'o','b','y'),(70,1,-10,-1962993669054805646,-6008622308929669427,'2024-01-09','2023-12-14',null,'a','d','x'),(71,3,0,null,-5808769432222500599,'2023-12-15','2024-02-18','u','f','y','b'),(72,-10,-10,-5219650699813656115,452002228724588510,'2023-12-18','2024-01-19',null,'c','j','y'),(73,0,8,-8474540639839757820,6411085865775239406,'2025-02-18','2024-01-19',null,'z','z','n'),(74,-4,8,-2199433898224071335,8363644609820182223,'2027-01-09','2023-12-09','p','s','m','y'),(75,3,-10,-2522181458998583891,917421047128804747,'2023-12-11','2023-12-13','t','u','r','c'),(76,0,4,4399813326725698376,1373458130594935549,'2024-02-18','2024-01-17','h','p','n','t'),(77,-4,-4,null,1788584297854554832,'2025-02-17','2024-01-09','w','r','u','r'),(78,0,-10,165950310516640650,-8133159160941577613,'2025-06-18','2024-02-18','n','c',null,'p'),(79,0,6,-2829447613177748553,-4770797190584838628,'2023-12-20','2023-12-20','f','w',null,'g'),(80,3,1,null,6702519360356810260,'2023-12-12','2023-12-19','d','y','n','i'),(81,null,3,4248574368647718721,-8514779561337794294,'2023-12-15','2024-01-17','h','r','n','z'),(82,2,1,320280761780398808,4314609622203347175,null,'2023-12-20','x','n','y','j'),(83,1,0,-6200587512045784782,-4498885757862052232,'2027-01-16','2023-12-18','u','d','g','f'),(84,5,-4,-4277349083685494679,-3593280850611947078,'2025-06-18','2025-02-17',null,'v','w','f'),(85,5,7,2883282944364027996,6420277952201969882,'2026-01-18','2024-02-18','u','j','t','q'),(86,4,-10,-1120247934953844457,1663931126940365825,'2023-12-11','2027-01-16','q','a','z','t'),(87,9,8,-1426751146107022190,1441141349683396036,'2023-12-16','2023-12-17','q','y','h','i'),(88,8,-10,-4349974916742880190,8256435217108546627,'2023-12-14','2024-01-09','z','c','o','b'),(89,-10,8,-8338928813651598785,7977286452179410459,null,'2024-01-19','n','k','j','w'),(90,null,0,244807790468898978,-3801880175864777196,null,'2023-12-17','l','y','h','i'),(91,null,9,-6408133915102679384,7511711843888882940,'2026-01-18','2027-01-16',null,'v','m','a'),(92,null,-4,3739649918962133441,3076240410999154553,'2023-12-17','2024-01-08','z','f','u','y'),(93,null,-10,null,5205086860864014631,null,'2023-12-13','m','y',null,'e'),(94,4,3,7271842280143827859,-1246168252444258268,'2025-02-17','2023-12-14','c','q','w','m'),(95,-10,1,null,-1956081584567562286,'2023-12-11','2024-02-18','y','g','u','p'),(96,null,0,-7842733493711584669,2232657695829197601,'2026-01-18','2023-12-20',null,'x','r','u'),(97,null,1,null,-8604813143528815146,'2023-12-20','2024-01-08','z','v','r','i'),(98,-4,4,null,2825934924130026445,'2024-01-09','2023-12-09','k','r','x','u'),(99,1,0,null,-1181926554319033971,'2024-02-18','2023-12-13','l','g','e','r'),(100,4,4,null,-8117404878456129464,'2023-12-16','2024-01-08','l','q','n','e'),(101,9,-10,null,-8162239741142259898,null,'2024-01-31','s','l','v','e'),(102,8,4,4428460829238539547,4665293281033362886,'2024-01-19','2025-06-18','y','a',null,'j'),(103,8,2,-1223671322140090504,6977230827413685849,'2025-02-18','2024-02-18','h','s','q','m'),(104,2,-10,null,-2682464990487136210,'2027-01-16','2026-01-18','a','u','t','a'),(105,8,3,1844228284799324033,7396769740370937616,'2024-01-08','2026-02-18','l','q','m','w'),(106,null,0,-4635982079725022381,-1559819812914917184,'2025-06-18','2025-06-18','x','b',null,'w'),(107,8,-4,-5968215346736716838,9136666151714541291,'2024-02-18','2024-01-08','w','r','g','v'),(108,5,5,null,5858275700878532942,null,'2024-01-19','p','c','v','t'),(109,4,-10,7788561359573057073,3796991113318205212,'2024-01-19','2027-01-16','s','z','y','u'),(110,9,8,-4936498559299264714,3987489369204641984,'2023-12-16','2024-01-08','m','n','l','u'),(111,0,-10,null,-1839332505961199897,'2025-02-17','2023-12-16','i','r','x','y'),(112,1,1,7588479964786885990,-3518894912918244447,'2023-12-10','2024-02-18','b','u','t','a'),(113,-4,-10,3503740574835224983,-8376857573915349696,'2023-12-11','2023-12-15','o','g','k','d'),(114,9,3,null,2623523588167267085,'2023-12-11','2024-01-08','m','q','z','u'),(115,4,-10,null,1141333940801996130,'2023-12-09','2025-02-18','a','k',null,'c'),(116,1,1,1301860584665365272,-3137133797699518743,'2023-12-13','2023-12-11','o','f','i','g'),(117,-10,7,2061572628480164506,-941565778547616976,'2025-02-18','2024-02-18','y','b','d','v'),(118,4,-4,5905457525257274831,-3537379062861041102,'2025-06-18','2023-12-15',null,'p','b','a'),(119,6,0,5203103959331291655,4553687495326142230,'2024-01-17','2024-02-18','k','q','x','y'),(120,-4,9,-8635697863181382818,7636960765531229395,'2023-12-09','2025-02-18','t','c','w','m'),(121,0,0,-8318602828209501850,-4943371026882157173,'2024-01-17','2023-12-16','r','x','n','f'),(122,1,7,2423501569419443281,-6589241835404749979,'2025-02-18','2027-01-09','l','e','x','x'),(123,-4,6,null,3729608390680606227,'2023-12-15','2026-02-18','x','o','m','l'),(124,null,-10,4987191974521539793,7099886620557264771,null,'2023-12-19','b','q','g','j'),(125,-10,-10,null,-8031447195377137816,null,'2024-02-18','r','p','u','z'),(126,7,1,6676484990875474971,2888513296794301991,'2024-02-18','2023-12-09','p','n','g','b'),(127,8,2,-2907338527699127177,-4546369298413621144,'2024-01-31','2025-06-18',null,'h','c','w'),(128,-4,-4,-725621622182332157,-4345970020462840706,'2027-01-16','2027-01-09','v','v','w','r'),(129,5,5,null,-7250528589413808433,'2023-12-12','2023-12-17','a','g','z','d'),(130,null,0,-7201945181697281727,4076316632344864610,'2024-01-09','2026-02-18','e','g','p','x'),(131,8,2,4039015488782675948,-7627575764896379667,null,'2024-02-18',null,'x','x','u'),(132,-4,8,582950484149896044,-8546974684347671801,'2023-12-15','2023-12-16',null,'c',null,'s'),(133,4,-10,8472160150721707654,-8121377870390656734,'2023-12-16','2027-01-16','f','t',null,'c'),(134,8,3,null,-7286212975735329414,null,'2023-12-16','e','e','v','v'),(135,8,5,8893169871966679916,-3528815577223369116,'2024-01-09','2023-12-18','a','u','a','b'),(136,2,-10,null,-600117778267872813,'2025-02-17','2026-01-18','v','o','u','a'),(137,3,-10,null,3875574420073502874,'2027-01-16','2023-12-15','d','h',null,'m'),(138,6,3,-7092907178026955224,-7458173286579166661,'2025-02-18','2023-12-20','k','s',null,'v'),(139,4,-4,null,8066978303437641605,'2023-12-14','2025-02-17','x','o','o','c'),(140,3,0,-5283347581061457496,-3904748897731435093,'2024-01-09','2023-12-20','g','o','o','t'),(141,null,3,null,1915421260870512382,'2023-12-11','2025-02-17','l','y','e','k'),(142,-10,-10,8989121510646360393,-5554479379366875651,'2025-06-18','2023-12-20','l','z',null,'w'),(143,-10,-4,5103258104632957393,9108626379079271426,'2025-06-18','2023-12-11','o','t',null,'v'),(144,8,5,null,7089037888036198838,'2024-02-18','2023-12-12','w','e','z','g'),(145,2,0,-2530114892096232328,-3029426656119524867,'2026-02-18','2023-12-20','q','n','w','f'),(146,2,0,-1167184901984734011,9197712261028249733,'2027-01-16','2026-01-18','y','g','d','w'),(147,0,-10,-3151820955481808490,6084406231058480929,null,'2026-02-18','m','z','e','k'),(148,null,7,-5620657663724505253,-5569893795944384789,'2024-02-18','2023-12-15','u','r','t','n'),(149,null,7,1932155420012171131,-7307674080602904438,'2025-06-18','2023-12-18',null,'w','r','a'),(150,null,2,-843675053631435346,794239051911249282,'2023-12-15','2027-01-16','j','a','r','h'),(151,2,3,3099780186868693967,-3225999145687125620,'2024-01-19','2024-01-08','k','c','t','k'),(152,4,2,1770467068126077319,-9055195259747766247,'2025-06-18','2027-01-09','v','a',null,'h'),(153,4,0,-2754737360318041457,-4243320690494160068,'2024-02-18','2026-02-18','h','s','k','t'),(154,null,1,3047341609933447747,-5430978432065487602,'2023-12-10','2025-06-18','r','t','e','w'),(155,null,6,9002764758580821577,4301472086716260964,'2023-12-14','2023-12-17','s','f','u','j'),(156,-10,7,5766282996410787024,-6842767888259184512,'2025-06-18','2024-01-08',null,'i','t','t'),(157,8,0,null,-2971991946957950726,'2023-12-11','2026-01-18','e','n','x','u'),(158,0,5,3486248075304478637,7151930690139263019,'2027-01-09','2023-12-17','s','w','w','h'),(159,null,1,null,8198990090355964665,'2024-01-19','2024-01-31','d','g','y','r'),(160,9,6,null,-2148224693875975660,'2023-12-16','2025-02-18','a','k','b','q'),(161,-10,-4,5488734119027589165,7513618645834418897,'2024-01-09','2023-12-14',null,'s','c','w'),(162,9,8,-7672565124538576135,-5841834824122770876,'2025-02-17','2027-01-09','n','k','c','v'),(163,-4,5,null,7364114271450150187,null,'2023-12-14',null,'j','h','n'),(164,2,-10,null,-2194630486679592764,'2023-12-14','2026-01-18','u','y','p','x'),(165,2,2,-1880918634814261976,1232284826891731722,'2025-06-18','2024-02-18','c','l','p','p'),(166,1,3,null,2074110522301738224,'2026-02-18','2024-01-17','u','c',null,'f'),(167,-10,-4,null,-1170888295489186999,'2023-12-19','2023-12-20','j','q','m','v'),(168,-10,-4,null,-5537440894255523447,null,'2024-02-18',null,'q','j','f'),(169,-10,6,-3451103407491045129,5150722079806394405,'2025-06-18','2024-01-09','v','l',null,'k'),(170,3,4,-5818977070284761683,-5371459815538469672,'2026-02-18','2023-12-14',null,'q','b','m'),(171,1,5,4168395638427775128,5611668983964341559,null,'2024-01-17','w','s','q','h'),(172,1,0,3458544995986307787,-4149888810199163471,'2024-02-18','2024-01-19',null,'q',null,'z'),(173,1,-10,4142592142963263928,-909410561626911386,'2025-06-18','2023-12-09','a','a','d','l'),(174,null,4,-518273896821184968,1288957583256666554,null,'2025-02-17','c','f','x','p'),(175,-10,3,-3032449689171348418,-2741600948103211533,'2024-01-17','2024-01-09','q','y','f','u'),(176,5,0,null,-8712847991493189369,'2026-01-18','2023-12-10',null,'y','o','k'),(177,-10,-10,6505905262846026612,-2663878103275066151,'2023-12-16','2023-12-13','d','i','b','t'),(178,-10,1,2979439245250192393,-4004139275935906983,'2025-02-18','2024-02-18','b','a',null,'f'),(179,null,3,-5246999956982673330,4693551967836520193,'2027-01-16','2023-12-16','x','r','q','t'),(180,-4,6,6129616258684699357,-7442537280431110769,'2026-01-18','2023-12-14','i','p','u','m'),(181,8,-4,null,3559171006199606037,'2025-06-18','2024-02-18',null,'a','o','a'),(182,-10,0,576423267430397537,2065938004294521372,'2024-01-31','2027-01-09','z','f','m','z'),(183,8,9,-46478079095765773,2258977652029773198,'2023-12-14','2023-12-13','y','h',null,'s'),(184,3,-4,755103508423070586,9018243765720151284,'2023-12-12','2023-12-14','n','w','f','z'),(185,7,3,6433137528287040546,-7371938000327475691,'2024-01-08','2025-06-18','f','z','i','b'),(186,-10,8,1177751778138866228,7659149130558923595,'2023-12-12','2027-01-09','r','c',null,'c'),(187,0,9,1288191403351998836,-6549118763715205452,'2023-12-12','2023-12-20','e','i','p','i'),(188,8,-4,null,253602092357870614,'2024-02-18','2027-01-16','c','h','l','d'),(189,-4,3,5718357978282980367,869765378314899903,'2023-12-16','2024-01-17','h','l','e','m'),(190,4,9,2418044860521148649,770875792276394729,'2026-02-18','2025-02-18','o','h',null,'s'),(191,2,4,-1120990051628321869,-5502418519216245814,null,'2023-12-12','d','i','j','b'),(192,5,-10,null,-9098364149107256069,'2023-12-17','2024-01-09','c','i','g','y'),(193,8,-10,null,6154296133843956869,'2023-12-16','2024-02-18','t','r','v','i'),(194,-4,8,-2387697740444229124,-4420658912264770524,'2024-01-17','2023-12-16','f','e','u','c'),(195,-10,6,-2772463034040194217,-7907822037637823718,'2023-12-12','2025-06-18','r','j','c','y'),(196,-4,2,8554448119524477807,5158562227277810813,null,'2024-01-19','z','p','w','k'),(197,4,1,-5392061529260431139,3278574395762126118,null,'2023-12-09','a','s','d','z'),(198,null,-10,-4067083055147098114,2685481298193076314,'2024-02-18','2023-12-11','t','g','v','k'),(199,1,1,-8261512111679927590,-1534216194492202538,'2024-01-31','2023-12-12','t','i','w','e');
    """

    qt_in33 """
        SELECT
        col_varchar_1024__undef_signed
        FROM
        table_200_undef_partitions2_keys3_properties4_distributed_by56 AS table1
        WHERE
        table1.`col_varchar_1024__undef_signed` NOT IN (NULL, 'c')
        AND table1.`col_varchar_1024__undef_signed` IN (NULL, 'u', 'd');
    """
}
