/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.scheduler.impl;

import jakarta.inject.Inject;
import java.util.logging.Logger;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class DynamicExpressionObserverJob
implements Deactivatable,
Job {
    static final String CONFIG_EXPRESSION_KEY = "ds_configExpression";
    static final String ACTIVE_CRON_EXPRESSION_KEY = "ds_activeCronExpression";
    static final String TRIGGER_ID_KEY = "ds_triggerKey";
    static final String OBSERVER_POSTFIX = "_observer";
    private static final Logger LOG = Logger.getLogger(DynamicExpressionObserverJob.class.getName());
    @Inject
    private org.apache.deltaspike.scheduler.spi.Scheduler<Job> scheduler;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        String configKey;
        String configuredValue;
        JobDataMap jobDataMap = context.getMergedJobDataMap();
        String configExpression = jobDataMap.getString(CONFIG_EXPRESSION_KEY);
        String triggerId = jobDataMap.getString(TRIGGER_ID_KEY);
        String activeCronExpression = jobDataMap.getString(ACTIVE_CRON_EXPRESSION_KEY);
        if (!activeCronExpression.equals(configuredValue = ConfigResolver.getPropertyAwarePropertyValue((String)(configKey = configExpression.substring(1, configExpression.length() - 1)), (String)activeCronExpression))) {
            context.getJobDetail().getJobDataMap().put(ACTIVE_CRON_EXPRESSION_KEY, configuredValue);
            context.getTrigger().getJobDataMap().put(ACTIVE_CRON_EXPRESSION_KEY, configuredValue);
            BeanProvider.injectFields((Object)this);
            JobKey observerJobKey = context.getJobDetail().getKey();
            String observedJobName = observerJobKey.getName().substring(0, observerJobKey.getName().length() - OBSERVER_POSTFIX.length());
            JobKey observedJobKey = new JobKey(observedJobName, observerJobKey.getGroup());
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerId).forJob(observedJobName, observedJobKey.getGroup()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)configuredValue)).build();
            Scheduler quartzScheduler = (Scheduler)this.scheduler.unwrap(Scheduler.class);
            try {
                quartzScheduler.rescheduleJob(trigger.getKey(), trigger);
            }
            catch (SchedulerException e) {
                LOG.warning("failed to updated cron-expression for " + observedJobKey);
            }
        }
    }
}

