/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;

public class AttributeTransformer
implements SourceTransformer {
    private static final char SOURCE_TARGET_SEPARATION_CHAR = '=';
    private static final String COMMENT_CHAR = "#";
    private static final char ESCAPE_CHAR = '\\';
    private static final char DEFINITION_CHAR = '$';
    private static final char DEFINITION_START_CHAR = '{';
    private static final char DEFINITION_END_CHAR = '}';
    private static final char DEFINITION_TYPE_SEPARATION_CHAR = ':';
    private static Log log = LogFactory.getLog(AttributeTransformer.class);
    private final List<TransformRule> transformRules = new ArrayList<TransformRule>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeTransformer(Reader transformDefinition) throws SourceTransformerException {
        try (BufferedReader reader = new BufferedReader(transformDefinition);){
            String line = reader.readLine();
            while (line != null) {
                try {
                    if (line.trim().startsWith(COMMENT_CHAR) || line.trim().length() == 0) continue;
                    int equalsPos = line.indexOf(61);
                    String target = line.substring(0, equalsPos).trim();
                    String source = line.substring(equalsPos + 1).trim();
                    List<Definition> targetDefinitions = this.parse(target, false);
                    if (targetDefinitions.size() != 1) {
                        log.error((Object)("While parsing \"" + line + "\" : " + targetDefinitions.size() + " definitions found before = at position " + equalsPos + ", must be 1"));
                    }
                    List<Definition> sourceDefinitions = this.parse(source, true);
                    TransformRule transformRule = new TransformRule(targetDefinitions.get(0), sourceDefinitions);
                    this.transformRules.add(transformRule);
                }
                finally {
                    line = reader.readLine();
                }
            }
        }
        catch (IOException e) {
            throw new SourceTransformerException("Could not read transformDefinition", e);
        }
    }

    @Override
    public Object transform(Object toTransform, ControllerState controllerState) throws SourceTransformerException {
        SourceElement toTransformElement = (SourceElement)toTransform;
        for (TransformRule transformRule : this.transformRules) {
            String attributeName;
            StringBuilder sourceResult = new StringBuilder();
            for (Definition definition : transformRule.getSource()) {
                Definition.Type type = definition.getType();
                if (Definition.Type.PLAIN == type) {
                    sourceResult.append(definition.getContent());
                    continue;
                }
                if (Definition.Type.ATTRIBUTE == type) {
                    Object attributeValue = toTransformElement.getAttribute(definition.getContent());
                    if (attributeValue == null) continue;
                    sourceResult.append(attributeValue.toString());
                    continue;
                }
                if (Definition.Type.OPTION == type) {
                    Object optionValue = controllerState.getOption(definition.getContent());
                    if (optionValue == null) continue;
                    sourceResult.append(optionValue.toString());
                    continue;
                }
                throw new SourceTransformerException("Unknown definition Type" + String.valueOf((Object)type) + " in source");
            }
            Definition target = transformRule.getTarget();
            if (Definition.Type.ATTRIBUTE_NO_OVERRIDE == target.getType()) {
                attributeName = target.getContent();
                if (toTransformElement.getAttribute(attributeName) == null) {
                    toTransformElement.setAttribute(attributeName, (Object)sourceResult.toString());
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Setting Attribute " + attributeName + " on element " + toTransformElement.getName() + " to " + String.valueOf(sourceResult)));
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Attribute " + attributeName + " already set on element " + toTransformElement.getName() + " skipping"));
                continue;
            }
            if (Definition.Type.ATTRIBUTE_OVERRIDE == target.getType()) {
                attributeName = target.getContent();
                if (toTransformElement.getAttribute(attributeName) == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Setting Attribute " + attributeName + " on element " + toTransformElement.getName() + " to " + String.valueOf(sourceResult)));
                    }
                } else if (log.isTraceEnabled()) {
                    log.trace((Object)("Overriding Attribute " + attributeName + " on element " + toTransformElement.getName() + " with value " + String.valueOf(sourceResult)));
                }
                toTransformElement.setAttribute(attributeName, (Object)sourceResult.toString());
                continue;
            }
            throw new SourceTransformerException("Unknown target type " + String.valueOf((Object)target.getType()));
        }
        return toTransform;
    }

    List<Definition> parse(String toParse, boolean source) throws SourceTransformerException {
        ArrayList<Definition> result = new ArrayList<Definition>();
        ParseState parseState = new ParseState();
        for (int position = 0; position < toParse.length(); ++position) {
            char current = toParse.charAt(position);
            if (parseState.isDefinitionStart()) {
                this.parseAfterDefinitionStart(current, parseState, toParse, position);
                continue;
            }
            if (parseState.isEscape()) {
                this.parseAfterEscape(current, parseState);
                continue;
            }
            if (current == '\\') {
                parseState.setEscape(true);
                continue;
            }
            if (current == '$') {
                if (parseState.isDefinitionStart()) {
                    log.error((Object)("While parsing \"" + toParse + "\" : $ must be escaped inside Definition at Position " + position));
                    throw new SourceTransformerException("$ must be followed by {");
                }
                if (parseState.getDefinitionValue().length() > 0) {
                    this.checkTypeAllowed(parseState.getDefinitionType(), source);
                    result.add(new Definition(parseState.getDefinitionType(), parseState.getDefinitionValue().toString()));
                    parseState.resetDefinitionValue();
                }
                parseState.setDefinitionStart(true);
                continue;
            }
            if (!parseState.isInDefinition()) {
                parseState.getDefinitionValue().append(current);
                continue;
            }
            if (current == '}') {
                Definition definition = this.parseDefinitionEnd(parseState, source, toParse, position);
                result.add(definition);
                continue;
            }
            if (parseState.isInType()) {
                this.parseInType(current, parseState, source, toParse, position);
                continue;
            }
            parseState.getDefinitionValue().append(current);
        }
        if (Definition.Type.PLAIN != parseState.getDefinitionType()) {
            log.error((Object)("While parsing \"" + toParse + "\" : Definition not closed at end of String."));
            throw new SourceTransformerException("Definition not closed at end of String.");
        }
        if (parseState.getDefinitionValue().length() > 0) {
            this.checkTypeAllowed(parseState.getDefinitionType(), source);
            result.add(new Definition(parseState.getDefinitionType(), parseState.getDefinitionValue().toString()));
        }
        return result;
    }

    private void parseInType(char current, ParseState parseState, boolean source, String toParse, int position) throws SourceTransformerException {
        if (current != ':') {
            parseState.getDefinitionTypeBuffer().append(current);
        } else {
            String typeString = parseState.getDefinitionTypeBuffer().toString();
            Definition.Type type = null;
            for (Definition.Type possibleType : Definition.Type.values()) {
                if (!possibleType.getName().equals(typeString)) continue;
                this.checkTypeAllowed(possibleType, source);
                type = possibleType;
                break;
            }
            if (type == null) {
                log.error((Object)("While parsing \"" + toParse + "\" : Unknown definition type " + typeString + " at Position " + position));
                throw new SourceTransformerException("Unknown definition type");
            }
            parseState.setDefinitionType(type);
            parseState.resetDefinitionTypeBuffer();
            parseState.setInType(false);
        }
    }

    private Definition parseDefinitionEnd(ParseState parseState, boolean source, String toParse, int position) throws SourceTransformerException {
        if (parseState.isInType()) {
            log.error((Object)("While parsing \"" + toParse + "\" : Seen } before : at Position " + position));
            throw new SourceTransformerException("Seen } before :");
        }
        this.checkTypeAllowed(parseState.getDefinitionType(), source);
        Definition result = new Definition(parseState.getDefinitionType(), parseState.getDefinitionValue().toString());
        parseState.setDefinitionType(Definition.Type.PLAIN);
        parseState.resetDefinitionValue();
        parseState.setInDefinition(false);
        return result;
    }

    private void parseAfterEscape(char current, ParseState parseState) {
        if (parseState.isInType()) {
            parseState.getDefinitionTypeBuffer().append(current);
        } else {
            parseState.getDefinitionValue().append(current);
        }
        parseState.setEscape(false);
    }

    private void parseAfterDefinitionStart(char current, ParseState parseState, String toParse, int position) throws SourceTransformerException {
        if (current != '{') {
            log.error((Object)("While parsing \"" + toParse + "\" : $ must be followed by { at Position " + position));
            throw new SourceTransformerException("$ must be followed by {");
        }
        parseState.setDefinitionStart(false);
        parseState.setInDefinition(true);
        parseState.setInType(true);
    }

    private void checkTypeAllowed(Definition.Type type, boolean source) throws SourceTransformerException {
        if (source && !type.inSource) {
            log.error((Object)("Definition type " + String.valueOf((Object)type) + " may not occur in source "));
            throw new SourceTransformerException("definition type not allowed in source");
        }
        if (!source && !type.inTarget) {
            log.error((Object)("Definition type " + String.valueOf((Object)type) + " may not occur in target "));
            throw new SourceTransformerException("definition type not allowed in target");
        }
    }

    static class TransformRule {
        private final Definition target;
        private final List<Definition> source;

        public TransformRule(Definition target, List<Definition> source) {
            if (target == null) {
                throw new NullPointerException("target is null");
            }
            if (source == null) {
                throw new NullPointerException("source is null");
            }
            this.target = target;
            this.source = source;
        }

        public Definition getTarget() {
            return this.target;
        }

        public List<Definition> getSource() {
            return this.source;
        }
    }

    static class Definition {
        private final Type type;
        private final String content;

        public Definition(Type type, String content) {
            if (type == null) {
                throw new NullPointerException("type is null");
            }
            if (content == null) {
                throw new NullPointerException("content is null");
            }
            this.type = type;
            this.content = content;
        }

        public Type getType() {
            return this.type;
        }

        public String getContent() {
            return this.content;
        }

        static enum Type {
            ATTRIBUTE("attribute", true, false),
            OPTION("option", true, false),
            PLAIN("plain", true, false),
            ATTRIBUTE_OVERRIDE("attribute(override)", false, true),
            ATTRIBUTE_NO_OVERRIDE("attribute(noOverride)", false, true);

            private final String name;
            private final boolean inSource;
            private final boolean inTarget;

            private Type(String name, boolean inSource, boolean inTarget) {
                this.name = name;
                this.inSource = inSource;
                this.inTarget = inTarget;
            }

            public String getName() {
                return this.name;
            }

            public boolean isInSource() {
                return this.inSource;
            }

            public boolean isInTarget() {
                return this.inTarget;
            }

            public String toString() {
                return this.name;
            }
        }
    }

    static class ParseState {
        private boolean escape = false;
        private boolean definitionStart = false;
        private boolean inDefinition = false;
        private StringBuilder definitionTypeBuffer = new StringBuilder();
        private Definition.Type definitionType = Definition.Type.PLAIN;
        private StringBuilder definitionValue = new StringBuilder();
        private boolean inType = false;

        ParseState() {
        }

        public boolean isEscape() {
            return this.escape;
        }

        public void setEscape(boolean escape) {
            this.escape = escape;
        }

        public boolean isDefinitionStart() {
            return this.definitionStart;
        }

        public void setDefinitionStart(boolean definitionStart) {
            this.definitionStart = definitionStart;
        }

        public boolean isInDefinition() {
            return this.inDefinition;
        }

        public void setInDefinition(boolean inDefinition) {
            this.inDefinition = inDefinition;
        }

        public boolean isInType() {
            return this.inType;
        }

        public void setInType(boolean inType) {
            this.inType = inType;
        }

        public StringBuilder getDefinitionTypeBuffer() {
            return this.definitionTypeBuffer;
        }

        public void resetDefinitionTypeBuffer() {
            this.definitionTypeBuffer = new StringBuilder();
        }

        public Definition.Type getDefinitionType() {
            return this.definitionType;
        }

        public void setDefinitionType(Definition.Type definitionType) {
            this.definitionType = definitionType;
        }

        public StringBuilder getDefinitionValue() {
            return this.definitionValue;
        }

        public void resetDefinitionValue() {
            this.definitionValue = new StringBuilder();
        }
    }
}

