<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# sqlparser-rs 0.60.0 Changelog

This release consists of 37 commits from 20 contributors. See credits at the end of this changelog for more information.

**Implemented enhancements:**

- feat: Add RESET to the base dialect #2078 [#2079](https://github.com/apache/datafusion-sqlparser-rs/pull/2079) (watford-ep)
- feat: Add support for SET SESSION AUTHORIZATION #2086 [#2087](https://github.com/apache/datafusion-sqlparser-rs/pull/2087) (watford-ep)

**Fixed bugs:**

- fix: parse error on unnamed arg with default syntax [#2091](https://github.com/apache/datafusion-sqlparser-rs/pull/2091) (r1b)

**Other:**

- Add support for INVISIBLE columns in MySQL [#2033](https://github.com/apache/datafusion-sqlparser-rs/pull/2033) (altmannmarcelo)
- Link to actual change logs in CHANGELOG.md [#2040](https://github.com/apache/datafusion-sqlparser-rs/pull/2040) (lovasoa)
- Snowflake: ALTER USER and KeyValueOptions Refactoring [#2035](https://github.com/apache/datafusion-sqlparser-rs/pull/2035) (yoavcloud)
- Correctly tokenize nested comments in Databricks, ClickHouse, and ANSI [#2044](https://github.com/apache/datafusion-sqlparser-rs/pull/2044) (jmhain)
- MySQL: `CREATE INDEX`: allow `USING` clause before `ON` [#2029](https://github.com/apache/datafusion-sqlparser-rs/pull/2029) (MohamedAbdeen21)
- [databricks] update dialect to support grouping by with modifier [#2047](https://github.com/apache/datafusion-sqlparser-rs/pull/2047) (n-young)
- Moved constraint variant outside of `TableConstraint` enum [#2054](https://github.com/apache/datafusion-sqlparser-rs/pull/2054) (LucaCappelletti94)
- Add support for procedure parameter default values [#2041](https://github.com/apache/datafusion-sqlparser-rs/pull/2041) (aharpervc)
- Support updating PRs using github UI [#2052](https://github.com/apache/datafusion-sqlparser-rs/pull/2052) (blaginin)
- Increase version of sqlparser_derive from 0.3.0 to 0.4.0 [#2060](https://github.com/apache/datafusion-sqlparser-rs/pull/2060) (jjbayer)
- Moving several struct variants out of `Statement` enum to allow for trait impls for specific sub-variants [#2057](https://github.com/apache/datafusion-sqlparser-rs/pull/2057) (LucaCappelletti94)
- Added support for SQLite triggers [#2037](https://github.com/apache/datafusion-sqlparser-rs/pull/2037) (LucaCappelletti94)
- Added support for MATCH syntax and unified column option ForeignKey [#2062](https://github.com/apache/datafusion-sqlparser-rs/pull/2062) (LucaCappelletti94)
- chore: add stack overflow warning for Visitor and VisitorMut [#2068](https://github.com/apache/datafusion-sqlparser-rs/pull/2068) (niebayes)
- Reused `CheckConstraint` in `ColumnOption` [#2063](https://github.com/apache/datafusion-sqlparser-rs/pull/2063) (LucaCappelletti94)
- Refactored `ColumnOption::Unique` to reuse `UniqueConstraint` and `PrimaryKeyConstraint` [#2064](https://github.com/apache/datafusion-sqlparser-rs/pull/2064) (LucaCappelletti94)
- Redshift: more copy options [#2072](https://github.com/apache/datafusion-sqlparser-rs/pull/2072) (yoavcloud)
- SQLite: make period optional for CREATE TRIGGER [#2071](https://github.com/apache/datafusion-sqlparser-rs/pull/2071) (takluyver)
- Added TIMESTAMP_NTZ type support with precision to Snowflake dialect [#2080](https://github.com/apache/datafusion-sqlparser-rs/pull/2080) (romanoff)
- Make `BitwiseNot` ("~") available for all dialects, not just PostgreSQL [#2081](https://github.com/apache/datafusion-sqlparser-rs/pull/2081) (alexander-beedie)
- Add snowflake dynamic table parsing [#2083](https://github.com/apache/datafusion-sqlparser-rs/pull/2083) (romanoff)
- Add support for `INSERT INTO VALUE` [#2085](https://github.com/apache/datafusion-sqlparser-rs/pull/2085) (etgarperets)
- Complete PostgreSQL `CREATE TYPE` Support [#2094](https://github.com/apache/datafusion-sqlparser-rs/pull/2094) (LucaCappelletti94)
- Include DML keyword in statement span [#2090](https://github.com/apache/datafusion-sqlparser-rs/pull/2090) (xitep)
- Add PostgreSQL Operator DDL Support [#2096](https://github.com/apache/datafusion-sqlparser-rs/pull/2096) (LucaCappelletti94)
- impl `Spanned` for MERGE statements [#2100](https://github.com/apache/datafusion-sqlparser-rs/pull/2100) (xitep)
- Preserve optional `AS` keyword in aliases [#2103](https://github.com/apache/datafusion-sqlparser-rs/pull/2103) (xitep)
- Added support for `DROP OPERATOR` syntax [#2102](https://github.com/apache/datafusion-sqlparser-rs/pull/2102) (LucaCappelletti94)
- Only set `hive_formats` on `CreateTable` if formats are present [#2105](https://github.com/apache/datafusion-sqlparser-rs/pull/2105) (mvzink)
- Support PostgreSQL C Functions with Multiple AS Parameters [#2095](https://github.com/apache/datafusion-sqlparser-rs/pull/2095) (LucaCappelletti94)
- Added support for `DROP OPERATOR FAMILY` [#2106](https://github.com/apache/datafusion-sqlparser-rs/pull/2106) (LucaCappelletti94)
- Update criterion requirement from 0.7 to 0.8 in /sqlparser_bench [#2111](https://github.com/apache/datafusion-sqlparser-rs/pull/2111) (dependabot[bot])
- Added support for `DROP OPERATOR CLASS` syntax [#2109](https://github.com/apache/datafusion-sqlparser-rs/pull/2109) (LucaCappelletti94)
- Introduce Oracle dialect [#2113](https://github.com/apache/datafusion-sqlparser-rs/pull/2113) (xitep)

## Credits

Thank you to everyone who contributed to this release. Here is a breakdown of commits (PRs merged) per contributor.

```
    12	Luca Cappelletti
     4	xitep
     2	Andriy Romanov
     2	Christopher Watford
     2	Yoav Cohen
     1	Alexander Beedie
     1	Andrew Harper
     1	Dmitrii Blaginin
     1	Joey Hain
     1	Joris Bayer
     1	Marcelo Altmann
     1	Michael Victor Zink
     1	Mohamed Abdeen
     1	Ophir LOJKINE
     1	Thomas Kluyver
     1	dependabot[bot]
     1	etgarperets
     1	nick young
     1	niebayes
     1	r1b
```

Thank you also to everyone who contributed in other ways such as filing issues, reviewing PRs, and providing feedback on this release.

