/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.SnapshotRequest;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.SimpleBufferSource;
import com.terracottatech.frs.log.BufferListWrapper;
import com.terracottatech.frs.log.DisposableLogRecordImpl;
import com.terracottatech.frs.log.FormatException;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRecordImpl;
import com.terracottatech.frs.log.LogRegionFactory;
import com.terracottatech.frs.log.Signature;
import com.terracottatech.frs.log.SnapshotBufferList;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRegionPacker
implements LogRegionFactory<LogRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogManager.class);
    static final int LOG_RECORD_HEADER_SIZE = 18;
    static final int LOG_REGION_HEADER_SIZE = 20;
    private static final long RECORD_HEADER_OVERHEAD = 18L;
    private static final long MINIMUM_RECORD_OVERHEAD = 46L;
    private final BufferSource source;
    private int tuningMax = 10;
    static final short REGION_VERSION = 2;
    public static final String OLD_REGION_FORMAT_STRING = "NF";
    public static final String NEW_REGION_FORMAT_STRING = "HT";
    static final byte[] OLD_REGION_FORMAT = "NF".getBytes();
    static final byte[] NEW_REGION_FORMAT = "HT".getBytes(StandardCharsets.US_ASCII);
    static final short LR_FORMAT = 2;
    private static final String BAD_CHECKSUM = "bad checksum";
    private final Signature cType;
    private final String forcedLogRegionFormat;
    private static final ThreadLocal<byte[]> buffer = new ThreadLocal();

    public LogRegionPacker(Signature sig, String forcedLogRegionFormat) {
        this(sig, new SimpleBufferSource(), forcedLogRegionFormat);
    }

    public LogRegionPacker(Signature sig, BufferSource src, String forcedLogRegionFormat) {
        this.cType = sig;
        assert (this.cType == Signature.NONE || this.cType == Signature.ADLER32);
        this.source = src == null ? new SimpleBufferSource() : src;
        this.forcedLogRegionFormat = forcedLogRegionFormat;
    }

    @Override
    public Chunk pack(final Iterable<LogRecord> payload) {
        final LinkedList<SnapshotRequest> holder = new LinkedList<SnapshotRequest>();
        Chunk c = this.writeRecords(new Iterable<LogRecord>(){

            @Override
            public Iterator<LogRecord> iterator() {
                return new Iterator<LogRecord>(){
                    Iterator<LogRecord> delegate;
                    {
                        this.delegate = payload.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegate.hasNext();
                    }

                    @Override
                    public LogRecord next() {
                        LogRecord lr = this.delegate.next();
                        if (lr instanceof SnapshotRequest) {
                            holder.add((SnapshotRequest)((Object)lr));
                        }
                        return lr;
                    }

                    @Override
                    public void remove() {
                        this.delegate.remove();
                    }
                };
            }
        });
        if (!holder.isEmpty()) {
            return new SnapshotBufferList(Arrays.asList(c.getBuffers()), holder);
        }
        return c;
    }

    public static LogRecord extract(Signature type, String forcedLogRegionFormat, Chunk data, long match) throws FormatException, IOException {
        long[] spreads = LogRegionPacker.readRegionHeader(forcedLogRegionFormat, data, type == Signature.ADLER32);
        long skip = 0L;
        for (long j : spreads) {
            long mark = data.getLong(data.position() + skip + j + 2L);
            if (mark > match) break;
            skip += j;
        }
        data.skip(skip);
        LogRecord target = null;
        while (target == null) {
            if (!data.hasRemaining()) {
                return null;
            }
            target = LogRegionPacker.readRecord(data, match);
        }
        return target;
    }

    public static List<LogRecord> unpack(Signature type, String forcedLogRegionFormat, Chunk data) throws FormatException {
        LogRegionPacker.readRegionHeader(forcedLogRegionFormat, data, type == Signature.ADLER32);
        LinkedList<LogRecord> queue = new LinkedList<LogRecord>();
        while (data.hasRemaining()) {
            queue.add(LogRegionPacker.readRecord(data, -1L));
        }
        return queue;
    }

    public static List<LogRecord> unpackInReverse(Signature type, String forcedLogRegionFormat, Chunk data) throws FormatException {
        LogRegionPacker.readRegionHeader(forcedLogRegionFormat, data, type == Signature.ADLER32);
        LinkedList<LogRecord> queue = new LinkedList<LogRecord>();
        while (data.hasRemaining()) {
            queue.push(LogRegionPacker.readRecord(data, -1L));
        }
        return queue;
    }

    @Override
    public List<LogRecord> unpack(Chunk data) throws FormatException {
        LogRegionPacker.readRegionHeader(this.forcedLogRegionFormat, data, false);
        ArrayList<LogRecord> queue = new ArrayList<LogRecord>();
        while (data.hasRemaining()) {
            queue.add(LogRegionPacker.readRecord(data, -1L));
        }
        return queue;
    }

    protected Chunk writeRecords(Iterable<LogRecord> records) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.tuningMax);
        int count = 0;
        int HINTS_MAX_SIZE = 256;
        int hintSpread = 16;
        ByteBuffer regionHeader = this.source.getBuffer(20);
        ByteBuffer hints = this.source.getBuffer(2050);
        buffers.add(regionHeader);
        buffers.add(hints);
        ArrayList<Long> spreads = new ArrayList<Long>(257);
        long pos = 0L;
        for (LogRecord record : records) {
            if (pos > 0L && count % hintSpread == 0) {
                spreads.add(pos);
                pos = 0L;
                if (spreads.size() > 256) {
                    boolean remove = true;
                    ListIterator<Long> si = spreads.listIterator();
                    while (si.hasNext()) {
                        pos += ((Long)si.next()).longValue();
                        if (remove) {
                            si.remove();
                        } else {
                            si.set(pos);
                            pos = 0L;
                        }
                        remove = !remove;
                    }
                    hintSpread <<= 1;
                }
            }
            ByteBuffer rhead = this.source.getBuffer(18);
            buffers.add(rhead);
            ByteBuffer[] payload = record.getPayload();
            long len = 0L;
            for (ByteBuffer bb : payload) {
                len += (long)bb.remaining();
                buffers.add(bb);
            }
            pos += len;
            pos += 18L;
            ++count;
            this.formRecordHeader(len, record.getLsn(), rhead);
            rhead.flip();
        }
        hints.putShort((short)spreads.size());
        for (Long spread : spreads) {
            hints.putLong(spread);
        }
        hints.flip();
        this.formRegionHeader(this.doChecksum() ? LogRegionPacker.checksum(buffers.subList(2, buffers.size())) : 0L, regionHeader);
        this.tuningMax += (int)Math.round((double)(count - this.tuningMax) * 0.1);
        return new BufferListWrapper(buffers, this.source);
    }

    protected boolean doChecksum() {
        return this.cType == Signature.ADLER32;
    }

    private static long[] readRegionHeader(String forcedLogRegionFormat, Chunk data, boolean checksum) throws FormatException {
        Chunk header = data.getChunk(20L);
        try {
            short region = header.getShort();
            long check = header.getLong();
            long check2 = header.getLong();
            byte[] regionFormat = FrsProperty.FORCE_LOG_REGION_FORMAT.defaultValue().equals(forcedLogRegionFormat) ? new byte[]{header.get(), header.get()} : Arrays.copyOf(forcedLogRegionFormat.getBytes(StandardCharsets.US_ASCII), 2);
            if (check != check2) {
                throw new FormatException("log region has mismatched checksums");
            }
            if (region != 2) {
                throw new FormatException("log region has an unrecognized version code");
            }
            long[] spreads = Arrays.equals(NEW_REGION_FORMAT, regionFormat) ? LogRegionPacker.readSpreads(data) : new long[]{};
            if (check != 0L && checksum) {
                long value;
                long l = value = data.getBuffers() == null ? LogRegionPacker.checksum(data) : LogRegionPacker.checksum(Arrays.asList(data.getBuffers()));
                if (check != value) {
                    throw new FormatException("Adler32 checksum is not correct", check, value, data.length());
                }
            }
            long[] lArray = spreads;
            return lArray;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (header instanceof Closeable) {
                try {
                    ((Closeable)((Object)header)).close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    private static long[] readSpreads(Chunk data) throws IOException {
        short len = data.getShort();
        long[] list = new long[len];
        Chunk c = data.getChunk(len * 8);
        for (int x = 0; x < list.length; ++x) {
            list[x] = c.getLong();
        }
        if (c instanceof Closeable) {
            ((Closeable)((Object)c)).close();
        }
        return list;
    }

    protected int formRegionHeader(long checksum, ByteBuffer header) {
        header.clear();
        header.putShort((short)2);
        header.putLong(checksum);
        header.putLong(checksum);
        header.put(NEW_REGION_FORMAT);
        header.flip();
        return header.remaining();
    }

    protected int formRecordHeader(long length, long lsn, ByteBuffer header) {
        header.putShort((short)2);
        header.putLong(lsn);
        header.putLong(length);
        return header.remaining();
    }

    protected static long checksum(Chunk bufs) {
        long pos = bufs.position();
        long lim = bufs.length();
        Adler32 checksum = new Adler32();
        byte[] temp = new byte[8192];
        while (bufs.hasRemaining()) {
            int got = bufs.get(temp);
            checksum.update(temp, 0, got);
        }
        bufs.clear();
        bufs.skip(pos);
        bufs.limit(lim);
        return checksum.getValue();
    }

    protected static long checksum(Iterable<ByteBuffer> bufs) {
        Adler32 checksum = new Adler32();
        for (ByteBuffer buf : bufs) {
            if (buf.hasArray()) {
                checksum.update(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position());
                continue;
            }
            byte[] temp = buffer.get();
            if (temp == null) {
                temp = new byte[8192];
                buffer.set(temp);
            }
            buf.mark();
            while (buf.hasRemaining()) {
                int fetch = buf.remaining() > temp.length ? temp.length : buf.remaining();
                buf.get(temp, 0, fetch);
                checksum.update(temp, 0, fetch);
            }
            buf.reset();
        }
        return checksum.getValue();
    }

    protected static byte[] md5(Iterable<ByteBuffer> bufs) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (ByteBuffer buf : bufs) {
                if (buf.hasArray()) {
                    md5.update(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position());
                    continue;
                }
                buf.mark();
                md5.update(buf);
                buf.reset();
            }
            return md5.digest();
        }
        catch (NoSuchAlgorithmException no) {
            LOGGER.error("MD5 checksumming selected but the package is not available", (Throwable)no);
            return new byte[16];
        }
    }

    private static LogRecord readRecord(Chunk buffer, long match) throws FormatException {
        Chunk header = buffer.getChunk(18L);
        long lsn = 0L;
        long len = 0L;
        try {
            short format = header.getShort();
            lsn = header.getLong();
            len = header.getLong();
            if (match < 0L || match == lsn) {
                if (format != 2) {
                    throw new FormatException("log record has an unrecognized version code");
                }
                Chunk payload = buffer.getChunk(len);
                LogRecordImpl record = payload instanceof Closeable ? new DisposableLogRecordImpl(payload) : new LogRecordImpl(payload.getBuffers(), null);
                record.updateLsn(lsn);
                LogRecordImpl logRecordImpl = record;
                return logRecordImpl;
            }
            if (lsn > match) {
                throw new AssertionError();
            }
            buffer.skip(len);
            LogRecord logRecord = null;
            return logRecord;
        }
        catch (Exception exp) {
            throw new RuntimeException("lsn:" + lsn + " len:" + len + " match:" + match, exp);
        }
        finally {
            if (header instanceof Closeable) {
                try {
                    ((Closeable)((Object)header)).close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    public static long getMinimumRecordOverhead() {
        return 46L;
    }
}

