/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AbstractJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.BufferSplitter;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.LargeMessagePersister;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.RefEncoding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationPrimaryIsStoppingMessage;
import org.apache.activemq.artemis.core.replication.ReplicatedJournal;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.journal.ActiveMQJournalBundle;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.ArtemisCloseable;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalStorageManager
extends AbstractJournalStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ACTIVEMQ_DATA = "activemq-data";
    protected SequentialFileFactory journalFF;
    protected SequentialFileFactory bindingsFF;
    protected SequentialFileFactory largeMessagesFactory;
    protected Journal originalMessageJournal;
    protected Journal originalBindingsJournal;
    protected String largeMessagesDirectory;
    protected ReplicationManager replicator;

    public JournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors) {
        this(config, analyzer, executorFactory, scheduledExecutorService, ioExecutors, null);
    }

    public JournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ExecutorFactory ioExecutors) {
        this(config, analyzer, executorFactory, null, ioExecutors, null);
    }

    public JournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutorService, ExecutorFactory ioExecutors, IOCriticalErrorListener criticalErrorListener) {
        super(config, analyzer, executorFactory, scheduledExecutorService, ioExecutors, criticalErrorListener);
    }

    public JournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ExecutorFactory ioExecutors, IOCriticalErrorListener criticalErrorListener) {
        super(config, analyzer, executorFactory, null, ioExecutors, criticalErrorListener);
    }

    @Override
    public Set<RemotingConnection> getUsedConnections() {
        if (this.replicator == null) {
            return Collections.emptySet();
        }
        HashSet<RemotingConnection> usedConnections = new HashSet<RemotingConnection>();
        usedConnections.add((RemotingConnection)this.replicator.getBackupTransportConnection());
        return usedConnections;
    }

    @Override
    public SequentialFileFactory getJournalSequentialFileFactory() {
        return this.journalFF;
    }

    @Override
    protected void init(Configuration config, IOCriticalErrorListener criticalErrorListener) {
        Journal localMessage;
        if (!EnumSet.allOf(JournalType.class).contains((Object)config.getJournalType())) {
            throw ActiveMQMessageBundle.BUNDLE.invalidJournal();
        }
        this.bindingsFF = new NIOSequentialFileFactory(config.getBindingsLocation(), criticalErrorListener, config.getJournalMaxIO_NIO());
        this.bindingsFF.setDatasync(config.isJournalDatasync());
        JournalImpl localBindings = new JournalImpl(this.ioExecutorFactory, 0x100000, 2, config.getJournalPoolFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), config.getJournalFileOpenTimeout(), this.bindingsFF, "activemq-bindings", "bindings", 1, 0, criticalErrorListener, config.getJournalMaxAtticFiles());
        this.bindingsJournal = localBindings;
        this.originalBindingsJournal = localBindings;
        switch (config.getJournalType()) {
            case NIO: {
                if (criticalErrorListener != null) {
                    ActiveMQServerLogger.LOGGER.journalUseNIO();
                }
                this.journalFF = new NIOSequentialFileFactory(config.getJournalLocation(), true, config.getJournalBufferSize_NIO(), config.getJournalBufferTimeout_NIO(), config.getJournalMaxIO_NIO(), config.isLogJournalWriteRate(), criticalErrorListener, this.getCriticalAnalyzer());
                break;
            }
            case ASYNCIO: {
                if (criticalErrorListener != null) {
                    ActiveMQServerLogger.LOGGER.journalUseAIO();
                }
                this.journalFF = new AIOSequentialFileFactory(config.getJournalLocation(), config.getJournalBufferSize_AIO(), config.getJournalBufferTimeout_AIO(), config.getJournalMaxIO_AIO(), config.isLogJournalWriteRate(), criticalErrorListener, this.getCriticalAnalyzer());
                if (config.getJournalDeviceBlockSize() == null) break;
                this.journalFF.setAlignment(config.getJournalDeviceBlockSize().intValue());
                break;
            }
            case MAPPED: {
                if (criticalErrorListener != null) {
                    ActiveMQServerLogger.LOGGER.journalUseMAPPED();
                }
                this.journalFF = new MappedSequentialFileFactory(config.getJournalLocation(), config.getJournalFileSize(), true, config.getJournalBufferSize_NIO(), config.getJournalBufferTimeout_NIO(), criticalErrorListener);
                break;
            }
            default: {
                throw ActiveMQMessageBundle.BUNDLE.invalidJournalType2(config.getJournalType());
            }
        }
        this.journalFF.setDatasync(config.isJournalDatasync());
        int fileSize = this.fixJournalFileSize(config.getJournalFileSize(), this.journalFF.getAlignment());
        this.messageJournal = localMessage = this.createMessageJournal(config, criticalErrorListener, fileSize);
        this.messageJournal.replaceableRecord((byte)34);
        this.messageJournal.replaceableRecord((byte)36);
        this.originalMessageJournal = localMessage;
        this.largeMessagesDirectory = config.getLargeMessagesDirectory();
        this.largeMessagesFactory = new NIOSequentialFileFactory(config.getLargeMessagesLocation(), false, criticalErrorListener, 1);
    }

    protected int fixJournalFileSize(int fileSize, int alignment) {
        int size = fileSize;
        if (fileSize <= alignment) {
            size = alignment;
        } else {
            int modulus = fileSize % alignment;
            if (modulus != 0) {
                int difference = modulus;
                int low = fileSize - difference;
                int high = low + alignment;
                size = difference < alignment / 2 ? low : high;
                ActiveMQServerLogger.LOGGER.invalidJournalFileSize(fileSize, size, alignment);
            }
        }
        return size;
    }

    protected Journal createMessageJournal(Configuration config, IOCriticalErrorListener criticalErrorListener, int fileSize) {
        return new JournalImpl(this.ioExecutorFactory, fileSize, config.getJournalMinFiles(), config.getJournalPoolFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), config.getJournalFileOpenTimeout(), this.journalFF, ACTIVEMQ_DATA, "amq", this.journalFF.getMaxIO(), 0, criticalErrorListener, config.getJournalMaxAtticFiles());
    }

    @Override
    protected void beforeStart() throws Exception {
        this.createDirectories();
        this.cleanupIncompleteFiles();
    }

    protected void createDirectories() {
        if (!this.config.isUsingDatabasePersistence()) {
            this.checkAndCreateDir(this.config.getBindingsLocation(), this.config.isCreateBindingsDir());
            this.checkAndCreateDir(this.config.getJournalLocation(), this.config.isCreateJournalDir());
            this.checkAndCreateDir(this.config.getLargeMessagesLocation(), this.config.isCreateJournalDir());
        }
    }

    @Override
    protected void beforeStop() throws Exception {
        if (this.replicator != null) {
            this.replicator.stop();
        }
    }

    @Override
    public void stop() throws Exception {
        this.stop(false, true);
    }

    @Override
    public boolean isReplicated() {
        return this.replicator != null && this.replicator.isStarted();
    }

    private void cleanupIncompleteFiles() throws Exception {
        if (this.largeMessagesFactory != null) {
            List tmpFiles = this.largeMessagesFactory.listFiles("tmp");
            for (String tmpFile : tmpFiles) {
                SequentialFile file = this.largeMessagesFactory.createSequentialFile(tmpFile);
                file.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        try (CriticalCloseable critical = this.measureCritical(1);){
            JournalStorageManager journalStorageManager = this;
            synchronized (journalStorageManager) {
                block11: {
                    if (!this.internalStop(ioCriticalError, sendFailover)) break block11;
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalStop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return true;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.stop();
            }
        }
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.executor.execute(latch::countDown);
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        try (CriticalCloseable critical = this.measureCritical(2);){
            this.storageManagerLock.writeLock().lock();
            try {
                ReplicationManager replicatorInUse = this.replicator;
                if (replicatorInUse != null) {
                    OperationContext token;
                    if (sendFailover && (token = this.replicator.sendPrimaryIsStopping(ReplicationPrimaryIsStoppingMessage.PrimaryStopping.FAIL_OVER)) != null) {
                        try {
                            token.waitCompletion(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    replicatorInUse.stop(false);
                }
                this.bindingsJournal.stop();
                this.messageJournal.stop();
                this.journalLoaded = false;
                this.started = false;
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    protected void performCachedLargeMessageDeletes() {
        this.storageManagerLock.writeLock().lock();
        try {
            this.largeMessagesToDelete.forEach((messageId, largeServerMessage) -> {
                SequentialFile msg = this.createFileForLargeMessage(messageId, StorageManager.LargeMessageExtension.DURABLE);
                try {
                    msg.delete();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.journalErrorDeletingMessage(messageId, e);
                }
                if (this.replicator != null) {
                    this.replicator.largeMessageDelete(messageId, this);
                }
            });
            this.largeMessagesToDelete.clear();
        }
        finally {
            this.storageManagerLock.writeLock().unlock();
        }
    }

    @Override
    protected LargeServerMessage parseLargeMessage(ActiveMQBuffer buff) throws Exception {
        LargeServerMessage largeMessage = this.createCoreLargeMessage();
        LargeMessagePersister.getInstance().decode(buff, largeMessage, null);
        largeMessage.setStorageManager(this);
        if (largeMessage.toMessage().containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            SequentialFile linkedFile;
            long originalMessageID = largeMessage.toMessage().getLongProperty(Message.HDR_ORIG_MESSAGE_ID);
            SequentialFile currentFile = this.createFileForLargeMessage(largeMessage.toMessage().getMessageID(), true);
            if (!currentFile.exists() && (linkedFile = this.createFileForLargeMessage(originalMessageID, true)).exists()) {
                linkedFile.copyTo(currentFile);
                linkedFile.close();
            }
            currentFile.close();
        }
        return largeMessage;
    }

    @Override
    public void pageClosed(SimpleString storeName, long pageNumber) {
        if (this.isReplicated()) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                if (this.isReplicated()) {
                    this.replicator.pageClosed(storeName, pageNumber);
                }
            }
        }
    }

    @Override
    public void pageDeleted(SimpleString storeName, long pageNumber) {
        if (this.isReplicated()) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                if (this.isReplicated()) {
                    this.replicator.pageDeleted(storeName, pageNumber);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pageWrite(SimpleString address, PagedMessage message, long pageNumber, boolean storageUp, boolean originallyReplicated) {
        ArtemisCloseable lock;
        if (this.messageJournal.isHistory()) {
            try {
                lock = this.closeableReadLock();
                try {
                    Message theMessage = message.getMessage();
                    if (theMessage.isLargeMessage() && theMessage instanceof LargeServerMessageImpl) {
                        this.messageJournal.appendAddEvent(theMessage.getMessageID(), (byte)30, (Persister)LargeMessagePersister.getInstance(), (Object)theMessage, false, (IOCompletion)this.getContext(false));
                    } else {
                        this.messageJournal.appendAddEvent(theMessage.getMessageID(), (byte)45, theMessage.getPersister(), (Object)theMessage, false, (IOCompletion)this.getContext(false));
                    }
                    for (long queueID : message.getQueueIDs()) {
                        this.messageJournal.appendAddEvent(message.getMessage().getMessageID(), (byte)32, (Persister)EncoderPersister.getInstance(), (Object)new RefEncoding(queueID), false, (IOCompletion)this.getContext(false));
                    }
                }
                finally {
                    if (lock != null) {
                        lock.close();
                    }
                }
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (this.isReplicated()) {
            lock = this.closeableReadLock();
            try {
                OperationContext context;
                if (this.isReplicated()) {
                    this.replicator.pageWrite(address, message, pageNumber, storageUp);
                    return;
                }
                if (!originallyReplicated || (context = OperationContextImpl.getContext()) == null) return;
                context.replicationDone();
                return;
            }
            finally {
                if (lock != null) {
                    lock.close();
                }
            }
        } else {
            OperationContext context;
            if (!originallyReplicated || (context = OperationContextImpl.getContext()) == null) return;
            context.replicationDone();
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return this.journalFF.allocateDirectBuffer(size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
        this.journalFF.releaseBuffer(buffer);
    }

    @Override
    public void largeMessageClosed(LargeServerMessage largeServerMessage) throws ActiveMQException {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (this.isReplicated()) {
                this.replicator.largeMessageClosed(largeServerMessage.toMessage().getMessageID(), this);
            }
        }
    }

    @Override
    public void deleteLargeMessageBody(LargeServerMessage largeServerMessage) throws ActiveMQException {
        SequentialFile file = largeServerMessage.getAppendFile();
        if (file == null) {
            return;
        }
        if (largeServerMessage.toMessage().isDurable() && this.isReplicated()) {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                if (this.isReplicated() && this.replicator.isSynchronizing()) {
                    this.largeMessagesToDelete.put(largeServerMessage.toMessage().getMessageID(), (Object)largeServerMessage);
                    return;
                }
            }
        }
        final Runnable deleteAction = () -> {
            try (ArtemisCloseable lock = this.closeableReadLock();){
                if (this.replicator != null) {
                    this.replicator.largeMessageDelete(largeServerMessage.toMessage().getMessageID(), this);
                }
                file.delete();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.journalErrorDeletingMessage(largeServerMessage.toMessage().getMessageID(), e);
            }
        };
        this.getContext(true).executeOnCompletion(new IOCallback(){

            public void done() {
                if (JournalStorageManager.this.executor == null) {
                    deleteAction.run();
                } else {
                    JournalStorageManager.this.executor.execute(deleteAction);
                }
            }

            public void onError(int errorCode, String errorMessage) {
            }
        });
    }

    @Override
    public LargeServerMessage createCoreLargeMessage() {
        return new LargeServerMessageImpl(this);
    }

    @Override
    public LargeServerMessage createCoreLargeMessage(long id, Message message) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Initializing large message {}", (Object)id, (Object)new Exception("trace"));
        }
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (this.isReplicated()) {
                this.replicator.largeMessageBegin(id);
            }
            LargeServerMessageImpl largeMessage = (LargeServerMessageImpl)this.createCoreLargeMessage();
            largeMessage.moveHeadersAndProperties(message);
            LargeServerMessage largeServerMessage = this.onLargeMessageCreate(id, largeMessage);
            return largeServerMessage;
        }
    }

    @Override
    public LargeServerMessage onLargeMessageCreate(long id, LargeServerMessage largeMessage) throws Exception {
        largeMessage.setMessageID(id);
        if (largeMessage.toMessage().isDurable()) {
            LargeServerMessageImpl largeServerMessage;
            int messageEncodeSize;
            long maxRecordSize = this.getMaxRecordSize();
            if (largeMessage instanceof LargeServerMessageImpl && (long)(messageEncodeSize = (largeServerMessage = (LargeServerMessageImpl)largeMessage).getEncodeSize()) > maxRecordSize) {
                ActiveMQServerLogger.LOGGER.messageWithHeaderTooLarge(largeMessage.getMessageID(), logger.getName());
                logger.debug("Message header too large for {}", (Object)largeMessage);
                throw ActiveMQJournalBundle.BUNDLE.recordLargerThanStoreMax((long)messageEncodeSize, maxRecordSize);
            }
        }
        return largeMessage;
    }

    @Override
    public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
        return this.largeMessagesFactory.createSequentialFile(messageID + extension.getExtension());
    }

    private void sendJournalFile(JournalFile[] journalFiles, AbstractJournalStorageManager.JournalContent type) throws Exception {
        for (JournalFile jf : journalFiles) {
            if (!this.started) {
                return;
            }
            ReplicationManager replicatorInUse = this.replicator;
            if (replicatorInUse == null) {
                throw ActiveMQMessageBundle.BUNDLE.replicatorIsNull();
            }
            replicatorInUse.syncJournalFile(jf, type);
        }
    }

    private JournalFile[] prepareJournalForCopy(Journal journal, AbstractJournalStorageManager.JournalContent contentType, String nodeID, boolean autoFailBack) throws Exception {
        journal.forceMoveNextFile();
        JournalFile[] datafiles = journal.getDataFiles();
        this.replicator.sendStartSyncMessage(datafiles, contentType, nodeID, autoFailBack);
        return datafiles;
    }

    void setReplicator(ReplicationManager replicator) {
        this.replicator = replicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplication(ReplicationManager replicationManager, PagingManager pagingManager, String nodeID, boolean autoFailBack, long initialReplicationSyncTimeout) throws Exception {
        if (!this.started) {
            throw new IllegalStateException("JournalStorageManager must be started...");
        }
        assert (replicationManager != null);
        if (!(this.originalMessageJournal instanceof JournalImpl) || !(this.originalBindingsJournal instanceof JournalImpl)) {
            throw ActiveMQMessageBundle.BUNDLE.notJournalImpl();
        }
        this.originalMessageJournal.scheduleCompactAndBlock(-1);
        this.originalBindingsJournal.scheduleCompactAndBlock(-1);
        JournalFile[] messageFiles = null;
        JournalFile[] bindingsFiles = null;
        Map<Long, Pair<String, Long>> pendingLargeMessages = null;
        try {
            Map<SimpleString, Collection<Integer>> pageFilesToSync;
            pagingManager.lock();
            this.storageManagerLock.writeLock().lock();
            try {
                if (this.isReplicated()) {
                    throw ActiveMQMessageBundle.BUNDLE.alreadyReplicating(this.replicator.isStarted());
                }
                this.replicator = replicationManager;
                ((JournalImpl)this.originalMessageJournal).flushAppendExecutor(10L, TimeUnit.SECONDS);
                ((JournalImpl)this.originalBindingsJournal).flushAppendExecutor(10L, TimeUnit.SECONDS);
                this.originalMessageJournal.synchronizationLock();
                this.originalBindingsJournal.synchronizationLock();
                try {
                    this.originalBindingsJournal.replicationSyncPreserveOldFiles();
                    this.originalMessageJournal.replicationSyncPreserveOldFiles();
                    pagingManager.disableCleanup();
                    messageFiles = this.prepareJournalForCopy(this.originalMessageJournal, AbstractJournalStorageManager.JournalContent.MESSAGES, nodeID, autoFailBack);
                    bindingsFiles = this.prepareJournalForCopy(this.originalBindingsJournal, AbstractJournalStorageManager.JournalContent.BINDINGS, nodeID, autoFailBack);
                    pageFilesToSync = this.getPageInformationForSync(pagingManager);
                    pendingLargeMessages = this.recoverPendingLargeMessages();
                }
                finally {
                    this.originalMessageJournal.synchronizationUnlock();
                    this.originalBindingsJournal.synchronizationUnlock();
                }
                this.bindingsJournal = new ReplicatedJournal(0, this.originalBindingsJournal, this.replicator);
                this.messageJournal = new ReplicatedJournal(1, this.originalMessageJournal, this.replicator);
                this.replicator.sendLargeMessageIdListMessage(pendingLargeMessages);
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
                pagingManager.unlock();
            }
            this.sendJournalFile(messageFiles, AbstractJournalStorageManager.JournalContent.MESSAGES);
            this.sendJournalFile(bindingsFiles, AbstractJournalStorageManager.JournalContent.BINDINGS);
            this.sendLargeMessageFiles(pendingLargeMessages);
            this.sendPagesToBackup(pageFilesToSync, pagingManager);
            this.storageManagerLock.writeLock().lock();
            try {
                if (this.replicator != null) {
                    this.replicator.sendSynchronizationDone(nodeID, initialReplicationSyncTimeout, this.ioCriticalErrorListener);
                    this.performCachedLargeMessageDeletes();
                }
            }
            finally {
                this.storageManagerLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToStartReplication(e);
            this.stopReplication();
            throw e;
        }
        finally {
            this.originalBindingsJournal.replicationSyncFinished();
            this.originalMessageJournal.replicationSyncFinished();
            pagingManager.resumeCleanup();
        }
    }

    private void sendLargeMessageFiles(Map<Long, Pair<String, Long>> pendingLargeMessages) throws Exception {
        Iterator<Map.Entry<Long, Pair<String, Long>>> iter = pendingLargeMessages.entrySet().iterator();
        while (this.started && iter.hasNext()) {
            Map.Entry<Long, Pair<String, Long>> entry = iter.next();
            String fileName = (String)entry.getValue().getA();
            long id = entry.getKey();
            long size = (Long)entry.getValue().getB();
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(fileName);
            if (!seqFile.exists()) continue;
            ReplicationManager replicatorInUse = this.replicator;
            if (replicatorInUse == null) {
                throw ActiveMQMessageBundle.BUNDLE.replicatorIsNull();
            }
            replicatorInUse.syncLargeMessageFile(seqFile, size, id);
        }
    }

    private Map<SimpleString, Collection<Integer>> getPageInformationForSync(PagingManager pagingManager) throws Exception {
        HashMap<SimpleString, Collection<Integer>> info = new HashMap<SimpleString, Collection<Integer>>();
        for (SimpleString storeName : pagingManager.getStoreNames()) {
            PagingStore store = pagingManager.getPageStore(storeName);
            Collection<Integer> ids = store.getCurrentIds();
            info.put(storeName, ids);
            if (ids.isEmpty()) continue;
            store.forceAnotherPage();
        }
        return info;
    }

    private void checkAndCreateDir(File dir, boolean create) {
        if (!dir.exists()) {
            if (create) {
                if (!dir.mkdirs() && !dir.exists()) {
                    throw new IllegalStateException("Failed to create directory " + String.valueOf(dir));
                }
            } else {
                throw ActiveMQMessageBundle.BUNDLE.cannotCreateDir(dir.getAbsolutePath());
            }
        }
    }

    private Map<Long, Pair<String, Long>> recoverPendingLargeMessages() throws Exception {
        HashMap<Long, Pair<String, Long>> largeMessages = new HashMap<Long, Pair<String, Long>>();
        List filenames = this.largeMessagesFactory.listFiles("msg");
        for (String filename : filenames) {
            long id = this.getLargeMessageIdFromFilename(filename);
            if (this.largeMessagesToDelete.containsKey(id)) continue;
            SequentialFile seqFile = this.largeMessagesFactory.createSequentialFile(filename);
            long size = seqFile.size();
            largeMessages.put(id, (Pair<String, Long>)new Pair((Object)filename, (Object)size));
        }
        return largeMessages;
    }

    @Override
    public void recoverLargeMessagesOnFolder(Set<Long> storedLargeMessages) throws Exception {
        List filenames = this.largeMessagesFactory.listFiles("msg");
        filenames.forEach(f -> storedLargeMessages.add(this.getLargeMessageIdFromFilename((String)f)));
    }

    private void sendPagesToBackup(Map<SimpleString, Collection<Integer>> pageFilesToSync, PagingManager manager) throws Exception {
        for (Map.Entry<SimpleString, Collection<Integer>> entry : pageFilesToSync.entrySet()) {
            if (!this.started) {
                return;
            }
            ReplicationManager replicatorInUse = this.replicator;
            if (replicatorInUse == null) {
                throw ActiveMQMessageBundle.BUNDLE.replicatorIsNull();
            }
            PagingStore store = manager.getPageStore(entry.getKey());
            store.sendPages(replicatorInUse, entry.getValue());
        }
    }

    private long getLargeMessageIdFromFilename(String filename) {
        return Long.parseLong(filename.split("\\.")[0]);
    }

    @Override
    public void stopReplication() {
        logger.trace("stopReplication()");
        this.storageManagerLock.writeLock().lock();
        try {
            if (this.replicator == null) {
                return;
            }
            this.bindingsJournal = this.originalBindingsJournal;
            this.messageJournal = this.originalMessageJournal;
            try {
                this.replicator.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingReplicationManager(e);
            }
            this.replicator = null;
            this.performCachedLargeMessageDeletes();
        }
        finally {
            this.storageManagerLock.writeLock().unlock();
        }
    }

    @Override
    public void addBytesToLargeMessage(SequentialFile file, long messageId, ActiveMQBuffer bytes) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (this.messageJournal.isHistory()) {
                BufferSplitter.split(bytes, 10240, c -> this.historyBody(messageId, (EncodingSupport)c));
            }
            file.position(file.size());
            if (bytes.byteBuf() != null && bytes.byteBuf().nioBufferCount() == 1) {
                ByteBuffer nioBytes = bytes.byteBuf().internalNioBuffer(bytes.readerIndex(), bytes.readableBytes());
                file.blockingWriteDirect(nioBytes, false, false);
                if (this.isReplicated()) {
                    byte[] bytesCopy = new byte[bytes.readableBytes()];
                    bytes.getBytes(bytes.readerIndex(), bytesCopy);
                    this.replicator.largeMessageWrite(messageId, bytesCopy);
                }
            } else {
                byte[] bytesCopy = new byte[bytes.readableBytes()];
                bytes.readBytes(bytesCopy);
                this.addBytesToLargeMessage(file, messageId, bytesCopy);
            }
        }
    }

    private void historyBody(long messageId, EncodingSupport partialBuffer) {
        try {
            this.messageJournal.appendAddEvent(messageId, (byte)49, (Persister)EncoderPersister.getInstance(), (Object)partialBuffer, false, null);
        }
        catch (Exception e) {
            logger.warn("Error processing history large message body for {}", (Object)messageId, (Object)e);
        }
    }

    @Override
    public void addBytesToLargeMessage(SequentialFile file, long messageId, byte[] bytes) throws Exception {
        try (ArtemisCloseable lock = this.closeableReadLock();){
            if (this.messageJournal.isHistory()) {
                BufferSplitter.split(bytes, 10240, c -> this.historyBody(messageId, (EncodingSupport)c));
            }
            file.position(file.size());
            file.blockingWriteDirect(ByteBuffer.wrap(bytes), false, false);
            if (this.isReplicated()) {
                this.replicator.largeMessageWrite(messageId, bytes);
            }
        }
    }

    @Override
    public void injectMonitor(FileStoreMonitor monitor) throws Exception {
        if (this.journalFF != null) {
            monitor.addStore(this.journalFF.getDirectory());
        }
        if (this.largeMessagesFactory != null) {
            monitor.addStore(this.largeMessagesFactory.getDirectory());
        }
        if (this.bindingsFF != null) {
            monitor.addStore(this.bindingsFF.getDirectory());
        }
    }

    @Override
    public int getAllowedPageSize(int pageSize) {
        if (this.config.getStoreConfiguration() == null) {
            return pageSize;
        }
        return this.config.getStoreConfiguration().getAllowedPageSize(pageSize);
    }
}

