/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.utils;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oidc.idp.OidcProviderMetadata;
import org.apache.cxf.rt.security.crypto.MessageDigestUtils;

public final class OidcUtils {
    public static final String ID_TOKEN_RESPONSE_TYPE = "id_token";
    public static final String ID_TOKEN_AT_RESPONSE_TYPE = "id_token token";
    public static final String CODE_AT_RESPONSE_TYPE = "code token";
    public static final String CODE_ID_TOKEN_RESPONSE_TYPE = "code id_token";
    public static final String CODE_ID_TOKEN_AT_RESPONSE_TYPE = "code id_token token";
    public static final String ID_TOKEN = "id_token";
    public static final String OPENID_SCOPE = "openid";
    public static final String PROFILE_SCOPE = "profile";
    public static final String EMAIL_SCOPE = "email";
    public static final String ADDRESS_SCOPE = "address";
    public static final String PHONE_SCOPE = "phone";
    public static final List<String> PROFILE_CLAIMS = Collections.unmodifiableList(Arrays.asList("name", "family_name", "given_name", "middle_name", "nickname", "preferred_username", "profile", "picture", "website", "gender", "birthdate", "zoneinfo", "locale", "updated_at"));
    public static final List<String> EMAIL_CLAIMS = Collections.unmodifiableList(Arrays.asList("email", "email_verified"));
    public static final List<String> ADDRESS_CLAIMS = Collections.unmodifiableList(Arrays.asList("address"));
    public static final List<String> PHONE_CLAIMS = Collections.unmodifiableList(Arrays.asList("phone_number"));
    public static final String CLAIMS_PARAM = "claims";
    public static final String CLAIM_NAMES_PROPERTY = "_claim_names";
    public static final String CLAIM_SOURCES_PROPERTY = "_claim_sources";
    public static final String JWT_CLAIM_SOURCE_PROPERTY = "JWT";
    public static final String ENDPOINT_CLAIM_SOURCE_PROPERTY = "endpoint";
    public static final String TOKEN_CLAIM_SOURCE_PROPERTY = "access_token";
    public static final String PROMPT_PARAMETER = "prompt";
    public static final String PROMPT_NONE_VALUE = "none";
    public static final String PROMPT_CONSENT_VALUE = "consent";
    public static final String CONSENT_REQUIRED_ERROR = "consent_required";
    private static final Map<String, List<String>> SCOPES_MAP = new HashMap<String, List<String>>();

    private OidcUtils() {
    }

    public static List<String> getPromptValues(MultivaluedMap<String, String> params) {
        String prompt = (String)params.getFirst((Object)PROMPT_PARAMETER);
        if (prompt != null) {
            return Arrays.asList(prompt.trim().split(" "));
        }
        return Collections.emptyList();
    }

    public static String getOpenIdScope() {
        return OPENID_SCOPE;
    }

    public static String getProfileScope() {
        return OidcUtils.getScope(OPENID_SCOPE, PROFILE_SCOPE);
    }

    public static String getEmailScope() {
        return OidcUtils.getScope(OPENID_SCOPE, EMAIL_SCOPE);
    }

    public static String getAddressScope() {
        return OidcUtils.getScope(OPENID_SCOPE, ADDRESS_SCOPE);
    }

    public static String getPhoneScope() {
        return OidcUtils.getScope(OPENID_SCOPE, PHONE_SCOPE);
    }

    public static String getAllScopes() {
        return OidcUtils.getScope(OPENID_SCOPE, PROFILE_SCOPE, EMAIL_SCOPE, ADDRESS_SCOPE, PHONE_SCOPE);
    }

    public static List<String> getScopeClaims(String ... scope) {
        ArrayList<String> claims = new ArrayList<String>();
        if (scope != null) {
            for (String s : scope) {
                if (!SCOPES_MAP.containsKey(s)) continue;
                claims.addAll((Collection<String>)SCOPES_MAP.get(s));
            }
        }
        return claims;
    }

    private static String getScope(String ... scopes) {
        return String.join((CharSequence)" ", scopes);
    }

    public static void validateAccessTokenHash(ClientAccessToken at, JwtToken jwt) {
        OidcUtils.validateAccessTokenHash(at, jwt, true);
    }

    public static void validateAccessTokenHash(ClientAccessToken at, JwtToken jwt, boolean required) {
        OidcUtils.validateAccessTokenHash(at.getTokenKey(), jwt, required);
    }

    public static void validateAccessTokenHash(String accessToken, JwtToken jwt, boolean required) {
        String hashClaim = (String)jwt.getClaims().getClaim("at_hash");
        if (hashClaim == null && required) {
            throw new OAuthServiceException("Invalid hash");
        }
        if (hashClaim != null) {
            OidcUtils.validateHash(accessToken, (String)jwt.getClaims().getClaim("at_hash"), jwt.getJwsHeaders().getSignatureAlgorithm());
        }
    }

    public static void validateCodeHash(String code, JwtToken jwt) {
        OidcUtils.validateCodeHash(code, jwt, true);
    }

    public static void validateCodeHash(String code, JwtToken jwt, boolean required) {
        String hashClaim = (String)jwt.getClaims().getClaim("c_hash");
        if (hashClaim == null && required) {
            throw new OAuthServiceException("Invalid hash");
        }
        if (hashClaim != null) {
            OidcUtils.validateHash(code, (String)jwt.getClaims().getClaim("c_hash"), jwt.getJwsHeaders().getSignatureAlgorithm());
        }
    }

    private static void validateHash(String value, String theHash, SignatureAlgorithm joseAlgo) {
        String hash = OidcUtils.calculateHash(value, joseAlgo);
        if (!hash.equals(theHash)) {
            throw new OAuthServiceException("Invalid hash");
        }
    }

    public static String calculateAccessTokenHash(String value, SignatureAlgorithm sigAlgo) {
        return OidcUtils.calculateHash(value, sigAlgo);
    }

    public static String calculateAuthorizationCodeHash(String value, SignatureAlgorithm sigAlgo) {
        return OidcUtils.calculateHash(value, sigAlgo);
    }

    private static String calculateHash(String value, SignatureAlgorithm sigAlgo) {
        if (sigAlgo == SignatureAlgorithm.NONE) {
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
        String algoShaSizeString = sigAlgo.getJwaName().substring(2);
        String javaShaAlgo = "SHA-" + algoShaSizeString;
        int algoShaSize = Integer.parseInt(algoShaSizeString);
        int valueHashSize = algoShaSize / 8 / 2;
        try {
            byte[] atBytes = StringUtils.toBytesASCII((String)value);
            byte[] digest = MessageDigestUtils.createDigest((byte[])atBytes, (String)javaShaAlgo);
            return Base64UrlUtility.encodeChunk((byte[])digest, (int)0, (int)valueHashSize);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OAuthServiceException((Throwable)ex);
        }
    }

    public static void setStateClaimsProperty(OAuthRedirectionState state, MultivaluedMap<String, String> params) {
        String claims = (String)params.getFirst((Object)CLAIMS_PARAM);
        if (claims != null) {
            state.getExtraProperties().put(CLAIMS_PARAM, claims);
        }
    }

    public static OidcProviderMetadata getOidcProviderMetadata(String issuerURL) {
        Response response = WebClient.create((String)issuerURL).path((Object)"/.well-known/openid-configuration").accept(new String[]{"application/json"}).get();
        if (Response.Status.OK.getStatusCode() != response.getStatus()) {
            throw ExceptionUtils.toWebApplicationException((Response)response);
        }
        return new OidcProviderMetadata(new JsonMapObjectReaderWriter().fromJson((String)response.readEntity(String.class)));
    }

    static {
        SCOPES_MAP.put(PHONE_SCOPE, PHONE_CLAIMS);
        SCOPES_MAP.put(EMAIL_SCOPE, EMAIL_CLAIMS);
        SCOPES_MAP.put(ADDRESS_SCOPE, ADDRESS_CLAIMS);
        SCOPES_MAP.put(PROFILE_SCOPE, PROFILE_CLAIMS);
    }
}

