/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.apache.commons.digester3.BeanPropertySetterRule;
import org.apache.commons.digester3.CallMethodRule;
import org.apache.commons.digester3.CallParamRule;
import org.apache.commons.digester3.FactoryCreateRule;
import org.apache.commons.digester3.ObjectCreateRule;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.apache.commons.digester3.ObjectParamRule;
import org.apache.commons.digester3.PathCallParamRule;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.RuleSet;
import org.apache.commons.digester3.Rules;
import org.apache.commons.digester3.RulesBase;
import org.apache.commons.digester3.SetNestedPropertiesRule;
import org.apache.commons.digester3.SetNextRule;
import org.apache.commons.digester3.SetPropertiesRule;
import org.apache.commons.digester3.SetPropertyRule;
import org.apache.commons.digester3.SetRootRule;
import org.apache.commons.digester3.SetTopRule;
import org.apache.commons.digester3.StackAction;
import org.apache.commons.digester3.Substitutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digester
extends DefaultHandler {
    private StringBuilder bodyText = new StringBuilder();
    private final Stack<StringBuilder> bodyTexts = new Stack();
    private final Stack<List<Rule>> matches = new Stack();
    private ClassLoader classLoader = null;
    private boolean configured = false;
    private EntityResolver entityResolver;
    private final HashMap<String, URL> entityValidator = new HashMap();
    private ErrorHandler errorHandler = null;
    private SAXParserFactory factory = null;
    private Locator locator = null;
    private String match = "";
    private boolean namespaceAware = false;
    private ExecutorService executorService;
    private final HashMap<String, Stack<String>> namespaces = new HashMap();
    private boolean xincludeAware = false;
    private final Stack<Object[]> params = new Stack();
    private SAXParser parser = null;
    private String publicId = null;
    private XMLReader reader = null;
    private Object root = null;
    private Rules rules = null;
    private Schema schema = null;
    private final Stack<Object> stack = new Stack();
    private boolean useContextClassLoader = true;
    private boolean validating = false;
    private Log log = LogFactory.getLog("org.apache.commons.digester3.Digester");
    private Log saxLog = LogFactory.getLog("org.apache.commons.digester3.Digester.sax");
    protected static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private Substitutor substitutor;
    private final HashMap<String, Stack<Object>> stacksByName = new HashMap();
    private ContentHandler customContentHandler = null;
    private StackAction stackAction = null;
    protected List<InputSource> inputSources = new ArrayList<InputSource>(5);

    public Digester() {
    }

    public Digester(SAXParser parser) {
        this.parser = parser;
    }

    public Digester(XMLReader reader) {
        this.reader = reader;
    }

    public String findNamespaceURI(String prefix) {
        Stack<String> nsStack = this.namespaces.get(prefix);
        if (nsStack == null) {
            return null;
        }
        try {
            return nsStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public int getCount() {
        return this.stack.size();
    }

    public String getCurrentElementName() {
        String elementName = this.match;
        int lastSlash = elementName.lastIndexOf(47);
        if (lastSlash >= 0) {
            elementName = elementName.substring(lastSlash + 1);
        }
        return elementName;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SAXParserFactory getFactory() {
        if (this.factory == null) {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(this.namespaceAware);
            this.factory.setXIncludeAware(this.xincludeAware);
            this.factory.setValidating(this.validating);
            this.factory.setSchema(this.schema);
        }
        return this.factory;
    }

    public boolean getFeature(String feature) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        return this.getFactory().getFeature(feature);
    }

    public void setFeature(String feature, boolean value) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        this.getFactory().setFeature(feature, value);
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public Log getSAXLogger() {
        return this.saxLog;
    }

    public void setSAXLogger(Log saxLog) {
        this.saxLog = saxLog;
    }

    public String getMatch() {
        return this.match;
    }

    public Stack<List<Rule>> getMatches() {
        return this.matches;
    }

    public boolean getNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean getXIncludeAware() {
        return this.xincludeAware;
    }

    public void setXIncludeAware(boolean xincludeAware) {
        this.xincludeAware = xincludeAware;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getRuleNamespaceURI() {
        return this.getRules().getNamespaceURI();
    }

    public void setRuleNamespaceURI(String ruleNamespaceURI) {
        this.getRules().setNamespaceURI(ruleNamespaceURI);
    }

    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        try {
            this.parser = this.getFactory().newSAXParser();
        }
        catch (Exception e) {
            this.log.error("Digester.getParser: ", e);
            return null;
        }
        return this.parser;
    }

    public Object getProperty(String property) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.getParser().getProperty(property);
    }

    public void setProperty(String property, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getParser().setProperty(property, value);
    }

    public Rules getRules() {
        if (this.rules == null) {
            this.rules = new RulesBase();
            this.rules.setDigester(this);
        }
        return this.rules;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public Schema getXMLSchema() {
        return this.schema;
    }

    public void setXMLSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
        }
        this.reader.setDTDHandler(this);
        this.reader.setContentHandler(this);
        if (this.entityResolver == null) {
            this.reader.setEntityResolver(this);
        } else {
            this.reader.setEntityResolver(this.entityResolver);
        }
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    public Substitutor getSubstitutor() {
        return this.substitutor;
    }

    public void setSubstitutor(Substitutor substitutor) {
        this.substitutor = substitutor;
    }

    public ContentHandler getCustomContentHandler() {
        return this.customContentHandler;
    }

    public void setCustomContentHandler(ContentHandler handler) {
        this.customContentHandler = handler;
    }

    public void setStackAction(StackAction stackAction) {
        this.stackAction = stackAction;
    }

    public StackAction getStackAction() {
        return this.stackAction;
    }

    public Map<String, String> getCurrentNamespaces() {
        if (!this.namespaceAware) {
            this.log.warn("Digester is not namespace aware");
        }
        HashMap<String, String> currentNamespaces = new HashMap<String, String>();
        for (Map.Entry<String, Stack<String>> nsEntry : this.namespaces.entrySet()) {
            try {
                currentNamespaces.put(nsEntry.getKey(), nsEntry.getValue().peek());
            }
            catch (RuntimeException e) {
                this.log.error(e.getMessage(), e);
                throw e;
            }
        }
        return currentNamespaces;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void characters(char[] buffer, int start, int length) throws SAXException {
        if (this.customContentHandler != null) {
            this.customContentHandler.characters(buffer, start, length);
            return;
        }
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("characters(" + new String(buffer, start, length) + ")");
        }
        this.bodyText.append(buffer, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            if (this.getCount() > 1) {
                this.saxLog.debug("endDocument():  " + this.getCount() + " elements left");
            } else {
                this.saxLog.debug("endDocument()");
            }
        }
        for (Rule rule : this.getRules().rules()) {
            try {
                rule.finish();
            }
            catch (Exception e) {
                this.log.error("Finish event threw exception", e);
                throw this.createSAXException(e);
            }
            catch (Error e) {
                this.log.error("Finish event threw error", e);
                throw e;
            }
        }
        this.clear();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        int slash;
        List<Rule> rules;
        String name;
        if (this.customContentHandler != null) {
            this.customContentHandler.endElement(namespaceURI, localName, qName);
            return;
        }
        boolean debug = this.log.isDebugEnabled();
        if (debug) {
            if (this.saxLog.isDebugEnabled()) {
                this.saxLog.debug("endElement(" + namespaceURI + "," + localName + "," + qName + ")");
            }
            this.log.debug("  match='" + this.match + "'");
            this.log.debug("  bodyText='" + this.bodyText + "'");
        }
        if ((name = localName) == null || name.length() < 1) {
            name = qName;
        }
        if ((rules = this.matches.pop()) != null && rules.size() > 0) {
            String bodyText = this.bodyText.toString();
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                bodyText = substitutor.substitute(bodyText);
            }
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    Rule rule = rules.get(i);
                    if (debug) {
                        this.log.debug("  Fire body() for " + rule);
                    }
                    rule.body(namespaceURI, name, bodyText);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Body event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("Body event threw error", e);
                    throw e;
                }
            }
        } else if (debug) {
            this.log.debug("  No rules found matching '" + this.match + "'.");
        }
        this.bodyText = this.bodyTexts.pop();
        if (debug) {
            this.log.debug("  Popping body text '" + this.bodyText.toString() + "'");
        }
        if (rules != null) {
            for (int i = 0; i < rules.size(); ++i) {
                int j = rules.size() - i - 1;
                try {
                    Rule rule = rules.get(j);
                    if (debug) {
                        this.log.debug("  Fire end() for " + rule);
                    }
                    rule.end(namespaceURI, name);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("End event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("End event threw error", e);
                    throw e;
                }
            }
        }
        this.match = (slash = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, slash) : "";
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        Stack<String> stack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("endPrefixMapping(" + prefix + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            return;
        }
        try {
            stack.pop();
            if (stack.empty()) {
                this.namespaces.remove(prefix);
            }
        }
        catch (EmptyStackException e) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    @Override
    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("ignorableWhitespace(" + new String(buffer, start, len) + ")");
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.customContentHandler != null) {
            this.customContentHandler.processingInstruction(target, data);
            return;
        }
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("processingInstruction('" + target + "','" + data + "')");
        }
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("setDocumentLocator(" + locator + ")");
        }
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("skippedEntity(" + name + ")");
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startDocument()");
        }
        this.configure();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        boolean debug = this.log.isDebugEnabled();
        if (this.customContentHandler != null) {
            this.customContentHandler.startElement(namespaceURI, localName, qName, list);
            return;
        }
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startElement(" + namespaceURI + "," + localName + "," + qName + ")");
        }
        this.bodyTexts.push(this.bodyText);
        if (debug) {
            this.log.debug("  Pushing body text '" + this.bodyText.toString() + "'");
        }
        this.bodyText = new StringBuilder();
        String name = localName;
        if (name == null || name.length() < 1) {
            name = qName;
        }
        StringBuilder sb = new StringBuilder(this.match);
        if (this.match.length() > 0) {
            sb.append('/');
        }
        sb.append(name);
        this.match = sb.toString();
        if (debug) {
            this.log.debug("  New match='" + this.match + "'");
        }
        List<Rule> rules = this.getRules().match(namespaceURI, this.match, localName, list);
        this.matches.push(rules);
        if (rules != null && rules.size() > 0) {
            Substitutor substitutor = this.getSubstitutor();
            if (substitutor != null) {
                list = substitutor.substitute(list);
            }
            for (int i = 0; i < rules.size(); ++i) {
                try {
                    Rule rule = rules.get(i);
                    if (debug) {
                        this.log.debug("  Fire begin() for " + rule);
                    }
                    rule.begin(namespaceURI, name, list);
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Begin event threw exception", e);
                    throw this.createSAXException(e);
                }
                catch (Error e) {
                    this.log.error("Begin event threw error", e);
                    throw e;
                }
            }
        } else if (debug) {
            this.log.debug("  No rules found matching '" + this.match + "'.");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        Stack<String> stack;
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("startPrefixMapping(" + prefix + "," + namespaceURI + ")");
        }
        if ((stack = this.namespaces.get(prefix)) == null) {
            stack = new Stack();
            this.namespaces.put(prefix, stack);
        }
        stack.push(namespaceURI);
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("notationDecl(" + name + "," + publicId + "," + systemId + ")");
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("unparsedEntityDecl(" + name + "," + publicId + "," + systemId + "," + notation + ")");
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.saxLog.isDebugEnabled()) {
            this.saxLog.debug("resolveEntity('" + publicId + "', '" + systemId + "')");
        }
        if (publicId != null) {
            this.publicId = publicId;
        }
        URL entityURL = null;
        if (publicId != null) {
            entityURL = this.entityValidator.get(publicId);
        }
        if (entityURL == null && systemId != null) {
            entityURL = this.entityValidator.get(systemId);
        }
        if (entityURL == null) {
            if (systemId == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(" Cannot resolve null entity, returning null InputSource");
                }
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(" Trying to resolve using system ID '" + systemId + "'");
            }
            try {
                entityURL = new URL(systemId);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL '" + systemId + "' : " + e.getMessage());
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Resolving to alternate DTD '" + entityURL + "'");
        }
        try {
            return this.createInputSourceFromURL(entityURL);
        }
        catch (Exception e) {
            throw this.createSAXException(e);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.log.error("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.log.error("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(exception);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.errorHandler != null) {
            this.log.warn("Parse Warning Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
            this.errorHandler.warning(exception);
        }
    }

    public <T> T parse(File file) throws IOException, SAXException {
        if (file == null) {
            throw new IllegalArgumentException("File to parse is null");
        }
        InputSource input = new InputSource(new FileInputStream(file));
        input.setSystemId(file.toURI().toURL().toString());
        return this.parse(input);
    }

    public <T> Future<T> asyncParse(final File file) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(file);
            }
        });
    }

    public <T> T parse(InputSource input) throws IOException, SAXException {
        if (input == null) {
            throw new IllegalArgumentException("InputSource to parse is null");
        }
        this.configure();
        String systemId = input.getSystemId();
        if (systemId == null) {
            systemId = "(already loaded from stream)";
        }
        try {
            this.getXMLReader().parse(input);
        }
        catch (IOException e) {
            this.log.error(String.format("An error occurred while reading stream from '%s', see nested exceptions", systemId), e);
            throw e;
        }
        catch (SAXException e) {
            this.log.error(String.format("An error occurred while parsing XML from '%s', see nested exceptions", systemId), e);
            throw e;
        }
        this.cleanup();
        return this.getRoot();
    }

    public <T> Future<T> asyncParse(final InputSource input) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(input);
            }
        });
    }

    public <T> T parse(InputStream input) throws IOException, SAXException {
        if (input == null) {
            throw new IllegalArgumentException("InputStream to parse is null");
        }
        return this.parse(new InputSource(input));
    }

    public <T> Future<T> asyncParse(final InputStream input) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(input);
            }
        });
    }

    public <T> T parse(Reader reader) throws IOException, SAXException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader to parse is null");
        }
        return this.parse(new InputSource(reader));
    }

    public <T> Future<T> asyncParse(final Reader reader) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(reader);
            }
        });
    }

    public <T> T parse(String uri) throws IOException, SAXException {
        if (uri == null) {
            throw new IllegalArgumentException("String URI to parse is null");
        }
        return this.parse(this.createInputSourceFromURL(uri));
    }

    public <T> Future<T> asyncParse(final String uri) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(uri);
            }
        });
    }

    public <T> T parse(URL url) throws IOException, SAXException {
        if (url == null) {
            throw new IllegalArgumentException("URL to parse is null");
        }
        return this.parse(this.createInputSourceFromURL(url));
    }

    public <T> Future<T> asyncParse(final URL url) {
        return this.asyncParse(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return Digester.this.parse(url);
            }
        });
    }

    private <T> Future<T> asyncParse(Callable<T> callable) {
        if (this.executorService == null) {
            throw new IllegalStateException("ExecutorService not set");
        }
        return this.executorService.submit(callable);
    }

    public void register(String publicId, URL entityURL) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("register('" + publicId + "', '" + entityURL + "'");
        }
        this.entityValidator.put(publicId, entityURL);
    }

    public void register(String publicId, String entityURL) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("register('" + publicId + "', '" + entityURL + "'");
        }
        try {
            this.entityValidator.put(publicId, new URL(entityURL));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL '" + entityURL + "' : " + e.getMessage());
        }
    }

    public void registerAll(Map<String, URL> entityValidator) {
        this.entityValidator.putAll(entityValidator);
    }

    public InputSource createInputSourceFromURL(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream stream = connection.getInputStream();
        InputSource source = new InputSource(stream);
        source.setSystemId(url.toExternalForm());
        this.inputSources.add(source);
        return source;
    }

    public InputSource createInputSourceFromURL(String url) throws IOException {
        return this.createInputSourceFromURL(new URL(url));
    }

    public void addRule(String pattern, Rule rule) {
        rule.setDigester(this);
        this.getRules().add(pattern, rule);
    }

    public void addRuleSet(RuleSet ruleSet) {
        String oldNamespaceURI = this.getRuleNamespaceURI();
        String newNamespaceURI = ruleSet.getNamespaceURI();
        if (this.log.isDebugEnabled()) {
            if (newNamespaceURI == null) {
                this.log.debug("addRuleSet() with no namespace URI");
            } else {
                this.log.debug("addRuleSet() with namespace URI " + newNamespaceURI);
            }
        }
        this.setRuleNamespaceURI(newNamespaceURI);
        ruleSet.addRuleInstances(this);
        this.setRuleNamespaceURI(oldNamespaceURI);
    }

    public void addBeanPropertySetter(String pattern) {
        this.addRule(pattern, new BeanPropertySetterRule());
    }

    public void addBeanPropertySetter(String pattern, String propertyName) {
        this.addRule(pattern, new BeanPropertySetterRule(propertyName));
    }

    public void addCallMethod(String pattern, String methodName) {
        this.addRule(pattern, new CallMethodRule(methodName));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, String[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount, paramTypes));
    }

    public void addCallMethod(String pattern, String methodName, int paramCount, Class<?>[] paramTypes) {
        this.addRule(pattern, new CallMethodRule(methodName, paramCount, paramTypes));
    }

    public void addCallParam(String pattern, int paramIndex) {
        this.addRule(pattern, new CallParamRule(paramIndex));
    }

    public void addCallParam(String pattern, int paramIndex, String attributeName) {
        this.addRule(pattern, new CallParamRule(paramIndex, attributeName));
    }

    public void addCallParam(String pattern, int paramIndex, boolean fromStack) {
        this.addRule(pattern, new CallParamRule(paramIndex, fromStack));
    }

    public void addCallParam(String pattern, int paramIndex, int stackIndex) {
        this.addRule(pattern, new CallParamRule(paramIndex, stackIndex));
    }

    public void addCallParamPath(String pattern, int paramIndex) {
        this.addRule(pattern, new PathCallParamRule(paramIndex));
    }

    public void addObjectParam(String pattern, int paramIndex, Object paramObj) {
        this.addRule(pattern, new ObjectParamRule(paramIndex, paramObj));
    }

    public void addFactoryCreate(String pattern, String className) {
        this.addFactoryCreate(pattern, className, false);
    }

    public void addFactoryCreate(String pattern, Class<? extends ObjectCreationFactory<?>> clazz) {
        this.addFactoryCreate(pattern, clazz, false);
    }

    public void addFactoryCreate(String pattern, String className, String attributeName) {
        this.addFactoryCreate(pattern, className, attributeName, false);
    }

    public void addFactoryCreate(String pattern, Class<? extends ObjectCreationFactory<?>> clazz, String attributeName) {
        this.addFactoryCreate(pattern, clazz, attributeName, false);
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory<?> creationFactory) {
        this.addFactoryCreate(pattern, creationFactory, false);
    }

    public void addFactoryCreate(String pattern, String className, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(className, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, Class<? extends ObjectCreationFactory<?>> clazz, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(clazz, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, String className, String attributeName, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(className, attributeName, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, Class<? extends ObjectCreationFactory<?>> clazz, String attributeName, boolean ignoreCreateExceptions) {
        this.addRule(pattern, new FactoryCreateRule(clazz, attributeName, ignoreCreateExceptions));
    }

    public void addFactoryCreate(String pattern, ObjectCreationFactory<?> creationFactory, boolean ignoreCreateExceptions) {
        creationFactory.setDigester(this);
        this.addRule(pattern, new FactoryCreateRule(creationFactory, ignoreCreateExceptions));
    }

    public void addObjectCreate(String pattern, String className) {
        this.addRule(pattern, new ObjectCreateRule(className));
    }

    public void addObjectCreate(String pattern, Class<?> clazz) {
        this.addRule(pattern, new ObjectCreateRule(clazz));
    }

    public void addObjectCreate(String pattern, String className, String attributeName) {
        this.addRule(pattern, new ObjectCreateRule(className, attributeName));
    }

    public void addObjectCreate(String pattern, String attributeName, Class<?> clazz) {
        this.addRule(pattern, new ObjectCreateRule(attributeName, clazz));
    }

    public void addSetNestedProperties(String pattern) {
        this.addRule(pattern, new SetNestedPropertiesRule());
    }

    public void addSetNestedProperties(String pattern, String elementName, String propertyName) {
        this.addRule(pattern, new SetNestedPropertiesRule(elementName, propertyName));
    }

    public void addSetNestedProperties(String pattern, String[] elementNames, String[] propertyNames) {
        this.addRule(pattern, new SetNestedPropertiesRule(elementNames, propertyNames));
    }

    public void addSetNext(String pattern, String methodName) {
        this.addRule(pattern, new SetNextRule(methodName));
    }

    public void addSetNext(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetNextRule(methodName, paramType));
    }

    public void addSetRoot(String pattern, String methodName) {
        this.addRule(pattern, new SetRootRule(methodName));
    }

    public void addSetRoot(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetRootRule(methodName, paramType));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesRule());
    }

    public void addSetProperties(String pattern, String attributeName, String propertyName) {
        this.addRule(pattern, new SetPropertiesRule(attributeName, propertyName));
    }

    public void addSetProperties(String pattern, String[] attributeNames, String[] propertyNames) {
        this.addRule(pattern, new SetPropertiesRule(attributeNames, propertyNames));
    }

    public void addSetProperty(String pattern, String name, String value) {
        this.addRule(pattern, new SetPropertyRule(name, value));
    }

    public void addSetTop(String pattern, String methodName) {
        this.addRule(pattern, new SetTopRule(methodName));
    }

    public void addSetTop(String pattern, String methodName, String paramType) {
        this.addRule(pattern, new SetTopRule(methodName, paramType));
    }

    public void clear() {
        this.match = "";
        this.bodyTexts.clear();
        this.params.clear();
        this.publicId = null;
        this.stack.clear();
        this.stacksByName.clear();
        this.customContentHandler = null;
    }

    public <T> T peek() {
        try {
            return this.npeSafeCast(this.stack.peek());
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public <T> T peek(int n) {
        int index = this.stack.size() - 1 - n;
        if (index < 0) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
        try {
            return this.npeSafeCast(this.stack.get(index));
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public <T> T pop() {
        try {
            T popped = this.npeSafeCast(this.stack.pop());
            if (this.stackAction != null) {
                popped = this.stackAction.onPop(this, null, popped);
            }
            return popped;
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public <T> void push(T object) {
        if (this.stackAction != null) {
            object = this.stackAction.onPush(this, null, object);
        }
        if (this.stack.size() == 0) {
            this.root = object;
        }
        this.stack.push(object);
    }

    public <T> void push(String stackName, T value) {
        Stack<Object> namedStack;
        if (this.stackAction != null) {
            value = this.stackAction.onPush(this, stackName, value);
        }
        if ((namedStack = this.stacksByName.get(stackName)) == null) {
            namedStack = new Stack();
            this.stacksByName.put(stackName, namedStack);
        }
        namedStack.push(value);
    }

    public <T> T pop(String stackName) {
        Object result = null;
        Stack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stack '" + stackName + "' is empty");
            }
            throw new EmptyStackException();
        }
        result = this.npeSafeCast(namedStack.pop());
        if (this.stackAction != null) {
            result = this.stackAction.onPop(this, stackName, result);
        }
        return result;
    }

    public <T> T peek(String stackName) {
        return this.npeSafeCast(this.peek(stackName, 0));
    }

    public <T> T peek(String stackName, int n) {
        T result = null;
        Stack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stack '" + stackName + "' is empty");
            }
            throw new EmptyStackException();
        }
        int index = namedStack.size() - 1 - n;
        if (index < 0) {
            throw new EmptyStackException();
        }
        result = this.npeSafeCast(namedStack.get(index));
        return result;
    }

    public boolean isEmpty(String stackName) {
        boolean result = true;
        Stack<Object> namedStack = this.stacksByName.get(stackName);
        if (namedStack != null) {
            result = namedStack.isEmpty();
        }
        return result;
    }

    public <T> T getRoot() {
        return this.npeSafeCast(this.root);
    }

    public void resetRoot() {
        this.root = null;
    }

    protected void cleanup() {
        for (InputSource source : this.inputSources) {
            try {
                source.getByteStream().close();
            }
            catch (IOException e) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn(String.format("An error occurred while closing resource %s (%s)", source.getPublicId(), source.getSystemId()), e);
            }
        }
        this.inputSources.clear();
    }

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.initialize();
        this.configured = true;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    protected void initialize() {
    }

    Map<String, URL> getRegistrations() {
        return Collections.unmodifiableMap(this.entityValidator);
    }

    public Object[] peekParams() {
        try {
            return this.params.peek();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object[] peekParams(int n) {
        int index = this.params.size() - 1 - n;
        if (index < 0) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
        try {
            return (Object[])this.params.get(index);
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public Object[] popParams() {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Popping params");
            }
            return this.params.pop();
        }
        catch (EmptyStackException e) {
            this.log.warn("Empty stack (returning null)");
            return null;
        }
    }

    public void pushParams(Object ... object) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Pushing params");
        }
        this.params.push(object);
    }

    public SAXException createSAXException(String message, Exception e) {
        Throwable t;
        if (e != null && e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) != null && t instanceof Exception) {
            e = (Exception)t;
        }
        if (this.locator != null) {
            String error = "Error at line " + this.locator.getLineNumber() + " char " + this.locator.getColumnNumber() + ": " + message;
            if (e != null) {
                return new SAXParseException(error, this.locator, e);
            }
            return new SAXParseException(error, this.locator);
        }
        this.log.error("No Locator!");
        if (e != null) {
            return new SAXException(message, e);
        }
        return new SAXException(message);
    }

    public SAXException createSAXException(Exception e) {
        Throwable t;
        if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) != null && t instanceof Exception) {
            e = (Exception)t;
        }
        return this.createSAXException(e.getMessage(), e);
    }

    public SAXException createSAXException(String message) {
        return this.createSAXException(message, null);
    }

    private <T> T npeSafeCast(Object obj) {
        if (obj == null) {
            return null;
        }
        Object result = obj;
        return (T)result;
    }
}

