/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.vfs2.FileObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestEntityResolver
implements EntityResolver {
    private final FileObject containerFile;
    private final FileObject sourceFile;

    public TestEntityResolver(FileObject containerFile, FileObject sourceFile) {
        this.containerFile = containerFile;
        this.sourceFile = sourceFile;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String fileName = new File(URI.create(systemId).getPath()).getName();
        if (fileName.equals("name.xsd") || fileName.equals("address.xsd")) {
            String path = "/read-xml-tests/" + fileName;
            FileObject xsdFileObject = this.sourceFile.resolveFile(path);
            if (!xsdFileObject.exists()) {
                System.err.println("File does not exist: " + xsdFileObject);
                throw new IllegalStateException("Schema " + path + " not found in file " + this.containerFile + " parsing " + this.sourceFile);
            }
            return new InputSource(xsdFileObject.getContent().getInputStream());
        }
        return null;
    }
}

