/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.tar.TarFileObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFileSystemTest {
    private FileObject createFileSystem(String testFilePath) throws IOException {
        File testFile = new File(testFilePath);
        FileSystemManager manager = VFS.getManager();
        try (FileObject localFileObject = manager.resolveFile(testFile.getAbsolutePath());){
            FileObject fileObject = manager.createFileSystem(localFileObject);
            return fileObject;
        }
    }

    @Test
    public void testTarFile() throws IOException {
        String testFilePath = "src/test/resources/test-data/test.tar";
        try (FileObject fileObject = this.createFileSystem("src/test/resources/test-data/test.tar");){
            Assertions.assertInstanceOf(TarFileObject.class, (Object)fileObject);
        }
    }

    @Test
    public void testTbz2File() throws IOException {
        String testFilePath = "src/test/resources/test-data/test.tbz2";
        try (FileObject fileObject = this.createFileSystem("src/test/resources/test-data/test.tbz2");){
            Assertions.assertInstanceOf(TarFileObject.class, (Object)fileObject);
        }
    }

    @Test
    public void testTgzFile() throws IOException {
        String testFilePath = "src/test/resources/test-data/test.tgz";
        try (FileObject fileObject = this.createFileSystem("src/test/resources/test-data/test.tgz");){
            Assertions.assertInstanceOf(TarFileObject.class, (Object)fileObject);
        }
    }
}

