/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class SftpFileSystemGroupsTests {
    private SftpFileSystem fileSystem;
    private final FileSystemOptions options = new FileSystemOptions();
    private Session session;

    @Before
    public void setup() throws JSchException {
        this.session = new JSch().getSession("");
        this.fileSystem = new SftpFileSystem(null, this.session, this.options);
    }

    @Test
    public void testShouldHandleEmptyGroupResult() {
        StringBuilder builder = new StringBuilder("\n");
        int[] groups = this.fileSystem.parseGroupIdOutput(builder);
        Assertions.assertEquals((int)0, (int)groups.length, (String)"Group ids should be empty");
    }

    @Test
    public void testShouldHandleListOfGroupIds() {
        StringBuilder builder = new StringBuilder("1 22 333 4444\n");
        int[] groups = this.fileSystem.parseGroupIdOutput(builder);
        Assertions.assertEquals((int)4, (int)groups.length, (String)"Group ids should not be empty");
        Assertions.assertArrayEquals((int[])new int[]{1, 22, 333, 4444}, (int[])groups);
    }

    @Test
    public void testShouldThrowOnUnexpectedOutput() {
        StringBuilder builder = new StringBuilder("abc\n");
        Assertions.assertThrows(NumberFormatException.class, () -> this.fileSystem.parseGroupIdOutput(builder));
    }
}

