/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Bzip2Test {
    @Test
    public void testBZip2() throws IOException {
        File testResource = VfsTestUtils.getTestResource("bla.txt.bz2");
        try (FileObject bz2FileObject = VFS.getManager().resolveFile("bz2://" + testResource);){
            Assertions.assertTrue((boolean)bz2FileObject.exists());
            Assertions.assertTrue((boolean)bz2FileObject.isFolder());
            try (FileObject fileObjectDir = bz2FileObject.resolveFile("bla.txt");){
                Assertions.assertTrue((boolean)fileObjectDir.exists());
                Assertions.assertTrue((boolean)bz2FileObject.isFolder());
                try (FileObject fileObject = fileObjectDir.resolveFile("bla.txt");){
                    Assertions.assertTrue((boolean)fileObject.exists());
                    Assertions.assertFalse((boolean)fileObject.isFolder());
                    Assertions.assertTrue((boolean)fileObject.isFile());
                    try (FileContent content = fileObject.getContent();){
                        Assertions.assertEquals((long)-1L, (long)content.getSize());
                        String string = content.getString(StandardCharsets.UTF_8);
                        Assertions.assertEquals((int)26, (int)string.length());
                        Assertions.assertEquals((Object)"Hallo, dies ist ein Test.\n", (Object)string);
                    }
                }
            }
        }
    }
}

