/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MutableFloatTest
extends AbstractLangTest {
    MutableFloatTest() {
    }

    @Test
    void testAddAndGetValueObject() {
        MutableFloat mutableFloat = new MutableFloat(5.0f);
        float result = mutableFloat.addAndGet((Number)Float.valueOf(2.5f));
        Assertions.assertEquals((float)7.5f, (float)result, (float)0.01f);
        Assertions.assertEquals((float)7.5f, (float)mutableFloat.floatValue(), (float)0.01f);
    }

    @Test
    void testAddAndGetValuePrimitive() {
        MutableFloat mutableFloat = new MutableFloat(0.5f);
        float result = mutableFloat.addAndGet(1.0f);
        Assertions.assertEquals((float)1.5f, (float)result, (float)0.01f);
        Assertions.assertEquals((float)1.5f, (float)mutableFloat.floatValue(), (float)0.01f);
    }

    @Test
    void testAddValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add((Number)Float.valueOf(1.1f));
        Assertions.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    void testAddValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.add(1.1f);
        Assertions.assertEquals((float)2.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    void testCompareTo() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        Assertions.assertEquals((int)0, (int)mutNum.compareTo(new MutableFloat(0.0f)));
        Assertions.assertEquals((int)1, (int)mutNum.compareTo(new MutableFloat(-1.0f)));
        Assertions.assertEquals((int)-1, (int)mutNum.compareTo(new MutableFloat(1.0f)));
    }

    @Test
    void testCompareToNull() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        LangAssertions.assertNullPointerException(() -> mutNum.compareTo(null));
    }

    @Test
    void testConstructorNull() {
        LangAssertions.assertNullPointerException(() -> new MutableFloat((Number)null));
    }

    @Test
    void testConstructors() {
        Assertions.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((float)1.0f, (float)new MutableFloat(1.0f).floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((float)2.0f, (float)new MutableFloat((Number)Float.valueOf(2.0f)).floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((float)3.0f, (float)new MutableFloat((Number)new MutableFloat(3.0f)).floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((float)2.0f, (float)new MutableFloat("2.0").floatValue(), (float)1.0E-4f);
    }

    @Test
    void testDecrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.decrement();
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testDecrementAndGet() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        float result = mutNum.decrementAndGet();
        Assertions.assertEquals((float)0.0f, (float)result, (float)0.01f);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testEquals() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumA, (Object)mutNumB);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumA);
        Assertions.assertEquals((Object)mutNumB, (Object)mutNumB);
        Assertions.assertNotEquals((Object)mutNumA, (Object)mutNumC);
        Assertions.assertNotEquals((Object)mutNumB, (Object)mutNumC);
        Assertions.assertEquals((Object)mutNumC, (Object)mutNumC);
        Assertions.assertNotEquals(null, (Object)mutNumA);
        Assertions.assertNotEquals((Object)mutNumA, (Object)Float.valueOf(0.0f));
        Assertions.assertNotEquals((Object)"0", (Object)mutNumA);
    }

    @Test
    void testGetAndAddValueObject() {
        MutableFloat mutableFloat = new MutableFloat(7.75f);
        float result = mutableFloat.getAndAdd((Number)Float.valueOf(2.25f));
        Assertions.assertEquals((float)7.75f, (float)result, (float)0.01f);
        Assertions.assertEquals((float)10.0f, (float)mutableFloat.floatValue(), (float)0.01f);
    }

    @Test
    void testGetAndAddValuePrimitive() {
        MutableFloat mutableFloat = new MutableFloat(1.25f);
        float result = mutableFloat.getAndAdd(0.75f);
        Assertions.assertEquals((float)1.25f, (float)result, (float)0.01f);
        Assertions.assertEquals((float)2.0f, (float)mutableFloat.floatValue(), (float)0.01f);
    }

    @Test
    void testGetAndDecrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        float result = mutNum.getAndDecrement();
        Assertions.assertEquals((float)1.0f, (float)result, (float)0.01f);
        Assertions.assertEquals((int)0, (int)mutNum.intValue());
        Assertions.assertEquals((long)0L, (long)mutNum.longValue());
    }

    @Test
    void testGetAndIncrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        float result = mutNum.getAndIncrement();
        Assertions.assertEquals((float)1.0f, (float)result, (float)0.01f);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testGetSet() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        Assertions.assertEquals((float)0.0f, (float)new MutableFloat().floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((Object)Float.valueOf(0.0f), (Object)new MutableFloat().get());
        Assertions.assertEquals((Float)Float.valueOf(0.0f), (Float)new MutableFloat().getValue());
        mutNum.setValue(1.0f);
        Assertions.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((Object)Float.valueOf(1.0f), (Object)mutNum.get());
        Assertions.assertEquals((Float)Float.valueOf(1.0f), (Float)mutNum.getValue());
        mutNum.setValue((Number)Float.valueOf(2.0f));
        Assertions.assertEquals((float)2.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((Object)Float.valueOf(2.0f), (Object)mutNum.get());
        Assertions.assertEquals((Float)Float.valueOf(2.0f), (Float)mutNum.getValue());
        mutNum.setValue((Number)new MutableFloat(3.0f));
        Assertions.assertEquals((float)3.0f, (float)mutNum.floatValue(), (float)1.0E-4f);
        Assertions.assertEquals((Object)Float.valueOf(3.0f), (Object)mutNum.get());
        Assertions.assertEquals((Float)Float.valueOf(3.0f), (Float)mutNum.getValue());
    }

    @Test
    void testHashCode() {
        MutableFloat mutNumA = new MutableFloat(0.0f);
        MutableFloat mutNumB = new MutableFloat(0.0f);
        MutableFloat mutNumC = new MutableFloat(1.0f);
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumA.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)mutNumB.hashCode());
        Assertions.assertNotEquals((int)mutNumA.hashCode(), (int)mutNumC.hashCode());
        Assertions.assertEquals((int)mutNumA.hashCode(), (int)Float.valueOf(0.0f).hashCode());
    }

    @Test
    void testIncrement() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.increment();
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testIncrementAndGet() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        float result = mutNum.incrementAndGet();
        Assertions.assertEquals((float)2.0f, (float)result, (float)0.01f);
        Assertions.assertEquals((int)2, (int)mutNum.intValue());
        Assertions.assertEquals((long)2L, (long)mutNum.longValue());
    }

    @Test
    void testNanInfinite() {
        MutableFloat mutNum = new MutableFloat(Float.NaN);
        Assertions.assertTrue((boolean)mutNum.isNaN());
        mutNum = new MutableFloat(Float.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)mutNum.isInfinite());
        mutNum = new MutableFloat(Float.NEGATIVE_INFINITY);
        Assertions.assertTrue((boolean)mutNum.isInfinite());
    }

    @Test
    void testPrimitiveValues() {
        MutableFloat mutNum = new MutableFloat(1.7f);
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((double)1.7, (double)mutNum.doubleValue(), (double)1.0E-5);
        Assertions.assertEquals((byte)1, (byte)mutNum.byteValue());
        Assertions.assertEquals((short)1, (short)mutNum.shortValue());
        Assertions.assertEquals((int)1, (int)mutNum.intValue());
        Assertions.assertEquals((long)1L, (long)mutNum.longValue());
    }

    @Test
    void testSetNull() {
        MutableFloat mutNum = new MutableFloat(0.0f);
        LangAssertions.assertNullPointerException(() -> mutNum.setValue(null));
    }

    @Test
    void testSubtractValueObject() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract((Number)Float.valueOf(0.9f));
        Assertions.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    void testSubtractValuePrimitive() {
        MutableFloat mutNum = new MutableFloat(1.0f);
        mutNum.subtract(0.9f);
        Assertions.assertEquals((float)0.1f, (float)mutNum.floatValue(), (float)0.01f);
    }

    @Test
    void testToFloat() {
        Assertions.assertEquals((Float)Float.valueOf(0.0f), (Float)new MutableFloat(0.0f).toFloat());
        Assertions.assertEquals((Float)Float.valueOf(12.3f), (Float)new MutableFloat(12.3f).toFloat());
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"0.0", (Object)new MutableFloat(0.0f).toString());
        Assertions.assertEquals((Object)"10.0", (Object)new MutableFloat(10.0f).toString());
        Assertions.assertEquals((Object)"-123.0", (Object)new MutableFloat(-123.0f).toString());
    }
}

