/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingTestConstants;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.imaging.test.FileSystemTraversal;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractImagingTest {
    private static final List<File> ALL_IMAGES = new ArrayList<File>();

    protected static List<File> getTestImages() throws IOException, ImagingException {
        return AbstractImagingTest.getTestImages(null, -1);
    }

    protected static List<File> getTestImages(ImageFilter filter) throws IOException, ImagingException {
        return AbstractImagingTest.getTestImages(filter, -1);
    }

    protected static List<File> getTestImages(ImageFilter filter, int max) throws IOException, ImagingException {
        ArrayList<File> images = new ArrayList<File>();
        for (File file : ALL_IMAGES) {
            if (!Imaging.hasImageFileExtension((File)file) || file.getParentFile().getName().toLowerCase().equals("@broken") || filter != null && !filter.accept(file)) continue;
            images.add(file);
            if (max <= 0 || images.size() < max) continue;
            break;
        }
        Assertions.assertFalse((boolean)images.isEmpty());
        return images;
    }

    protected File getTestImage() throws IOException, ImagingException {
        return this.getTestImage(null);
    }

    protected File getTestImage(ImageFilter filter) throws IOException, ImagingException {
        List<File> images = AbstractImagingTest.getTestImages(filter, 1);
        Assertions.assertFalse((boolean)images.isEmpty());
        return images.get(0);
    }

    protected File getTestImageByName(String fileName) throws IOException, ImagingException {
        return this.getTestImage(file -> file.getName().equals(fileName));
    }

    protected boolean isInvalidPngTestFile(File file) {
        return file.getParentFile().getName().equalsIgnoreCase("pngsuite") && file.getName().toLowerCase().startsWith("x");
    }

    protected boolean isPhilHarveyTestImage(File file) {
        return file.getAbsolutePath().startsWith(ImagingTestConstants.PHIL_HARVEY_TEST_IMAGE_FOLDER.getAbsolutePath());
    }

    static {
        File imagesFolder = ImagingTestConstants.TEST_IMAGE_FOLDER;
        imagesFolder = imagesFolder.getAbsoluteFile();
        Debug.debug((String)"imagesFolder", (Object)imagesFolder);
        Assertions.assertTrue((boolean)imagesFolder.exists());
        FileSystemTraversal.Visitor visitor = (file, progressEstimate) -> {
            if (!Imaging.hasImageFileExtension((File)file)) {
                return true;
            }
            ALL_IMAGES.add(file);
            return true;
        };
        new FileSystemTraversal().traverseFiles(imagesFolder, visitor);
    }

    public static interface ImageFilter {
        public boolean accept(File var1) throws IOException, ImagingException;
    }
}

