/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RootPaneContainer;

public class UIUtil {
    public static void scrollToSelectedRow(JTable table) {
        int row = table.getSelectedRow();
        if (row >= 0) {
            UIUtil.scroll(table, row, 0);
        }
    }

    public static void scroll(JTable table, int rowIndex, int vColIndex) {
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Rectangle viewRect = viewport.getViewRect();
        if (viewRect.intersects(rect)) {
            return;
        }
        rect.setLocation(rect.x - viewRect.x, rect.y - viewRect.y);
        int centerX = (viewRect.width - rect.width) / 2;
        int centerY = (viewRect.height - rect.height) / 2;
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
        viewport.scrollRectToVisible(rect);
    }

    public static void dock(Window window, Window dockTo) {
        window.setVisible(false);
        ((RootPaneContainer)((Object)dockTo)).getContentPane().add((Component)((RootPaneContainer)((Object)window)).getContentPane(), "South");
        dockTo.setVisible(true);
    }

    public static void dock(Window window) {
        UIUtil.dock(window, window.getOwner());
    }
}

