/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ToJsonFct
extends NativeScalarFunction {
    private static final Map<AbstractType<?>, ToJsonFct> instances = new ConcurrentHashMap();

    public static ToJsonFct getInstance(String name, List<AbstractType<?>> argTypes) throws InvalidRequestException {
        if (argTypes.size() != 1) {
            throw new InvalidRequestException(String.format("%s() only accepts one argument (got %d)", name, argTypes.size()));
        }
        AbstractType<?> fromType = argTypes.get(0);
        ToJsonFct func = instances.get(fromType);
        if (func == null) {
            func = new ToJsonFct(name, fromType);
            instances.put(fromType, func);
        }
        return func;
    }

    private ToJsonFct(String name, AbstractType<?> argType) {
        super(name, UTF8Type.instance, argType);
    }

    @Override
    public Arguments newArguments(ProtocolVersion version) {
        return new FunctionArguments(version, (protocolVersion, buffer) -> {
            AbstractType argType = (AbstractType)this.argTypes.get(0);
            if (buffer == null || !buffer.hasRemaining() && argType.isEmptyValueMeaningless()) {
                return null;
            }
            return ((AbstractType)this.argTypes.get(0)).toJSONString(buffer, protocolVersion);
        });
    }

    @Override
    public ByteBuffer execute(Arguments arguments) throws InvalidRequestException {
        if (arguments.containsNulls()) {
            return ByteBufferUtil.bytes("null");
        }
        return ByteBufferUtil.bytes((String)arguments.get(0));
    }

    public static void addFunctionsTo(NativeFunctions functions) {
        functions.add(new Factory("to_json"));
        functions.add(new Factory("tojson"));
    }

    private static class Factory
    extends FunctionFactory {
        public Factory(String name) {
            super(name, FunctionParameter.anyType(false));
        }

        @Override
        protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
            return ToJsonFct.getInstance(this.name.name, argTypes);
        }
    }
}

