/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NonBlockingRateLimiter {
    public static final long NANOS_PER_SECOND;
    static final long DEFAULT_BURST_NANOS;
    private final long startedNanos;
    private final AtomicLong nextAvailable = new AtomicLong();
    private volatile Ticker ticker;
    private volatile int permitsPerSecond;
    private volatile long intervalNanos;
    private final long burstNanos;
    public static final NonBlockingRateLimiter NO_OP_LIMITER;

    public NonBlockingRateLimiter(int permitsPerSecond) {
        this(permitsPerSecond, DEFAULT_BURST_NANOS, Ticker.systemTicker());
    }

    @VisibleForTesting
    public NonBlockingRateLimiter(int permitsPerSecond, long burstNanos, Ticker ticker) {
        this.startedNanos = ticker.read();
        this.burstNanos = burstNanos;
        this.setRate(permitsPerSecond, ticker);
    }

    public void setRate(int permitsPerSecond) {
        this.setRate(permitsPerSecond, Ticker.systemTicker());
    }

    @VisibleForTesting
    public synchronized void setRate(int permitsPerSecond, Ticker ticker) {
        Preconditions.checkArgument((permitsPerSecond > 0 ? 1 : 0) != 0, (Object)"permits/second must be positive");
        Preconditions.checkArgument(((long)permitsPerSecond <= NANOS_PER_SECOND ? 1 : 0) != 0, (Object)("permits/second cannot be greater than " + NANOS_PER_SECOND));
        this.ticker = ticker;
        this.permitsPerSecond = permitsPerSecond;
        this.intervalNanos = NANOS_PER_SECOND / (long)permitsPerSecond;
        this.nextAvailable.set(this.nanosElapsed());
    }

    public int getRate() {
        return this.permitsPerSecond;
    }

    public long reserveAndGetDelay(TimeUnit delayUnit) {
        long interval;
        long firstAvailable;
        long prev;
        long nowNanos = this.nanosElapsed();
        do {
            prev = this.nextAvailable.get();
            interval = this.intervalNanos;
        } while (!this.nextAvailable.compareAndSet(prev, (firstAvailable = Math.max(prev, nowNanos - this.burstNanos)) + interval));
        return delayUnit.convert(Math.max(0L, firstAvailable - nowNanos), TimeUnit.NANOSECONDS);
    }

    public boolean tryReserve() {
        long interval;
        long firstAvailable;
        long prev;
        long nowNanos = this.nanosElapsed();
        do {
            prev = this.nextAvailable.get();
            interval = this.intervalNanos;
            firstAvailable = Math.max(prev, nowNanos - this.burstNanos);
            if (nowNanos >= firstAvailable) continue;
            return false;
        } while (!this.nextAvailable.compareAndSet(prev, firstAvailable + interval));
        return true;
    }

    @VisibleForTesting
    public long getIntervalNanos() {
        return this.intervalNanos;
    }

    @VisibleForTesting
    public long getStartedNanos() {
        return this.startedNanos;
    }

    private long nanosElapsed() {
        return this.ticker.read() - this.startedNanos;
    }

    static {
        DEFAULT_BURST_NANOS = NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
        NO_OP_LIMITER = new NonBlockingRateLimiter(Math.toIntExact(NANOS_PER_SECOND)){

            @Override
            public long reserveAndGetDelay(TimeUnit delayUnit) {
                return 0L;
            }

            @Override
            public boolean tryReserve() {
                return true;
            }
        };
    }
}

