/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SequenceBasedSSTableId;
import org.apache.cassandra.io.sstable.UUIDBasedSSTableId;

public class SSTableIdFactory {
    public static final SSTableIdFactory instance = new SSTableIdFactory();
    public static final Comparator<SSTableId> COMPARATOR = Comparator.nullsFirst((id1, id2) -> {
        if (id1 instanceof UUIDBasedSSTableId) {
            UUIDBasedSSTableId uuidId1 = (UUIDBasedSSTableId)id1;
            return id2 instanceof UUIDBasedSSTableId ? uuidId1.compareTo((UUIDBasedSSTableId)id2) : 1;
        }
        if (id1 instanceof SequenceBasedSSTableId) {
            SequenceBasedSSTableId seqId1 = (SequenceBasedSSTableId)id1;
            return id2 instanceof SequenceBasedSSTableId ? seqId1.compareTo((SequenceBasedSSTableId)id2) : -1;
        }
        throw new AssertionError((Object)("Unsupported comparison between " + id1.getClass().getName() + " and  " + id2.getClass().getName()));
    });

    public SSTableId fromString(String str) throws IllegalArgumentException {
        return (SSTableId)((Object)Stream.of(UUIDBasedSSTableId.Builder.instance, SequenceBasedSSTableId.Builder.instance).filter(b -> b.isUniqueIdentifier(str)).findFirst().map(b -> (Comparable)b.fromString(str)).orElseThrow(() -> new IllegalArgumentException("String '" + str + "' does not match any SSTable identifier format")));
    }

    public SSTableId fromBytes(ByteBuffer bytes) {
        return (SSTableId)((Object)Stream.of(UUIDBasedSSTableId.Builder.instance, SequenceBasedSSTableId.Builder.instance).filter(b -> b.isUniqueIdentifier(bytes)).findFirst().map(b -> (Comparable)b.fromBytes(bytes)).orElseThrow(() -> new IllegalArgumentException("Byte buffer of length " + bytes.remaining() + " does not match any SSTable identifier format")));
    }

    public SSTableId.Builder<SSTableId> defaultBuilder() {
        SSTableId.Builder<UUIDBasedSSTableId> builder = DatabaseDescriptor.isUUIDSSTableIdentifiersEnabled() ? UUIDBasedSSTableId.Builder.instance : SequenceBasedSSTableId.Builder.instance;
        return builder;
    }
}

