/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht.tokenallocator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.PriorityQueue;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.ReplicationStrategy;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorBase;
import org.apache.cassandra.dht.tokenallocator.TokenAllocatorDiagnostics;

class ReplicationAwareTokenAllocator<Unit>
extends TokenAllocatorBase<Unit> {
    final Multimap<Unit, Token> unitToTokens = HashMultimap.create();
    final int replicas;

    ReplicationAwareTokenAllocator(NavigableMap<Token, Unit> sortedTokens, ReplicationStrategy<Unit> strategy, IPartitioner partitioner) {
        super(sortedTokens, strategy, partitioner);
        for (Map.Entry en : sortedTokens.entrySet()) {
            this.unitToTokens.put(en.getValue(), en.getKey());
        }
        this.replicas = strategy.replicas();
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public Collection<Token> addUnit(Unit newUnit, int numTokens) {
        assert (!this.unitToTokens.containsKey(newUnit));
        if (this.unitCount() < this.replicas) {
            return this.generateSplits(newUnit, numTokens);
        }
        if (numTokens > this.sortedTokens.size()) {
            return this.generateSplits(newUnit, numTokens);
        }
        double optTokenOwnership = this.optimalTokenOwnership(numTokens);
        HashMap groups = Maps.newHashMap();
        Map unitInfos = this.createUnitInfos(groups);
        if (groups.size() < this.replicas) {
            return this.generateSplits(newUnit, numTokens);
        }
        TokenAllocatorBase.UnitInfo<Unit> newUnitInfo = new TokenAllocatorBase.UnitInfo<Unit>(newUnit, (double)numTokens * optTokenOwnership, groups, this.strategy);
        TokenAllocatorBase.TokenInfo tokens = this.createTokenInfos(unitInfos, newUnitInfo.group);
        newUnitInfo.tokenCount = numTokens;
        CandidateInfo candidates = this.createCandidates(tokens, newUnitInfo, optTokenOwnership);
        PriorityQueue improvements = new PriorityQueue(this.sortedTokens.size());
        CandidateInfo candidate = candidates;
        do {
            double impr = this.evaluateImprovement(candidate, optTokenOwnership, 1.0 / (double)numTokens);
            improvements.add(new TokenAllocatorBase.Weighted(impr, candidate));
        } while ((candidate = (CandidateInfo)candidate.next) != candidates);
        CandidateInfo bestToken = (CandidateInfo)((TokenAllocatorBase.Weighted)improvements.remove()).value;
        int vn = 1;
        while (true) {
            candidates = bestToken.removeFrom(candidates);
            this.confirmCandidate(bestToken);
            if (vn == numTokens) break;
            while (true) {
                bestToken = (CandidateInfo)((TokenAllocatorBase.Weighted)improvements.remove()).value;
                double impr = this.evaluateImprovement(bestToken, optTokenOwnership, ((double)vn + 1.0) / (double)numTokens);
                TokenAllocatorBase.Weighted next = (TokenAllocatorBase.Weighted)improvements.peek();
                if (next == null || impr >= next.weight) break;
                improvements.add(new TokenAllocatorBase.Weighted<CandidateInfo>(impr, bestToken));
            }
            ++vn;
        }
        ImmutableList newTokens = ImmutableList.copyOf((Collection)this.unitToTokens.get(newUnit));
        TokenAllocatorDiagnostics.unitedAdded(this, numTokens, this.unitToTokens, this.sortedTokens, (List<Token>)newTokens, newUnit);
        return newTokens;
    }

    @Override
    Collection<Token> generateSplits(Unit newUnit, int numTokens) {
        Collection<Token> tokens = super.generateSplits(newUnit, numTokens);
        this.unitToTokens.putAll(newUnit, tokens);
        TokenAllocatorDiagnostics.splitsGenerated(this, numTokens, this.unitToTokens, this.sortedTokens, newUnit, tokens);
        return tokens;
    }

    private TokenAllocatorBase.TokenInfo<Unit> createTokenInfos(Map<Unit, TokenAllocatorBase.UnitInfo<Unit>> units, TokenAllocatorBase.GroupInfo newUnitGroup) {
        TokenAllocatorBase.TokenInfo<Unit> prev = null;
        TokenAllocatorBase.TokenInfo first = null;
        for (Map.Entry en : this.sortedTokens.entrySet()) {
            Token t = (Token)en.getKey();
            TokenAllocatorBase.UnitInfo<Unit> ni = units.get(en.getValue());
            TokenAllocatorBase.TokenInfo<Unit> ti = new TokenAllocatorBase.TokenInfo<Unit>(t, ni);
            first = ti.insertAfter(first, prev);
            prev = ti;
        }
        TokenAllocatorBase.TokenInfo curr = first;
        do {
            this.populateTokenInfoAndAdjustUnit(curr, newUnitGroup);
        } while ((curr = (TokenAllocatorBase.TokenInfo)curr.next) != first);
        TokenAllocatorDiagnostics.tokenInfosCreated(this, this.unitToTokens, first);
        return first;
    }

    private CandidateInfo<Unit> createCandidates(TokenAllocatorBase.TokenInfo<Unit> tokens, TokenAllocatorBase.UnitInfo<Unit> newUnitInfo, double initialTokenOwnership) {
        TokenAllocatorBase.TokenInfo curr = tokens;
        CandidateInfo first = null;
        CandidateInfo<Unit> prev = null;
        do {
            CandidateInfo<Unit> candidate = new CandidateInfo<Unit>(this.partitioner.midpoint(((TokenAllocatorBase.TokenInfo)curr.prev).token, curr.token), curr, newUnitInfo);
            first = candidate.insertAfter(first, prev);
            candidate.replicatedOwnership = initialTokenOwnership;
            this.populateCandidate(candidate);
            prev = candidate;
        } while ((curr = (TokenAllocatorBase.TokenInfo)curr.next) != tokens);
        prev.next = first;
        return first;
    }

    private void populateCandidate(CandidateInfo<Unit> candidate) {
        this.populateTokenInfo(candidate, candidate.owningUnit.group);
    }

    private void confirmCandidate(CandidateInfo<Unit> candidate) {
        TokenAllocatorBase.UnitInfo newUnit = candidate.owningUnit;
        Token newToken = candidate.token;
        this.sortedTokens.put(newToken, newUnit.unit);
        this.unitToTokens.put(newUnit.unit, (Object)newToken);
        TokenAllocatorBase.TokenInfo<Unit> prev = candidate.prevInRing();
        TokenAllocatorBase.TokenInfo newTokenInfo = new TokenAllocatorBase.TokenInfo(newToken, newUnit);
        newTokenInfo.replicatedOwnership = candidate.replicatedOwnership;
        newTokenInfo.insertAfter(prev, prev);
        this.populateTokenInfoAndAdjustUnit(newTokenInfo, newUnit.group);
        ReplicationVisitor replicationVisitor = new ReplicationVisitor();
        assert (newTokenInfo.next == candidate.split);
        TokenAllocatorBase.TokenInfo curr = (TokenAllocatorBase.TokenInfo)newTokenInfo.next;
        while (!replicationVisitor.visitedAll()) {
            candidate = (CandidateInfo)candidate.next;
            this.populateCandidate(candidate);
            if (replicationVisitor.add(curr.owningUnit.group)) {
                this.populateTokenInfoAndAdjustUnit(curr, newUnit.group);
            }
            curr = (TokenAllocatorBase.TokenInfo)curr.next;
        }
        replicationVisitor.clean();
    }

    private Token populateTokenInfo(TokenAllocatorBase.BaseTokenInfo<Unit, ?> token, TokenAllocatorBase.GroupInfo newUnitGroup) {
        TokenAllocatorBase.GroupInfo currGroup;
        Token replicationStart;
        TokenAllocatorBase.GroupInfo tokenGroup = token.owningUnit.group;
        PopulateVisitor visitor = new PopulateVisitor();
        Token replicationThreshold = token.token;
        TokenAllocatorBase.TokenInfo curr = token.prevInRing();
        while (true) {
            replicationStart = curr.token;
            currGroup = curr.owningUnit.group;
            if (visitor.add(currGroup)) {
                if (visitor.visitedAll()) break;
                replicationThreshold = replicationStart;
                if (currGroup == tokenGroup) break;
            }
            curr = (TokenAllocatorBase.TokenInfo)curr.prev;
        }
        if (newUnitGroup == tokenGroup) {
            replicationThreshold = token.token;
        } else if (newUnitGroup != currGroup && visitor.seen(newUnitGroup)) {
            replicationThreshold = replicationStart;
        }
        visitor.clean();
        token.replicationThreshold = replicationThreshold;
        token.replicationStart = replicationStart;
        return replicationStart;
    }

    private void populateTokenInfoAndAdjustUnit(TokenAllocatorBase.TokenInfo<Unit> populate, TokenAllocatorBase.GroupInfo newUnitGroup) {
        Token replicationStart = this.populateTokenInfo(populate, newUnitGroup);
        double newOwnership = replicationStart.size(populate.token);
        double oldOwnership = populate.replicatedOwnership;
        populate.replicatedOwnership = newOwnership;
        populate.owningUnit.ownership += newOwnership - oldOwnership;
    }

    private double evaluateImprovement(CandidateInfo<Unit> candidate, double optTokenOwnership, double newUnitMult) {
        double tokenChange = 0.0;
        TokenAllocatorBase.UnitInfo candidateUnit = candidate.owningUnit;
        Token candidateEnd = candidate.token;
        UnitAdjustmentTracker unitTracker = new UnitAdjustmentTracker(candidateUnit);
        tokenChange += this.applyOwnershipAdjustment(candidate, candidateUnit, candidate.replicationStart, candidateEnd, optTokenOwnership, unitTracker);
        ReplicationVisitor replicationVisitor = new ReplicationVisitor();
        TokenAllocatorBase.TokenInfo curr = candidate.split;
        while (!replicationVisitor.visitedAll()) {
            TokenAllocatorBase.UnitInfo currUnit = curr.owningUnit;
            if (replicationVisitor.add(currUnit.group)) {
                Token replicationEnd = curr.token;
                Token replicationStart = this.findUpdatedReplicationStart(curr, candidate);
                tokenChange += this.applyOwnershipAdjustment(curr, currUnit, replicationStart, replicationEnd, optTokenOwnership, unitTracker);
            }
            curr = (TokenAllocatorBase.TokenInfo)curr.next;
        }
        replicationVisitor.clean();
        double nodeChange = unitTracker.calculateUnitChange(newUnitMult, optTokenOwnership);
        return -(tokenChange + nodeChange);
    }

    private Token findUpdatedReplicationStart(TokenAllocatorBase.TokenInfo<Unit> curr, CandidateInfo<Unit> candidate) {
        return ReplicationAwareTokenAllocator.furtherStartToken(curr.replicationThreshold, candidate.token, curr.token);
    }

    private double applyOwnershipAdjustment(TokenAllocatorBase.BaseTokenInfo<Unit, ?> curr, TokenAllocatorBase.UnitInfo<Unit> currUnit, Token replicationStart, Token replicationEnd, double optTokenOwnership, UnitAdjustmentTracker<Unit> unitTracker) {
        double oldOwnership = curr.replicatedOwnership;
        double newOwnership = replicationStart.size(replicationEnd);
        double tokenCount = currUnit.tokenCount;
        assert (tokenCount > 0.0);
        unitTracker.add(currUnit, newOwnership - oldOwnership);
        return (ReplicationAwareTokenAllocator.sq(newOwnership - optTokenOwnership) - ReplicationAwareTokenAllocator.sq(oldOwnership - optTokenOwnership)) / ReplicationAwareTokenAllocator.sq(tokenCount);
    }

    private double optimalTokenOwnership(int tokensToAdd) {
        return 1.0 * (double)this.replicas / (double)(this.sortedTokens.size() + tokensToAdd);
    }

    private static Token furtherStartToken(Token t1, Token t2, Token towards) {
        if (t1.equals(towards)) {
            return t2;
        }
        if (t2.equals(towards)) {
            return t1;
        }
        return t1.size(towards) > t2.size(towards) ? t1 : t2;
    }

    private static double sq(double d) {
        return d * d;
    }

    void removeUnit(Unit n) {
        Collection tokens = this.unitToTokens.removeAll(n);
        this.sortedTokens.keySet().removeAll(tokens);
        TokenAllocatorDiagnostics.unitRemoved(this, n, this.unitToTokens, this.sortedTokens);
    }

    public int unitCount() {
        return this.unitToTokens.asMap().size();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class CandidateInfo<Unit>
    extends TokenAllocatorBase.BaseTokenInfo<Unit, CandidateInfo<Unit>> {
        final TokenAllocatorBase.TokenInfo<Unit> split;

        public CandidateInfo(Token token, TokenAllocatorBase.TokenInfo<Unit> split, TokenAllocatorBase.UnitInfo<Unit> owningUnit) {
            super(token, owningUnit);
            this.split = split;
        }

        @Override
        TokenAllocatorBase.TokenInfo<Unit> prevInRing() {
            return (TokenAllocatorBase.TokenInfo)this.split.prev;
        }
    }

    private class PopulateVisitor
    extends GroupVisitor {
        private PopulateVisitor() {
        }

        @Override
        TokenAllocatorBase.GroupInfo prevSeen(TokenAllocatorBase.GroupInfo group) {
            return group.prevPopulate;
        }

        @Override
        void setPrevSeen(TokenAllocatorBase.GroupInfo group, TokenAllocatorBase.GroupInfo prevSeen) {
            group.prevPopulate = prevSeen;
        }
    }

    private class ReplicationVisitor
    extends GroupVisitor {
        private ReplicationVisitor() {
        }

        @Override
        TokenAllocatorBase.GroupInfo prevSeen(TokenAllocatorBase.GroupInfo group) {
            return group.prevSeen;
        }

        @Override
        void setPrevSeen(TokenAllocatorBase.GroupInfo group, TokenAllocatorBase.GroupInfo prevSeen) {
            group.prevSeen = prevSeen;
        }
    }

    private abstract class GroupVisitor {
        TokenAllocatorBase.GroupInfo groupChain = TokenAllocatorBase.GroupInfo.TERMINATOR;
        int seen = 0;

        private GroupVisitor() {
        }

        abstract TokenAllocatorBase.GroupInfo prevSeen(TokenAllocatorBase.GroupInfo var1);

        abstract void setPrevSeen(TokenAllocatorBase.GroupInfo var1, TokenAllocatorBase.GroupInfo var2);

        boolean add(TokenAllocatorBase.GroupInfo group) {
            if (this.prevSeen(group) != null) {
                return false;
            }
            ++this.seen;
            this.setPrevSeen(group, this.groupChain);
            this.groupChain = group;
            return true;
        }

        boolean visitedAll() {
            return this.seen >= ReplicationAwareTokenAllocator.this.replicas;
        }

        boolean seen(TokenAllocatorBase.GroupInfo group) {
            return this.prevSeen(group) != null;
        }

        void clean() {
            TokenAllocatorBase.GroupInfo groupChain = this.groupChain;
            while (groupChain != TokenAllocatorBase.GroupInfo.TERMINATOR) {
                TokenAllocatorBase.GroupInfo prev = this.prevSeen(groupChain);
                this.setPrevSeen(groupChain, null);
                groupChain = prev;
            }
            this.groupChain = TokenAllocatorBase.GroupInfo.TERMINATOR;
        }
    }

    private static class UnitAdjustmentTracker<Unit> {
        TokenAllocatorBase.UnitInfo<Unit> unitsChain;

        UnitAdjustmentTracker(TokenAllocatorBase.UnitInfo<Unit> newUnit) {
            this.unitsChain = newUnit;
        }

        void add(TokenAllocatorBase.UnitInfo<Unit> currUnit, double diff) {
            if (currUnit.prevUsed == null) {
                assert (this.unitsChain.prevUsed != null || currUnit == this.unitsChain);
                currUnit.adjustedOwnership = currUnit.ownership + diff;
                currUnit.prevUsed = this.unitsChain;
                this.unitsChain = currUnit;
            } else {
                currUnit.adjustedOwnership += diff;
            }
        }

        double calculateUnitChange(double newUnitMult, double optTokenOwnership) {
            double diff;
            double unitChange = 0.0;
            TokenAllocatorBase.UnitInfo<Unit> unitsChain = this.unitsChain;
            while (true) {
                double newOwnership = unitsChain.adjustedOwnership;
                double oldOwnership = unitsChain.ownership;
                double tokenCount = unitsChain.tokenCount;
                diff = ReplicationAwareTokenAllocator.sq(newOwnership / tokenCount - optTokenOwnership) - ReplicationAwareTokenAllocator.sq(oldOwnership / tokenCount - optTokenOwnership);
                TokenAllocatorBase.UnitInfo prev = unitsChain.prevUsed;
                unitsChain.prevUsed = null;
                if (unitsChain == prev) break;
                unitChange += diff;
                unitsChain = prev;
            }
            this.unitsChain = unitsChain;
            return unitChange += diff * newUnitMult;
        }
    }
}

