/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import java.util.Objects;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.IndexRestrictions;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.schema.TableMetadata;

public class CustomIndexExpression {
    private final ColumnIdentifier valueColId = new ColumnIdentifier("custom index expression", false);
    public final QualifiedName targetIndex;
    public final Term.Raw valueRaw;
    private Term value;

    public CustomIndexExpression(QualifiedName targetIndex, Term.Raw value) {
        this.targetIndex = targetIndex;
        this.valueRaw = value;
    }

    public void prepareValue(TableMetadata table, AbstractType<?> expressionType, VariableSpecifications boundNames) {
        ColumnSpecification spec = new ColumnSpecification(table.keyspace, table.keyspace, this.valueColId, expressionType);
        this.value = this.valueRaw.prepare(table.keyspace, spec);
        this.value.collectMarkerSpecification(boundNames);
    }

    public void addToRowFilter(RowFilter filter, TableMetadata table, QueryOptions options) {
        filter.addCustomIndexExpression(table, table.indexes.get(this.targetIndex.getName()).orElseThrow(() -> IndexRestrictions.indexNotFound(this.targetIndex, table)), this.value.bindAndGet(options));
    }

    public String toCQLString() {
        return String.format("expr(%s,%s)", this.targetIndex.toCQLString(), this.valueRaw.getText());
    }

    public String toString() {
        return this.toCQLString();
    }

    public int hashCode() {
        return Objects.hash(this.targetIndex, this.valueRaw);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomIndexExpression)) {
            return false;
        }
        CustomIndexExpression cie = (CustomIndexExpression)o;
        return this.targetIndex.equals(cie.targetIndex) && this.valueRaw.equals(cie.valueRaw);
    }
}

