/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.PermissionDetails;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthorizationStatement;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class ListPermissionsStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "permissions";
    private static final List<ColumnSpecification> metadata;
    protected final Set<Permission> permissions;
    protected IResource resource;
    protected final boolean recursive;
    private final RoleResource grantee;

    public ListPermissionsStatement(Set<Permission> permissions, IResource resource, RoleName grantee, boolean recursive) {
        this.permissions = permissions;
        this.resource = resource;
        this.recursive = recursive;
        this.grantee = grantee.hasName() ? RoleResource.role(grantee.getName()) : null;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (this.resource != null) {
            this.resource = ListPermissionsStatement.maybeCorrectResource(this.resource, state);
            if (!this.resource.exists()) {
                throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
            }
        }
        if (this.grantee != null && !DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.grantee));
        }
    }

    @Override
    public void checkAccess(ClientState state) {
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        ArrayList<PermissionDetails> details = new ArrayList<PermissionDetails>();
        if (this.resource != null && this.recursive) {
            for (IResource iResource : Resources.chain(this.resource)) {
                details.addAll(this.list(state, iResource));
            }
        } else {
            details.addAll(this.list(state, this.resource));
        }
        Collections.sort(details);
        return this.resultMessage(details);
    }

    private Set<PermissionDetails> list(ClientState state, IResource resource) throws RequestValidationException, RequestExecutionException {
        try {
            return DatabaseDescriptor.getAuthorizer().list(state.getUser(), this.permissions, resource, this.grantee);
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private ResultMessage resultMessage(List<PermissionDetails> details) {
        if (details.isEmpty()) {
            return new ResultMessage.Void();
        }
        ResultSet result = new ResultSet(metadata);
        for (PermissionDetails pd : details) {
            result.addColumnValue(UTF8Type.instance.decompose(pd.grantee));
            result.addColumnValue(UTF8Type.instance.decompose(pd.grantee));
            result.addColumnValue(UTF8Type.instance.decompose(pd.resource.toString()));
            result.addColumnValue(UTF8Type.instance.decompose(pd.permission.toString()));
        }
        return new ResultMessage.Rows(result);
    }

    static {
        ArrayList<ColumnSpecification> columns = new ArrayList<ColumnSpecification>(4);
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("role", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("username", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("resource", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("permission", true), UTF8Type.instance));
        metadata = Collections.unmodifiableList(columns);
    }
}

