/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AccessOrderDeque;
import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.BLCHeader;
import com.github.benmanes.caffeine.cache.BoundedBuffer;
import com.github.benmanes.caffeine.cache.Buffer;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.FrequencySketch;
import com.github.benmanes.caffeine.cache.LinkedDeque;
import com.github.benmanes.caffeine.cache.LocalAsyncLoadingCache;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.LocalLoadingCache;
import com.github.benmanes.caffeine.cache.LocalManualCache;
import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import com.github.benmanes.caffeine.cache.NonReentrantLock;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.References;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.SerializationProxy;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.cache.WriteOrderDeque;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
abstract class BoundedLocalCache<K, V>
extends BLCHeader.DrainStatusRef<K, V>
implements LocalCache<K, V> {
    static final Logger logger = Logger.getLogger(BoundedLocalCache.class.getName());
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final double PERCENT_MAIN = (double)0.99f;
    static final double PERCENT_MAIN_PROTECTED = (double)0.8f;
    static final long EXPIRE_WRITE_TOLERANCE = TimeUnit.SECONDS.toNanos(1L);
    final ConcurrentHashMap<Object, Node<K, V>> data;
    final PerformCleanupTask drainBuffersTask;
    final Consumer<Node<K, V>> accessPolicy;
    final CacheLoader<K, V> cacheLoader;
    final Buffer<Node<K, V>> readBuffer;
    final CacheWriter<K, V> writer;
    final NodeFactory nodeFactory;
    final Weigher<K, V> weigher;
    final Lock evictionLock;
    final Executor executor;
    final boolean isAsync;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;

    protected BoundedLocalCache(Caffeine<K, V> builder, @Nullable CacheLoader<K, V> cacheLoader, boolean isAsync) {
        this.isAsync = isAsync;
        this.cacheLoader = cacheLoader;
        this.executor = builder.getExecutor();
        this.writer = builder.getCacheWriter();
        this.weigher = builder.getWeigher(isAsync);
        this.data = new ConcurrentHashMap(builder.getInitialCapacity());
        this.evictionLock = builder.getExecutor() instanceof ForkJoinPool ? new NonReentrantLock() : new ReentrantLock();
        this.nodeFactory = NodeFactory.getFactory(builder.isStrongKeys(), builder.isWeakKeys(), builder.isStrongValues(), builder.isWeakValues(), builder.isSoftValues(), builder.expiresAfterAccess(), builder.expiresAfterWrite(), builder.refreshes(), builder.evicts(), isAsync && builder.evicts() || builder.isWeighted());
        this.readBuffer = this.evicts() || this.collectKeys() || this.collectValues() || this.expiresAfterAccess() ? new BoundedBuffer<Node<K, V>>() : Buffer.disabled();
        this.accessPolicy = this.evicts() || this.expiresAfterAccess() ? this::onAccess : e -> {};
        this.drainBuffersTask = new PerformCleanupTask();
        if (this.evicts()) {
            this.setMaximum(builder.getMaximumWeight());
        }
    }

    final boolean isComputingAsync(Node<?, ?> node) {
        return this.isAsync && !Async.isReady((CompletableFuture)node.getValue());
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderEdenDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderProbationDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected AccessOrderDeque<Node<K, V>> accessOrderProtectedDeque() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        throw new UnsupportedOperationException();
    }

    protected boolean buffersWrites() {
        return false;
    }

    protected Queue<Runnable> writeQueue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Executor executor() {
        return this.executor;
    }

    protected boolean hasWriter() {
        return this.writer != CacheWriter.disabledWriter();
    }

    @Override
    public boolean isRecordingStats() {
        return false;
    }

    @Override
    public StatsCounter statsCounter() {
        return StatsCounter.disabledStatsCounter();
    }

    @Override
    public Ticker statsTicker() {
        return Ticker.disabledTicker();
    }

    @Override
    public RemovalListener<K, V> removalListener() {
        return null;
    }

    protected boolean hasRemovalListener() {
        return false;
    }

    void notifyRemoval(@Nullable K key, @Nullable V value, RemovalCause cause) {
        Caffeine.requireState(this.hasRemovalListener(), "Notification should be guarded with a check", new Object[0]);
        Runnable task = () -> {
            try {
                this.removalListener().onRemoval(key, value, cause);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception thrown by removal listener", t);
            }
        };
        try {
            this.executor().execute(task);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception thrown when submitting removal listener", t);
            task.run();
        }
    }

    protected boolean collectKeys() {
        return false;
    }

    protected boolean collectValues() {
        return false;
    }

    @Nullable
    protected ReferenceQueue<K> keyReferenceQueue() {
        return null;
    }

    @Nullable
    protected ReferenceQueue<V> valueReferenceQueue() {
        return null;
    }

    protected boolean expiresAfterAccess() {
        return false;
    }

    protected long expiresAfterAccessNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterAccessNanos(long expireAfterAccessNanos) {
        throw new UnsupportedOperationException();
    }

    protected boolean expiresAfterWrite() {
        return false;
    }

    protected long expiresAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setExpiresAfterWriteNanos(long expireAfterWriteNanos) {
        throw new UnsupportedOperationException();
    }

    protected boolean refreshAfterWrite() {
        return false;
    }

    protected long refreshAfterWriteNanos() {
        throw new UnsupportedOperationException();
    }

    protected void setRefreshAfterWriteNanos(long refreshAfterWriteNanos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ticker expirationTicker() {
        return Ticker.disabledTicker();
    }

    protected boolean evicts() {
        return false;
    }

    protected boolean isWeighted() {
        return this.weigher != Weigher.singletonWeigher();
    }

    protected FrequencySketch<K> frequencySketch() {
        throw new UnsupportedOperationException();
    }

    protected boolean fastpath() {
        return false;
    }

    protected long maximum() {
        throw new UnsupportedOperationException();
    }

    protected long edenMaximum() {
        throw new UnsupportedOperationException();
    }

    protected long mainProtectedMaximum() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetMaximum(long maximum) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetEdenMaximum(long maximum) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetMainProtectedMaximum(long maximum) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    void setMaximum(long maximum) {
        Caffeine.requireArgument(maximum >= 0L);
        long max = Math.min(maximum, 9223372034707292160L);
        long eden = max - (long)((double)max * (double)0.99f);
        long mainProtected = (long)((double)max * (double)0.8f);
        this.lazySetMaximum(max);
        this.lazySetEdenMaximum(eden);
        this.lazySetMainProtectedMaximum(mainProtected);
        if (this.frequencySketch() != null && !this.isWeighted() && this.weightedSize() >= max >>> 1) {
            this.frequencySketch().ensureCapacity(max);
        }
    }

    long adjustedWeightedSize() {
        return Math.max(0L, this.weightedSize());
    }

    protected long weightedSize() {
        throw new UnsupportedOperationException();
    }

    protected long edenWeightedSize() {
        throw new UnsupportedOperationException();
    }

    protected long mainProtectedWeightedSize() {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetWeightedSize(long weightedSize) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetEdenWeightedSize(long weightedSize) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    protected void lazySetMainProtectedWeightedSize(long weightedSize) {
        throw new UnsupportedOperationException();
    }

    @GuardedBy(value="evictionLock")
    void evictEntries() {
        if (!this.evicts()) {
            return;
        }
        int candidates = this.evictFromEden();
        this.evictFromMain(candidates);
    }

    @GuardedBy(value="evictionLock")
    int evictFromEden() {
        int candidates = 0;
        long mainMaximum = this.maximum() - this.edenMaximum();
        AccessOrderDeque.AccessOrder node = (Node)this.accessOrderEdenDeque().peek();
        while ((this.edenWeightedSize() > this.edenMaximum() || this.weightedSize() < mainMaximum) && node != null) {
            AccessOrderDeque.AccessOrder next = node.getNextInAccessOrder();
            if (node.getWeight() != 0) {
                node.makeMainProbation();
                this.accessOrderEdenDeque().remove((Node<K, V>)node);
                this.accessOrderProbationDeque().add((Node<K, V>)node);
                ++candidates;
                this.lazySetEdenWeightedSize(this.edenWeightedSize() - (long)node.getPolicyWeight());
            }
            node = next;
        }
        return candidates;
    }

    @GuardedBy(value="evictionLock")
    void evictFromMain(int candidates) {
        AccessOrderDeque.AccessOrder victim = (Node)this.accessOrderProbationDeque().peekFirst();
        AccessOrderDeque.AccessOrder candidate = (Node)this.accessOrderProbationDeque().peekLast();
        while (this.weightedSize() > this.maximum()) {
            AccessOrderDeque.AccessOrder evict;
            Node evict2;
            if (candidates == 0) {
                candidate = null;
            }
            if (candidate == null && victim == null && (victim = (Node)this.accessOrderProtectedDeque().peekFirst()) == null) break;
            if (victim != null && victim.getPolicyWeight() == 0) {
                victim = victim.getNextInAccessOrder();
                continue;
            }
            if (candidate != null && candidate.getPolicyWeight() == 0) {
                candidate = candidate.getPreviousInAccessOrder();
                --candidates;
                continue;
            }
            if (victim == null) {
                --candidates;
                evict2 = candidate;
                candidate = candidate.getPreviousInAccessOrder();
                this.evictEntry(evict2, RemovalCause.SIZE, 0L);
                continue;
            }
            if (candidate == null) {
                evict2 = victim;
                victim = victim.getNextInAccessOrder();
                this.evictEntry(evict2, RemovalCause.SIZE, 0L);
                continue;
            }
            Object victimKey = victim.getKey();
            Object candidateKey = candidate.getKey();
            if (victimKey == null) {
                AccessOrderDeque.AccessOrder evict3 = victim;
                victim = victim.getNextInAccessOrder();
                this.evictEntry((Node<K, V>)evict3, RemovalCause.COLLECTED, 0L);
                continue;
            }
            if (candidateKey == null) {
                --candidates;
                AccessOrderDeque.AccessOrder evict4 = candidate;
                candidate = candidate.getPreviousInAccessOrder();
                this.evictEntry((Node<K, V>)evict4, RemovalCause.COLLECTED, 0L);
                continue;
            }
            if ((long)candidate.getPolicyWeight() > this.maximum()) {
                --candidates;
                AccessOrderDeque.AccessOrder evict5 = candidate;
                candidate = candidate.getPreviousInAccessOrder();
                this.evictEntry((Node<K, V>)evict5, RemovalCause.SIZE, 0L);
                continue;
            }
            --candidates;
            int victimFreq = this.frequencySketch().frequency(victimKey);
            int candidateFreq = this.frequencySketch().frequency(candidateKey);
            if (candidateFreq > victimFreq) {
                evict = victim;
                victim = victim.getNextInAccessOrder();
                this.evictEntry((Node<K, V>)evict, RemovalCause.SIZE, 0L);
                candidate = candidate.getPreviousInAccessOrder();
                continue;
            }
            evict = candidate;
            candidate = candidate.getPreviousInAccessOrder();
            this.evictEntry((Node<K, V>)evict, RemovalCause.SIZE, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    void expireEntries() {
        long now = this.expirationTicker().read();
        this.expireAfterAccessEntries(now);
        this.expireAfterWriteEntries(now);
    }

    @GuardedBy(value="evictionLock")
    void expireAfterAccessEntries(long now) {
        if (!this.expiresAfterAccess()) {
            return;
        }
        long expirationTime = now - this.expiresAfterAccessNanos();
        this.expireAfterAccessEntries(this.accessOrderEdenDeque(), expirationTime, now);
        if (this.evicts()) {
            this.expireAfterAccessEntries(this.accessOrderProbationDeque(), expirationTime, now);
            this.expireAfterAccessEntries(this.accessOrderProtectedDeque(), expirationTime, now);
        }
    }

    @GuardedBy(value="evictionLock")
    void expireAfterAccessEntries(AccessOrderDeque<Node<K, V>> accessOrderDeque, long expirationTime, long now) {
        Node node;
        while ((node = (Node)accessOrderDeque.peekFirst()) != null && node.getAccessTime() <= expirationTime) {
            this.evictEntry(node, RemovalCause.EXPIRED, now);
        }
        return;
    }

    @GuardedBy(value="evictionLock")
    void expireAfterWriteEntries(long now) {
        Node node;
        if (!this.expiresAfterWrite()) {
            return;
        }
        long expirationTime = now - this.expiresAfterWriteNanos();
        while ((node = (Node)this.writeOrderDeque().peekFirst()) != null && node.getWriteTime() <= expirationTime) {
            this.evictEntry(node, RemovalCause.EXPIRED, now);
        }
    }

    boolean hasExpired(Node<K, V> node, long now) {
        if (this.isComputingAsync(node)) {
            return false;
        }
        return this.expiresAfterAccess() && now - node.getAccessTime() >= this.expiresAfterAccessNanos() || this.expiresAfterWrite() && now - node.getWriteTime() >= this.expiresAfterWriteNanos();
    }

    @GuardedBy(value="evictionLock")
    void evictEntry(Node<K, V> node, RemovalCause cause, long now) {
        K key = node.getKey();
        V value = node.getValue();
        boolean[] removed = new boolean[1];
        boolean[] resurrect = new boolean[1];
        RemovalCause actualCause = key == null || value == null ? RemovalCause.COLLECTED : cause;
        this.data.computeIfPresent(node.getKeyReference(), (k, n) -> {
            if (n != node) {
                return n;
            }
            if (actualCause == RemovalCause.EXPIRED) {
                long expirationTime;
                boolean expired = false;
                if (this.expiresAfterAccess()) {
                    expirationTime = now - this.expiresAfterAccessNanos();
                    expired |= n.getAccessTime() <= expirationTime;
                }
                if (this.expiresAfterWrite()) {
                    expirationTime = now - this.expiresAfterWriteNanos();
                    expired |= n.getWriteTime() <= expirationTime;
                }
                if (!expired) {
                    resurrect[0] = true;
                    return n;
                }
            } else if (actualCause == RemovalCause.SIZE && node.getWeight() == 0) {
                resurrect[0] = true;
                return n;
            }
            this.writer.delete(key, value, actualCause);
            removed[0] = true;
            return null;
        });
        if (resurrect[0]) {
            return;
        }
        this.makeDead(node);
        if (node.inEden() && (this.evicts() || this.expiresAfterAccess())) {
            this.accessOrderEdenDeque().remove(node);
        } else if (this.evicts()) {
            if (node.inMainProbation()) {
                this.accessOrderProbationDeque().remove(node);
            } else {
                this.accessOrderProtectedDeque().remove(node);
            }
        }
        if (this.expiresAfterWrite()) {
            this.writeOrderDeque().remove(node);
        }
        if (removed[0]) {
            this.statsCounter().recordEviction();
            if (this.hasRemovalListener()) {
                this.notifyRemoval(key, value, actualCause);
            }
        }
    }

    void afterRead(Node<K, V> node, long now, boolean recordHit) {
        boolean delayable;
        if (recordHit) {
            this.statsCounter().recordHits(1);
        }
        node.setAccessTime(now);
        boolean bl = delayable = this.skipReadBuffer() || this.readBuffer.offer(node) != 1;
        if (this.shouldDrainBuffers(delayable)) {
            this.scheduleDrainBuffers();
        }
        this.refreshIfNeeded(node, now);
    }

    boolean skipReadBuffer() {
        return this.fastpath() && this.frequencySketch().isNotInitialized();
    }

    void refreshIfNeeded(Node<K, V> node, long now) {
        long refreshWriteTime;
        if (!this.refreshAfterWrite()) {
            return;
        }
        long oldWriteTime = node.getWriteTime();
        long l = refreshWriteTime = this.isAsync ? Long.MAX_VALUE : now;
        if (now - oldWriteTime > this.refreshAfterWriteNanos() && node.casWriteTime(oldWriteTime, refreshWriteTime)) {
            try {
                this.executor().execute(() -> {
                    Object key = node.getKey();
                    if (key != null && node.isAlive()) {
                        BiFunction<Object, Object, Object> refreshFunction = (k, v) -> {
                            if (node.getWriteTime() != refreshWriteTime) {
                                return v;
                            }
                            try {
                                if (this.isAsync) {
                                    Object oldValue = ((CompletableFuture)v).join();
                                    CompletableFuture<V> future = this.cacheLoader.asyncReload(key, oldValue, Runnable::run);
                                    if (future.join() == null) {
                                        return null;
                                    }
                                    CompletableFuture<V> castFuture = future;
                                    return castFuture;
                                }
                                return this.cacheLoader.reload(k, v);
                            }
                            catch (Exception e) {
                                node.setWriteTime(oldWriteTime);
                                return LocalCache.throwUnchecked(e);
                            }
                        };
                        try {
                            this.computeIfPresent(key, refreshFunction);
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "Exception thrown during refresh", t);
                        }
                    }
                });
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception thrown when submitting refresh task", t);
            }
        }
    }

    void afterWrite(@Nullable Node<K, V> node, Runnable task, long now) {
        if (node != null) {
            node.setAccessTime(now);
            node.setWriteTime(now);
        }
        if (this.buffersWrites()) {
            this.writeQueue().add(task);
        }
        this.scheduleAfterWrite();
    }

    void scheduleAfterWrite() {
        block6: while (true) {
            switch (this.drainStatus()) {
                case 0: {
                    this.casDrainStatus(0, 1);
                    this.scheduleDrainBuffers();
                    return;
                }
                case 1: {
                    this.scheduleDrainBuffers();
                    return;
                }
                case 2: {
                    if (!this.casDrainStatus(2, 3)) continue block6;
                    return;
                }
                case 3: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    void scheduleDrainBuffers() {
        if (this.drainStatus() >= 2) {
            return;
        }
        if (this.evictionLock.tryLock()) {
            try {
                int drainStatus = this.drainStatus();
                if (drainStatus >= 2) {
                    return;
                }
                this.lazySetDrainStatus(2);
                this.drainBuffersTask.reinitialize();
                this.executor().execute(this.drainBuffersTask);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception thrown when submitting maintenance task", t);
                this.performCleanUp();
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    @Override
    public void cleanUp() {
        try {
            this.performCleanUp();
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Exception thrown when performing the maintenance task", e);
        }
    }

    void performCleanUp() {
        this.evictionLock.lock();
        try {
            this.lazySetDrainStatus(2);
            this.maintenance();
        }
        finally {
            if (this.drainStatus() != 2 || !this.casDrainStatus(2, 0)) {
                this.lazySetDrainStatus(1);
            }
            this.evictionLock.unlock();
        }
    }

    @GuardedBy(value="evictionLock")
    void maintenance() {
        this.drainReadBuffer();
        this.drainWriteBuffer();
        this.drainKeyReferences();
        this.drainValueReferences();
        this.expireEntries();
        this.evictEntries();
    }

    @GuardedBy(value="evictionLock")
    void drainKeyReferences() {
        Reference<K> keyRef;
        if (!this.collectKeys()) {
            return;
        }
        while ((keyRef = this.keyReferenceQueue().poll()) != null) {
            Node<K, V> node = this.data.get(keyRef);
            if (node == null) continue;
            this.evictEntry(node, RemovalCause.COLLECTED, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainValueReferences() {
        Reference<V> valueRef;
        if (!this.collectValues()) {
            return;
        }
        while ((valueRef = this.valueReferenceQueue().poll()) != null) {
            References.InternalReference ref = (References.InternalReference)((Object)valueRef);
            Node<K, V> node = this.data.get(ref.getKeyReference());
            if (node == null || valueRef != node.getValueReference()) continue;
            this.evictEntry(node, RemovalCause.COLLECTED, 0L);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainReadBuffer() {
        if (!this.skipReadBuffer()) {
            this.readBuffer.drainTo(this.accessPolicy);
        }
    }

    @GuardedBy(value="evictionLock")
    void onAccess(Node<K, V> node) {
        if (this.evicts()) {
            K key = node.getKey();
            if (key == null) {
                return;
            }
            this.frequencySketch().increment(key);
            if (node.inEden()) {
                BoundedLocalCache.reorder(this.accessOrderEdenDeque(), node);
            } else if (node.inMainProbation()) {
                this.reorderProbation(node);
            } else {
                BoundedLocalCache.reorder(this.accessOrderProtectedDeque(), node);
            }
        } else if (this.expiresAfterAccess()) {
            BoundedLocalCache.reorder(this.accessOrderEdenDeque(), node);
        }
    }

    @GuardedBy(value="evictionLock")
    void reorderProbation(Node<K, V> node) {
        Node demoted;
        long mainProtectedWeightedSize;
        if (!this.accessOrderProbationDeque().contains(node)) {
            return;
        }
        if ((long)node.getPolicyWeight() > this.mainProtectedMaximum()) {
            return;
        }
        this.accessOrderProbationDeque().remove(node);
        this.accessOrderProtectedDeque().add(node);
        node.makeMainProtected();
        long mainProtectedMaximum = this.mainProtectedMaximum();
        for (mainProtectedWeightedSize = this.mainProtectedWeightedSize() + (long)node.getPolicyWeight(); mainProtectedWeightedSize > mainProtectedMaximum && (demoted = (Node)this.accessOrderProtectedDeque().pollFirst()) != null; mainProtectedWeightedSize -= (long)node.getPolicyWeight()) {
            demoted.makeMainProbation();
            this.accessOrderProbationDeque().add(demoted);
        }
        this.lazySetMainProtectedWeightedSize(mainProtectedWeightedSize);
    }

    static <K, V> void reorder(LinkedDeque<Node<K, V>> deque, Node<K, V> node) {
        if (deque.contains(node)) {
            deque.moveToBack(node);
        }
    }

    @GuardedBy(value="evictionLock")
    void drainWriteBuffer() {
        Runnable task;
        if (!this.buffersWrites()) {
            return;
        }
        while ((task = this.writeQueue().poll()) != null) {
            task.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="evictionLock")
    void makeDead(Node<K, V> node) {
        Node<K, V> node2 = node;
        synchronized (node2) {
            if (node.isDead()) {
                return;
            }
            if (this.evicts()) {
                if (node.inEden()) {
                    this.lazySetEdenWeightedSize(this.edenWeightedSize() - (long)node.getWeight());
                } else if (node.inMainProtected()) {
                    this.lazySetMainProtectedWeightedSize(this.mainProtectedWeightedSize() - (long)node.getWeight());
                }
                this.lazySetWeightedSize(this.weightedSize() - (long)node.getWeight());
            }
            node.die();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public long estimatedSize() {
        return this.data.mappingCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long now = this.expirationTicker().read();
        this.evictionLock.lock();
        try {
            Runnable task;
            while (this.buffersWrites() && (task = this.writeQueue().poll()) != null) {
                task.run();
            }
            if (this.evicts() || this.expiresAfterAccess()) {
                this.removeNodes(this.accessOrderEdenDeque(), now);
            }
            if (this.evicts()) {
                this.removeNodes(this.accessOrderProbationDeque(), now);
                this.removeNodes(this.accessOrderProtectedDeque(), now);
            }
            if (this.expiresAfterWrite()) {
                this.removeNodes(this.writeOrderDeque(), now);
            }
            this.data.values().forEach((? super T node) -> this.removeNode((Node<K, V>)node, now));
            this.readBuffer.drainTo(e -> {});
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @GuardedBy(value="evictionLock")
    void removeNodes(LinkedDeque<Node<K, V>> deque, long now) {
        Node node;
        while ((node = (Node)deque.peek()) != null) {
            this.removeNode(node, now);
            deque.poll();
        }
    }

    @GuardedBy(value="evictionLock")
    void removeNode(Node<K, V> node, long now) {
        K key = node.getKey();
        V value = node.getValue();
        boolean[] removed = new boolean[1];
        RemovalCause cause = key == null || value == null ? RemovalCause.COLLECTED : (this.hasExpired(node, now) ? RemovalCause.EXPIRED : RemovalCause.EXPLICIT);
        this.data.computeIfPresent(node.getKeyReference(), (k, n) -> {
            if (n == node) {
                this.writer.delete(key, value, cause);
                removed[0] = true;
                return null;
            }
            return n;
        });
        if (removed[0] && this.hasRemovalListener()) {
            this.notifyRemoval(key, value, cause);
        }
        this.makeDead(node);
    }

    @Override
    public boolean containsKey(Object key) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        return node != null && node.getValue() != null && !this.hasExpired(node, this.expirationTicker().read());
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        long now = this.expirationTicker().read();
        for (Node<K, V> node : this.data.values()) {
            if (!node.containsValue(value) || this.hasExpired(node, now) || node.getKey() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getIfPresent(key, false);
    }

    @Override
    public V getIfPresent(Object key, boolean recordStats) {
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        if (node == null) {
            if (recordStats) {
                this.statsCounter().recordMisses(1);
            }
            return null;
        }
        long now = this.expirationTicker().read();
        if (this.hasExpired(node, now)) {
            if (recordStats) {
                this.statsCounter().recordMisses(1);
            }
            this.scheduleDrainBuffers();
            return null;
        }
        this.afterRead(node, now, recordStats);
        return node.getValue();
    }

    @Override
    public Map<K, V> getAllPresent(Iterable<?> keys) {
        int misses = 0;
        long now = this.expirationTicker().read();
        LinkedHashMap result = new LinkedHashMap();
        for (Object key : keys) {
            Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
            if (node == null || this.hasExpired(node, now)) {
                ++misses;
                continue;
            }
            Object castKey = key;
            V value = node.getValue();
            if (value == null) continue;
            result.put(castKey, value);
            this.afterRead(node, now, true);
        }
        this.statsCounter().recordMisses(misses);
        return Collections.unmodifiableMap(result);
    }

    @Override
    public V put(K key, V value) {
        int weight = this.weigher.weigh(key, value);
        return weight > 0 ? this.putFast(key, value, weight, true, false) : this.putSlow(key, value, weight, true, false);
    }

    @Override
    public V put(K key, V value, boolean notifyWriter) {
        int weight = this.weigher.weigh(key, value);
        return weight > 0 ? this.putFast(key, value, weight, notifyWriter, false) : this.putSlow(key, value, weight, notifyWriter, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int weight = this.weigher.weigh(key, value);
        return weight > 0 ? this.putFast(key, value, weight, true, true) : this.putSlow(key, value, weight, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    V putFast(K key, V value, int newWeight, boolean notifyWriter, boolean onlyIfAbsent) {
        V v;
        int weightedDifference;
        boolean mayUpdate;
        boolean expired;
        Node prior;
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Caffeine.requireState(newWeight != 0);
        Node<K, V> node = null;
        long now = this.expirationTicker().read();
        while (true) {
            if ((prior = this.data.get(this.nodeFactory.newLookupKey(key))) == null) {
                if (node == null) {
                    node = this.nodeFactory.newNode(key, this.keyReferenceQueue(), value, this.valueReferenceQueue(), newWeight, now);
                }
                if (notifyWriter && this.hasWriter()) {
                    Node<K, V> computed = node;
                    prior = this.data.computeIfAbsent(node.getKeyReference(), k -> {
                        this.writer.write(key, value);
                        return computed;
                    });
                    if (prior == node) {
                        this.afterWrite(node, new AddTask(node, newWeight), now);
                        return null;
                    }
                } else {
                    prior = this.data.putIfAbsent(node.getKeyReference(), node);
                    if (prior == null) {
                        this.afterWrite(node, new AddTask(node, newWeight), now);
                        return null;
                    }
                }
            }
            expired = false;
            mayUpdate = true;
            Node node2 = prior;
            // MONITORENTER : node2
            if (prior.isAlive()) break;
            // MONITOREXIT : node2
        }
        Object oldValue = prior.getValue();
        int oldWeight = prior.getWeight();
        if (oldValue == null) {
            this.writer.delete(key, null, RemovalCause.COLLECTED);
        } else if (this.hasExpired(prior, now)) {
            this.writer.delete(key, oldValue, RemovalCause.EXPIRED);
            expired = true;
        } else if (onlyIfAbsent) {
            mayUpdate = false;
        }
        if (notifyWriter && (expired || mayUpdate && value != oldValue)) {
            this.writer.write(key, value);
        }
        if (mayUpdate) {
            prior.setValue(value, this.valueReferenceQueue());
            prior.setWeight(newWeight);
        }
        // MONITOREXIT : node2
        if (this.hasRemovalListener()) {
            if (expired) {
                this.notifyRemoval(key, oldValue, RemovalCause.EXPIRED);
            } else if (oldValue == null) {
                this.notifyRemoval(key, oldValue, RemovalCause.COLLECTED);
            } else if (mayUpdate && value != oldValue) {
                this.notifyRemoval(key, oldValue, RemovalCause.REPLACED);
            }
        }
        int n = weightedDifference = mayUpdate ? newWeight - oldWeight : 0;
        if (oldValue == null || weightedDifference != 0 || expired) {
            this.afterWrite(prior, new UpdateTask(prior, weightedDifference), now);
        } else if (!onlyIfAbsent && oldValue != null && this.expiresAfterWrite() && now - prior.getWriteTime() > EXPIRE_WRITE_TOLERANCE) {
            this.afterWrite(prior, new UpdateTask(prior, weightedDifference), now);
        } else {
            if (!onlyIfAbsent) {
                prior.setWriteTime(now);
            }
            this.afterRead(prior, now, false);
        }
        if (expired) {
            v = null;
            return v;
        }
        v = oldValue;
        return v;
    }

    V putSlow(K key, V value, int newWeight, boolean notifyWriter, boolean onlyIfAbsent) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Object[] nodeKey = new Object[1];
        Object[] oldValue = new Object[1];
        RemovalCause[] cause = new RemovalCause[1];
        long now = this.expirationTicker().read();
        int[] oldWeight = new int[1];
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        Node node = this.data.compute(keyRef, (kr, n) -> {
            if (n == null) {
                if (notifyWriter) {
                    this.writer.write(key, value);
                }
                return this.nodeFactory.newNode(kr, value, this.valueReferenceQueue(), newWeight, now);
            }
            Node node = n;
            synchronized (node) {
                nodeKey[0] = n.getKey();
                oldValue[0] = n.getValue();
                oldWeight[0] = n.getWeight();
                if (nodeKey == null || oldValue[0] == null) {
                    cause[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)n, now)) {
                    cause[0] = RemovalCause.EXPIRED;
                }
                if (cause[0] != null) {
                    this.writer.delete(nodeKey[0], oldValue[0], cause[0]);
                } else if (onlyIfAbsent && oldValue[0] != null) {
                    return n;
                }
                if (value != oldValue[0]) {
                    if (cause[0] == null) {
                        cause[0] = RemovalCause.REPLACED;
                    }
                    if (notifyWriter) {
                        this.writer.write(key, value);
                    }
                }
                n.setValue(value, this.valueReferenceQueue());
                n.setWeight(newWeight);
                n.setAccessTime(now);
                n.setWriteTime(now);
                return n;
            }
        });
        if (cause[0] != null) {
            if (cause[0].wasEvicted()) {
                this.statsCounter().recordEviction();
            }
            if (this.hasRemovalListener()) {
                this.notifyRemoval(nodeKey[0], oldValue[0], cause[0]);
            }
        }
        if (oldValue[0] == null && cause[0] == null) {
            this.afterWrite(node, new AddTask(node, newWeight), now);
        } else if (onlyIfAbsent && oldValue[0] != null && cause[0] == null) {
            this.afterRead(node, now, false);
        } else {
            int weightedDifference = newWeight - oldWeight[0];
            if (this.expiresAfterWrite() || oldValue[0] == null || weightedDifference != 0 || cause[0] != null && cause[0] != RemovalCause.REPLACED) {
                this.afterWrite(node, new UpdateTask(node, weightedDifference), now);
            } else {
                this.afterRead(node, now, false);
            }
        }
        return (V)(cause[0] == null || cause[0] == RemovalCause.REPLACED ? oldValue[0] : null);
    }

    @Override
    public V remove(Object key) {
        Object castKey = key;
        Node[] node = new Node[1];
        Object[] oldValue = new Object[1];
        long now = this.expirationTicker().read();
        RemovalCause[] cause = new RemovalCause[1];
        this.data.computeIfPresent(this.nodeFactory.newLookupKey(key), (k, n) -> {
            Node node2 = n;
            synchronized (node2) {
                oldValue[0] = n.getValue();
                cause[0] = oldValue[0] == null ? RemovalCause.COLLECTED : (this.hasExpired((Node<K, V>)n, now) ? RemovalCause.EXPIRED : RemovalCause.EXPLICIT);
                this.writer.delete(castKey, oldValue[0], cause[0]);
                n.retire();
            }
            node[0] = n;
            return null;
        });
        if (cause[0] != null) {
            this.afterWrite(node[0], new RemovalTask(node[0]), now);
            if (this.hasRemovalListener()) {
                this.notifyRemoval(castKey, oldValue[0], cause[0]);
            }
        }
        return (V)(cause[0] == RemovalCause.EXPLICIT ? oldValue[0] : null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Objects.requireNonNull(key);
        Object lookupKey = this.nodeFactory.newLookupKey(key);
        if (this.data.get(lookupKey) == null || value == null) {
            return false;
        }
        Node[] removed = new Node[1];
        Object[] oldKey = new Object[1];
        Object[] oldValue = new Object[1];
        RemovalCause[] cause = new RemovalCause[1];
        long now = this.expirationTicker().read();
        this.data.computeIfPresent(lookupKey, (kR, node) -> {
            Node node2 = node;
            synchronized (node2) {
                oldKey[0] = node.getKey();
                oldValue[0] = node.getValue();
                if (oldKey[0] == null) {
                    cause[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)node, now)) {
                    cause[0] = RemovalCause.EXPIRED;
                } else if (node.containsValue(value)) {
                    cause[0] = RemovalCause.EXPLICIT;
                } else {
                    return node;
                }
                this.writer.delete(oldKey[0], oldValue[0], cause[0]);
                removed[0] = node;
                node.retire();
                return null;
            }
        });
        if (removed[0] == null) {
            return false;
        }
        if (this.hasRemovalListener()) {
            this.notifyRemoval(oldKey[0], oldValue[0], cause[0]);
        }
        this.afterWrite(removed[0], new RemovalTask(removed[0]), now);
        return cause[0] == RemovalCause.EXPLICIT;
    }

    @Override
    public V replace(K key, V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        int[] oldWeight = new int[1];
        Object[] nodeKey = new Object[1];
        Object[] oldValue = new Object[1];
        long now = this.expirationTicker().read();
        int weight = this.weigher.weigh(key, value);
        Node node = this.data.computeIfPresent(this.nodeFactory.newLookupKey(key), (k, n) -> {
            Node node = n;
            synchronized (node) {
                nodeKey[0] = n.getKey();
                oldValue[0] = n.getValue();
                oldWeight[0] = n.getWeight();
                if (nodeKey[0] == null || oldValue[0] == null || this.hasExpired((Node<K, V>)n, now)) {
                    oldValue[0] = null;
                    return n;
                }
                if (value != oldValue[0]) {
                    this.writer.write(nodeKey[0], value);
                }
                n.setValue(value, this.valueReferenceQueue());
                n.setWriteTime(now);
                n.setWeight(weight);
                return n;
            }
        });
        if (oldValue[0] == null) {
            return null;
        }
        int weightedDifference = weight - oldWeight[0];
        if (this.expiresAfterWrite() || weightedDifference != 0) {
            this.afterWrite(node, new UpdateTask(node, weightedDifference), now);
        } else {
            this.afterRead(node, now, false);
        }
        if (this.hasRemovalListener() && value != oldValue[0]) {
            this.notifyRemoval(nodeKey[0], oldValue[0], RemovalCause.REPLACED);
        }
        return (V)oldValue[0];
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(oldValue);
        Objects.requireNonNull(newValue);
        int weight = this.weigher.weigh(key, newValue);
        boolean[] replaced = new boolean[1];
        Object[] nodeKey = new Object[1];
        Object[] prevValue = new Object[1];
        int[] oldWeight = new int[1];
        long now = this.expirationTicker().read();
        Node node = this.data.computeIfPresent(this.nodeFactory.newLookupKey(key), (k, n) -> {
            Node node = n;
            synchronized (node) {
                nodeKey[0] = n.getKey();
                prevValue[0] = n.getValue();
                oldWeight[0] = n.getWeight();
                if (nodeKey[0] == null || prevValue[0] == null || this.hasExpired((Node<K, V>)n, now) || !n.containsValue(oldValue)) {
                    return n;
                }
                if (newValue != prevValue[0]) {
                    this.writer.write(key, newValue);
                }
                n.setValue(newValue, this.valueReferenceQueue());
                n.setWeight(weight);
                n.setWriteTime(now);
                replaced[0] = true;
            }
            return n;
        });
        if (!replaced[0]) {
            return false;
        }
        int weightedDifference = weight - oldWeight[0];
        if (this.expiresAfterWrite() || weightedDifference != 0) {
            this.afterWrite(node, new UpdateTask(node, weightedDifference), now);
        } else {
            this.afterRead(node, now, false);
        }
        if (this.hasRemovalListener() && oldValue != newValue) {
            this.notifyRemoval(nodeKey[0], prevValue[0], RemovalCause.REPLACED);
        }
        return true;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        BiFunction<Object, Object, Object> remappingFunction = (key, oldValue) -> {
            Object newValue = Objects.requireNonNull(function.apply((K)key, (V)oldValue));
            if (oldValue != newValue) {
                this.writer.write(key, newValue);
            }
            return newValue;
        };
        for (K key2 : this.keySet()) {
            long now = this.expirationTicker().read();
            Object lookupKey = this.nodeFactory.newLookupKey(key2);
            this.remap(key2, lookupKey, remappingFunction, now, false);
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, boolean isAsync) {
        V value;
        Objects.requireNonNull(key);
        Objects.requireNonNull(mappingFunction);
        long now = this.expirationTicker().read();
        Node<K, V> node = this.data.get(this.nodeFactory.newLookupKey(key));
        if (node != null && (value = node.getValue()) != null && !this.hasExpired(node, now)) {
            this.afterRead(node, now, true);
            return value;
        }
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        return this.doComputeIfAbsent(key, keyRef, mappingFunction, isAsync, now);
    }

    V doComputeIfAbsent(K key, Object keyRef, Function<? super K, ? extends V> mappingFunction, boolean isAsync, long now) {
        Object[] newValue = new Object[1];
        int[] weight = new int[2];
        Object[] nodeKey = new Object[1];
        Object[] oldValue = new Object[1];
        RemovalCause[] cause = new RemovalCause[1];
        Node[] removed = new Node[1];
        Node node = this.data.compute(keyRef, (k, n) -> {
            if (n == null) {
                newValue[0] = this.statsAware(mappingFunction, isAsync).apply(key);
                if (newValue[0] == null) {
                    return null;
                }
                weight[1] = this.weigher.weigh(key, newValue[0]);
                return this.nodeFactory.newNode(key, this.keyReferenceQueue(), newValue[0], this.valueReferenceQueue(), weight[1], now);
            }
            Node node = n;
            synchronized (node) {
                nodeKey[0] = n.getKey();
                weight[0] = n.getWeight();
                oldValue[0] = n.getValue();
                if (nodeKey == null || oldValue[0] == null) {
                    cause[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)n, now)) {
                    cause[0] = RemovalCause.EXPIRED;
                    n.setAccessTime(now);
                    n.setWriteTime(now);
                } else {
                    return n;
                }
                this.writer.delete(nodeKey[0], oldValue[0], cause[0]);
                newValue[0] = this.statsAware(mappingFunction, isAsync).apply(key);
                if (newValue[0] == null) {
                    removed[0] = n;
                    n.retire();
                    return null;
                }
                weight[1] = this.weigher.weigh(key, newValue[0]);
                n.setValue(newValue[0], this.valueReferenceQueue());
                n.setWeight(weight[1]);
                return n;
            }
        });
        if (node == null) {
            if (removed[0] != null) {
                this.afterWrite(null, new RemovalTask(removed[0]), now);
            }
            return null;
        }
        if (cause[0] != null) {
            if (this.hasRemovalListener()) {
                this.notifyRemoval(nodeKey[0], oldValue[0], cause[0]);
            }
            this.statsCounter().recordEviction();
        }
        if (newValue[0] == null) {
            this.afterRead(node, now, true);
            return (V)oldValue[0];
        }
        if (oldValue[0] == null && cause[0] == null) {
            this.afterWrite(node, new AddTask(node, weight[1]), now);
        } else {
            int weightedDifference = weight[1] - weight[0];
            this.afterWrite(node, new UpdateTask(node, weightedDifference), now);
        }
        return (V)newValue[0];
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        long now;
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        Object lookupKey = this.nodeFactory.newLookupKey(key);
        Node<K, V> node = this.data.get(lookupKey);
        if (node == null || node.getValue() == null || this.hasExpired(node, now = this.expirationTicker().read())) {
            this.scheduleDrainBuffers();
            return null;
        }
        boolean computeIfAbsent = false;
        BiFunction<? super K, ? super V, ? extends V> statsAwareRemappingFunction = this.statsAware(remappingFunction, false, false);
        return this.remap(key, lookupKey, statsAwareRemappingFunction, now, computeIfAbsent);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, boolean recordMiss, boolean isAsync) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        long now = this.expirationTicker().read();
        boolean computeIfAbsent = true;
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        BiFunction<? super K, ? super V, ? extends V> statsAwareRemappingFunction = this.statsAware(remappingFunction, recordMiss, isAsync);
        return this.remap(key, keyRef, statsAwareRemappingFunction, now, computeIfAbsent);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        Objects.requireNonNull(remappingFunction);
        boolean computeIfAbsent = true;
        long now = this.expirationTicker().read();
        Object keyRef = this.nodeFactory.newReferenceKey(key, this.keyReferenceQueue());
        BiFunction<Object, Object, Object> mergeFunction = (k, oldValue) -> oldValue == null ? value : this.statsAware(remappingFunction).apply(oldValue, value);
        return (V)this.remap(key, keyRef, mergeFunction, now, computeIfAbsent);
    }

    V remap(K key, Object keyRef, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long now, boolean computeIfAbsent) {
        Object[] nodeKey = new Object[1];
        Object[] oldValue = new Object[1];
        Object[] newValue = new Object[1];
        Node[] removed = new Node[1];
        int[] weight = new int[2];
        RemovalCause[] cause = new RemovalCause[1];
        Node node = this.data.compute(keyRef, (kr, n) -> {
            if (n == null) {
                if (!computeIfAbsent) {
                    return null;
                }
                newValue[0] = remappingFunction.apply((K)key, (V)null);
                if (newValue[0] == null) {
                    return null;
                }
                weight[1] = this.weigher.weigh(key, newValue[0]);
                return this.nodeFactory.newNode(keyRef, newValue[0], this.valueReferenceQueue(), weight[1], now);
            }
            Node node = n;
            synchronized (node) {
                nodeKey[0] = n.getKey();
                oldValue[0] = n.getValue();
                if (nodeKey == null || oldValue[0] == null) {
                    cause[0] = RemovalCause.COLLECTED;
                } else if (this.hasExpired((Node<K, V>)n, now)) {
                    cause[0] = RemovalCause.EXPIRED;
                }
                if (cause[0] != null) {
                    this.writer.delete(nodeKey[0], oldValue[0], cause[0]);
                    if (!computeIfAbsent) {
                        removed[0] = n;
                        n.retire();
                        return null;
                    }
                }
                newValue[0] = remappingFunction.apply((K)nodeKey[0], (V)(cause[0] == null ? oldValue[0] : null));
                if (newValue[0] == null) {
                    if (cause[0] == null) {
                        cause[0] = RemovalCause.EXPLICIT;
                    }
                    removed[0] = n;
                    n.retire();
                    return null;
                }
                weight[0] = n.getWeight();
                weight[1] = this.weigher.weigh(key, newValue[0]);
                n.setValue(newValue[0], this.valueReferenceQueue());
                n.setWeight(weight[1]);
                n.setWriteTime(now);
                n.setAccessTime(now);
                if (cause[0] == null && newValue[0] != oldValue[0]) {
                    cause[0] = RemovalCause.REPLACED;
                }
                return n;
            }
        });
        if (cause[0] != null) {
            if (cause[0].wasEvicted()) {
                this.statsCounter().recordEviction();
            }
            if (this.hasRemovalListener()) {
                this.notifyRemoval(nodeKey[0], oldValue[0], cause[0]);
            }
        }
        if (removed[0] != null) {
            this.afterWrite(removed[0], new RemovalTask(removed[0]), now);
        } else if (node != null) {
            if (oldValue[0] == null && cause[0] == null) {
                this.afterWrite(node, new AddTask(node, weight[1]), now);
            } else {
                int weightedDifference = weight[1] - weight[0];
                if (this.expiresAfterWrite() || weightedDifference != 0) {
                    this.afterWrite(node, new UpdateTask(node, weightedDifference), now);
                } else {
                    this.afterRead(node, now, false);
                }
            }
        }
        return (V)newValue[0];
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        return ks == null ? (this.keySet = new KeySetView(this)) : ks;
    }

    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        return vs == null ? (this.values = new ValuesView(this)) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySetView(this)) : es;
    }

    Map<K, V> evictionOrder(int limit, Function<V, V> transformer, boolean ascending) {
        LinkedDeque.PeekingIterator main;
        Iterator eden;
        Comparator<Node> comparator = Comparator.comparingInt(node -> this.frequencySketch().frequency(node.getKey()));
        Comparator<Node> comparator2 = comparator = ascending ? comparator : comparator.reversed();
        if (ascending) {
            eden = this.accessOrderEdenDeque().iterator();
            main = LinkedDeque.PeekingIterator.concat(this.accessOrderProbationDeque().iterator(), this.accessOrderProtectedDeque().iterator());
        } else {
            eden = this.accessOrderEdenDeque().descendingIterator();
            main = LinkedDeque.PeekingIterator.concat(this.accessOrderProbationDeque().descendingIterator(), this.accessOrderProtectedDeque().descendingIterator());
        }
        LinkedDeque.PeekingIterator<Node<K, V>> iterator = LinkedDeque.PeekingIterator.comparing(eden, main, comparator);
        return this.snapshot(iterator, transformer, limit);
    }

    Map<K, V> expireAfterAcessOrder(int limit, Function<V, V> transformer, boolean ascending) {
        Iterator third;
        Iterator second;
        Iterator first;
        if (!this.evicts()) {
            Iterator iterator = ascending ? this.accessOrderEdenDeque().iterator() : this.accessOrderEdenDeque().descendingIterator();
            return this.snapshot(iterator, transformer, limit);
        }
        Comparator<Node> comparator = Comparator.comparingLong(Node::getAccessTime);
        if (ascending) {
            first = this.accessOrderEdenDeque().iterator();
            second = this.accessOrderProbationDeque().iterator();
            third = this.accessOrderProtectedDeque().iterator();
        } else {
            comparator = comparator.reversed();
            first = this.accessOrderEdenDeque().descendingIterator();
            second = this.accessOrderProbationDeque().descendingIterator();
            third = this.accessOrderProtectedDeque().descendingIterator();
        }
        LinkedDeque.PeekingIterator<Node<K, V>> iterator = LinkedDeque.PeekingIterator.comparing(LinkedDeque.PeekingIterator.comparing(first, second, comparator), third, comparator);
        return this.snapshot(iterator, transformer, limit);
    }

    Map<K, V> expireAfterWriteOrder(int limit, Function<V, V> transformer, boolean ascending) {
        Iterator iterator = ascending ? this.writeOrderDeque().iterator() : this.writeOrderDeque().descendingIterator();
        return this.snapshot(iterator, transformer, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> snapshot(Iterator<Node<K, V>> iterator, Function<V, V> transformer, int limit) {
        Caffeine.requireArgument(limit >= 0);
        this.evictionLock.lock();
        try {
            this.maintenance();
            int initialCapacity = this.isWeighted() ? 16 : Math.min(limit, this.evicts() ? (int)this.adjustedWeightedSize() : this.size());
            LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(initialCapacity);
            while (map.size() < limit && iterator.hasNext()) {
                Node<K, V> node = iterator.next();
                K key = node.getKey();
                V value = node.getValue();
                if (key == null || value == null || !node.isAlive()) continue;
                map.put(key, transformer.apply(value));
            }
            Map map2 = Collections.unmodifiableMap(map);
            return map2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    static <K, V> SerializationProxy<K, V> makeSerializationProxy(BoundedLocalCache<?, ?> cache, boolean isWeighted) {
        SerializationProxy proxy = new SerializationProxy();
        proxy.weakKeys = cache.collectKeys();
        proxy.weakValues = cache.nodeFactory.weakValues();
        proxy.softValues = cache.nodeFactory.softValues();
        proxy.isRecordingStats = cache.isRecordingStats();
        proxy.removalListener = cache.removalListener();
        proxy.ticker = cache.expirationTicker();
        proxy.writer = cache.writer;
        if (cache.expiresAfterAccess()) {
            proxy.expiresAfterAccessNanos = cache.expiresAfterAccessNanos();
        }
        if (cache.expiresAfterWrite()) {
            proxy.expiresAfterWriteNanos = cache.expiresAfterWriteNanos();
        }
        if (cache.evicts()) {
            if (isWeighted) {
                proxy.weigher = cache.weigher;
                proxy.maximumWeight = cache.maximum();
            } else {
                proxy.maximumSize = cache.maximum();
            }
        }
        return proxy;
    }

    static final class BoundedLocalAsyncLoadingCache<K, V>
    extends LocalAsyncLoadingCache<BoundedLocalCache<K, CompletableFuture<V>>, K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final boolean isWeighted;
        Policy<K, V> policy;

        BoundedLocalAsyncLoadingCache(Caffeine<K, V> builder, AsyncCacheLoader<? super K, V> loader) {
            super(LocalCacheFactory.newBoundedLocalCache(builder, BoundedLocalAsyncLoadingCache.asyncLoader(loader, builder), true), loader);
            this.isWeighted = builder.isWeighted();
        }

        private static <K, V> CacheLoader<K, V> asyncLoader(final AsyncCacheLoader<? super K, V> loader, Caffeine<?, ?> builder) {
            final Executor executor = builder.getExecutor();
            return new CacheLoader<K, V>(){

                @Override
                public V load(K key) {
                    CompletableFuture newValue = loader.asyncLoad(key, executor);
                    return newValue;
                }

                @Override
                public V reload(K key, V oldValue) {
                    CompletableFuture newValue = loader.asyncReload(key, oldValue, executor);
                    return newValue;
                }

                @Override
                public CompletableFuture<V> asyncReload(K key, V oldValue, Executor executor2) {
                    return loader.asyncReload(key, oldValue, executor2);
                }
            };
        }

        @Override
        protected Policy<K, V> policy() {
            if (this.policy == null) {
                Function<CompletableFuture, Object> transformer;
                BoundedLocalCache castCache = (BoundedLocalCache)this.cache;
                Function<CompletableFuture, Object> castTransformer = transformer = Async::getIfReady;
                this.policy = new BoundedPolicy(castCache, castTransformer, this.isWeighted);
            }
            return this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            SerializationProxy proxy = BoundedLocalCache.makeSerializationProxy((BoundedLocalCache)this.cache, this.isWeighted);
            if (((BoundedLocalCache)this.cache).refreshAfterWrite()) {
                proxy.refreshAfterWriteNanos = ((BoundedLocalCache)this.cache).refreshAfterWriteNanos();
            }
            proxy.loader = this.loader;
            proxy.async = true;
            return proxy;
        }
    }

    static final class BoundedLocalLoadingCache<K, V>
    extends BoundedLocalManualCache<K, V>
    implements LocalLoadingCache<BoundedLocalCache<K, V>, K, V> {
        private static final long serialVersionUID = 1L;
        final boolean hasBulkLoader;
        final Function<K, V> mappingFunction;

        BoundedLocalLoadingCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            super(builder, loader);
            Objects.requireNonNull(loader);
            this.hasBulkLoader = this.hasLoadAll(loader);
            this.mappingFunction = key -> {
                try {
                    return loader.load(key);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new CompletionException(e);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            };
        }

        @Override
        public CacheLoader<? super K, V> cacheLoader() {
            return this.cache.cacheLoader;
        }

        @Override
        public Function<K, V> mappingFunction() {
            return this.mappingFunction;
        }

        @Override
        public boolean hasBulkLoader() {
            return this.hasBulkLoader;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        @Override
        Object writeReplace() {
            SerializationProxy proxy = (SerializationProxy)super.writeReplace();
            if (this.cache.refreshAfterWrite()) {
                proxy.refreshAfterWriteNanos = this.cache.refreshAfterWriteNanos();
            }
            proxy.loader = this.cache.cacheLoader;
            return proxy;
        }
    }

    static final class BoundedPolicy<K, V>
    implements Policy<K, V> {
        final BoundedLocalCache<K, V> cache;
        final Function<V, V> transformer;
        final boolean isWeighted;
        Optional<Policy.Eviction<K, V>> eviction;
        Optional<Policy.Expiration<K, V>> refreshes;
        Optional<Policy.Expiration<K, V>> afterWrite;
        Optional<Policy.Expiration<K, V>> afterAccess;

        BoundedPolicy(BoundedLocalCache<K, V> cache, Function<V, V> transformer, boolean isWeighted) {
            this.transformer = transformer;
            this.isWeighted = isWeighted;
            this.cache = cache;
        }

        @Override
        public boolean isRecordingStats() {
            return this.cache.isRecordingStats();
        }

        @Override
        public Optional<Policy.Eviction<K, V>> eviction() {
            Optional<Policy.Eviction<K, V>> optional;
            if (this.cache.evicts()) {
                if (this.eviction == null) {
                    this.eviction = Optional.of(new BoundedEviction());
                    optional = this.eviction;
                } else {
                    optional = this.eviction;
                }
            } else {
                optional = Optional.empty();
            }
            return optional;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterAccess() {
            if (!this.cache.expiresAfterAccess()) {
                return Optional.empty();
            }
            return this.afterAccess == null ? (this.afterAccess = Optional.of(new BoundedExpireAfterAccess())) : this.afterAccess;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> expireAfterWrite() {
            if (!this.cache.expiresAfterWrite()) {
                return Optional.empty();
            }
            return this.afterWrite == null ? (this.afterWrite = Optional.of(new BoundedExpireAfterWrite())) : this.afterWrite;
        }

        @Override
        public Optional<Policy.Expiration<K, V>> refreshAfterWrite() {
            if (!this.cache.refreshAfterWrite()) {
                return Optional.empty();
            }
            return this.refreshes == null ? (this.refreshes = Optional.of(new BoundedRefreshAfterWrite())) : this.refreshes;
        }

        final class BoundedRefreshAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedRefreshAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object lookupKey = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(lookupKey);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.expirationTicker().read() - node.getWriteTime();
                return age > BoundedPolicy.this.cache.refreshAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.refreshAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setRefreshAfterWriteNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().oldest(limit) : this.sortedByWriteTime(limit, true);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.expiresAfterWrite() ? BoundedPolicy.this.expireAfterWrite().get().youngest(limit) : this.sortedByWriteTime(limit, false);
            }

            Map<K, V> sortedByWriteTime(int limit, boolean ascending) {
                Comparator<Node> comparator = Comparator.comparingLong(Node::getWriteTime);
                Iterator iterator = ((Stream)BoundedPolicy.this.cache.data.values().stream().parallel()).sorted(ascending ? comparator : comparator.reversed()).limit(limit).iterator();
                return BoundedPolicy.this.cache.snapshot(iterator, BoundedPolicy.this.transformer, limit);
            }
        }

        final class BoundedExpireAfterWrite
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterWrite() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object lookupKey = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(lookupKey);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.expirationTicker().read() - node.getWriteTime();
                return age > BoundedPolicy.this.cache.expiresAfterWriteNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.expiresAfterWriteNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterWriteNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.expireAfterWriteOrder(limit, BoundedPolicy.this.transformer, true);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.expireAfterWriteOrder(limit, BoundedPolicy.this.transformer, false);
            }
        }

        final class BoundedExpireAfterAccess
        implements Policy.Expiration<K, V> {
            BoundedExpireAfterAccess() {
            }

            @Override
            public OptionalLong ageOf(K key, TimeUnit unit) {
                Object lookupKey = BoundedPolicy.this.cache.nodeFactory.newLookupKey(key);
                Node node = BoundedPolicy.this.cache.data.get(lookupKey);
                if (node == null) {
                    return OptionalLong.empty();
                }
                long age = BoundedPolicy.this.cache.expirationTicker().read() - node.getAccessTime();
                return age > BoundedPolicy.this.cache.expiresAfterAccessNanos() ? OptionalLong.empty() : OptionalLong.of(unit.convert(age, TimeUnit.NANOSECONDS));
            }

            @Override
            public long getExpiresAfter(TimeUnit unit) {
                return unit.convert(BoundedPolicy.this.cache.expiresAfterAccessNanos(), TimeUnit.NANOSECONDS);
            }

            @Override
            public void setExpiresAfter(long duration, TimeUnit unit) {
                Caffeine.requireArgument(duration >= 0L);
                BoundedPolicy.this.cache.setExpiresAfterAccessNanos(unit.toNanos(duration));
                BoundedPolicy.this.cache.scheduleAfterWrite();
            }

            @Override
            public Map<K, V> oldest(int limit) {
                return BoundedPolicy.this.cache.expireAfterAcessOrder(limit, BoundedPolicy.this.transformer, true);
            }

            @Override
            public Map<K, V> youngest(int limit) {
                return BoundedPolicy.this.cache.expireAfterAcessOrder(limit, BoundedPolicy.this.transformer, false);
            }
        }

        final class BoundedEviction
        implements Policy.Eviction<K, V> {
            BoundedEviction() {
            }

            @Override
            public boolean isWeighted() {
                return BoundedPolicy.this.isWeighted;
            }

            @Override
            public OptionalLong weightedSize() {
                if (BoundedPolicy.this.cache.evicts() && this.isWeighted()) {
                    BoundedPolicy.this.cache.evictionLock.lock();
                    try {
                        OptionalLong optionalLong = OptionalLong.of(BoundedPolicy.this.cache.adjustedWeightedSize());
                        return optionalLong;
                    }
                    finally {
                        BoundedPolicy.this.cache.evictionLock.unlock();
                    }
                }
                return OptionalLong.empty();
            }

            @Override
            public long getMaximum() {
                return BoundedPolicy.this.cache.maximum();
            }

            @Override
            public void setMaximum(long maximum) {
                BoundedPolicy.this.cache.evictionLock.lock();
                try {
                    BoundedPolicy.this.cache.setMaximum(maximum);
                    BoundedPolicy.this.cache.maintenance();
                }
                finally {
                    BoundedPolicy.this.cache.evictionLock.unlock();
                }
            }

            @Override
            public Map<K, V> coldest(int limit) {
                return BoundedPolicy.this.cache.evictionOrder(limit, BoundedPolicy.this.transformer, true);
            }

            @Override
            public Map<K, V> hottest(int limit) {
                return BoundedPolicy.this.cache.evictionOrder(limit, BoundedPolicy.this.transformer, false);
            }
        }
    }

    static class BoundedLocalManualCache<K, V>
    implements LocalManualCache<BoundedLocalCache<K, V>, K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final BoundedLocalCache<K, V> cache;
        final boolean isWeighted;
        Policy<K, V> policy;

        BoundedLocalManualCache(Caffeine<K, V> builder) {
            this(builder, null);
        }

        BoundedLocalManualCache(Caffeine<K, V> builder, CacheLoader<? super K, V> loader) {
            this.cache = LocalCacheFactory.newBoundedLocalCache(builder, loader, false);
            this.isWeighted = builder.isWeighted();
        }

        @Override
        public BoundedLocalCache<K, V> cache() {
            return this.cache;
        }

        @Override
        public Policy<K, V> policy() {
            return this.policy == null ? (this.policy = new BoundedPolicy<K, V>(this.cache, Function.identity(), this.isWeighted)) : this.policy;
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        Object writeReplace() {
            return BoundedLocalCache.makeSerializationProxy(this.cache, this.isWeighted);
        }
    }

    final class PerformCleanupTask
    extends ForkJoinTask<Void>
    implements Runnable {
        private static final long serialVersionUID = 1L;

        PerformCleanupTask() {
        }

        @Override
        public Void getRawResult() {
            return null;
        }

        @Override
        public void setRawResult(Void v) {
        }

        @Override
        public boolean exec() {
            try {
                this.run();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception thrown when performing the maintenance task", t);
            }
            return false;
        }

        @Override
        public void run() {
            BoundedLocalCache.this.performCleanUp();
        }
    }

    static final class EntrySpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        EntrySpliterator(BoundedLocalCache<K, V> cache) {
            this(cache, cache.data.values().spliterator());
        }

        EntrySpliterator(BoundedLocalCache<K, V> cache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
            Objects.requireNonNull(action);
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept(new WriteThroughEntry<K, V>(this.cache, key, value));
                }
            };
            this.spliterator.forEachRemaining(consumer);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            Objects.requireNonNull(action);
            boolean[] advanced = new boolean[]{false};
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept(new WriteThroughEntry<K, V>(this.cache, key, value));
                    advanced[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer)) {
                if (!advanced[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            Spliterator<Node<K, V>> split = this.spliterator.trySplit();
            return split == null ? null : new EntrySpliterator<K, V>(this.cache, split);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        final BoundedLocalCache<K, V> cache;
        final Iterator<Node<K, V>> iterator;
        final long now;
        K key;
        V value;
        K removalKey;
        Node<K, V> next;

        EntryIterator(BoundedLocalCache<K, V> cache) {
            this.iterator = cache.data.values().iterator();
            this.now = cache.expirationTicker().read();
            this.cache = cache;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                this.value = this.next.getValue();
                this.key = this.next.getKey();
                if (this.cache.hasExpired(this.next, this.now) || this.key == null || this.value == null || !this.next.isAlive()) {
                    this.value = null;
                    this.next = null;
                    this.key = null;
                    continue;
                }
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            WriteThroughEntry<K, V> entry = new WriteThroughEntry<K, V>(this.cache, this.key, this.value);
            this.removalKey = this.key;
            this.value = null;
            this.next = null;
            this.key = null;
            return entry;
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.removalKey != null);
            this.cache.remove(this.removalKey);
            this.removalKey = null;
        }
    }

    static final class EntrySetView<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        final BoundedLocalCache<K, V> cache;

        EntrySetView(BoundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = this.cache.data.get(this.cache.nodeFactory.newLookupKey(entry.getKey()));
            return node != null && Objects.equals(node.getValue(), entry.getValue());
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.cache.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            for (Map.Entry<K, V> entry : this) {
                if (!filter.test(entry)) continue;
                removed |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return removed;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator<K, V>(this.cache);
        }
    }

    static final class ValueSpliterator<K, V>
    implements Spliterator<V> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        ValueSpliterator(BoundedLocalCache<K, V> cache) {
            this(cache, cache.data.values().spliterator());
        }

        ValueSpliterator(BoundedLocalCache<K, V> cache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            Objects.requireNonNull(action);
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept((V)value);
                }
            };
            this.spliterator.forEachRemaining(consumer);
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            Objects.requireNonNull(action);
            boolean[] advanced = new boolean[]{false};
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept((V)value);
                    advanced[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer)) {
                if (!advanced[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<V> trySplit() {
            Spliterator<Node<K, V>> split = this.spliterator.trySplit();
            return split == null ? null : new ValueSpliterator<K, V>(this.cache, split);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4352;
        }
    }

    static final class ValueIterator<K, V>
    implements Iterator<V> {
        final Iterator<Map.Entry<K, V>> iterator;

        ValueIterator(BoundedLocalCache<K, V> cache) {
            this.iterator = cache.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    static final class ValuesView<K, V>
    extends AbstractCollection<V> {
        final BoundedLocalCache<K, V> cache;

        ValuesView(BoundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.cache.containsValue(o);
        }

        @Override
        public boolean removeIf(Predicate<? super V> filter) {
            Objects.requireNonNull(filter);
            boolean removed = false;
            for (Map.Entry<K, V> entry : this.cache.entrySet()) {
                if (!filter.test(entry.getValue())) continue;
                removed |= this.cache.remove(entry.getKey(), entry.getValue());
            }
            return removed;
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<V> spliterator() {
            return new ValueSpliterator<K, V>(this.cache);
        }
    }

    static final class KeySpliterator<K, V>
    implements Spliterator<K> {
        final Spliterator<Node<K, V>> spliterator;
        final BoundedLocalCache<K, V> cache;

        KeySpliterator(BoundedLocalCache<K, V> cache) {
            this(cache, cache.data.values().spliterator());
        }

        KeySpliterator(BoundedLocalCache<K, V> cache, Spliterator<Node<K, V>> spliterator) {
            this.spliterator = Objects.requireNonNull(spliterator);
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public void forEachRemaining(Consumer<? super K> action) {
            Objects.requireNonNull(action);
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept((K)key);
                }
            };
            this.spliterator.forEachRemaining(consumer);
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            Objects.requireNonNull(action);
            boolean[] advanced = new boolean[]{false};
            long now = this.cache.expirationTicker().read();
            Consumer<Node> consumer = node -> {
                Object key = node.getKey();
                Object value = node.getValue();
                if (key != null && value != null && !this.cache.hasExpired((Node<K, V>)node, now) && node.isAlive()) {
                    action.accept((K)key);
                    advanced[0] = true;
                }
            };
            while (this.spliterator.tryAdvance(consumer)) {
                if (!advanced[0]) continue;
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<K> trySplit() {
            Spliterator<Node<K, V>> split = this.spliterator.trySplit();
            return split == null ? null : new KeySpliterator<K, V>(this.cache, split);
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class KeyIterator<K, V>
    implements Iterator<K> {
        final Iterator<Map.Entry<K, V>> iterator;
        final BoundedLocalCache<K, V> cache;
        K current;

        KeyIterator(BoundedLocalCache<K, V> cache) {
            this.iterator = cache.entrySet().iterator();
            this.cache = cache;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            K next = this.iterator.next().getKey();
            this.current = next;
            return this.current;
        }

        @Override
        public void remove() {
            Caffeine.requireState(this.current != null);
            this.cache.remove(this.current);
            this.current = null;
        }
    }

    static final class KeySetView<K, V>
    extends AbstractSet<K> {
        final BoundedLocalCache<K, V> cache;

        KeySetView(BoundedLocalCache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean contains(Object obj) {
            return this.cache.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.cache.remove(obj) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator<K, V>(this.cache);
        }

        @Override
        public Spliterator<K> spliterator() {
            return new KeySpliterator<K, V>(this.cache);
        }

        @Override
        public Object[] toArray() {
            if (this.cache.collectKeys()) {
                ArrayList<K> keys = new ArrayList<K>(this.size());
                for (K key : this) {
                    keys.add(key);
                }
                return keys.toArray();
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.cache.data.keySet())).toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            if (this.cache.collectKeys()) {
                ArrayList<K> keys = new ArrayList<K>(this.size());
                for (K key : this) {
                    keys.add(key);
                }
                return keys.toArray(array);
            }
            return ((ConcurrentHashMap.CollectionView)((Object)this.cache.data.keySet())).toArray(array);
        }
    }

    final class UpdateTask
    implements Runnable {
        final int weightDifference;
        final Node<K, V> node;

        public UpdateTask(Node<K, V> node, int weightDifference) {
            this.weightDifference = weightDifference;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (BoundedLocalCache.this.evicts()) {
                if (this.node.inEden()) {
                    BoundedLocalCache.this.lazySetEdenWeightedSize(BoundedLocalCache.this.edenWeightedSize() + (long)this.weightDifference);
                } else if (this.node.inMainProtected()) {
                    BoundedLocalCache.this.lazySetMainProtectedWeightedSize(BoundedLocalCache.this.mainProtectedMaximum() + (long)this.weightDifference);
                }
                BoundedLocalCache.this.lazySetWeightedSize(BoundedLocalCache.this.weightedSize() + (long)this.weightDifference);
                this.node.setPolicyWeight(this.node.getPolicyWeight() + this.weightDifference);
            }
            if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                BoundedLocalCache.this.onAccess(this.node);
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.reorder(BoundedLocalCache.this.writeOrderDeque(), this.node);
            }
        }
    }

    final class RemovalTask
    implements Runnable {
        final Node<K, V> node;

        RemovalTask(Node<K, V> node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (this.node.inEden() && (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess())) {
                BoundedLocalCache.this.accessOrderEdenDeque().remove(this.node);
            } else if (BoundedLocalCache.this.evicts()) {
                if (this.node.inMainProbation()) {
                    BoundedLocalCache.this.accessOrderProbationDeque().remove(this.node);
                } else {
                    BoundedLocalCache.this.accessOrderProtectedDeque().remove(this.node);
                }
            }
            if (BoundedLocalCache.this.expiresAfterWrite()) {
                BoundedLocalCache.this.writeOrderDeque().remove(this.node);
            }
            BoundedLocalCache.this.makeDead(this.node);
        }
    }

    final class AddTask
    implements Runnable {
        final Node<K, V> node;
        final int weight;

        AddTask(Node<K, V> node, int weight) {
            this.weight = weight;
            this.node = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            boolean isAlive;
            if (BoundedLocalCache.this.evicts()) {
                this.node.setPolicyWeight(this.weight);
                long weightedSize = BoundedLocalCache.this.weightedSize();
                BoundedLocalCache.this.lazySetWeightedSize(weightedSize + (long)this.weight);
                BoundedLocalCache.this.lazySetEdenWeightedSize(BoundedLocalCache.this.edenWeightedSize() + (long)this.weight);
                if (BoundedLocalCache.this.isWeighted()) {
                    BoundedLocalCache.this.frequencySketch().ensureCapacity(BoundedLocalCache.this.data.mappingCount());
                } else {
                    long maximumSize = BoundedLocalCache.this.maximum();
                    if (weightedSize >= maximumSize >>> 1) {
                        BoundedLocalCache.this.frequencySketch().ensureCapacity(maximumSize);
                    }
                }
                Object key = this.node.getKey();
                if (key != null) {
                    BoundedLocalCache.this.frequencySketch().increment(key);
                }
            }
            Node node = this.node;
            synchronized (node) {
                isAlive = this.node.isAlive();
            }
            if (isAlive) {
                if (BoundedLocalCache.this.expiresAfterWrite()) {
                    BoundedLocalCache.this.writeOrderDeque().add(this.node);
                }
                if (BoundedLocalCache.this.evicts() || BoundedLocalCache.this.expiresAfterAccess()) {
                    BoundedLocalCache.this.accessOrderEdenDeque().add(this.node);
                }
            }
            if (BoundedLocalCache.this.isComputingAsync(this.node)) {
                this.node.setAccessTime(Long.MAX_VALUE);
                this.node.setWriteTime(Long.MAX_VALUE);
                ((CompletableFuture)this.node.getValue()).thenRun(() -> {
                    long now = BoundedLocalCache.this.expirationTicker().read();
                    this.node.setAccessTime(now);
                    this.node.setWriteTime(now);
                });
            }
        }
    }
}

