/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "k8s.io/api/core/v1"
)

// ValueSourceApplyConfiguration represents an declarative configuration of the ValueSource type for use
// with apply.
type ValueSourceApplyConfiguration struct {
	ConfigMapKeyRef *v1.ConfigMapKeySelector `json:"configMapKeyRef,omitempty"`
	SecretKeyRef    *v1.SecretKeySelector    `json:"secretKeyRef,omitempty"`
}

// ValueSourceApplyConfiguration constructs an declarative configuration of the ValueSource type for use with
// apply.
func ValueSource() *ValueSourceApplyConfiguration {
	return &ValueSourceApplyConfiguration{}
}

// WithConfigMapKeyRef sets the ConfigMapKeyRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConfigMapKeyRef field is set to the value of the last call.
func (b *ValueSourceApplyConfiguration) WithConfigMapKeyRef(value v1.ConfigMapKeySelector) *ValueSourceApplyConfiguration {
	b.ConfigMapKeyRef = &value
	return b
}

// WithSecretKeyRef sets the SecretKeyRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SecretKeyRef field is set to the value of the last call.
func (b *ValueSourceApplyConfiguration) WithSecretKeyRef(value v1.SecretKeySelector) *ValueSourceApplyConfiguration {
	b.SecretKeyRef = &value
	return b
}
