/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class SimpleUtils {

    private static final Set<String> SIMPLE_FUNCTIONS = Collections.unmodifiableSet(new LinkedHashSet<>(
            Arrays.asList(
                    // Generated by camel build tools - do NOT edit this list!
                    // SIMPLE-FUNCTIONS: START
                    "abs",
                    "assert",
                    "attachment",
                    "attachments",
                    "attachmentscontent",
                    "attachmentscontentas",
                    "attachmentscontentastext",
                    "attachmentsheader",
                    "attachmentsheaderas",
                    "attachmentskeys",
                    "attachmentssize",
                    "average",
                    "base64decode",
                    "base64encode",
                    "bean",
                    "body",
                    "bodyas",
                    "bodyoneline",
                    "bodytype",
                    "camelcontext",
                    "camelid",
                    "capitalize",
                    "ceil",
                    "clearattachments",
                    "collate",
                    "concat",
                    "contains",
                    "convertto",
                    "date",
                    "date-with-timezone",
                    "distinct",
                    "empty",
                    "env",
                    "exception",
                    "exchange",
                    "exchangeid",
                    "exchangeproperty",
                    "filter",
                    "floor",
                    "foreach",
                    "fromrouteid",
                    "function",
                    "hash",
                    "header",
                    "headeras",
                    "headers",
                    "hostname",
                    "id",
                    "iif",
                    "isalpha",
                    "isalphanumeric",
                    "isempty",
                    "isnumeric",
                    "join",
                    "jq",
                    "jsonpath",
                    "kindoftype",
                    "length",
                    "list",
                    "load",
                    "lowercase",
                    "mandatorybodyas",
                    "map",
                    "max",
                    "messageas",
                    "messagehistory",
                    "messagetimestamp",
                    "min",
                    "newempty",
                    "normalizewhitespace",
                    "not",
                    "null",
                    "originalbody",
                    "pad",
                    "pretty",
                    "prettybody",
                    "properties",
                    "propertiesexist",
                    "quote",
                    "random",
                    "range",
                    "ref",
                    "replace",
                    "reverse",
                    "routegroup",
                    "routeid",
                    "safequote",
                    "setheader",
                    "setvariable",
                    "shuffle",
                    "size",
                    "skip",
                    "split",
                    "stepid",
                    "substring",
                    "substringafter",
                    "substringbefore",
                    "substringbetween",
                    "sum",
                    "sys",
                    "threadid",
                    "threadname",
                    "throwexception",
                    "trim",
                    "type",
                    "unquote",
                    "uppercase",
                    "uuid",
                    "variable",
                    "variableas",
                    "variables",
                    "xpath"
            // SIMPLE-FUNCTIONS: END
            )));

    private SimpleUtils() {
    }

    /**
     * All the built-in simple language function names (in lower case)
     */
    public static Set<String> getFunctions() {
        return SIMPLE_FUNCTIONS;
    }

}
