/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.common.util.Encode;
import org.keycloak.common.util.PathHelper;

public class KeycloakUriBuilder {
    private String host;
    private String scheme;
    private int port = -1;
    private boolean preserveDefaultPort = false;
    private String userInfo;
    private String path;
    private String query;
    private String fragment;
    private String ssp;
    private String authority;
    private static final Pattern opaqueUri = Pattern.compile("^([^:/?#]+):([^/].*)");
    private static final Pattern hierarchicalUri = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern hostPortPattern = Pattern.compile("([^/:]+):(\\d+)");
    private static final Pattern PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");

    public static KeycloakUriBuilder fromUri(URI uri) {
        return new KeycloakUriBuilder().uri(uri);
    }

    public static KeycloakUriBuilder fromUri(String uriTemplate) {
        return new KeycloakUriBuilder().uri(uriTemplate, true);
    }

    public static KeycloakUriBuilder fromUri(String uri, boolean template) {
        return new KeycloakUriBuilder().uri(uri, template);
    }

    public static KeycloakUriBuilder fromPath(String path) throws IllegalArgumentException {
        return new KeycloakUriBuilder().path(path);
    }

    public KeycloakUriBuilder clone() {
        KeycloakUriBuilder impl = new KeycloakUriBuilder();
        impl.host = this.host;
        impl.scheme = this.scheme;
        impl.port = this.port;
        impl.userInfo = this.userInfo;
        impl.path = this.path;
        impl.query = this.query;
        impl.fragment = this.fragment;
        impl.ssp = this.ssp;
        impl.authority = this.authority;
        return impl;
    }

    public static boolean compare(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static URI relativize(URI from, URI to) {
        int i;
        if (!KeycloakUriBuilder.compare(from.getScheme(), to.getScheme())) {
            return to;
        }
        if (!KeycloakUriBuilder.compare(from.getHost(), to.getHost())) {
            return to;
        }
        if (from.getPort() != to.getPort()) {
            return to;
        }
        if (from.getPath() == null && to.getPath() == null) {
            return URI.create("");
        }
        if (from.getPath() == null) {
            return URI.create(to.getPath());
        }
        if (to.getPath() == null) {
            return to;
        }
        String fromPath = from.getPath();
        if (fromPath.startsWith("/")) {
            fromPath = fromPath.substring(1);
        }
        String[] fsplit = fromPath.split("/");
        String toPath = to.getPath();
        if (toPath.startsWith("/")) {
            toPath = toPath.substring(1);
        }
        String[] tsplit = toPath.split("/");
        for (int f = 0; f < fsplit.length && f < tsplit.length && fsplit[f].equals(tsplit[f]); ++f) {
        }
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromPath("");
        for (i = f; i < fsplit.length; ++i) {
            builder.path("..");
        }
        for (i = f; i < tsplit.length; ++i) {
            builder.path(tsplit[i]);
        }
        return builder.build(new Object[0]);
    }

    public static KeycloakUriBuilder fromTemplate(String uriTemplate) {
        KeycloakUriBuilder impl = new KeycloakUriBuilder();
        impl.uriTemplate(uriTemplate);
        return impl;
    }

    public KeycloakUriBuilder uriTemplate(String uriTemplate) {
        return this.uri(uriTemplate, true);
    }

    protected KeycloakUriBuilder parseHierarchicalUri(String uri, Matcher match, boolean template) {
        String authority;
        boolean scheme;
        boolean bl = scheme = match.group(2) != null;
        if (scheme) {
            this.scheme = match.group(2);
        }
        if ((authority = match.group(4)) != null) {
            Matcher hostPortMatch;
            this.authority = null;
            String host = match.group(4);
            int at = host.indexOf(64);
            if (at > -1) {
                String user = host.substring(0, at);
                host = host.substring(at + 1);
                this.replaceUserInfo(user, template);
            }
            if ((hostPortMatch = hostPortPattern.matcher(host)).matches()) {
                this.host = hostPortMatch.group(1);
                try {
                    this.port = Integer.parseInt(hostPortMatch.group(2));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal uri template: " + uri, e);
                }
            } else {
                this.host = host;
            }
        }
        if (match.group(5) != null) {
            String group = match.group(5);
            if (!(scheme || "".equals(group) || group.startsWith("/") || group.indexOf(58) <= -1)) {
                throw new IllegalArgumentException("Illegal uri template: " + uri);
            }
            if (!"".equals(group)) {
                this.replacePath(group, template);
            }
        }
        if (match.group(7) != null) {
            this.replaceQuery(match.group(7), template);
        }
        if (match.group(9) != null) {
            this.fragment(match.group(9), template);
        }
        return this;
    }

    public KeycloakUriBuilder uri(String uri) throws IllegalArgumentException {
        return this.uri(uri, true);
    }

    public KeycloakUriBuilder uri(String uri, boolean template) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("uri parameter is null");
        }
        Matcher opaque = opaqueUri.matcher(uri);
        if (opaque.matches()) {
            this.authority = null;
            this.host = null;
            this.port = -1;
            this.userInfo = null;
            this.query = null;
            this.scheme = opaque.group(1);
            this.ssp = opaque.group(2);
            return this;
        }
        Matcher match = hierarchicalUri.matcher(uri);
        if (match.matches()) {
            this.ssp = null;
            return this.parseHierarchicalUri(uri, match, template);
        }
        throw new IllegalArgumentException("Illegal uri template: " + uri);
    }

    public KeycloakUriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("URI was null");
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        if (uri.isOpaque()) {
            this.scheme = uri.getScheme();
            this.ssp = uri.getRawSchemeSpecificPart();
            return this;
        }
        if (uri.getScheme() == null) {
            if (this.ssp != null && uri.getRawSchemeSpecificPart() != null) {
                this.ssp = uri.getRawSchemeSpecificPart();
                return this;
            }
        } else {
            this.scheme = uri.getScheme();
        }
        this.ssp = null;
        if (uri.getRawAuthority() != null) {
            if (uri.getRawUserInfo() == null && uri.getHost() == null && uri.getPort() == -1) {
                this.authority = uri.getRawAuthority();
                this.userInfo = null;
                this.host = null;
                this.port = -1;
            } else {
                this.authority = null;
                if (uri.getRawUserInfo() != null) {
                    this.userInfo = uri.getRawUserInfo();
                }
                if (uri.getHost() != null) {
                    this.host = uri.getHost();
                }
                if (uri.getPort() != -1) {
                    this.port = uri.getPort();
                }
            }
        }
        if (uri.getRawPath() != null && uri.getRawPath().length() > 0) {
            this.path = uri.getRawPath();
        }
        if (uri.getRawQuery() != null && uri.getRawQuery().length() > 0) {
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public KeycloakUriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = scheme;
        return this;
    }

    public KeycloakUriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("schemeSpecificPart was null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (ssp != null) {
            sb.append(ssp);
        }
        if (this.fragment != null && this.fragment.length() > 0) {
            sb.append('#').append(this.fragment);
        }
        if ((uri = URI.create(sb.toString())).getRawSchemeSpecificPart() != null && uri.getRawPath() == null) {
            this.ssp = uri.getRawSchemeSpecificPart();
        } else {
            this.ssp = null;
            this.userInfo = uri.getRawUserInfo();
            this.host = uri.getHost();
            this.port = uri.getPort();
            this.path = uri.getRawPath();
            this.query = uri.getRawQuery();
        }
        return this;
    }

    public KeycloakUriBuilder userInfo(String ui) {
        this.userInfo = ui;
        return this;
    }

    public KeycloakUriBuilder host(String host) throws IllegalArgumentException {
        if (host != null && host.equals("")) {
            throw new IllegalArgumentException("invalid host");
        }
        this.host = host;
        return this;
    }

    public KeycloakUriBuilder port(int port) throws IllegalArgumentException {
        if (port < -1) {
            throw new IllegalArgumentException("Invalid port value");
        }
        this.port = port;
        return this;
    }

    public KeycloakUriBuilder preserveDefaultPort() {
        this.preserveDefaultPort = true;
        return this;
    }

    protected static String paths(boolean encode, String basePath, String ... segments) {
        String path = basePath;
        if (path == null) {
            path = "";
        }
        for (String segment : segments) {
            if ("".equals(segment)) continue;
            if (path.endsWith("/")) {
                if (segment.startsWith("/") && "".equals(segment = segment.substring(1))) continue;
                if (encode) {
                    segment = Encode.encodePath(segment);
                }
                path = path + segment;
                continue;
            }
            if (encode) {
                segment = Encode.encodePath(segment);
            }
            path = "".equals(path) ? segment : (segment.startsWith("/") ? path + segment : path + "/" + segment);
        }
        return path;
    }

    public KeycloakUriBuilder path(String segment) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("path was null");
        }
        this.path = KeycloakUriBuilder.paths(true, this.path, segment);
        return this;
    }

    public KeycloakUriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        if (matrix == null) {
            matrix = "";
        }
        if (!matrix.startsWith(";")) {
            matrix = ";" + matrix;
        }
        matrix = Encode.encodePath(matrix);
        if (this.path == null) {
            this.path = matrix;
        } else {
            int matrixIndex;
            int start = this.path.lastIndexOf(47);
            if (start < 0) {
                start = 0;
            }
            this.path = (matrixIndex = this.path.indexOf(59, start)) > -1 ? this.path.substring(0, matrixIndex) + matrix : this.path + matrix;
        }
        return this;
    }

    public KeycloakUriBuilder replaceQuery(String query) throws IllegalArgumentException {
        return this.replaceQuery(query, true);
    }

    public KeycloakUriBuilder replaceQuery(String query, boolean template) throws IllegalArgumentException {
        if (query == null || query.length() == 0) {
            this.query = null;
            return this;
        }
        this.query = template ? Encode.encodeQueryString(query) : Encode.encodeQueryStringNotTemplateParameters(query);
        return this;
    }

    public KeycloakUriBuilder fragment(String fragment) throws IllegalArgumentException {
        return this.fragment(fragment, true);
    }

    public KeycloakUriBuilder fragment(String fragment, boolean template) throws IllegalArgumentException {
        if (fragment == null) {
            this.fragment = null;
            return this;
        }
        this.fragment = template ? Encode.encodeFragment(fragment) : Encode.encodeFragmentNotTemplateParameters(fragment);
        return this;
    }

    public KeycloakUriBuilder encodedFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public KeycloakUriBuilder substitutePathParam(String name, Object value, boolean isEncoded) {
        if (this.path != null) {
            StringBuffer buffer = new StringBuffer();
            this.replacePathParameter(name, value.toString(), isEncoded, this.path, buffer, false);
            this.path = buffer.toString();
        }
        return this;
    }

    public URI buildFromMap(Map<String, ?> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildUriFromMap(values, false, true);
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildUriFromMap(values, true, false);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildUriFromMap(values, false, encodeSlashInPath);
    }

    protected URI buildUriFromMap(Map<String, ?> paramMap, boolean fromEncodedMap, boolean encodeSlash) throws IllegalArgumentException {
        String buf = this.buildString(paramMap, fromEncodedMap, false, encodeSlash);
        try {
            return URI.create(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI: " + buf, e);
        }
    }

    private String buildString(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, boolean encodeSlash) {
        for (Map.Entry<String, ?> entry : paramMap.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("map key is null");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("map value is null");
        }
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.scheme, buffer, encodeSlash).append(":");
        }
        if (this.ssp != null) {
            buffer.append(this.ssp);
        } else if (this.userInfo != null || this.host != null || this.port != -1) {
            buffer.append("//");
            if (this.userInfo != null) {
                this.replaceUserInfoParameter(paramMap, fromEncodedMap, isTemplate, this.userInfo, buffer).append("@");
            }
            if (this.host != null) {
                if ("".equals(this.host)) {
                    throw new RuntimeException("empty host name");
                }
                this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.host, buffer, encodeSlash);
            }
            if (!(this.port == -1 || !this.preserveDefaultPort && ("http".equals(this.scheme) && this.port == 80 || "https".equals(this.scheme) && this.port == 443))) {
                buffer.append(":").append(Integer.toString(this.port));
            }
        } else if (this.authority != null) {
            buffer.append("//");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.authority, buffer, encodeSlash);
        }
        if (this.path != null) {
            StringBuffer tmp = new StringBuffer();
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.path, tmp, encodeSlash);
            String tmpPath = tmp.toString();
            if (!(this.userInfo == null && this.host == null || tmpPath.startsWith("/"))) {
                buffer.append("/");
            }
            buffer.append(tmpPath);
        }
        if (this.query != null) {
            buffer.append("?");
            this.replaceQueryStringParameter(paramMap, fromEncodedMap, isTemplate, this.query, buffer);
        }
        if (this.fragment != null) {
            buffer.append("#");
            this.replaceParameter(paramMap, fromEncodedMap, isTemplate, this.fragment, buffer, encodeSlash);
        }
        return buffer.toString();
    }

    protected StringBuffer replacePathParameter(String name, String value, boolean isEncoded, String string, StringBuffer buffer, boolean encodeSlash) {
        Matcher matcher = KeycloakUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            if (!param.equals(name)) continue;
            value = !isEncoded ? (encodeSlash ? Encode.encodePath(value) : Encode.encodePathSegment(value)) : Encode.encodeNonCodes(value);
            value = value.replace("$", "\\$");
            matcher.appendReplacement(buffer, value);
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public static Matcher createUriParamMatcher(String string) {
        return PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
    }

    protected StringBuffer replaceParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer, boolean encodeSlash) {
        Matcher matcher = KeycloakUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? (encodeSlash ? Encode.encodePathSegmentAsIs(value) : Encode.encodePathAsIs(value)) : (encodeSlash ? Encode.encodePathSegmentSaveEncodings(value) : Encode.encodePathSaveEncodings(value));
                matcher.appendReplacement(buffer, Matcher.quoteReplacement(value));
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected StringBuffer replaceQueryStringParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer) {
        Matcher matcher = KeycloakUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodeQueryParamAsIs(value) : Encode.encodeQueryParamSaveEncodings(value);
                matcher.appendReplacement(buffer, value);
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected StringBuffer replaceUserInfoParameter(Map<String, ?> paramMap, boolean fromEncodedMap, boolean isTemplate, String string, StringBuffer buffer) {
        Matcher matcher = KeycloakUriBuilder.createUriParamMatcher(string);
        while (matcher.find()) {
            String param = matcher.group(1);
            Object valObj = paramMap.get(param);
            if (valObj == null && !isTemplate) {
                throw new IllegalArgumentException("NULL value for template parameter: " + param);
            }
            if (valObj == null && isTemplate) {
                matcher.appendReplacement(buffer, matcher.group());
                continue;
            }
            String value = valObj.toString();
            if (value != null) {
                value = !fromEncodedMap ? Encode.encodeUserInfoAsIs(value) : Encode.encodeUserInfoSaveEncodings(value);
                matcher.appendReplacement(buffer, value);
                continue;
            }
            throw new IllegalArgumentException("path param " + param + " has not been provided by the parameter map");
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    public List<String> getPathParamNamesInDeclarationOrder() {
        ArrayList<String> params = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        if (this.scheme != null) {
            this.addToPathParamList(params, set, this.scheme);
        }
        if (this.userInfo != null) {
            this.addToPathParamList(params, set, this.userInfo);
        }
        if (this.host != null) {
            this.addToPathParamList(params, set, this.host);
        }
        if (this.path != null) {
            this.addToPathParamList(params, set, this.path);
        }
        if (this.query != null) {
            this.addToPathParamList(params, set, this.query);
        }
        if (this.fragment != null) {
            this.addToPathParamList(params, set, this.fragment);
        }
        return params;
    }

    private void addToPathParamList(List<String> params, HashSet<String> set, String string) {
        Matcher matcher = PathHelper.URI_PARAM_PATTERN.matcher(PathHelper.replaceEnclosedCurlyBraces(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            if (set.contains(param)) continue;
            set.add(param);
            params.add(param);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildFromValues(true, false, values);
    }

    public String buildAsString(Object ... values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        return this.buildFromValuesAsString(true, false, values);
    }

    protected URI buildFromValues(boolean encodeSlash, boolean encoded, Object ... values) {
        String buf = this.buildFromValuesAsString(encodeSlash, encoded, values);
        try {
            return new URI(buf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create URI: " + buf, e);
        }
    }

    protected String buildFromValuesAsString(boolean encodeSlash, boolean encoded, Object ... values) {
        List<String> params = this.getPathParamNamesInDeclarationOrder();
        if (values.length < params.size()) {
            throw new IllegalArgumentException("You did not supply enough values to fill path parameters");
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (int i = 0; i < params.size(); ++i) {
            String pathParam = params.get(i);
            Object val = values[i];
            if (val == null) {
                throw new IllegalArgumentException("A value was null");
            }
            pathParams.put(pathParam, val.toString());
        }
        return this.buildString(pathParams, encoded, false, encodeSlash);
    }

    public KeycloakUriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        if (this.path == null) {
            this.path = "";
        }
        for (Object val : values) {
            if (val == null) {
                throw new IllegalArgumentException("null value");
            }
            this.path = this.path + ";" + Encode.encodeMatrixParam(name) + "=" + Encode.encodeMatrixParam(val.toString());
        }
        return this;
    }

    public KeycloakUriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values parameter is null");
        }
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException("A passed in value was null");
            }
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + Encode.encodeQueryParamAsIs(name) + "=" + Encode.encodeQueryParamAsIs(value.toString());
        }
        return this;
    }

    public KeycloakUriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name parameter is null");
        }
        if (this.query == null || this.query.equals("")) {
            if (values != null) {
                return this.queryParam(name, values);
            }
            return this;
        }
        String[] params = this.query.split("&");
        this.query = null;
        String replacedName = Encode.encodeQueryParam(name);
        for (String param : params) {
            String paramName;
            int pos = param.indexOf(61);
            if (pos < 0 ? param.equals(replacedName) : (paramName = param.substring(0, pos)).equals(replacedName)) continue;
            this.query = this.query == null ? "" : this.query + "&";
            this.query = this.query + param;
        }
        if (values == null) {
            return this;
        }
        return this.queryParam(name, values);
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public KeycloakUriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("segments parameter was null");
        }
        for (String segment : segments) {
            if (segment == null) {
                throw new IllegalArgumentException("A segment is null");
            }
            this.path(Encode.encodePathSegment(segment));
        }
        return this;
    }

    public KeycloakUriBuilder replacePath(String path) {
        return this.replacePath(path, true);
    }

    public KeycloakUriBuilder replacePath(String path, boolean template) {
        if (path == null) {
            this.path = null;
            return this;
        }
        this.path = template ? Encode.encodePath(path) : Encode.encodePathSaveEncodings(path);
        return this;
    }

    public KeycloakUriBuilder replaceUserInfo(String userInfo, boolean template) {
        if (userInfo == null) {
            this.userInfo = null;
            return this;
        }
        this.userInfo = template ? Encode.encodeUserInfo(userInfo) : Encode.encodeUserInfoNotTemplateParameters(userInfo);
        return this;
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values param is null");
        }
        return this.buildFromValues(encodeSlashInPath, false, values);
    }

    public String toTemplate() {
        return this.buildString(new HashMap(), true, true, true);
    }

    public KeycloakUriBuilder resolveTemplate(String name, Object value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name param is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value param is null");
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put(name, value);
        return this.resolveTemplates(vals);
    }

    public KeycloakUriBuilder resolveTemplates(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("templateValues param null");
        }
        String str = this.buildString(templateValues, false, true, true);
        return KeycloakUriBuilder.fromTemplate(str);
    }

    public KeycloakUriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name param is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value param is null");
        }
        HashMap<String, Object> vals = new HashMap<String, Object>();
        vals.put(name, value);
        String str = this.buildString(vals, false, true, encodeSlashInPath);
        return KeycloakUriBuilder.fromTemplate(str);
    }

    public KeycloakUriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("templateValues param null");
        }
        String str = this.buildString(templateValues, false, true, encodeSlashInPath);
        return KeycloakUriBuilder.fromTemplate(str);
    }

    public KeycloakUriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws IllegalArgumentException {
        if (templateValues == null) {
            throw new IllegalArgumentException("templateValues param null");
        }
        String str = this.buildString(templateValues, true, true, true);
        return KeycloakUriBuilder.fromTemplate(str);
    }
}

