/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class ContextualExecutorService
implements ExecutorService {
    private final boolean managed;
    private final AtomicBoolean shutdown;
    private volatile ExecutorService delegate;

    ContextualExecutorService(ExecutorService delegate, boolean managed) {
        this.delegate = delegate;
        this.managed = managed;
        this.shutdown = new AtomicBoolean(false);
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.isManaged()) {
                this.delegate = null;
            } else {
                ExecutorService delegate = this.getDelegate();
                ContextualExecutorService.shutdownDelegate(() -> {
                    delegate.shutdown();
                    return null;
                });
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.shutdown.compareAndSet(false, true)) {
            if (this.isManaged()) {
                this.delegate = null;
            } else {
                ExecutorService delegate = this.getDelegate();
                return ContextualExecutorService.shutdownDelegate(delegate::shutdownNow);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        if (this.isManaged()) {
            return this.shutdown.get();
        }
        return this.getDelegate().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        if (this.isManaged()) {
            return false;
        }
        return this.getDelegate().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.isManaged()) {
            return false;
        }
        return this.getDelegate().awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getDelegate().submit(ContextualExecutors.callable(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getDelegate().submit(ContextualExecutors.runnable(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getDelegate().submit(ContextualExecutors.runnable(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getDelegate().invokeAll(ContextualExecutors.callable(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDelegate().invokeAll(ContextualExecutors.callable(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getDelegate().invokeAny(ContextualExecutors.callable(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getDelegate().invokeAny(ContextualExecutors.callable(tasks), timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.getDelegate().execute(ContextualExecutors.runnable(command));
    }

    public boolean isManaged() {
        return this.managed;
    }

    ExecutorService getDelegate() {
        ExecutorService delegate = this.delegate;
        if (delegate == null) {
            throw Messages.MESSAGES.executorShutdown();
        }
        return delegate;
    }

    private static <T> T shutdownDelegate(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }
}

