/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import jakarta.servlet.ServletException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponse;

public class ServletRequestBindingException
extends ServletException
implements ErrorResponse {
    private final ProblemDetail body = ProblemDetail.forStatus(this.getStatusCode());
    private final String messageDetailCode;
    @Nullable
    private final Object[] messageDetailArguments;

    public ServletRequestBindingException(String msg) {
        this(msg, null, null);
    }

    public ServletRequestBindingException(String msg, Throwable cause) {
        this(msg, cause, null, null);
    }

    protected ServletRequestBindingException(String msg, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        this(msg, null, messageDetailCode, messageDetailArguments);
    }

    protected ServletRequestBindingException(String msg, @Nullable Throwable cause, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(msg, cause);
        this.messageDetailCode = this.initMessageDetailCode(messageDetailCode);
        this.messageDetailArguments = messageDetailArguments;
    }

    private String initMessageDetailCode(@Nullable String messageDetailCode) {
        return messageDetailCode != null ? messageDetailCode : ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.BAD_REQUEST;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public String getDetailMessageCode() {
        return this.messageDetailCode;
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return this.messageDetailArguments;
    }
}

