/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

class DerParser {
    static final int UNIVERSAL = 0;
    static final int APPLICATION = 64;
    static final int CONTEXT = 128;
    static final int PRIVATE = 192;
    static final int CONSTRUCTED = 32;
    static final int ANY = 0;
    static final int BOOLEAN = 1;
    static final int INTEGER = 2;
    static final int BIT_STRING = 3;
    static final int OCTET_STRING = 4;
    static final int NULL = 5;
    static final int OID = 6;
    static final int REAL = 9;
    static final int ENUMERATED = 10;
    static final int SEQUENCE = 16;
    static final int SET = 17;
    static final int NUMERIC_STRING = 18;
    static final int PRINTABLE_STRING = 19;
    static final int VIDEOTEX_STRING = 21;
    static final int IA5_STRING = 22;
    static final int GRAPHIC_STRING = 25;
    static final int ISO646_STRING = 26;
    static final int GENERAL_STRING = 27;
    static final int TAGGED = 128;
    static final int UTF8_STRING = 12;
    static final int UNIVERSAL_STRING = 28;
    static final int BMP_STRING = 30;
    static final int UTC_TIME = 23;
    protected InputStream in;

    DerParser(InputStream in) {
        this.in = in;
    }

    DerParser(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public Asn1Object read() throws IOException {
        byte[] value;
        int n;
        int tag = this.in.read();
        if (tag == -1) {
            throw new IllegalStateException("Invalid DER: stream too short, missing tag");
        }
        int tagNo = DerParser.readTagNumber(this.in, tag);
        int length = this.getLength();
        if (tag == 3) {
            int padBits = this.in.read();
            --length;
        }
        if ((n = this.in.read(value = new byte[length])) < length) {
            throw new IllegalStateException("Invalid DER: stream too short, missing value");
        }
        return new Asn1Object(tag, tagNo, length, value);
    }

    static int readTagNumber(InputStream s, int tag) throws IOException {
        int tagNo = tag & 0x1F;
        if (tagNo == 31) {
            tagNo = 0;
            int b = s.read();
            if ((b & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (b >= 0 && (b & 0x80) != 0) {
                tagNo |= b & 0x7F;
                tagNo <<= 7;
                b = s.read();
            }
            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 0x7F;
        }
        return tagNo;
    }

    private int getLength() throws IOException {
        int i = this.in.read();
        if (i == -1) {
            throw new IllegalStateException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > 4) {
            throw new IllegalStateException("Invalid DER: length field too big (" + i + ")");
        }
        byte[] bytes = new byte[num];
        int n = this.in.read(bytes);
        if (n < num) {
            throw new IllegalStateException("Invalid DER: length too short");
        }
        return new BigInteger(1, bytes).intValue();
    }

    public boolean hasLength() throws IOException {
        return this.in.available() > 0;
    }

    static class Asn1Object {
        private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
        private final int type;
        private final int tag;
        private final int tagNo;
        private final int length;
        private final byte[] value;

        Asn1Object(int tag, int tagNo, int length, byte[] value) {
            this.tag = tag;
            this.tagNo = tagNo;
            this.type = tag & 0x1F;
            this.length = length;
            this.value = value;
        }

        int getTagNo() {
            return this.tagNo;
        }

        boolean isTagged() {
            return (this.tag & 0x80) != 0;
        }

        int getType() {
            return this.type;
        }

        int getLength() {
            return this.length;
        }

        byte[] getValue() {
            return this.value;
        }

        boolean isConstructed() {
            return (this.tag & 0x20) == 32;
        }

        DerParser createNestedParser() {
            if (!this.isConstructed()) {
                throw new IllegalStateException("Invalid DER: can't parse primitive entity");
            }
            return new DerParser(this.value);
        }

        BigInteger getInteger() {
            if (this.type != 2) {
                throw new IllegalStateException(String.format("Invalid DER: object (%d) is not integer.", this.type));
            }
            return new BigInteger(this.value);
        }

        String getString() throws IOException {
            String encoding;
            switch (this.type) {
                case 18: 
                case 19: 
                case 21: 
                case 22: 
                case 25: 
                case 26: 
                case 27: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 30: {
                    encoding = "UTF-16BE";
                    break;
                }
                case 12: {
                    encoding = "UTF-8";
                    break;
                }
                case 28: {
                    throw new IllegalStateException("Invalid DER: can't handle UCS-4 string");
                }
                case 6: {
                    return Asn1Object.getObjectIdentifier(this.value);
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid DER: object (%d) is not a string", this.type));
                }
            }
            return new String(this.value, encoding);
        }

        private static String getObjectIdentifier(byte[] bytes) {
            StringBuffer objId = new StringBuffer();
            long value = 0L;
            BigInteger bigValue = null;
            boolean first = true;
            for (int i = 0; i != bytes.length; ++i) {
                int b = bytes[i] & 0xFF;
                if (value <= 0xFFFFFFFFFFFF80L) {
                    value += (long)(b & 0x7F);
                    if ((b & 0x80) == 0) {
                        if (first) {
                            if (value < 40L) {
                                objId.append('0');
                            } else if (value < 80L) {
                                objId.append('1');
                                value -= 40L;
                            } else {
                                objId.append('2');
                                value -= 80L;
                            }
                            first = false;
                        }
                        objId.append('.');
                        objId.append(value);
                        value = 0L;
                        continue;
                    }
                    value <<= 7;
                    continue;
                }
                if (bigValue == null) {
                    bigValue = BigInteger.valueOf(value);
                }
                bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
                if ((b & 0x80) == 0) {
                    if (first) {
                        objId.append('2');
                        bigValue = bigValue.subtract(BigInteger.valueOf(80L));
                        first = false;
                    }
                    objId.append('.');
                    objId.append(bigValue);
                    bigValue = null;
                    value = 0L;
                    continue;
                }
                bigValue = bigValue.shiftLeft(7);
            }
            return objId.toString();
        }
    }
}

