/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.cloud.vault.config.KeyValueSecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.vault.core.util.PropertyTransformer;
import org.springframework.vault.core.util.PropertyTransformers;

public class VaultConfigLocation
extends ConfigDataResource {
    public static final String VAULT_PREFIX = "vault:";
    private final SecretBackendMetadata secretBackendMetadata;
    private final boolean optional;

    public VaultConfigLocation(String contextPath, boolean optional) {
        this(contextPath, PropertyTransformers.noop(), optional);
    }

    public VaultConfigLocation(String contextPath, PropertyTransformer propertyTransformer, boolean optional) {
        super(optional);
        Assert.hasText((String)contextPath, (String)"Location must not be empty");
        VaultConfigLocation.validatePath(contextPath);
        this.secretBackendMetadata = KeyValueSecretBackendMetadata.create(contextPath, propertyTransformer);
        this.optional = optional;
    }

    public VaultConfigLocation(SecretBackendMetadata secretBackendMetadata, boolean optional) {
        Assert.notNull((Object)secretBackendMetadata, (String)"SecretBackendMetadata must not be null");
        VaultConfigLocation.validatePath(secretBackendMetadata.getPath());
        this.secretBackendMetadata = secretBackendMetadata;
        this.optional = optional;
    }

    public SecretBackendMetadata getSecretBackendMetadata() {
        return this.secretBackendMetadata;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VaultConfigLocation)) {
            return false;
        }
        VaultConfigLocation that = (VaultConfigLocation)((Object)o);
        if (this.optional != that.optional) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.secretBackendMetadata.getName(), (Object)that.secretBackendMetadata.getName()) && ObjectUtils.nullSafeEquals((Object)this.secretBackendMetadata.getPath(), (Object)that.secretBackendMetadata.getPath());
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.secretBackendMetadata.getName());
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.secretBackendMetadata.getPath());
        result = 31 * result + (this.optional ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(" [path='").append(this.secretBackendMetadata.getPath()).append('\'');
        sb.append(", optional=").append(this.optional);
        sb.append(']');
        return sb.toString();
    }

    private static void validatePath(String contextPath) {
        Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, () -> String.format("Location 'vault://%s' must not end with a trailing slash", contextPath));
    }
}

