/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.ssl;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.ssl.JksSslBundleProperties;
import org.springframework.boot.autoconfigure.ssl.PemSslBundleProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.ssl")
public class SslProperties {
    private final Bundles bundle = new Bundles();

    public Bundles getBundle() {
        return this.bundle;
    }

    public static class Bundles {
        private final Map<String, PemSslBundleProperties> pem = new LinkedHashMap<String, PemSslBundleProperties>();
        private final Map<String, JksSslBundleProperties> jks = new LinkedHashMap<String, JksSslBundleProperties>();
        private final Watch watch = new Watch();

        public Map<String, PemSslBundleProperties> getPem() {
            return this.pem;
        }

        public Map<String, JksSslBundleProperties> getJks() {
            return this.jks;
        }

        public Watch getWatch() {
            return this.watch;
        }

        public static class Watch {
            private final File file = new File();

            public File getFile() {
                return this.file;
            }

            public static class File {
                private Duration quietPeriod = Duration.ofSeconds(10L);

                public Duration getQuietPeriod() {
                    return this.quietPeriod;
                }

                public void setQuietPeriod(Duration quietPeriod) {
                    this.quietPeriod = quietPeriod;
                }
            }
        }
    }
}

