/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.web.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.spring.web.config.ShiroFilterChainDefinition;
import org.apache.shiro.web.config.ShiroFilterConfiguration;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class AbstractShiroWebFilterConfiguration {
    @Autowired
    protected SecurityManager securityManager;
    @Autowired
    protected ShiroFilterChainDefinition shiroFilterChainDefinition;
    @Autowired(required=false)
    protected ShiroFilterConfiguration shiroFilterConfiguration;
    @Autowired(required=false)
    protected Map<String, Filter> filterMap;
    @Value(value="#{ @environment['shiro.loginUrl'] ?: '/login.jsp' }")
    protected String loginUrl;
    @Value(value="#{ @environment['shiro.successUrl'] ?: '/' }")
    protected String successUrl;
    @Value(value="#{ @environment['shiro.unauthorizedUrl'] ?: null }")
    protected String unauthorizedUrl;
    @Value(value="#{ @environment['shiro.caseInsensitive'] ?: false }")
    protected boolean caseInsensitive;

    protected List<String> globalFilters() {
        return Collections.singletonList(DefaultFilter.invalidRequest.name());
    }

    protected ShiroFilterConfiguration shiroFilterConfiguration() {
        return this.shiroFilterConfiguration != null ? this.shiroFilterConfiguration : new ShiroFilterConfiguration();
    }

    protected ShiroFilterFactoryBean shiroFilterFactoryBean() {
        ShiroFilterFactoryBean filterFactoryBean = new ShiroFilterFactoryBean();
        filterFactoryBean.setLoginUrl(this.loginUrl);
        filterFactoryBean.setSuccessUrl(this.successUrl);
        filterFactoryBean.setUnauthorizedUrl(this.unauthorizedUrl);
        filterFactoryBean.setCaseInsensitive(this.caseInsensitive);
        filterFactoryBean.setSecurityManager(this.securityManager);
        filterFactoryBean.setShiroFilterConfiguration(this.shiroFilterConfiguration());
        filterFactoryBean.setGlobalFilters(this.globalFilters());
        filterFactoryBean.setFilterChainDefinitionMap(this.shiroFilterChainDefinition.getFilterChainMap());
        if (this.filterMap != null) {
            filterFactoryBean.setFilters(this.filterMap);
        }
        return filterFactoryBean;
    }
}

