/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.processor;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.RestClientResponseValidator;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.http.RestUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.Jsoner;

public class DefaultRestClientResponseValidator
implements RestClientResponseValidator {
    public RestClientResponseValidator.ValidationError validate(Exchange exchange, RestClientResponseValidator.ValidationContext validationContext) {
        String json;
        String contentType = ExchangeHelper.getContentType(exchange);
        if (contentType != null && validationContext.responseCode() != null) {
            String code = (String)exchange.getMessage().getHeader("CamelHttpResponseCode", (Object)"200", String.class);
            String found = null;
            for (Map.Entry e : validationContext.responseCode().entrySet()) {
                String k = (String)e.getKey();
                if (!code.equals(k)) continue;
                found = (String)e.getValue();
            }
            if (found == null) {
                found = (String)validationContext.responseCode().get("default");
            }
            if (found != null && !RestUtil.isValidOrAcceptedContentType(found, contentType)) {
                return new RestClientResponseValidator.ValidationError(500, "Invalid content-type: " + contentType + " for response code: " + code);
            }
        }
        if (validationContext.responseHeaders() != null && !exchange.getMessage().getHeaders().keySet().containsAll(validationContext.responseHeaders())) {
            return new RestClientResponseValidator.ValidationError(500, "Some of the response HTTP headers are missing.");
        }
        Object body = exchange.getMessage().getBody();
        if (body != null && contentType != null && RestUtil.isValidOrAcceptedContentType("application/json", contentType) && !ObjectHelper.isEmpty((String)(json = MessageHelper.extractBodyAsString(exchange.getIn())))) {
            try {
                Jsoner.deserialize((String)json);
            }
            catch (DeserializationException e) {
                return new RestClientResponseValidator.ValidationError(500, "Invalid response JSon payload.");
            }
        }
        return null;
    }
}

