/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.activemq.util.ByteSequence;

public class AMQPRawInboundTransformer
extends InboundTransformer {
    @Override
    public String getTransformerName() {
        return "raw";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return null;
    }

    @Override
    protected ActiveMQMessage doTransform(EncodedMessage amqpMessage) throws Exception {
        ActiveMQBytesMessage result = new ActiveMQBytesMessage();
        result.setContent(new ByteSequence(amqpMessage.getArray(), amqpMessage.getArrayOffset(), amqpMessage.getLength()));
        result.setPersistent(true);
        result.setPriority((byte)4);
        long now = System.currentTimeMillis();
        result.setTimestamp(now);
        if (amqpMessage.getMessageFormat() != 0L) {
            result.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        }
        result.setBooleanProperty("JMS_AMQP_NATIVE", true);
        return result;
    }
}

