/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.17.0)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.accumulo.core.tabletserver.thrift;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
public class TabletClientService {

  public interface Iface {

    public long startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.UpdateErrors closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws NoSuchScanIDException, org.apache.thrift.TException;

    public boolean cancelUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws org.apache.thrift.TException;

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.TConditionalSession startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols) throws NoSuchScanIDException, org.apache.thrift.TException;

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException;

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException;

    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void loadFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException;

    public void loadFilesV2(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException;

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException;

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException;

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException;

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.master.thrift.TabletServerStatus getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public java.util.List<TabletStats> getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public TabletStats getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.thrift.TException;

    public java.util.List<ActiveCompaction> getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames) throws org.apache.thrift.TException;

    public java.util.List<java.lang.String> getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException, org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummariesForPartition(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummariesFromFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries contiuneGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId) throws NoSuchScanIDException, org.apache.thrift.TException;

    public java.util.List<TCompactionQueueSummary> getCompactionQueueInfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public TExternalCompactionJob reserveCompactionJob(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException;

    public void compactionJobFinished(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries) throws org.apache.thrift.TException;

    public void compactionJobFailed(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException;

    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> resultHandler) throws org.apache.thrift.TException;

    public void cancelUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> resultHandler) throws org.apache.thrift.TException;

    public void conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> resultHandler) throws org.apache.thrift.TException;

    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> resultHandler) throws org.apache.thrift.TException;

    public void loadFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void loadFilesV2(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> resultHandler) throws org.apache.thrift.TException;

    public void getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>> resultHandler) throws org.apache.thrift.TException;

    public void getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<TabletStats> resultHandler) throws org.apache.thrift.TException;

    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>> resultHandler) throws org.apache.thrift.TException;

    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException;

    public void startGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException;

    public void startGetSummariesForPartition(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException;

    public void startGetSummariesFromFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException;

    public void contiuneGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException;

    public void getCompactionQueueInfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>> resultHandler) throws org.apache.thrift.TException;

    public void reserveCompactionJob(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId, org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob> resultHandler) throws org.apache.thrift.TException;

    public void compactionJobFinished(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void compactionJobFailed(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      @Override
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      @Override
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    @Override
    public long startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startUpdate(tinfo, credentials, durability);
      return recv_startUpdate();
    }

    public void send_startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability) throws org.apache.thrift.TException
    {
      startUpdate_args args = new startUpdate_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setDurability(durability);
      sendBase("startUpdate", args);
    }

    public long recv_startUpdate() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startUpdate_result result = new startUpdate_result();
      receiveBase(result, "startUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startUpdate failed: unknown result");
    }

    @Override
    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations) throws org.apache.thrift.TException
    {
      send_applyUpdates(tinfo, updateID, keyExtent, mutations);
    }

    public void send_applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations) throws org.apache.thrift.TException
    {
      applyUpdates_args args = new applyUpdates_args();
      args.setTinfo(tinfo);
      args.setUpdateID(updateID);
      args.setKeyExtent(keyExtent);
      args.setMutations(mutations);
      sendBaseOneway("applyUpdates", args);
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.UpdateErrors closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_closeUpdate(tinfo, updateID);
      return recv_closeUpdate();
    }

    public void send_closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws org.apache.thrift.TException
    {
      closeUpdate_args args = new closeUpdate_args();
      args.setTinfo(tinfo);
      args.setUpdateID(updateID);
      sendBase("closeUpdate", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.UpdateErrors recv_closeUpdate() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      closeUpdate_result result = new closeUpdate_result();
      receiveBase(result, "closeUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "closeUpdate failed: unknown result");
    }

    @Override
    public boolean cancelUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws org.apache.thrift.TException
    {
      send_cancelUpdate(tinfo, updateID);
      return recv_cancelUpdate();
    }

    public void send_cancelUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID) throws org.apache.thrift.TException
    {
      cancelUpdate_args args = new cancelUpdate_args();
      args.setTinfo(tinfo);
      args.setUpdateID(updateID);
      sendBase("cancelUpdate", args);
    }

    public boolean recv_cancelUpdate() throws org.apache.thrift.TException
    {
      cancelUpdate_result result = new cancelUpdate_result();
      receiveBase(result, "cancelUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "cancelUpdate failed: unknown result");
    }

    @Override
    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException
    {
      send_update(tinfo, credentials, keyExtent, mutation, durability);
      recv_update();
    }

    public void send_update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability) throws org.apache.thrift.TException
    {
      update_args args = new update_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setKeyExtent(keyExtent);
      args.setMutation(mutation);
      args.setDurability(durability);
      sendBase("update", args);
    }

    public void recv_update() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException
    {
      update_result result = new update_result();
      receiveBase(result, "update");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      if (result.cve != null) {
        throw result.cve;
      }
      return;
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.TConditionalSession startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startConditionalUpdate(tinfo, credentials, authorizations, tableID, durability, classLoaderContext);
      return recv_startConditionalUpdate();
    }

    public void send_startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext) throws org.apache.thrift.TException
    {
      startConditionalUpdate_args args = new startConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setAuthorizations(authorizations);
      args.setTableID(tableID);
      args.setDurability(durability);
      args.setClassLoaderContext(classLoaderContext);
      sendBase("startConditionalUpdate", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.TConditionalSession recv_startConditionalUpdate() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startConditionalUpdate_result result = new startConditionalUpdate_result();
      receiveBase(result, "startConditionalUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startConditionalUpdate failed: unknown result");
    }

    @Override
    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_conditionalUpdate(tinfo, sessID, mutations, symbols);
      return recv_conditionalUpdate();
    }

    public void send_conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols) throws org.apache.thrift.TException
    {
      conditionalUpdate_args args = new conditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      args.setMutations(mutations);
      args.setSymbols(symbols);
      sendBase("conditionalUpdate", args);
    }

    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> recv_conditionalUpdate() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      conditionalUpdate_result result = new conditionalUpdate_result();
      receiveBase(result, "conditionalUpdate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "conditionalUpdate failed: unknown result");
    }

    @Override
    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      send_invalidateConditionalUpdate(tinfo, sessID);
      recv_invalidateConditionalUpdate();
    }

    public void send_invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      invalidateConditionalUpdate_args args = new invalidateConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      sendBase("invalidateConditionalUpdate", args);
    }

    public void recv_invalidateConditionalUpdate() throws org.apache.thrift.TException
    {
      invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
      receiveBase(result, "invalidateConditionalUpdate");
      return;
    }

    @Override
    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      send_closeConditionalUpdate(tinfo, sessID);
    }

    public void send_closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID) throws org.apache.thrift.TException
    {
      closeConditionalUpdate_args args = new closeConditionalUpdate_args();
      args.setTinfo(tinfo);
      args.setSessID(sessID);
      sendBaseOneway("closeConditionalUpdate", args);
    }

    @Override
    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_bulkImport(tinfo, credentials, tid, files, setTime);
      return recv_bulkImport();
    }

    public void send_bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      bulkImport_args args = new bulkImport_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTid(tid);
      args.setFiles(files);
      args.setSetTime(setTime);
      sendBase("bulkImport", args);
    }

    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> recv_bulkImport() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      bulkImport_result result = new bulkImport_result();
      receiveBase(result, "bulkImport");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "bulkImport failed: unknown result");
    }

    @Override
    public void loadFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      send_loadFiles(tinfo, credentials, tid, dir, files, setTime);
    }

    public void send_loadFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      loadFiles_args args = new loadFiles_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTid(tid);
      args.setDir(dir);
      args.setFiles(files);
      args.setSetTime(setTime);
      sendBaseOneway("loadFiles", args);
    }

    @Override
    public void loadFilesV2(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      send_loadFilesV2(tinfo, credentials, tid, dir, files, setTime);
      recv_loadFilesV2();
    }

    public void send_loadFilesV2(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime) throws org.apache.thrift.TException
    {
      loadFilesV2_args args = new loadFilesV2_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTid(tid);
      args.setDir(dir);
      args.setFiles(files);
      args.setSetTime(setTime);
      sendBase("loadFilesV2", args);
    }

    public void recv_loadFilesV2() throws org.apache.thrift.TException
    {
      loadFilesV2_result result = new loadFilesV2_result();
      receiveBase(result, "loadFilesV2");
      return;
    }

    @Override
    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException
    {
      send_splitTablet(tinfo, credentials, extent, splitPoint);
      recv_splitTablet();
    }

    public void send_splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint) throws org.apache.thrift.TException
    {
      splitTablet_args args = new splitTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setExtent(extent);
      args.setSplitPoint(splitPoint);
      sendBase("splitTablet", args);
    }

    public void recv_splitTablet() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException
    {
      splitTablet_result result = new splitTablet_result();
      receiveBase(result, "splitTablet");
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.nste != null) {
        throw result.nste;
      }
      return;
    }

    @Override
    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_loadTablet(tinfo, credentials, lock, extent);
    }

    public void send_loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      loadTablet_args args = new loadTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("loadTablet", args);
    }

    @Override
    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException
    {
      send_unloadTablet(tinfo, credentials, lock, extent, goal, requestTime);
    }

    public void send_unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime) throws org.apache.thrift.TException
    {
      unloadTablet_args args = new unloadTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      args.setGoal(goal);
      args.setRequestTime(requestTime);
      sendBaseOneway("unloadTablet", args);
    }

    @Override
    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException
    {
      send_flush(tinfo, credentials, lock, tableId, startRow, endRow);
    }

    public void send_flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException
    {
      flush_args args = new flush_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setTableId(tableId);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBaseOneway("flush", args);
    }

    @Override
    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_flushTablet(tinfo, credentials, lock, extent);
    }

    public void send_flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      flushTablet_args args = new flushTablet_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("flushTablet", args);
    }

    @Override
    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_chop(tinfo, credentials, lock, extent);
    }

    public void send_chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      chop_args args = new chop_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setExtent(extent);
      sendBaseOneway("chop", args);
    }

    @Override
    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException
    {
      send_compact(tinfo, credentials, lock, tableId, startRow, endRow);
    }

    public void send_compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow) throws org.apache.thrift.TException
    {
      compact_args args = new compact_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      args.setTableId(tableId);
      args.setStartRow(startRow);
      args.setEndRow(endRow);
      sendBaseOneway("compact", args);
    }

    @Override
    public org.apache.accumulo.core.master.thrift.TabletServerStatus getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getTabletServerStatus(tinfo, credentials);
      return recv_getTabletServerStatus();
    }

    public void send_getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getTabletServerStatus_args args = new getTabletServerStatus_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getTabletServerStatus", args);
    }

    public org.apache.accumulo.core.master.thrift.TabletServerStatus recv_getTabletServerStatus() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getTabletServerStatus_result result = new getTabletServerStatus_result();
      receiveBase(result, "getTabletServerStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTabletServerStatus failed: unknown result");
    }

    @Override
    public java.util.List<TabletStats> getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getTabletStats(tinfo, credentials, tableId);
      return recv_getTabletStats();
    }

    public void send_getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId) throws org.apache.thrift.TException
    {
      getTabletStats_args args = new getTabletStats_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setTableId(tableId);
      sendBase("getTabletStats", args);
    }

    public java.util.List<TabletStats> recv_getTabletStats() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getTabletStats_result result = new getTabletStats_result();
      receiveBase(result, "getTabletStats");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTabletStats failed: unknown result");
    }

    @Override
    public TabletStats getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getHistoricalStats(tinfo, credentials);
      return recv_getHistoricalStats();
    }

    public void send_getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getHistoricalStats_args args = new getHistoricalStats_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getHistoricalStats", args);
    }

    public TabletStats recv_getHistoricalStats() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getHistoricalStats_result result = new getHistoricalStats_result();
      receiveBase(result, "getHistoricalStats");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getHistoricalStats failed: unknown result");
    }

    @Override
    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_halt(tinfo, credentials, lock);
      recv_halt();
    }

    public void send_halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.thrift.TException
    {
      halt_args args = new halt_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      sendBase("halt", args);
    }

    public void recv_halt() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      halt_result result = new halt_result();
      receiveBase(result, "halt");
      if (result.sec != null) {
        throw result.sec;
      }
      return;
    }

    @Override
    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.thrift.TException
    {
      send_fastHalt(tinfo, credentials, lock);
    }

    public void send_fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock) throws org.apache.thrift.TException
    {
      fastHalt_args args = new fastHalt_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setLock(lock);
      sendBaseOneway("fastHalt", args);
    }

    @Override
    public java.util.List<ActiveCompaction> getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getActiveCompactions(tinfo, credentials);
      return recv_getActiveCompactions();
    }

    public void send_getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getActiveCompactions_args args = new getActiveCompactions_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getActiveCompactions", args);
    }

    public java.util.List<ActiveCompaction> recv_getActiveCompactions() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getActiveCompactions_result result = new getActiveCompactions_result();
      receiveBase(result, "getActiveCompactions");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveCompactions failed: unknown result");
    }

    @Override
    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames) throws org.apache.thrift.TException
    {
      send_removeLogs(tinfo, credentials, filenames);
    }

    public void send_removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames) throws org.apache.thrift.TException
    {
      removeLogs_args args = new removeLogs_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setFilenames(filenames);
      sendBaseOneway("removeLogs", args);
    }

    @Override
    public java.util.List<java.lang.String> getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      send_getActiveLogs(tinfo, credentials);
      return recv_getActiveLogs();
    }

    public void send_getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getActiveLogs_args args = new getActiveLogs_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getActiveLogs", args);
    }

    public java.util.List<java.lang.String> recv_getActiveLogs() throws org.apache.thrift.TException
    {
      getActiveLogs_result result = new getActiveLogs_result();
      receiveBase(result, "getActiveLogs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getActiveLogs failed: unknown result");
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException, org.apache.thrift.TException
    {
      send_startGetSummaries(tinfo, credentials, request);
      return recv_startGetSummaries();
    }

    public void send_startGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request) throws org.apache.thrift.TException
    {
      startGetSummaries_args args = new startGetSummaries_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setRequest(request);
      sendBase("startGetSummaries", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries recv_startGetSummaries() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException, org.apache.thrift.TException
    {
      startGetSummaries_result result = new startGetSummaries_result();
      receiveBase(result, "startGetSummaries");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      if (result.tope != null) {
        throw result.tope;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startGetSummaries failed: unknown result");
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummariesForPartition(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startGetSummariesForPartition(tinfo, credentials, request, modulus, remainder);
      return recv_startGetSummariesForPartition();
    }

    public void send_startGetSummariesForPartition(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder) throws org.apache.thrift.TException
    {
      startGetSummariesForPartition_args args = new startGetSummariesForPartition_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setRequest(request);
      args.setModulus(modulus);
      args.setRemainder(remainder);
      sendBase("startGetSummariesForPartition", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries recv_startGetSummariesForPartition() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startGetSummariesForPartition_result result = new startGetSummariesForPartition_result();
      receiveBase(result, "startGetSummariesForPartition");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startGetSummariesForPartition failed: unknown result");
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.TSummaries startGetSummariesFromFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_startGetSummariesFromFiles(tinfo, credentials, request, files);
      return recv_startGetSummariesFromFiles();
    }

    public void send_startGetSummariesFromFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files) throws org.apache.thrift.TException
    {
      startGetSummariesFromFiles_args args = new startGetSummariesFromFiles_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setRequest(request);
      args.setFiles(files);
      sendBase("startGetSummariesFromFiles", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries recv_startGetSummariesFromFiles() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      startGetSummariesFromFiles_result result = new startGetSummariesFromFiles_result();
      receiveBase(result, "startGetSummariesFromFiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "startGetSummariesFromFiles failed: unknown result");
    }

    @Override
    public org.apache.accumulo.core.dataImpl.thrift.TSummaries contiuneGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId) throws NoSuchScanIDException, org.apache.thrift.TException
    {
      send_contiuneGetSummaries(tinfo, sessionId);
      return recv_contiuneGetSummaries();
    }

    public void send_contiuneGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId) throws org.apache.thrift.TException
    {
      contiuneGetSummaries_args args = new contiuneGetSummaries_args();
      args.setTinfo(tinfo);
      args.setSessionId(sessionId);
      sendBase("contiuneGetSummaries", args);
    }

    public org.apache.accumulo.core.dataImpl.thrift.TSummaries recv_contiuneGetSummaries() throws NoSuchScanIDException, org.apache.thrift.TException
    {
      contiuneGetSummaries_result result = new contiuneGetSummaries_result();
      receiveBase(result, "contiuneGetSummaries");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.nssi != null) {
        throw result.nssi;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "contiuneGetSummaries failed: unknown result");
    }

    @Override
    public java.util.List<TCompactionQueueSummary> getCompactionQueueInfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_getCompactionQueueInfo(tinfo, credentials);
      return recv_getCompactionQueueInfo();
    }

    public void send_getCompactionQueueInfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) throws org.apache.thrift.TException
    {
      getCompactionQueueInfo_args args = new getCompactionQueueInfo_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      sendBase("getCompactionQueueInfo", args);
    }

    public java.util.List<TCompactionQueueSummary> recv_getCompactionQueueInfo() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      getCompactionQueueInfo_result result = new getCompactionQueueInfo_result();
      receiveBase(result, "getCompactionQueueInfo");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getCompactionQueueInfo failed: unknown result");
    }

    @Override
    public TExternalCompactionJob reserveCompactionJob(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId) throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      send_reserveCompactionJob(tinfo, credentials, queueName, priority, compactor, externalCompactionId);
      return recv_reserveCompactionJob();
    }

    public void send_reserveCompactionJob(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId) throws org.apache.thrift.TException
    {
      reserveCompactionJob_args args = new reserveCompactionJob_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setQueueName(queueName);
      args.setPriority(priority);
      args.setCompactor(compactor);
      args.setExternalCompactionId(externalCompactionId);
      sendBase("reserveCompactionJob", args);
    }

    public TExternalCompactionJob recv_reserveCompactionJob() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException
    {
      reserveCompactionJob_result result = new reserveCompactionJob_result();
      receiveBase(result, "reserveCompactionJob");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.sec != null) {
        throw result.sec;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "reserveCompactionJob failed: unknown result");
    }

    @Override
    public void compactionJobFinished(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries) throws org.apache.thrift.TException
    {
      send_compactionJobFinished(tinfo, credentials, externalCompactionId, extent, fileSize, entries);
    }

    public void send_compactionJobFinished(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries) throws org.apache.thrift.TException
    {
      compactionJobFinished_args args = new compactionJobFinished_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setExternalCompactionId(externalCompactionId);
      args.setExtent(extent);
      args.setFileSize(fileSize);
      args.setEntries(entries);
      sendBaseOneway("compactionJobFinished", args);
    }

    @Override
    public void compactionJobFailed(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      send_compactionJobFailed(tinfo, credentials, externalCompactionId, extent);
    }

    public void send_compactionJobFailed(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) throws org.apache.thrift.TException
    {
      compactionJobFailed_args args = new compactionJobFailed_args();
      args.setTinfo(tinfo);
      args.setCredentials(credentials);
      args.setExternalCompactionId(externalCompactionId);
      args.setExtent(extent);
      sendBaseOneway("compactionJobFailed", args);
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
    @Override
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    @Override
    public void startUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startUpdate_call method_call = new startUpdate_call(tinfo, credentials, durability, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Long> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private TDurability durability;
      public startUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.durability = durability;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startUpdate_args args = new startUpdate_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setDurability(durability);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.lang.Long getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startUpdate();
      }
    }

    @Override
    public void applyUpdates(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      applyUpdates_call method_call = new applyUpdates_call(tinfo, updateID, keyExtent, mutations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class applyUpdates_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long updateID;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent;
      private java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations;
      public applyUpdates_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.updateID = updateID;
        this.keyExtent = keyExtent;
        this.mutations = mutations;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("applyUpdates", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        applyUpdates_args args = new applyUpdates_args();
        args.setTinfo(tinfo);
        args.setUpdateID(updateID);
        args.setKeyExtent(keyExtent);
        args.setMutations(mutations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void closeUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeUpdate_call method_call = new closeUpdate_call(tinfo, updateID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long updateID;
      public closeUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.updateID = updateID;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeUpdate_args args = new closeUpdate_args();
        args.setTinfo(tinfo);
        args.setUpdateID(updateID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.UpdateErrors getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_closeUpdate();
      }
    }

    @Override
    public void cancelUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cancelUpdate_call method_call = new cancelUpdate_call(tinfo, updateID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cancelUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long updateID;
      public cancelUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long updateID, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.updateID = updateID;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cancelUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cancelUpdate_args args = new cancelUpdate_args();
        args.setTinfo(tinfo);
        args.setUpdateID(updateID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.lang.Boolean getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_cancelUpdate();
      }
    }

    @Override
    public void update(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      update_call method_call = new update_call(tinfo, credentials, keyExtent, mutation, durability, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class update_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent;
      private org.apache.accumulo.core.dataImpl.thrift.TMutation mutation;
      private TDurability durability;
      public update_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent, org.apache.accumulo.core.dataImpl.thrift.TMutation mutation, TDurability durability, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.keyExtent = keyExtent;
        this.mutation = mutation;
        this.durability = durability;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("update", org.apache.thrift.protocol.TMessageType.CALL, 0));
        update_args args = new update_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setKeyExtent(keyExtent);
        args.setMutation(mutation);
        args.setDurability(durability);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, ConstraintViolationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_update();
        return null;
      }
    }

    @Override
    public void startConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startConditionalUpdate_call method_call = new startConditionalUpdate_call(tinfo, credentials, authorizations, tableID, durability, classLoaderContext, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.util.List<java.nio.ByteBuffer> authorizations;
      private java.lang.String tableID;
      private TDurability durability;
      private java.lang.String classLoaderContext;
      public startConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.nio.ByteBuffer> authorizations, java.lang.String tableID, TDurability durability, java.lang.String classLoaderContext, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.authorizations = authorizations;
        this.tableID = tableID;
        this.durability = durability;
        this.classLoaderContext = classLoaderContext;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startConditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startConditionalUpdate_args args = new startConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setAuthorizations(authorizations);
        args.setTableID(tableID);
        args.setDurability(durability);
        args.setClassLoaderContext(classLoaderContext);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.TConditionalSession getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startConditionalUpdate();
      }
    }

    @Override
    public void conditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      conditionalUpdate_call method_call = new conditionalUpdate_call(tinfo, sessID, mutations, symbols, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class conditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      private java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations;
      private java.util.List<java.lang.String> symbols;
      public conditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations, java.util.List<java.lang.String> symbols, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.sessID = sessID;
        this.mutations = mutations;
        this.symbols = symbols;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("conditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        conditionalUpdate_args args = new conditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.setMutations(mutations);
        args.setSymbols(symbols);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_conditionalUpdate();
      }
    }

    @Override
    public void invalidateConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      invalidateConditionalUpdate_call method_call = new invalidateConditionalUpdate_call(tinfo, sessID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class invalidateConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      public invalidateConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.sessID = sessID;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("invalidateConditionalUpdate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        invalidateConditionalUpdate_args args = new invalidateConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_invalidateConditionalUpdate();
        return null;
      }
    }

    @Override
    public void closeConditionalUpdate(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeConditionalUpdate_call method_call = new closeConditionalUpdate_call(tinfo, sessID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeConditionalUpdate_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessID;
      public closeConditionalUpdate_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessID, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.sessID = sessID;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeConditionalUpdate", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        closeConditionalUpdate_args args = new closeConditionalUpdate_args();
        args.setTinfo(tinfo);
        args.setSessID(sessID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void bulkImport(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      bulkImport_call method_call = new bulkImport_call(tinfo, credentials, tid, files, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class bulkImport_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private long tid;
      private java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files;
      private boolean setTime;
      public bulkImport_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tid = tid;
        this.files = files;
        this.setTime = setTime;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("bulkImport", org.apache.thrift.protocol.TMessageType.CALL, 0));
        bulkImport_args args = new bulkImport_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTid(tid);
        args.setFiles(files);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_bulkImport();
      }
    }

    @Override
    public void loadFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      loadFiles_call method_call = new loadFiles_call(tinfo, credentials, tid, dir, files, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class loadFiles_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private long tid;
      private java.lang.String dir;
      private java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files;
      private boolean setTime;
      public loadFiles_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tid = tid;
        this.dir = dir;
        this.files = files;
        this.setTime = setTime;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("loadFiles", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        loadFiles_args args = new loadFiles_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTid(tid);
        args.setDir(dir);
        args.setFiles(files);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void loadFilesV2(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      loadFilesV2_call method_call = new loadFilesV2_call(tinfo, credentials, tid, dir, files, setTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class loadFilesV2_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private long tid;
      private java.lang.String dir;
      private java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files;
      private boolean setTime;
      public loadFilesV2_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, long tid, java.lang.String dir, java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files, boolean setTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tid = tid;
        this.dir = dir;
        this.files = files;
        this.setTime = setTime;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("loadFilesV2", org.apache.thrift.protocol.TMessageType.CALL, 0));
        loadFilesV2_args args = new loadFilesV2_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTid(tid);
        args.setDir(dir);
        args.setFiles(files);
        args.setSetTime(setTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_loadFilesV2();
        return null;
      }
    }

    @Override
    public void splitTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      splitTablet_call method_call = new splitTablet_call(tinfo, credentials, extent, splitPoint, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class splitTablet_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      private java.nio.ByteBuffer splitPoint;
      public splitTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, java.nio.ByteBuffer splitPoint, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.extent = extent;
        this.splitPoint = splitPoint;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("splitTablet", org.apache.thrift.protocol.TMessageType.CALL, 0));
        splitTablet_args args = new splitTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setExtent(extent);
        args.setSplitPoint(splitPoint);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, NotServingTabletException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_splitTablet();
        return null;
      }
    }

    @Override
    public void loadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      loadTablet_call method_call = new loadTablet_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class loadTablet_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      public loadTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("loadTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        loadTablet_args args = new loadTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void unloadTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      unloadTablet_call method_call = new unloadTablet_call(tinfo, credentials, lock, extent, goal, requestTime, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class unloadTablet_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      private TUnloadTabletGoal goal;
      private long requestTime;
      public unloadTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, TUnloadTabletGoal goal, long requestTime, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
        this.goal = goal;
        this.requestTime = requestTime;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("unloadTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        unloadTablet_args args = new unloadTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.setGoal(goal);
        args.setRequestTime(requestTime);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void flush(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flush_call method_call = new flush_call(tinfo, credentials, lock, tableId, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flush_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private java.lang.String tableId;
      private java.nio.ByteBuffer startRow;
      private java.nio.ByteBuffer endRow;
      public flush_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.tableId = tableId;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flush", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        flush_args args = new flush_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setTableId(tableId);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void flushTablet(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      flushTablet_call method_call = new flushTablet_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class flushTablet_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      public flushTablet_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("flushTablet", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        flushTablet_args args = new flushTablet_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void chop(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      chop_call method_call = new chop_call(tinfo, credentials, lock, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class chop_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      public chop_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.extent = extent;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("chop", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        chop_args args = new chop_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void compact(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compact_call method_call = new compact_call(tinfo, credentials, lock, tableId, startRow, endRow, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compact_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      private java.lang.String tableId;
      private java.nio.ByteBuffer startRow;
      private java.nio.ByteBuffer endRow;
      public compact_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, java.lang.String tableId, java.nio.ByteBuffer startRow, java.nio.ByteBuffer endRow, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
        this.tableId = tableId;
        this.startRow = startRow;
        this.endRow = endRow;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compact", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        compact_args args = new compact_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.setTableId(tableId);
        args.setStartRow(startRow);
        args.setEndRow(endRow);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void getTabletServerStatus(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTabletServerStatus_call method_call = new getTabletServerStatus_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTabletServerStatus_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.master.thrift.TabletServerStatus> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      public getTabletServerStatus_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTabletServerStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTabletServerStatus_args args = new getTabletServerStatus_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.master.thrift.TabletServerStatus getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTabletServerStatus();
      }
    }

    @Override
    public void getTabletStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTabletStats_call method_call = new getTabletStats_call(tinfo, credentials, tableId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTabletStats_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TabletStats>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String tableId;
      public getTabletStats_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String tableId, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.tableId = tableId;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTabletStats", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTabletStats_args args = new getTabletStats_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setTableId(tableId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<TabletStats> getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTabletStats();
      }
    }

    @Override
    public void getHistoricalStats(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<TabletStats> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getHistoricalStats_call method_call = new getHistoricalStats_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getHistoricalStats_call extends org.apache.thrift.async.TAsyncMethodCall<TabletStats> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      public getHistoricalStats_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<TabletStats> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getHistoricalStats", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getHistoricalStats_args args = new getHistoricalStats_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public TabletStats getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getHistoricalStats();
      }
    }

    @Override
    public void halt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      halt_call method_call = new halt_call(tinfo, credentials, lock, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class halt_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      public halt_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("halt", org.apache.thrift.protocol.TMessageType.CALL, 0));
        halt_args args = new halt_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_halt();
        return null;
      }
    }

    @Override
    public void fastHalt(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      fastHalt_call method_call = new fastHalt_call(tinfo, credentials, lock, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class fastHalt_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String lock;
      public fastHalt_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String lock, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.lock = lock;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("fastHalt", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        fastHalt_args args = new fastHalt_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setLock(lock);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void getActiveCompactions(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveCompactions_call method_call = new getActiveCompactions_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveCompactions_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<ActiveCompaction>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      public getActiveCompactions_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveCompactions", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveCompactions_args args = new getActiveCompactions_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<ActiveCompaction> getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveCompactions();
      }
    }

    @Override
    public void removeLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      removeLogs_call method_call = new removeLogs_call(tinfo, credentials, filenames, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class removeLogs_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.util.List<java.lang.String> filenames;
      public removeLogs_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.util.List<java.lang.String> filenames, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.filenames = filenames;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("removeLogs", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        removeLogs_args args = new removeLogs_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setFilenames(filenames);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void getActiveLogs(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getActiveLogs_call method_call = new getActiveLogs_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getActiveLogs_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<java.lang.String>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      public getActiveLogs_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getActiveLogs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getActiveLogs_args args = new getActiveLogs_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<java.lang.String> getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getActiveLogs();
      }
    }

    @Override
    public void startGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startGetSummaries_call method_call = new startGetSummaries_call(tinfo, credentials, request, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startGetSummaries_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request;
      public startGetSummaries_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.request = request;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startGetSummaries", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startGetSummaries_args args = new startGetSummaries_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setRequest(request);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.TSummaries getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startGetSummaries();
      }
    }

    @Override
    public void startGetSummariesForPartition(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startGetSummariesForPartition_call method_call = new startGetSummariesForPartition_call(tinfo, credentials, request, modulus, remainder, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startGetSummariesForPartition_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request;
      private int modulus;
      private int remainder;
      public startGetSummariesForPartition_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, int modulus, int remainder, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.request = request;
        this.modulus = modulus;
        this.remainder = remainder;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startGetSummariesForPartition", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startGetSummariesForPartition_args args = new startGetSummariesForPartition_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setRequest(request);
        args.setModulus(modulus);
        args.setRemainder(remainder);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.TSummaries getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startGetSummariesForPartition();
      }
    }

    @Override
    public void startGetSummariesFromFiles(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      startGetSummariesFromFiles_call method_call = new startGetSummariesFromFiles_call(tinfo, credentials, request, files, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class startGetSummariesFromFiles_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request;
      private java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files;
      public startGetSummariesFromFiles_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.accumulo.core.dataImpl.thrift.TSummaryRequest request, java.util.Map<java.lang.String,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TRowRange>> files, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.request = request;
        this.files = files;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("startGetSummariesFromFiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        startGetSummariesFromFiles_args args = new startGetSummariesFromFiles_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setRequest(request);
        args.setFiles(files);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.TSummaries getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_startGetSummariesFromFiles();
      }
    }

    @Override
    public void contiuneGetSummaries(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      contiuneGetSummaries_call method_call = new contiuneGetSummaries_call(tinfo, sessionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class contiuneGetSummaries_call extends org.apache.thrift.async.TAsyncMethodCall<org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private long sessionId;
      public contiuneGetSummaries_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, long sessionId, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.sessionId = sessionId;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("contiuneGetSummaries", org.apache.thrift.protocol.TMessageType.CALL, 0));
        contiuneGetSummaries_args args = new contiuneGetSummaries_args();
        args.setTinfo(tinfo);
        args.setSessionId(sessionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public org.apache.accumulo.core.dataImpl.thrift.TSummaries getResult() throws NoSuchScanIDException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_contiuneGetSummaries();
      }
    }

    @Override
    public void getCompactionQueueInfo(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getCompactionQueueInfo_call method_call = new getCompactionQueueInfo_call(tinfo, credentials, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getCompactionQueueInfo_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TCompactionQueueSummary>> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      public getCompactionQueueInfo_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getCompactionQueueInfo", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getCompactionQueueInfo_args args = new getCompactionQueueInfo_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public java.util.List<TCompactionQueueSummary> getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getCompactionQueueInfo();
      }
    }

    @Override
    public void reserveCompactionJob(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId, org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      reserveCompactionJob_call method_call = new reserveCompactionJob_call(tinfo, credentials, queueName, priority, compactor, externalCompactionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class reserveCompactionJob_call extends org.apache.thrift.async.TAsyncMethodCall<TExternalCompactionJob> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String queueName;
      private long priority;
      private java.lang.String compactor;
      private java.lang.String externalCompactionId;
      public reserveCompactionJob_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String queueName, long priority, java.lang.String compactor, java.lang.String externalCompactionId, org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.queueName = queueName;
        this.priority = priority;
        this.compactor = compactor;
        this.externalCompactionId = externalCompactionId;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("reserveCompactionJob", org.apache.thrift.protocol.TMessageType.CALL, 0));
        reserveCompactionJob_args args = new reserveCompactionJob_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setQueueName(queueName);
        args.setPriority(priority);
        args.setCompactor(compactor);
        args.setExternalCompactionId(externalCompactionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public TExternalCompactionJob getResult() throws org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_reserveCompactionJob();
      }
    }

    @Override
    public void compactionJobFinished(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compactionJobFinished_call method_call = new compactionJobFinished_call(tinfo, credentials, externalCompactionId, extent, fileSize, entries, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compactionJobFinished_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String externalCompactionId;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      private long fileSize;
      private long entries;
      public compactionJobFinished_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, long fileSize, long entries, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.externalCompactionId = externalCompactionId;
        this.extent = extent;
        this.fileSize = fileSize;
        this.entries = entries;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compactionJobFinished", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        compactionJobFinished_args args = new compactionJobFinished_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setExternalCompactionId(externalCompactionId);
        args.setExtent(extent);
        args.setFileSize(fileSize);
        args.setEntries(entries);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    @Override
    public void compactionJobFailed(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      compactionJobFailed_call method_call = new compactionJobFailed_call(tinfo, credentials, externalCompactionId, extent, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class compactionJobFailed_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private org.apache.accumulo.core.trace.thrift.TInfo tinfo;
      private org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials;
      private java.lang.String externalCompactionId;
      private org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent;
      public compactionJobFailed_call(org.apache.accumulo.core.trace.thrift.TInfo tinfo, org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials, java.lang.String externalCompactionId, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, true);
        this.tinfo = tinfo;
        this.credentials = credentials;
        this.externalCompactionId = externalCompactionId;
        this.extent = extent;
      }

      @Override
      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("compactionJobFailed", org.apache.thrift.protocol.TMessageType.ONEWAY, 0));
        compactionJobFailed_args args = new compactionJobFailed_args();
        args.setTinfo(tinfo);
        args.setCredentials(credentials);
        args.setExternalCompactionId(externalCompactionId);
        args.setExtent(extent);
        args.write(prot);
        prot.writeMessageEnd();
      }

      @Override
      public Void getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> java.util.Map<java.lang.String,  org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> getProcessMap(java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("startUpdate", new startUpdate());
      processMap.put("applyUpdates", new applyUpdates());
      processMap.put("closeUpdate", new closeUpdate());
      processMap.put("cancelUpdate", new cancelUpdate());
      processMap.put("update", new update());
      processMap.put("startConditionalUpdate", new startConditionalUpdate());
      processMap.put("conditionalUpdate", new conditionalUpdate());
      processMap.put("invalidateConditionalUpdate", new invalidateConditionalUpdate());
      processMap.put("closeConditionalUpdate", new closeConditionalUpdate());
      processMap.put("bulkImport", new bulkImport());
      processMap.put("loadFiles", new loadFiles());
      processMap.put("loadFilesV2", new loadFilesV2());
      processMap.put("splitTablet", new splitTablet());
      processMap.put("loadTablet", new loadTablet());
      processMap.put("unloadTablet", new unloadTablet());
      processMap.put("flush", new flush());
      processMap.put("flushTablet", new flushTablet());
      processMap.put("chop", new chop());
      processMap.put("compact", new compact());
      processMap.put("getTabletServerStatus", new getTabletServerStatus());
      processMap.put("getTabletStats", new getTabletStats());
      processMap.put("getHistoricalStats", new getHistoricalStats());
      processMap.put("halt", new halt());
      processMap.put("fastHalt", new fastHalt());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("removeLogs", new removeLogs());
      processMap.put("getActiveLogs", new getActiveLogs());
      processMap.put("startGetSummaries", new startGetSummaries());
      processMap.put("startGetSummariesForPartition", new startGetSummariesForPartition());
      processMap.put("startGetSummariesFromFiles", new startGetSummariesFromFiles());
      processMap.put("contiuneGetSummaries", new contiuneGetSummaries());
      processMap.put("getCompactionQueueInfo", new getCompactionQueueInfo());
      processMap.put("reserveCompactionJob", new reserveCompactionJob());
      processMap.put("compactionJobFinished", new compactionJobFinished());
      processMap.put("compactionJobFailed", new compactionJobFailed());
      return processMap;
    }

    public static class startUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startUpdate_args> {
      public startUpdate() {
        super("startUpdate");
      }

      @Override
      public startUpdate_args getEmptyArgsInstance() {
        return new startUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public startUpdate_result getResult(I iface, startUpdate_args args) throws org.apache.thrift.TException {
        startUpdate_result result = new startUpdate_result();
        try {
          result.success = iface.startUpdate(args.tinfo, args.credentials, args.durability);
          result.setSuccessIsSet(true);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class applyUpdates<I extends Iface> extends org.apache.thrift.ProcessFunction<I, applyUpdates_args> {
      public applyUpdates() {
        super("applyUpdates");
      }

      @Override
      public applyUpdates_args getEmptyArgsInstance() {
        return new applyUpdates_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, applyUpdates_args args) throws org.apache.thrift.TException {
        iface.applyUpdates(args.tinfo, args.updateID, args.keyExtent, args.mutations);
        return null;
      }
    }

    public static class closeUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeUpdate_args> {
      public closeUpdate() {
        super("closeUpdate");
      }

      @Override
      public closeUpdate_args getEmptyArgsInstance() {
        return new closeUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public closeUpdate_result getResult(I iface, closeUpdate_args args) throws org.apache.thrift.TException {
        closeUpdate_result result = new closeUpdate_result();
        try {
          result.success = iface.closeUpdate(args.tinfo, args.updateID);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class cancelUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, cancelUpdate_args> {
      public cancelUpdate() {
        super("cancelUpdate");
      }

      @Override
      public cancelUpdate_args getEmptyArgsInstance() {
        return new cancelUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public cancelUpdate_result getResult(I iface, cancelUpdate_args args) throws org.apache.thrift.TException {
        cancelUpdate_result result = new cancelUpdate_result();
        result.success = iface.cancelUpdate(args.tinfo, args.updateID);
        result.setSuccessIsSet(true);
        return result;
      }
    }

    public static class update<I extends Iface> extends org.apache.thrift.ProcessFunction<I, update_args> {
      public update() {
        super("update");
      }

      @Override
      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public update_result getResult(I iface, update_args args) throws org.apache.thrift.TException {
        update_result result = new update_result();
        try {
          iface.update(args.tinfo, args.credentials, args.keyExtent, args.mutation, args.durability);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        } catch (ConstraintViolationException cve) {
          result.cve = cve;
        }
        return result;
      }
    }

    public static class startConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startConditionalUpdate_args> {
      public startConditionalUpdate() {
        super("startConditionalUpdate");
      }

      @Override
      public startConditionalUpdate_args getEmptyArgsInstance() {
        return new startConditionalUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public startConditionalUpdate_result getResult(I iface, startConditionalUpdate_args args) throws org.apache.thrift.TException {
        startConditionalUpdate_result result = new startConditionalUpdate_result();
        try {
          result.success = iface.startConditionalUpdate(args.tinfo, args.credentials, args.authorizations, args.tableID, args.durability, args.classLoaderContext);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class conditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, conditionalUpdate_args> {
      public conditionalUpdate() {
        super("conditionalUpdate");
      }

      @Override
      public conditionalUpdate_args getEmptyArgsInstance() {
        return new conditionalUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public conditionalUpdate_result getResult(I iface, conditionalUpdate_args args) throws org.apache.thrift.TException {
        conditionalUpdate_result result = new conditionalUpdate_result();
        try {
          result.success = iface.conditionalUpdate(args.tinfo, args.sessID, args.mutations, args.symbols);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class invalidateConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, invalidateConditionalUpdate_args> {
      public invalidateConditionalUpdate() {
        super("invalidateConditionalUpdate");
      }

      @Override
      public invalidateConditionalUpdate_args getEmptyArgsInstance() {
        return new invalidateConditionalUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public invalidateConditionalUpdate_result getResult(I iface, invalidateConditionalUpdate_args args) throws org.apache.thrift.TException {
        invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
        iface.invalidateConditionalUpdate(args.tinfo, args.sessID);
        return result;
      }
    }

    public static class closeConditionalUpdate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeConditionalUpdate_args> {
      public closeConditionalUpdate() {
        super("closeConditionalUpdate");
      }

      @Override
      public closeConditionalUpdate_args getEmptyArgsInstance() {
        return new closeConditionalUpdate_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, closeConditionalUpdate_args args) throws org.apache.thrift.TException {
        iface.closeConditionalUpdate(args.tinfo, args.sessID);
        return null;
      }
    }

    public static class bulkImport<I extends Iface> extends org.apache.thrift.ProcessFunction<I, bulkImport_args> {
      public bulkImport() {
        super("bulkImport");
      }

      @Override
      public bulkImport_args getEmptyArgsInstance() {
        return new bulkImport_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public bulkImport_result getResult(I iface, bulkImport_args args) throws org.apache.thrift.TException {
        bulkImport_result result = new bulkImport_result();
        try {
          result.success = iface.bulkImport(args.tinfo, args.credentials, args.tid, args.files, args.setTime);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class loadFiles<I extends Iface> extends org.apache.thrift.ProcessFunction<I, loadFiles_args> {
      public loadFiles() {
        super("loadFiles");
      }

      @Override
      public loadFiles_args getEmptyArgsInstance() {
        return new loadFiles_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, loadFiles_args args) throws org.apache.thrift.TException {
        iface.loadFiles(args.tinfo, args.credentials, args.tid, args.dir, args.files, args.setTime);
        return null;
      }
    }

    public static class loadFilesV2<I extends Iface> extends org.apache.thrift.ProcessFunction<I, loadFilesV2_args> {
      public loadFilesV2() {
        super("loadFilesV2");
      }

      @Override
      public loadFilesV2_args getEmptyArgsInstance() {
        return new loadFilesV2_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public loadFilesV2_result getResult(I iface, loadFilesV2_args args) throws org.apache.thrift.TException {
        loadFilesV2_result result = new loadFilesV2_result();
        iface.loadFilesV2(args.tinfo, args.credentials, args.tid, args.dir, args.files, args.setTime);
        return result;
      }
    }

    public static class splitTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, splitTablet_args> {
      public splitTablet() {
        super("splitTablet");
      }

      @Override
      public splitTablet_args getEmptyArgsInstance() {
        return new splitTablet_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public splitTablet_result getResult(I iface, splitTablet_args args) throws org.apache.thrift.TException {
        splitTablet_result result = new splitTablet_result();
        try {
          iface.splitTablet(args.tinfo, args.credentials, args.extent, args.splitPoint);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (NotServingTabletException nste) {
          result.nste = nste;
        }
        return result;
      }
    }

    public static class loadTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, loadTablet_args> {
      public loadTablet() {
        super("loadTablet");
      }

      @Override
      public loadTablet_args getEmptyArgsInstance() {
        return new loadTablet_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, loadTablet_args args) throws org.apache.thrift.TException {
        iface.loadTablet(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class unloadTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, unloadTablet_args> {
      public unloadTablet() {
        super("unloadTablet");
      }

      @Override
      public unloadTablet_args getEmptyArgsInstance() {
        return new unloadTablet_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, unloadTablet_args args) throws org.apache.thrift.TException {
        iface.unloadTablet(args.tinfo, args.credentials, args.lock, args.extent, args.goal, args.requestTime);
        return null;
      }
    }

    public static class flush<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flush_args> {
      public flush() {
        super("flush");
      }

      @Override
      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, flush_args args) throws org.apache.thrift.TException {
        iface.flush(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow);
        return null;
      }
    }

    public static class flushTablet<I extends Iface> extends org.apache.thrift.ProcessFunction<I, flushTablet_args> {
      public flushTablet() {
        super("flushTablet");
      }

      @Override
      public flushTablet_args getEmptyArgsInstance() {
        return new flushTablet_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, flushTablet_args args) throws org.apache.thrift.TException {
        iface.flushTablet(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class chop<I extends Iface> extends org.apache.thrift.ProcessFunction<I, chop_args> {
      public chop() {
        super("chop");
      }

      @Override
      public chop_args getEmptyArgsInstance() {
        return new chop_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, chop_args args) throws org.apache.thrift.TException {
        iface.chop(args.tinfo, args.credentials, args.lock, args.extent);
        return null;
      }
    }

    public static class compact<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compact_args> {
      public compact() {
        super("compact");
      }

      @Override
      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, compact_args args) throws org.apache.thrift.TException {
        iface.compact(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow);
        return null;
      }
    }

    public static class getTabletServerStatus<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTabletServerStatus_args> {
      public getTabletServerStatus() {
        super("getTabletServerStatus");
      }

      @Override
      public getTabletServerStatus_args getEmptyArgsInstance() {
        return new getTabletServerStatus_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getTabletServerStatus_result getResult(I iface, getTabletServerStatus_args args) throws org.apache.thrift.TException {
        getTabletServerStatus_result result = new getTabletServerStatus_result();
        try {
          result.success = iface.getTabletServerStatus(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getTabletStats<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTabletStats_args> {
      public getTabletStats() {
        super("getTabletStats");
      }

      @Override
      public getTabletStats_args getEmptyArgsInstance() {
        return new getTabletStats_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getTabletStats_result getResult(I iface, getTabletStats_args args) throws org.apache.thrift.TException {
        getTabletStats_result result = new getTabletStats_result();
        try {
          result.success = iface.getTabletStats(args.tinfo, args.credentials, args.tableId);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class getHistoricalStats<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getHistoricalStats_args> {
      public getHistoricalStats() {
        super("getHistoricalStats");
      }

      @Override
      public getHistoricalStats_args getEmptyArgsInstance() {
        return new getHistoricalStats_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getHistoricalStats_result getResult(I iface, getHistoricalStats_args args) throws org.apache.thrift.TException {
        getHistoricalStats_result result = new getHistoricalStats_result();
        try {
          result.success = iface.getHistoricalStats(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class halt<I extends Iface> extends org.apache.thrift.ProcessFunction<I, halt_args> {
      public halt() {
        super("halt");
      }

      @Override
      public halt_args getEmptyArgsInstance() {
        return new halt_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public halt_result getResult(I iface, halt_args args) throws org.apache.thrift.TException {
        halt_result result = new halt_result();
        try {
          iface.halt(args.tinfo, args.credentials, args.lock);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class fastHalt<I extends Iface> extends org.apache.thrift.ProcessFunction<I, fastHalt_args> {
      public fastHalt() {
        super("fastHalt");
      }

      @Override
      public fastHalt_args getEmptyArgsInstance() {
        return new fastHalt_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, fastHalt_args args) throws org.apache.thrift.TException {
        iface.fastHalt(args.tinfo, args.credentials, args.lock);
        return null;
      }
    }

    public static class getActiveCompactions<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveCompactions_args> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      @Override
      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getActiveCompactions_result getResult(I iface, getActiveCompactions_args args) throws org.apache.thrift.TException {
        getActiveCompactions_result result = new getActiveCompactions_result();
        try {
          result.success = iface.getActiveCompactions(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class removeLogs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, removeLogs_args> {
      public removeLogs() {
        super("removeLogs");
      }

      @Override
      public removeLogs_args getEmptyArgsInstance() {
        return new removeLogs_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, removeLogs_args args) throws org.apache.thrift.TException {
        iface.removeLogs(args.tinfo, args.credentials, args.filenames);
        return null;
      }
    }

    public static class getActiveLogs<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getActiveLogs_args> {
      public getActiveLogs() {
        super("getActiveLogs");
      }

      @Override
      public getActiveLogs_args getEmptyArgsInstance() {
        return new getActiveLogs_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getActiveLogs_result getResult(I iface, getActiveLogs_args args) throws org.apache.thrift.TException {
        getActiveLogs_result result = new getActiveLogs_result();
        result.success = iface.getActiveLogs(args.tinfo, args.credentials);
        return result;
      }
    }

    public static class startGetSummaries<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startGetSummaries_args> {
      public startGetSummaries() {
        super("startGetSummaries");
      }

      @Override
      public startGetSummaries_args getEmptyArgsInstance() {
        return new startGetSummaries_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public startGetSummaries_result getResult(I iface, startGetSummaries_args args) throws org.apache.thrift.TException {
        startGetSummaries_result result = new startGetSummaries_result();
        try {
          result.success = iface.startGetSummaries(args.tinfo, args.credentials, args.request);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException tope) {
          result.tope = tope;
        }
        return result;
      }
    }

    public static class startGetSummariesForPartition<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startGetSummariesForPartition_args> {
      public startGetSummariesForPartition() {
        super("startGetSummariesForPartition");
      }

      @Override
      public startGetSummariesForPartition_args getEmptyArgsInstance() {
        return new startGetSummariesForPartition_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public startGetSummariesForPartition_result getResult(I iface, startGetSummariesForPartition_args args) throws org.apache.thrift.TException {
        startGetSummariesForPartition_result result = new startGetSummariesForPartition_result();
        try {
          result.success = iface.startGetSummariesForPartition(args.tinfo, args.credentials, args.request, args.modulus, args.remainder);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class startGetSummariesFromFiles<I extends Iface> extends org.apache.thrift.ProcessFunction<I, startGetSummariesFromFiles_args> {
      public startGetSummariesFromFiles() {
        super("startGetSummariesFromFiles");
      }

      @Override
      public startGetSummariesFromFiles_args getEmptyArgsInstance() {
        return new startGetSummariesFromFiles_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public startGetSummariesFromFiles_result getResult(I iface, startGetSummariesFromFiles_args args) throws org.apache.thrift.TException {
        startGetSummariesFromFiles_result result = new startGetSummariesFromFiles_result();
        try {
          result.success = iface.startGetSummariesFromFiles(args.tinfo, args.credentials, args.request, args.files);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class contiuneGetSummaries<I extends Iface> extends org.apache.thrift.ProcessFunction<I, contiuneGetSummaries_args> {
      public contiuneGetSummaries() {
        super("contiuneGetSummaries");
      }

      @Override
      public contiuneGetSummaries_args getEmptyArgsInstance() {
        return new contiuneGetSummaries_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public contiuneGetSummaries_result getResult(I iface, contiuneGetSummaries_args args) throws org.apache.thrift.TException {
        contiuneGetSummaries_result result = new contiuneGetSummaries_result();
        try {
          result.success = iface.contiuneGetSummaries(args.tinfo, args.sessionId);
        } catch (NoSuchScanIDException nssi) {
          result.nssi = nssi;
        }
        return result;
      }
    }

    public static class getCompactionQueueInfo<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getCompactionQueueInfo_args> {
      public getCompactionQueueInfo() {
        super("getCompactionQueueInfo");
      }

      @Override
      public getCompactionQueueInfo_args getEmptyArgsInstance() {
        return new getCompactionQueueInfo_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public getCompactionQueueInfo_result getResult(I iface, getCompactionQueueInfo_args args) throws org.apache.thrift.TException {
        getCompactionQueueInfo_result result = new getCompactionQueueInfo_result();
        try {
          result.success = iface.getCompactionQueueInfo(args.tinfo, args.credentials);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class reserveCompactionJob<I extends Iface> extends org.apache.thrift.ProcessFunction<I, reserveCompactionJob_args> {
      public reserveCompactionJob() {
        super("reserveCompactionJob");
      }

      @Override
      public reserveCompactionJob_args getEmptyArgsInstance() {
        return new reserveCompactionJob_args();
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public reserveCompactionJob_result getResult(I iface, reserveCompactionJob_args args) throws org.apache.thrift.TException {
        reserveCompactionJob_result result = new reserveCompactionJob_result();
        try {
          result.success = iface.reserveCompactionJob(args.tinfo, args.credentials, args.queueName, args.priority, args.compactor, args.externalCompactionId);
        } catch (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
          result.sec = sec;
        }
        return result;
      }
    }

    public static class compactionJobFinished<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compactionJobFinished_args> {
      public compactionJobFinished() {
        super("compactionJobFinished");
      }

      @Override
      public compactionJobFinished_args getEmptyArgsInstance() {
        return new compactionJobFinished_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, compactionJobFinished_args args) throws org.apache.thrift.TException {
        iface.compactionJobFinished(args.tinfo, args.credentials, args.externalCompactionId, args.extent, args.fileSize, args.entries);
        return null;
      }
    }

    public static class compactionJobFailed<I extends Iface> extends org.apache.thrift.ProcessFunction<I, compactionJobFailed_args> {
      public compactionJobFailed() {
        super("compactionJobFailed");
      }

      @Override
      public compactionJobFailed_args getEmptyArgsInstance() {
        return new compactionJobFailed_args();
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      @Override
      public org.apache.thrift.TBase getResult(I iface, compactionJobFailed_args args) throws org.apache.thrift.TException {
        iface.compactionJobFailed(args.tinfo, args.credentials, args.externalCompactionId, args.extent);
        return null;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("startUpdate", new startUpdate());
      processMap.put("applyUpdates", new applyUpdates());
      processMap.put("closeUpdate", new closeUpdate());
      processMap.put("cancelUpdate", new cancelUpdate());
      processMap.put("update", new update());
      processMap.put("startConditionalUpdate", new startConditionalUpdate());
      processMap.put("conditionalUpdate", new conditionalUpdate());
      processMap.put("invalidateConditionalUpdate", new invalidateConditionalUpdate());
      processMap.put("closeConditionalUpdate", new closeConditionalUpdate());
      processMap.put("bulkImport", new bulkImport());
      processMap.put("loadFiles", new loadFiles());
      processMap.put("loadFilesV2", new loadFilesV2());
      processMap.put("splitTablet", new splitTablet());
      processMap.put("loadTablet", new loadTablet());
      processMap.put("unloadTablet", new unloadTablet());
      processMap.put("flush", new flush());
      processMap.put("flushTablet", new flushTablet());
      processMap.put("chop", new chop());
      processMap.put("compact", new compact());
      processMap.put("getTabletServerStatus", new getTabletServerStatus());
      processMap.put("getTabletStats", new getTabletStats());
      processMap.put("getHistoricalStats", new getHistoricalStats());
      processMap.put("halt", new halt());
      processMap.put("fastHalt", new fastHalt());
      processMap.put("getActiveCompactions", new getActiveCompactions());
      processMap.put("removeLogs", new removeLogs());
      processMap.put("getActiveLogs", new getActiveLogs());
      processMap.put("startGetSummaries", new startGetSummaries());
      processMap.put("startGetSummariesForPartition", new startGetSummariesForPartition());
      processMap.put("startGetSummariesFromFiles", new startGetSummariesFromFiles());
      processMap.put("contiuneGetSummaries", new contiuneGetSummaries());
      processMap.put("getCompactionQueueInfo", new getCompactionQueueInfo());
      processMap.put("reserveCompactionJob", new reserveCompactionJob());
      processMap.put("compactionJobFinished", new compactionJobFinished());
      processMap.put("compactionJobFailed", new compactionJobFailed());
      return processMap;
    }

    public static class startUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startUpdate_args, java.lang.Long> {
      public startUpdate() {
        super("startUpdate");
      }

      @Override
      public startUpdate_args getEmptyArgsInstance() {
        return new startUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Long>() { 
          @Override
          public void onComplete(java.lang.Long o) {
            startUpdate_result result = new startUpdate_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            startUpdate_result result = new startUpdate_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, startUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Long> resultHandler) throws org.apache.thrift.TException {
        iface.startUpdate(args.tinfo, args.credentials, args.durability,resultHandler);
      }
    }

    public static class applyUpdates<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, applyUpdates_args, Void> {
      public applyUpdates() {
        super("applyUpdates");
      }

      @Override
      public applyUpdates_args getEmptyArgsInstance() {
        return new applyUpdates_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, applyUpdates_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.applyUpdates(args.tinfo, args.updateID, args.keyExtent, args.mutations,resultHandler);
      }
    }

    public static class closeUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeUpdate_args, org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> {
      public closeUpdate() {
        super("closeUpdate");
      }

      @Override
      public closeUpdate_args getEmptyArgsInstance() {
        return new closeUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.UpdateErrors o) {
            closeUpdate_result result = new closeUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            closeUpdate_result result = new closeUpdate_result();
            if (e instanceof NoSuchScanIDException) {
              result.nssi = (NoSuchScanIDException) e;
              result.setNssiIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, closeUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.UpdateErrors> resultHandler) throws org.apache.thrift.TException {
        iface.closeUpdate(args.tinfo, args.updateID,resultHandler);
      }
    }

    public static class cancelUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, cancelUpdate_args, java.lang.Boolean> {
      public cancelUpdate() {
        super("cancelUpdate");
      }

      @Override
      public cancelUpdate_args getEmptyArgsInstance() {
        return new cancelUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          @Override
          public void onComplete(java.lang.Boolean o) {
            cancelUpdate_result result = new cancelUpdate_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            cancelUpdate_result result = new cancelUpdate_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, cancelUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.cancelUpdate(args.tinfo, args.updateID,resultHandler);
      }
    }

    public static class update<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, update_args, Void> {
      public update() {
        super("update");
      }

      @Override
      public update_args getEmptyArgsInstance() {
        return new update_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
            update_result result = new update_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            update_result result = new update_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof NotServingTabletException) {
              result.nste = (NotServingTabletException) e;
              result.setNsteIsSet(true);
              msg = result;
            } else if (e instanceof ConstraintViolationException) {
              result.cve = (ConstraintViolationException) e;
              result.setCveIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, update_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.update(args.tinfo, args.credentials, args.keyExtent, args.mutation, args.durability,resultHandler);
      }
    }

    public static class startConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startConditionalUpdate_args, org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> {
      public startConditionalUpdate() {
        super("startConditionalUpdate");
      }

      @Override
      public startConditionalUpdate_args getEmptyArgsInstance() {
        return new startConditionalUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.TConditionalSession o) {
            startConditionalUpdate_result result = new startConditionalUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            startConditionalUpdate_result result = new startConditionalUpdate_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, startConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TConditionalSession> resultHandler) throws org.apache.thrift.TException {
        iface.startConditionalUpdate(args.tinfo, args.credentials, args.authorizations, args.tableID, args.durability, args.classLoaderContext,resultHandler);
      }
    }

    public static class conditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, conditionalUpdate_args, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> {
      public conditionalUpdate() {
        super("conditionalUpdate");
      }

      @Override
      public conditionalUpdate_args getEmptyArgsInstance() {
        return new conditionalUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>>() { 
          @Override
          public void onComplete(java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> o) {
            conditionalUpdate_result result = new conditionalUpdate_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            conditionalUpdate_result result = new conditionalUpdate_result();
            if (e instanceof NoSuchScanIDException) {
              result.nssi = (NoSuchScanIDException) e;
              result.setNssiIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, conditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>> resultHandler) throws org.apache.thrift.TException {
        iface.conditionalUpdate(args.tinfo, args.sessID, args.mutations, args.symbols,resultHandler);
      }
    }

    public static class invalidateConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, invalidateConditionalUpdate_args, Void> {
      public invalidateConditionalUpdate() {
        super("invalidateConditionalUpdate");
      }

      @Override
      public invalidateConditionalUpdate_args getEmptyArgsInstance() {
        return new invalidateConditionalUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
            invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            invalidateConditionalUpdate_result result = new invalidateConditionalUpdate_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, invalidateConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.invalidateConditionalUpdate(args.tinfo, args.sessID,resultHandler);
      }
    }

    public static class closeConditionalUpdate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeConditionalUpdate_args, Void> {
      public closeConditionalUpdate() {
        super("closeConditionalUpdate");
      }

      @Override
      public closeConditionalUpdate_args getEmptyArgsInstance() {
        return new closeConditionalUpdate_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, closeConditionalUpdate_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.closeConditionalUpdate(args.tinfo, args.sessID,resultHandler);
      }
    }

    public static class bulkImport<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, bulkImport_args, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> {
      public bulkImport() {
        super("bulkImport");
      }

      @Override
      public bulkImport_args getEmptyArgsInstance() {
        return new bulkImport_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>>() { 
          @Override
          public void onComplete(java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> o) {
            bulkImport_result result = new bulkImport_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            bulkImport_result result = new bulkImport_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, bulkImport_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>> resultHandler) throws org.apache.thrift.TException {
        iface.bulkImport(args.tinfo, args.credentials, args.tid, args.files, args.setTime,resultHandler);
      }
    }

    public static class loadFiles<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, loadFiles_args, Void> {
      public loadFiles() {
        super("loadFiles");
      }

      @Override
      public loadFiles_args getEmptyArgsInstance() {
        return new loadFiles_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, loadFiles_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.loadFiles(args.tinfo, args.credentials, args.tid, args.dir, args.files, args.setTime,resultHandler);
      }
    }

    public static class loadFilesV2<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, loadFilesV2_args, Void> {
      public loadFilesV2() {
        super("loadFilesV2");
      }

      @Override
      public loadFilesV2_args getEmptyArgsInstance() {
        return new loadFilesV2_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
            loadFilesV2_result result = new loadFilesV2_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            loadFilesV2_result result = new loadFilesV2_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, loadFilesV2_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.loadFilesV2(args.tinfo, args.credentials, args.tid, args.dir, args.files, args.setTime,resultHandler);
      }
    }

    public static class splitTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, splitTablet_args, Void> {
      public splitTablet() {
        super("splitTablet");
      }

      @Override
      public splitTablet_args getEmptyArgsInstance() {
        return new splitTablet_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
            splitTablet_result result = new splitTablet_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            splitTablet_result result = new splitTablet_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof NotServingTabletException) {
              result.nste = (NotServingTabletException) e;
              result.setNsteIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, splitTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.splitTablet(args.tinfo, args.credentials, args.extent, args.splitPoint,resultHandler);
      }
    }

    public static class loadTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, loadTablet_args, Void> {
      public loadTablet() {
        super("loadTablet");
      }

      @Override
      public loadTablet_args getEmptyArgsInstance() {
        return new loadTablet_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, loadTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.loadTablet(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class unloadTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, unloadTablet_args, Void> {
      public unloadTablet() {
        super("unloadTablet");
      }

      @Override
      public unloadTablet_args getEmptyArgsInstance() {
        return new unloadTablet_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, unloadTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.unloadTablet(args.tinfo, args.credentials, args.lock, args.extent, args.goal, args.requestTime,resultHandler);
      }
    }

    public static class flush<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flush_args, Void> {
      public flush() {
        super("flush");
      }

      @Override
      public flush_args getEmptyArgsInstance() {
        return new flush_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, flush_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.flush(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class flushTablet<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, flushTablet_args, Void> {
      public flushTablet() {
        super("flushTablet");
      }

      @Override
      public flushTablet_args getEmptyArgsInstance() {
        return new flushTablet_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, flushTablet_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.flushTablet(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class chop<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, chop_args, Void> {
      public chop() {
        super("chop");
      }

      @Override
      public chop_args getEmptyArgsInstance() {
        return new chop_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, chop_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.chop(args.tinfo, args.credentials, args.lock, args.extent,resultHandler);
      }
    }

    public static class compact<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compact_args, Void> {
      public compact() {
        super("compact");
      }

      @Override
      public compact_args getEmptyArgsInstance() {
        return new compact_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, compact_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.compact(args.tinfo, args.credentials, args.lock, args.tableId, args.startRow, args.endRow,resultHandler);
      }
    }

    public static class getTabletServerStatus<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTabletServerStatus_args, org.apache.accumulo.core.master.thrift.TabletServerStatus> {
      public getTabletServerStatus() {
        super("getTabletServerStatus");
      }

      @Override
      public getTabletServerStatus_args getEmptyArgsInstance() {
        return new getTabletServerStatus_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.master.thrift.TabletServerStatus o) {
            getTabletServerStatus_result result = new getTabletServerStatus_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTabletServerStatus_result result = new getTabletServerStatus_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getTabletServerStatus_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.master.thrift.TabletServerStatus> resultHandler) throws org.apache.thrift.TException {
        iface.getTabletServerStatus(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class getTabletStats<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTabletStats_args, java.util.List<TabletStats>> {
      public getTabletStats() {
        super("getTabletStats");
      }

      @Override
      public getTabletStats_args getEmptyArgsInstance() {
        return new getTabletStats_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>>() { 
          @Override
          public void onComplete(java.util.List<TabletStats> o) {
            getTabletStats_result result = new getTabletStats_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTabletStats_result result = new getTabletStats_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getTabletStats_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TabletStats>> resultHandler) throws org.apache.thrift.TException {
        iface.getTabletStats(args.tinfo, args.credentials, args.tableId,resultHandler);
      }
    }

    public static class getHistoricalStats<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getHistoricalStats_args, TabletStats> {
      public getHistoricalStats() {
        super("getHistoricalStats");
      }

      @Override
      public getHistoricalStats_args getEmptyArgsInstance() {
        return new getHistoricalStats_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<TabletStats> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TabletStats>() { 
          @Override
          public void onComplete(TabletStats o) {
            getHistoricalStats_result result = new getHistoricalStats_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getHistoricalStats_result result = new getHistoricalStats_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getHistoricalStats_args args, org.apache.thrift.async.AsyncMethodCallback<TabletStats> resultHandler) throws org.apache.thrift.TException {
        iface.getHistoricalStats(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class halt<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, halt_args, Void> {
      public halt() {
        super("halt");
      }

      @Override
      public halt_args getEmptyArgsInstance() {
        return new halt_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
            halt_result result = new halt_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            halt_result result = new halt_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, halt_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.halt(args.tinfo, args.credentials, args.lock,resultHandler);
      }
    }

    public static class fastHalt<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, fastHalt_args, Void> {
      public fastHalt() {
        super("fastHalt");
      }

      @Override
      public fastHalt_args getEmptyArgsInstance() {
        return new fastHalt_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, fastHalt_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.fastHalt(args.tinfo, args.credentials, args.lock,resultHandler);
      }
    }

    public static class getActiveCompactions<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveCompactions_args, java.util.List<ActiveCompaction>> {
      public getActiveCompactions() {
        super("getActiveCompactions");
      }

      @Override
      public getActiveCompactions_args getEmptyArgsInstance() {
        return new getActiveCompactions_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>>() { 
          @Override
          public void onComplete(java.util.List<ActiveCompaction> o) {
            getActiveCompactions_result result = new getActiveCompactions_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getActiveCompactions_result result = new getActiveCompactions_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getActiveCompactions_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<ActiveCompaction>> resultHandler) throws org.apache.thrift.TException {
        iface.getActiveCompactions(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class removeLogs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, removeLogs_args, Void> {
      public removeLogs() {
        super("removeLogs");
      }

      @Override
      public removeLogs_args getEmptyArgsInstance() {
        return new removeLogs_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, removeLogs_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.removeLogs(args.tinfo, args.credentials, args.filenames,resultHandler);
      }
    }

    public static class getActiveLogs<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getActiveLogs_args, java.util.List<java.lang.String>> {
      public getActiveLogs() {
        super("getActiveLogs");
      }

      @Override
      public getActiveLogs_args getEmptyArgsInstance() {
        return new getActiveLogs_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>>() { 
          @Override
          public void onComplete(java.util.List<java.lang.String> o) {
            getActiveLogs_result result = new getActiveLogs_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getActiveLogs_result result = new getActiveLogs_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getActiveLogs_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException {
        iface.getActiveLogs(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class startGetSummaries<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startGetSummaries_args, org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      public startGetSummaries() {
        super("startGetSummaries");
      }

      @Override
      public startGetSummaries_args getEmptyArgsInstance() {
        return new startGetSummaries_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.TSummaries o) {
            startGetSummaries_result result = new startGetSummaries_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            startGetSummaries_result result = new startGetSummaries_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException) {
              result.tope = (org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException) e;
              result.setTopeIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, startGetSummaries_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
        iface.startGetSummaries(args.tinfo, args.credentials, args.request,resultHandler);
      }
    }

    public static class startGetSummariesForPartition<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startGetSummariesForPartition_args, org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      public startGetSummariesForPartition() {
        super("startGetSummariesForPartition");
      }

      @Override
      public startGetSummariesForPartition_args getEmptyArgsInstance() {
        return new startGetSummariesForPartition_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.TSummaries o) {
            startGetSummariesForPartition_result result = new startGetSummariesForPartition_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            startGetSummariesForPartition_result result = new startGetSummariesForPartition_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, startGetSummariesForPartition_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
        iface.startGetSummariesForPartition(args.tinfo, args.credentials, args.request, args.modulus, args.remainder,resultHandler);
      }
    }

    public static class startGetSummariesFromFiles<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, startGetSummariesFromFiles_args, org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      public startGetSummariesFromFiles() {
        super("startGetSummariesFromFiles");
      }

      @Override
      public startGetSummariesFromFiles_args getEmptyArgsInstance() {
        return new startGetSummariesFromFiles_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.TSummaries o) {
            startGetSummariesFromFiles_result result = new startGetSummariesFromFiles_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            startGetSummariesFromFiles_result result = new startGetSummariesFromFiles_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, startGetSummariesFromFiles_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
        iface.startGetSummariesFromFiles(args.tinfo, args.credentials, args.request, args.files,resultHandler);
      }
    }

    public static class contiuneGetSummaries<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, contiuneGetSummaries_args, org.apache.accumulo.core.dataImpl.thrift.TSummaries> {
      public contiuneGetSummaries() {
        super("contiuneGetSummaries");
      }

      @Override
      public contiuneGetSummaries_args getEmptyArgsInstance() {
        return new contiuneGetSummaries_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries>() { 
          @Override
          public void onComplete(org.apache.accumulo.core.dataImpl.thrift.TSummaries o) {
            contiuneGetSummaries_result result = new contiuneGetSummaries_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            contiuneGetSummaries_result result = new contiuneGetSummaries_result();
            if (e instanceof NoSuchScanIDException) {
              result.nssi = (NoSuchScanIDException) e;
              result.setNssiIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, contiuneGetSummaries_args args, org.apache.thrift.async.AsyncMethodCallback<org.apache.accumulo.core.dataImpl.thrift.TSummaries> resultHandler) throws org.apache.thrift.TException {
        iface.contiuneGetSummaries(args.tinfo, args.sessionId,resultHandler);
      }
    }

    public static class getCompactionQueueInfo<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getCompactionQueueInfo_args, java.util.List<TCompactionQueueSummary>> {
      public getCompactionQueueInfo() {
        super("getCompactionQueueInfo");
      }

      @Override
      public getCompactionQueueInfo_args getEmptyArgsInstance() {
        return new getCompactionQueueInfo_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>>() { 
          @Override
          public void onComplete(java.util.List<TCompactionQueueSummary> o) {
            getCompactionQueueInfo_result result = new getCompactionQueueInfo_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getCompactionQueueInfo_result result = new getCompactionQueueInfo_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, getCompactionQueueInfo_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TCompactionQueueSummary>> resultHandler) throws org.apache.thrift.TException {
        iface.getCompactionQueueInfo(args.tinfo, args.credentials,resultHandler);
      }
    }

    public static class reserveCompactionJob<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, reserveCompactionJob_args, TExternalCompactionJob> {
      public reserveCompactionJob() {
        super("reserveCompactionJob");
      }

      @Override
      public reserveCompactionJob_args getEmptyArgsInstance() {
        return new reserveCompactionJob_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob>() { 
          @Override
          public void onComplete(TExternalCompactionJob o) {
            reserveCompactionJob_result result = new reserveCompactionJob_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          @Override
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            reserveCompactionJob_result result = new reserveCompactionJob_result();
            if (e instanceof org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) {
              result.sec = (org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException) e;
              result.setSecIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return false;
      }

      @Override
      public void start(I iface, reserveCompactionJob_args args, org.apache.thrift.async.AsyncMethodCallback<TExternalCompactionJob> resultHandler) throws org.apache.thrift.TException {
        iface.reserveCompactionJob(args.tinfo, args.credentials, args.queueName, args.priority, args.compactor, args.externalCompactionId,resultHandler);
      }
    }

    public static class compactionJobFinished<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compactionJobFinished_args, Void> {
      public compactionJobFinished() {
        super("compactionJobFinished");
      }

      @Override
      public compactionJobFinished_args getEmptyArgsInstance() {
        return new compactionJobFinished_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, compactionJobFinished_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.compactionJobFinished(args.tinfo, args.credentials, args.externalCompactionId, args.extent, args.fileSize, args.entries,resultHandler);
      }
    }

    public static class compactionJobFailed<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, compactionJobFailed_args, Void> {
      public compactionJobFailed() {
        super("compactionJobFailed");
      }

      @Override
      public compactionJobFailed_args getEmptyArgsInstance() {
        return new compactionJobFailed_args();
      }

      @Override
      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          @Override
          public void onComplete(Void o) {
          }
          @Override
          public void onError(java.lang.Exception e) {
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
            } else {
              _LOGGER.error("Exception inside oneway handler", e);
            }
          }
        };
      }

      @Override
      protected boolean isOneway() {
        return true;
      }

      @Override
      public void start(I iface, compactionJobFailed_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.compactionJobFailed(args.tinfo, args.credentials, args.externalCompactionId, args.extent,resultHandler);
      }
    }

  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class startUpdate_args implements org.apache.thrift.TBase<startUpdate_args, startUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<startUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new startUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new startUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    /**
     * 
     * @see TDurability
     */
    public @org.apache.thrift.annotation.Nullable TDurability durability; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)3, "durability");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 3: // DURABILITY
            return DURABILITY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startUpdate_args.class, metaDataMap);
    }

    public startUpdate_args() {
    }

    public startUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      TDurability durability)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.durability = durability;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startUpdate_args(startUpdate_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
    }

    @Override
    public startUpdate_args deepCopy() {
      return new startUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.durability = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startUpdate_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    @org.apache.thrift.annotation.Nullable
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public startUpdate_args setDurability(@org.apache.thrift.annotation.Nullable TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case DURABILITY:
        return getDurability();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case DURABILITY:
        return isSetDurability();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof startUpdate_args)
        return this.equals((startUpdate_args)that);
      return false;
    }

    public boolean equals(startUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetDurability()) ? 131071 : 524287);
      if (isSetDurability())
        hashCode = hashCode * 8191 + durability.getValue();

      return hashCode;
    }

    @Override
    public int compareTo(startUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetDurability(), other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("startUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startUpdate_argsStandardScheme getScheme() {
        return new startUpdate_argsStandardScheme();
      }
    }

    private static class startUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<startUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, startUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, startUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startUpdate_argsTupleScheme getScheme() {
        return new startUpdate_argsTupleScheme();
      }
    }

    private static class startUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<startUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetDurability()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class startUpdate_result implements org.apache.thrift.TBase<startUpdate_result, startUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<startUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I64, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new startUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new startUpdate_resultTupleSchemeFactory();

    public long success; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startUpdate_result.class, metaDataMap);
    }

    public startUpdate_result() {
    }

    public startUpdate_result(
      long success,
      org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startUpdate_result(startUpdate_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException(other.sec);
      }
    }

    @Override
    public startUpdate_result deepCopy() {
      return new startUpdate_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.sec = null;
    }

    public long getSuccess() {
      return this.success;
    }

    public startUpdate_result setSuccess(long success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startUpdate_result setSec(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Long)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof startUpdate_result)
        return this.equals((startUpdate_result)that);
      return false;
    }

    public boolean equals(startUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(success);

      hashCode = hashCode * 8191 + ((isSetSec()) ? 131071 : 524287);
      if (isSetSec())
        hashCode = hashCode * 8191 + sec.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(startUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSec(), other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("startUpdate_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startUpdate_resultStandardScheme getScheme() {
        return new startUpdate_resultStandardScheme();
      }
    }

    private static class startUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<startUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, startUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.success = iprot.readI64();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, startUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI64(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startUpdate_resultTupleScheme getScheme() {
        return new startUpdate_resultTupleScheme();
      }
    }

    private static class startUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<startUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI64(struct.success);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI64();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class applyUpdates_args implements org.apache.thrift.TBase<applyUpdates_args, applyUpdates_args._Fields>, java.io.Serializable, Cloneable, Comparable<applyUpdates_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("applyUpdates_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UPDATE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("updateID", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField KEY_EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("keyExtent", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("mutations", org.apache.thrift.protocol.TType.LIST, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new applyUpdates_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new applyUpdates_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long updateID; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent; // required
    public @org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      UPDATE_ID((short)2, "updateID"),
      KEY_EXTENT((short)3, "keyExtent"),
      MUTATIONS((short)4, "mutations");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // UPDATE_ID
            return UPDATE_ID;
          case 3: // KEY_EXTENT
            return KEY_EXTENT;
          case 4: // MUTATIONS
            return MUTATIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __UPDATEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.UPDATE_ID, new org.apache.thrift.meta_data.FieldMetaData("updateID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.KEY_EXTENT, new org.apache.thrift.meta_data.FieldMetaData("keyExtent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.MUTATIONS, new org.apache.thrift.meta_data.FieldMetaData("mutations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TMutation.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(applyUpdates_args.class, metaDataMap);
    }

    public applyUpdates_args() {
    }

    public applyUpdates_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long updateID,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent,
      java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations)
    {
      this();
      this.tinfo = tinfo;
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      this.keyExtent = keyExtent;
      this.mutations = mutations;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public applyUpdates_args(applyUpdates_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.updateID = other.updateID;
      if (other.isSetKeyExtent()) {
        this.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.keyExtent);
      }
      if (other.isSetMutations()) {
        java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> __this__mutations = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TMutation>(other.mutations.size());
        for (org.apache.accumulo.core.dataImpl.thrift.TMutation other_element : other.mutations) {
          __this__mutations.add(new org.apache.accumulo.core.dataImpl.thrift.TMutation(other_element));
        }
        this.mutations = __this__mutations;
      }
    }

    @Override
    public applyUpdates_args deepCopy() {
      return new applyUpdates_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setUpdateIDIsSet(false);
      this.updateID = 0;
      this.keyExtent = null;
      this.mutations = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public applyUpdates_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getUpdateID() {
      return this.updateID;
    }

    public applyUpdates_args setUpdateID(long updateID) {
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      return this;
    }

    public void unsetUpdateID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    /** Returns true if field updateID is set (has been assigned a value) and false otherwise */
    public boolean isSetUpdateID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    public void setUpdateIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __UPDATEID_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getKeyExtent() {
      return this.keyExtent;
    }

    public applyUpdates_args setKeyExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent) {
      this.keyExtent = keyExtent;
      return this;
    }

    public void unsetKeyExtent() {
      this.keyExtent = null;
    }

    /** Returns true if field keyExtent is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyExtent() {
      return this.keyExtent != null;
    }

    public void setKeyExtentIsSet(boolean value) {
      if (!value) {
        this.keyExtent = null;
      }
    }

    public int getMutationsSize() {
      return (this.mutations == null) ? 0 : this.mutations.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<org.apache.accumulo.core.dataImpl.thrift.TMutation> getMutationsIterator() {
      return (this.mutations == null) ? null : this.mutations.iterator();
    }

    public void addToMutations(org.apache.accumulo.core.dataImpl.thrift.TMutation elem) {
      if (this.mutations == null) {
        this.mutations = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TMutation>();
      }
      this.mutations.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> getMutations() {
      return this.mutations;
    }

    public applyUpdates_args setMutations(@org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation> mutations) {
      this.mutations = mutations;
      return this;
    }

    public void unsetMutations() {
      this.mutations = null;
    }

    /** Returns true if field mutations is set (has been assigned a value) and false otherwise */
    public boolean isSetMutations() {
      return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
      if (!value) {
        this.mutations = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case UPDATE_ID:
        if (value == null) {
          unsetUpdateID();
        } else {
          setUpdateID((java.lang.Long)value);
        }
        break;

      case KEY_EXTENT:
        if (value == null) {
          unsetKeyExtent();
        } else {
          setKeyExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      case MUTATIONS:
        if (value == null) {
          unsetMutations();
        } else {
          setMutations((java.util.List<org.apache.accumulo.core.dataImpl.thrift.TMutation>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case UPDATE_ID:
        return getUpdateID();

      case KEY_EXTENT:
        return getKeyExtent();

      case MUTATIONS:
        return getMutations();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case UPDATE_ID:
        return isSetUpdateID();
      case KEY_EXTENT:
        return isSetKeyExtent();
      case MUTATIONS:
        return isSetMutations();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof applyUpdates_args)
        return this.equals((applyUpdates_args)that);
      return false;
    }

    public boolean equals(applyUpdates_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_updateID = true;
      boolean that_present_updateID = true;
      if (this_present_updateID || that_present_updateID) {
        if (!(this_present_updateID && that_present_updateID))
          return false;
        if (this.updateID != that.updateID)
          return false;
      }

      boolean this_present_keyExtent = true && this.isSetKeyExtent();
      boolean that_present_keyExtent = true && that.isSetKeyExtent();
      if (this_present_keyExtent || that_present_keyExtent) {
        if (!(this_present_keyExtent && that_present_keyExtent))
          return false;
        if (!this.keyExtent.equals(that.keyExtent))
          return false;
      }

      boolean this_present_mutations = true && this.isSetMutations();
      boolean that_present_mutations = true && that.isSetMutations();
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(updateID);

      hashCode = hashCode * 8191 + ((isSetKeyExtent()) ? 131071 : 524287);
      if (isSetKeyExtent())
        hashCode = hashCode * 8191 + keyExtent.hashCode();

      hashCode = hashCode * 8191 + ((isSetMutations()) ? 131071 : 524287);
      if (isSetMutations())
        hashCode = hashCode * 8191 + mutations.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(applyUpdates_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetUpdateID(), other.isSetUpdateID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUpdateID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateID, other.updateID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetKeyExtent(), other.isSetKeyExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyExtent, other.keyExtent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetMutations(), other.isSetMutations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutations, other.mutations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("applyUpdates_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("updateID:");
      sb.append(this.updateID);
      first = false;
      if (!first) sb.append(", ");
      sb.append("keyExtent:");
      if (this.keyExtent == null) {
        sb.append("null");
      } else {
        sb.append(this.keyExtent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutations:");
      if (this.mutations == null) {
        sb.append("null");
      } else {
        sb.append(this.mutations);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (keyExtent != null) {
        keyExtent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class applyUpdates_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public applyUpdates_argsStandardScheme getScheme() {
        return new applyUpdates_argsStandardScheme();
      }
    }

    private static class applyUpdates_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<applyUpdates_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, applyUpdates_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UPDATE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.updateID = iprot.readI64();
                struct.setUpdateIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // KEY_EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.keyExtent.read(iprot);
                struct.setKeyExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // MUTATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list268 = iprot.readListBegin();
                  struct.mutations = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TMutation>(_list268.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TMutation _elem269;
                  for (int _i270 = 0; _i270 < _list268.size; ++_i270)
                  {
                    _elem269 = new org.apache.accumulo.core.dataImpl.thrift.TMutation();
                    _elem269.read(iprot);
                    struct.mutations.add(_elem269);
                  }
                  iprot.readListEnd();
                }
                struct.setMutationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, applyUpdates_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(UPDATE_ID_FIELD_DESC);
        oprot.writeI64(struct.updateID);
        oprot.writeFieldEnd();
        if (struct.keyExtent != null) {
          oprot.writeFieldBegin(KEY_EXTENT_FIELD_DESC);
          struct.keyExtent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.mutations != null) {
          oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.mutations.size()));
            for (org.apache.accumulo.core.dataImpl.thrift.TMutation _iter271 : struct.mutations)
            {
              _iter271.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class applyUpdates_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public applyUpdates_argsTupleScheme getScheme() {
        return new applyUpdates_argsTupleScheme();
      }
    }

    private static class applyUpdates_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<applyUpdates_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, applyUpdates_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetUpdateID()) {
          optionals.set(1);
        }
        if (struct.isSetKeyExtent()) {
          optionals.set(2);
        }
        if (struct.isSetMutations()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetUpdateID()) {
          oprot.writeI64(struct.updateID);
        }
        if (struct.isSetKeyExtent()) {
          struct.keyExtent.write(oprot);
        }
        if (struct.isSetMutations()) {
          {
            oprot.writeI32(struct.mutations.size());
            for (org.apache.accumulo.core.dataImpl.thrift.TMutation _iter272 : struct.mutations)
            {
              _iter272.write(oprot);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, applyUpdates_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.updateID = iprot.readI64();
          struct.setUpdateIDIsSet(true);
        }
        if (incoming.get(2)) {
          struct.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.keyExtent.read(iprot);
          struct.setKeyExtentIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list273 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.mutations = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TMutation>(_list273.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TMutation _elem274;
            for (int _i275 = 0; _i275 < _list273.size; ++_i275)
            {
              _elem274 = new org.apache.accumulo.core.dataImpl.thrift.TMutation();
              _elem274.read(iprot);
              struct.mutations.add(_elem274);
            }
          }
          struct.setMutationsIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class closeUpdate_args implements org.apache.thrift.TBase<closeUpdate_args, closeUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField UPDATE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("updateID", org.apache.thrift.protocol.TType.I64, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new closeUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new closeUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long updateID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)2, "tinfo"),
      UPDATE_ID((short)1, "updateID");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 2: // TINFO
            return TINFO;
          case 1: // UPDATE_ID
            return UPDATE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __UPDATEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.UPDATE_ID, new org.apache.thrift.meta_data.FieldMetaData("updateID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeUpdate_args.class, metaDataMap);
    }

    public closeUpdate_args() {
    }

    public closeUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long updateID)
    {
      this();
      this.tinfo = tinfo;
      this.updateID = updateID;
      setUpdateIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeUpdate_args(closeUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.updateID = other.updateID;
    }

    @Override
    public closeUpdate_args deepCopy() {
      return new closeUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setUpdateIDIsSet(false);
      this.updateID = 0;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getUpdateID() {
      return this.updateID;
    }

    public closeUpdate_args setUpdateID(long updateID) {
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      return this;
    }

    public void unsetUpdateID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    /** Returns true if field updateID is set (has been assigned a value) and false otherwise */
    public boolean isSetUpdateID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    public void setUpdateIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __UPDATEID_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case UPDATE_ID:
        if (value == null) {
          unsetUpdateID();
        } else {
          setUpdateID((java.lang.Long)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case UPDATE_ID:
        return getUpdateID();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case UPDATE_ID:
        return isSetUpdateID();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof closeUpdate_args)
        return this.equals((closeUpdate_args)that);
      return false;
    }

    public boolean equals(closeUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_updateID = true;
      boolean that_present_updateID = true;
      if (this_present_updateID || that_present_updateID) {
        if (!(this_present_updateID && that_present_updateID))
          return false;
        if (this.updateID != that.updateID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(updateID);

      return hashCode;
    }

    @Override
    public int compareTo(closeUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetUpdateID(), other.isSetUpdateID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUpdateID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateID, other.updateID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("closeUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("updateID:");
      sb.append(this.updateID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeUpdate_argsStandardScheme getScheme() {
        return new closeUpdate_argsStandardScheme();
      }
    }

    private static class closeUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<closeUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, closeUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 2: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // UPDATE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.updateID = iprot.readI64();
                struct.setUpdateIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, closeUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(UPDATE_ID_FIELD_DESC);
        oprot.writeI64(struct.updateID);
        oprot.writeFieldEnd();
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeUpdate_argsTupleScheme getScheme() {
        return new closeUpdate_argsTupleScheme();
      }
    }

    private static class closeUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<closeUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetUpdateID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetUpdateID()) {
          oprot.writeI64(struct.updateID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.updateID = iprot.readI64();
          struct.setUpdateIDIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class closeUpdate_result implements org.apache.thrift.TBase<closeUpdate_result, closeUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<closeUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new closeUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new closeUpdate_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.UpdateErrors success; // required
    public @org.apache.thrift.annotation.Nullable NoSuchScanIDException nssi; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.UpdateErrors.class)));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NoSuchScanIDException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeUpdate_result.class, metaDataMap);
    }

    public closeUpdate_result() {
    }

    public closeUpdate_result(
      org.apache.accumulo.core.dataImpl.thrift.UpdateErrors success,
      NoSuchScanIDException nssi)
    {
      this();
      this.success = success;
      this.nssi = nssi;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeUpdate_result(closeUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.dataImpl.thrift.UpdateErrors(other.success);
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
    }

    @Override
    public closeUpdate_result deepCopy() {
      return new closeUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.UpdateErrors getSuccess() {
      return this.success;
    }

    public closeUpdate_result setSuccess(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.UpdateErrors success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public closeUpdate_result setNssi(@org.apache.thrift.annotation.Nullable NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.dataImpl.thrift.UpdateErrors)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof closeUpdate_result)
        return this.equals((closeUpdate_result)that);
      return false;
    }

    public boolean equals(closeUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetNssi()) ? 131071 : 524287);
      if (isSetNssi())
        hashCode = hashCode * 8191 + nssi.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(closeUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNssi(), other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("closeUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeUpdate_resultStandardScheme getScheme() {
        return new closeUpdate_resultStandardScheme();
      }
    }

    private static class closeUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<closeUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, closeUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.dataImpl.thrift.UpdateErrors();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, closeUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeUpdate_resultTupleScheme getScheme() {
        return new closeUpdate_resultTupleScheme();
      }
    }

    private static class closeUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<closeUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.dataImpl.thrift.UpdateErrors();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class cancelUpdate_args implements org.apache.thrift.TBase<cancelUpdate_args, cancelUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<cancelUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField UPDATE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("updateID", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new cancelUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new cancelUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long updateID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      UPDATE_ID((short)2, "updateID");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // UPDATE_ID
            return UPDATE_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __UPDATEID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.UPDATE_ID, new org.apache.thrift.meta_data.FieldMetaData("updateID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelUpdate_args.class, metaDataMap);
    }

    public cancelUpdate_args() {
    }

    public cancelUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long updateID)
    {
      this();
      this.tinfo = tinfo;
      this.updateID = updateID;
      setUpdateIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelUpdate_args(cancelUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.updateID = other.updateID;
    }

    @Override
    public cancelUpdate_args deepCopy() {
      return new cancelUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setUpdateIDIsSet(false);
      this.updateID = 0;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public cancelUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getUpdateID() {
      return this.updateID;
    }

    public cancelUpdate_args setUpdateID(long updateID) {
      this.updateID = updateID;
      setUpdateIDIsSet(true);
      return this;
    }

    public void unsetUpdateID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    /** Returns true if field updateID is set (has been assigned a value) and false otherwise */
    public boolean isSetUpdateID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __UPDATEID_ISSET_ID);
    }

    public void setUpdateIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __UPDATEID_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case UPDATE_ID:
        if (value == null) {
          unsetUpdateID();
        } else {
          setUpdateID((java.lang.Long)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case UPDATE_ID:
        return getUpdateID();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case UPDATE_ID:
        return isSetUpdateID();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof cancelUpdate_args)
        return this.equals((cancelUpdate_args)that);
      return false;
    }

    public boolean equals(cancelUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_updateID = true;
      boolean that_present_updateID = true;
      if (this_present_updateID || that_present_updateID) {
        if (!(this_present_updateID && that_present_updateID))
          return false;
        if (this.updateID != that.updateID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(updateID);

      return hashCode;
    }

    @Override
    public int compareTo(cancelUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetUpdateID(), other.isSetUpdateID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetUpdateID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.updateID, other.updateID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("cancelUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("updateID:");
      sb.append(this.updateID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public cancelUpdate_argsStandardScheme getScheme() {
        return new cancelUpdate_argsStandardScheme();
      }
    }

    private static class cancelUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<cancelUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // UPDATE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.updateID = iprot.readI64();
                struct.setUpdateIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(UPDATE_ID_FIELD_DESC);
        oprot.writeI64(struct.updateID);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public cancelUpdate_argsTupleScheme getScheme() {
        return new cancelUpdate_argsTupleScheme();
      }
    }

    private static class cancelUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<cancelUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetUpdateID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetUpdateID()) {
          oprot.writeI64(struct.updateID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.updateID = iprot.readI64();
          struct.setUpdateIDIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class cancelUpdate_result implements org.apache.thrift.TBase<cancelUpdate_result, cancelUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<cancelUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("cancelUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new cancelUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new cancelUpdate_resultTupleSchemeFactory();

    public boolean success; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(cancelUpdate_result.class, metaDataMap);
    }

    public cancelUpdate_result() {
    }

    public cancelUpdate_result(
      boolean success)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public cancelUpdate_result(cancelUpdate_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
    }

    @Override
    public cancelUpdate_result deepCopy() {
      return new cancelUpdate_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public cancelUpdate_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Boolean)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof cancelUpdate_result)
        return this.equals((cancelUpdate_result)that);
      return false;
    }

    public boolean equals(cancelUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((success) ? 131071 : 524287);

      return hashCode;
    }

    @Override
    public int compareTo(cancelUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("cancelUpdate_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class cancelUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public cancelUpdate_resultStandardScheme getScheme() {
        return new cancelUpdate_resultStandardScheme();
      }
    }

    private static class cancelUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<cancelUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, cancelUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, cancelUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class cancelUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public cancelUpdate_resultTupleScheme getScheme() {
        return new cancelUpdate_resultTupleScheme();
      }
    }

    private static class cancelUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<cancelUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, cancelUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, cancelUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class update_args implements org.apache.thrift.TBase<update_args, update_args._Fields>, java.io.Serializable, Cloneable, Comparable<update_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("update_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField KEY_EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("keyExtent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField MUTATION_FIELD_DESC = new org.apache.thrift.protocol.TField("mutation", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)5);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new update_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new update_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TMutation mutation; // required
    /**
     * 
     * @see TDurability
     */
    public @org.apache.thrift.annotation.Nullable TDurability durability; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      KEY_EXTENT((short)2, "keyExtent"),
      MUTATION((short)3, "mutation"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)5, "durability");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // KEY_EXTENT
            return KEY_EXTENT;
          case 3: // MUTATION
            return MUTATION;
          case 5: // DURABILITY
            return DURABILITY;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.KEY_EXTENT, new org.apache.thrift.meta_data.FieldMetaData("keyExtent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.MUTATION, new org.apache.thrift.meta_data.FieldMetaData("mutation", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TMutation.class)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(update_args.class, metaDataMap);
    }

    public update_args() {
    }

    public update_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent,
      org.apache.accumulo.core.dataImpl.thrift.TMutation mutation,
      TDurability durability)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.keyExtent = keyExtent;
      this.mutation = mutation;
      this.durability = durability;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public update_args(update_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetKeyExtent()) {
        this.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.keyExtent);
      }
      if (other.isSetMutation()) {
        this.mutation = new org.apache.accumulo.core.dataImpl.thrift.TMutation(other.mutation);
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
    }

    @Override
    public update_args deepCopy() {
      return new update_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.keyExtent = null;
      this.mutation = null;
      this.durability = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public update_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public update_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getKeyExtent() {
      return this.keyExtent;
    }

    public update_args setKeyExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent keyExtent) {
      this.keyExtent = keyExtent;
      return this;
    }

    public void unsetKeyExtent() {
      this.keyExtent = null;
    }

    /** Returns true if field keyExtent is set (has been assigned a value) and false otherwise */
    public boolean isSetKeyExtent() {
      return this.keyExtent != null;
    }

    public void setKeyExtentIsSet(boolean value) {
      if (!value) {
        this.keyExtent = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TMutation getMutation() {
      return this.mutation;
    }

    public update_args setMutation(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TMutation mutation) {
      this.mutation = mutation;
      return this;
    }

    public void unsetMutation() {
      this.mutation = null;
    }

    /** Returns true if field mutation is set (has been assigned a value) and false otherwise */
    public boolean isSetMutation() {
      return this.mutation != null;
    }

    public void setMutationIsSet(boolean value) {
      if (!value) {
        this.mutation = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    @org.apache.thrift.annotation.Nullable
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public update_args setDurability(@org.apache.thrift.annotation.Nullable TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case KEY_EXTENT:
        if (value == null) {
          unsetKeyExtent();
        } else {
          setKeyExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      case MUTATION:
        if (value == null) {
          unsetMutation();
        } else {
          setMutation((org.apache.accumulo.core.dataImpl.thrift.TMutation)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case KEY_EXTENT:
        return getKeyExtent();

      case MUTATION:
        return getMutation();

      case DURABILITY:
        return getDurability();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case KEY_EXTENT:
        return isSetKeyExtent();
      case MUTATION:
        return isSetMutation();
      case DURABILITY:
        return isSetDurability();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof update_args)
        return this.equals((update_args)that);
      return false;
    }

    public boolean equals(update_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_keyExtent = true && this.isSetKeyExtent();
      boolean that_present_keyExtent = true && that.isSetKeyExtent();
      if (this_present_keyExtent || that_present_keyExtent) {
        if (!(this_present_keyExtent && that_present_keyExtent))
          return false;
        if (!this.keyExtent.equals(that.keyExtent))
          return false;
      }

      boolean this_present_mutation = true && this.isSetMutation();
      boolean that_present_mutation = true && that.isSetMutation();
      if (this_present_mutation || that_present_mutation) {
        if (!(this_present_mutation && that_present_mutation))
          return false;
        if (!this.mutation.equals(that.mutation))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetKeyExtent()) ? 131071 : 524287);
      if (isSetKeyExtent())
        hashCode = hashCode * 8191 + keyExtent.hashCode();

      hashCode = hashCode * 8191 + ((isSetMutation()) ? 131071 : 524287);
      if (isSetMutation())
        hashCode = hashCode * 8191 + mutation.hashCode();

      hashCode = hashCode * 8191 + ((isSetDurability()) ? 131071 : 524287);
      if (isSetDurability())
        hashCode = hashCode * 8191 + durability.getValue();

      return hashCode;
    }

    @Override
    public int compareTo(update_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetKeyExtent(), other.isSetKeyExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetKeyExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.keyExtent, other.keyExtent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetMutation(), other.isSetMutation());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutation()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutation, other.mutation);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetDurability(), other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("update_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("keyExtent:");
      if (this.keyExtent == null) {
        sb.append("null");
      } else {
        sb.append(this.keyExtent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutation:");
      if (this.mutation == null) {
        sb.append("null");
      } else {
        sb.append(this.mutation);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (keyExtent != null) {
        keyExtent.validate();
      }
      if (mutation != null) {
        mutation.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class update_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public update_argsStandardScheme getScheme() {
        return new update_argsStandardScheme();
      }
    }

    private static class update_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<update_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, update_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // KEY_EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.keyExtent.read(iprot);
                struct.setKeyExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MUTATION
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.mutation = new org.apache.accumulo.core.dataImpl.thrift.TMutation();
                struct.mutation.read(iprot);
                struct.setMutationIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, update_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.keyExtent != null) {
          oprot.writeFieldBegin(KEY_EXTENT_FIELD_DESC);
          struct.keyExtent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.mutation != null) {
          oprot.writeFieldBegin(MUTATION_FIELD_DESC);
          struct.mutation.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class update_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public update_argsTupleScheme getScheme() {
        return new update_argsTupleScheme();
      }
    }

    private static class update_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<update_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, update_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetKeyExtent()) {
          optionals.set(2);
        }
        if (struct.isSetMutation()) {
          optionals.set(3);
        }
        if (struct.isSetDurability()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetKeyExtent()) {
          struct.keyExtent.write(oprot);
        }
        if (struct.isSetMutation()) {
          struct.mutation.write(oprot);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, update_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.keyExtent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.keyExtent.read(iprot);
          struct.setKeyExtentIsSet(true);
        }
        if (incoming.get(3)) {
          struct.mutation = new org.apache.accumulo.core.dataImpl.thrift.TMutation();
          struct.mutation.read(iprot);
          struct.setMutationIsSet(true);
        }
        if (incoming.get(4)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class update_result implements org.apache.thrift.TBase<update_result, update_result._Fields>, java.io.Serializable, Cloneable, Comparable<update_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("update_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField CVE_FIELD_DESC = new org.apache.thrift.protocol.TField("cve", org.apache.thrift.protocol.TType.STRUCT, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new update_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new update_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec; // required
    public @org.apache.thrift.annotation.Nullable NotServingTabletException nste; // required
    public @org.apache.thrift.annotation.Nullable ConstraintViolationException cve; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      NSTE((short)2, "nste"),
      CVE((short)3, "cve");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // NSTE
            return NSTE;
          case 3: // CVE
            return CVE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException.class)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NotServingTabletException.class)));
      tmpMap.put(_Fields.CVE, new org.apache.thrift.meta_data.FieldMetaData("cve", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, ConstraintViolationException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(update_result.class, metaDataMap);
    }

    public update_result() {
    }

    public update_result(
      org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec,
      NotServingTabletException nste,
      ConstraintViolationException cve)
    {
      this();
      this.sec = sec;
      this.nste = nste;
      this.cve = cve;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public update_result(update_result other) {
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
      if (other.isSetCve()) {
        this.cve = new ConstraintViolationException(other.cve);
      }
    }

    @Override
    public update_result deepCopy() {
      return new update_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.nste = null;
      this.cve = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public update_result setSec(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public NotServingTabletException getNste() {
      return this.nste;
    }

    public update_result setNste(@org.apache.thrift.annotation.Nullable NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public ConstraintViolationException getCve() {
      return this.cve;
    }

    public update_result setCve(@org.apache.thrift.annotation.Nullable ConstraintViolationException cve) {
      this.cve = cve;
      return this;
    }

    public void unsetCve() {
      this.cve = null;
    }

    /** Returns true if field cve is set (has been assigned a value) and false otherwise */
    public boolean isSetCve() {
      return this.cve != null;
    }

    public void setCveIsSet(boolean value) {
      if (!value) {
        this.cve = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      case CVE:
        if (value == null) {
          unsetCve();
        } else {
          setCve((ConstraintViolationException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case NSTE:
        return getNste();

      case CVE:
        return getCve();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case NSTE:
        return isSetNste();
      case CVE:
        return isSetCve();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof update_result)
        return this.equals((update_result)that);
      return false;
    }

    public boolean equals(update_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      boolean this_present_cve = true && this.isSetCve();
      boolean that_present_cve = true && that.isSetCve();
      if (this_present_cve || that_present_cve) {
        if (!(this_present_cve && that_present_cve))
          return false;
        if (!this.cve.equals(that.cve))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSec()) ? 131071 : 524287);
      if (isSetSec())
        hashCode = hashCode * 8191 + sec.hashCode();

      hashCode = hashCode * 8191 + ((isSetNste()) ? 131071 : 524287);
      if (isSetNste())
        hashCode = hashCode * 8191 + nste.hashCode();

      hashCode = hashCode * 8191 + ((isSetCve()) ? 131071 : 524287);
      if (isSetCve())
        hashCode = hashCode * 8191 + cve.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(update_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSec(), other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNste(), other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCve(), other.isSetCve());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCve()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cve, other.cve);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("update_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("cve:");
      if (this.cve == null) {
        sb.append("null");
      } else {
        sb.append(this.cve);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class update_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public update_resultStandardScheme getScheme() {
        return new update_resultStandardScheme();
      }
    }

    private static class update_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<update_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, update_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // CVE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.cve = new ConstraintViolationException();
                struct.cve.read(iprot);
                struct.setCveIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, update_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.cve != null) {
          oprot.writeFieldBegin(CVE_FIELD_DESC);
          struct.cve.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class update_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public update_resultTupleScheme getScheme() {
        return new update_resultTupleScheme();
      }
    }

    private static class update_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<update_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, update_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        if (struct.isSetNste()) {
          optionals.set(1);
        }
        if (struct.isSetCve()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
        if (struct.isSetCve()) {
          struct.cve.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, update_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
        if (incoming.get(2)) {
          struct.cve = new ConstraintViolationException();
          struct.cve.read(iprot);
          struct.setCveIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class startConditionalUpdate_args implements org.apache.thrift.TBase<startConditionalUpdate_args, startConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<startConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField AUTHORIZATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("authorizations", org.apache.thrift.protocol.TType.LIST, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableID", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField DURABILITY_FIELD_DESC = new org.apache.thrift.protocol.TField("durability", org.apache.thrift.protocol.TType.I32, (short)5);
    private static final org.apache.thrift.protocol.TField CLASS_LOADER_CONTEXT_FIELD_DESC = new org.apache.thrift.protocol.TField("classLoaderContext", org.apache.thrift.protocol.TType.STRING, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new startConditionalUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new startConditionalUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> authorizations; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String tableID; // required
    /**
     * 
     * @see TDurability
     */
    public @org.apache.thrift.annotation.Nullable TDurability durability; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String classLoaderContext; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      AUTHORIZATIONS((short)3, "authorizations"),
      TABLE_ID((short)4, "tableID"),
      /**
       * 
       * @see TDurability
       */
      DURABILITY((short)5, "durability"),
      CLASS_LOADER_CONTEXT((short)6, "classLoaderContext");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // AUTHORIZATIONS
            return AUTHORIZATIONS;
          case 4: // TABLE_ID
            return TABLE_ID;
          case 5: // DURABILITY
            return DURABILITY;
          case 6: // CLASS_LOADER_CONTEXT
            return CLASS_LOADER_CONTEXT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.AUTHORIZATIONS, new org.apache.thrift.meta_data.FieldMetaData("authorizations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING              , true))));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.DURABILITY, new org.apache.thrift.meta_data.FieldMetaData("durability", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TDurability.class)));
      tmpMap.put(_Fields.CLASS_LOADER_CONTEXT, new org.apache.thrift.meta_data.FieldMetaData("classLoaderContext", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startConditionalUpdate_args.class, metaDataMap);
    }

    public startConditionalUpdate_args() {
    }

    public startConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.util.List<java.nio.ByteBuffer> authorizations,
      java.lang.String tableID,
      TDurability durability,
      java.lang.String classLoaderContext)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.authorizations = authorizations;
      this.tableID = tableID;
      this.durability = durability;
      this.classLoaderContext = classLoaderContext;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startConditionalUpdate_args(startConditionalUpdate_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetAuthorizations()) {
        java.util.List<java.nio.ByteBuffer> __this__authorizations = new java.util.ArrayList<java.nio.ByteBuffer>(other.authorizations);
        this.authorizations = __this__authorizations;
      }
      if (other.isSetTableID()) {
        this.tableID = other.tableID;
      }
      if (other.isSetDurability()) {
        this.durability = other.durability;
      }
      if (other.isSetClassLoaderContext()) {
        this.classLoaderContext = other.classLoaderContext;
      }
    }

    @Override
    public startConditionalUpdate_args deepCopy() {
      return new startConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.authorizations = null;
      this.tableID = null;
      this.durability = null;
      this.classLoaderContext = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public startConditionalUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public startConditionalUpdate_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public int getAuthorizationsSize() {
      return (this.authorizations == null) ? 0 : this.authorizations.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.nio.ByteBuffer> getAuthorizationsIterator() {
      return (this.authorizations == null) ? null : this.authorizations.iterator();
    }

    public void addToAuthorizations(java.nio.ByteBuffer elem) {
      if (this.authorizations == null) {
        this.authorizations = new java.util.ArrayList<java.nio.ByteBuffer>();
      }
      this.authorizations.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.nio.ByteBuffer> getAuthorizations() {
      return this.authorizations;
    }

    public startConditionalUpdate_args setAuthorizations(@org.apache.thrift.annotation.Nullable java.util.List<java.nio.ByteBuffer> authorizations) {
      this.authorizations = authorizations;
      return this;
    }

    public void unsetAuthorizations() {
      this.authorizations = null;
    }

    /** Returns true if field authorizations is set (has been assigned a value) and false otherwise */
    public boolean isSetAuthorizations() {
      return this.authorizations != null;
    }

    public void setAuthorizationsIsSet(boolean value) {
      if (!value) {
        this.authorizations = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getTableID() {
      return this.tableID;
    }

    public startConditionalUpdate_args setTableID(@org.apache.thrift.annotation.Nullable java.lang.String tableID) {
      this.tableID = tableID;
      return this;
    }

    public void unsetTableID() {
      this.tableID = null;
    }

    /** Returns true if field tableID is set (has been assigned a value) and false otherwise */
    public boolean isSetTableID() {
      return this.tableID != null;
    }

    public void setTableIDIsSet(boolean value) {
      if (!value) {
        this.tableID = null;
      }
    }

    /**
     * 
     * @see TDurability
     */
    @org.apache.thrift.annotation.Nullable
    public TDurability getDurability() {
      return this.durability;
    }

    /**
     * 
     * @see TDurability
     */
    public startConditionalUpdate_args setDurability(@org.apache.thrift.annotation.Nullable TDurability durability) {
      this.durability = durability;
      return this;
    }

    public void unsetDurability() {
      this.durability = null;
    }

    /** Returns true if field durability is set (has been assigned a value) and false otherwise */
    public boolean isSetDurability() {
      return this.durability != null;
    }

    public void setDurabilityIsSet(boolean value) {
      if (!value) {
        this.durability = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getClassLoaderContext() {
      return this.classLoaderContext;
    }

    public startConditionalUpdate_args setClassLoaderContext(@org.apache.thrift.annotation.Nullable java.lang.String classLoaderContext) {
      this.classLoaderContext = classLoaderContext;
      return this;
    }

    public void unsetClassLoaderContext() {
      this.classLoaderContext = null;
    }

    /** Returns true if field classLoaderContext is set (has been assigned a value) and false otherwise */
    public boolean isSetClassLoaderContext() {
      return this.classLoaderContext != null;
    }

    public void setClassLoaderContextIsSet(boolean value) {
      if (!value) {
        this.classLoaderContext = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case AUTHORIZATIONS:
        if (value == null) {
          unsetAuthorizations();
        } else {
          setAuthorizations((java.util.List<java.nio.ByteBuffer>)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableID();
        } else {
          setTableID((java.lang.String)value);
        }
        break;

      case DURABILITY:
        if (value == null) {
          unsetDurability();
        } else {
          setDurability((TDurability)value);
        }
        break;

      case CLASS_LOADER_CONTEXT:
        if (value == null) {
          unsetClassLoaderContext();
        } else {
          setClassLoaderContext((java.lang.String)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case AUTHORIZATIONS:
        return getAuthorizations();

      case TABLE_ID:
        return getTableID();

      case DURABILITY:
        return getDurability();

      case CLASS_LOADER_CONTEXT:
        return getClassLoaderContext();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case AUTHORIZATIONS:
        return isSetAuthorizations();
      case TABLE_ID:
        return isSetTableID();
      case DURABILITY:
        return isSetDurability();
      case CLASS_LOADER_CONTEXT:
        return isSetClassLoaderContext();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof startConditionalUpdate_args)
        return this.equals((startConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(startConditionalUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_authorizations = true && this.isSetAuthorizations();
      boolean that_present_authorizations = true && that.isSetAuthorizations();
      if (this_present_authorizations || that_present_authorizations) {
        if (!(this_present_authorizations && that_present_authorizations))
          return false;
        if (!this.authorizations.equals(that.authorizations))
          return false;
      }

      boolean this_present_tableID = true && this.isSetTableID();
      boolean that_present_tableID = true && that.isSetTableID();
      if (this_present_tableID || that_present_tableID) {
        if (!(this_present_tableID && that_present_tableID))
          return false;
        if (!this.tableID.equals(that.tableID))
          return false;
      }

      boolean this_present_durability = true && this.isSetDurability();
      boolean that_present_durability = true && that.isSetDurability();
      if (this_present_durability || that_present_durability) {
        if (!(this_present_durability && that_present_durability))
          return false;
        if (!this.durability.equals(that.durability))
          return false;
      }

      boolean this_present_classLoaderContext = true && this.isSetClassLoaderContext();
      boolean that_present_classLoaderContext = true && that.isSetClassLoaderContext();
      if (this_present_classLoaderContext || that_present_classLoaderContext) {
        if (!(this_present_classLoaderContext && that_present_classLoaderContext))
          return false;
        if (!this.classLoaderContext.equals(that.classLoaderContext))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetAuthorizations()) ? 131071 : 524287);
      if (isSetAuthorizations())
        hashCode = hashCode * 8191 + authorizations.hashCode();

      hashCode = hashCode * 8191 + ((isSetTableID()) ? 131071 : 524287);
      if (isSetTableID())
        hashCode = hashCode * 8191 + tableID.hashCode();

      hashCode = hashCode * 8191 + ((isSetDurability()) ? 131071 : 524287);
      if (isSetDurability())
        hashCode = hashCode * 8191 + durability.getValue();

      hashCode = hashCode * 8191 + ((isSetClassLoaderContext()) ? 131071 : 524287);
      if (isSetClassLoaderContext())
        hashCode = hashCode * 8191 + classLoaderContext.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(startConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetAuthorizations(), other.isSetAuthorizations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetAuthorizations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.authorizations, other.authorizations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTableID(), other.isSetTableID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableID, other.tableID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetDurability(), other.isSetDurability());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDurability()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.durability, other.durability);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetClassLoaderContext(), other.isSetClassLoaderContext());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetClassLoaderContext()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.classLoaderContext, other.classLoaderContext);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("startConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("authorizations:");
      if (this.authorizations == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.authorizations, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableID:");
      if (this.tableID == null) {
        sb.append("null");
      } else {
        sb.append(this.tableID);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("durability:");
      if (this.durability == null) {
        sb.append("null");
      } else {
        sb.append(this.durability);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("classLoaderContext:");
      if (this.classLoaderContext == null) {
        sb.append("null");
      } else {
        sb.append(this.classLoaderContext);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startConditionalUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startConditionalUpdate_argsStandardScheme getScheme() {
        return new startConditionalUpdate_argsStandardScheme();
      }
    }

    private static class startConditionalUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<startConditionalUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // AUTHORIZATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list276 = iprot.readListBegin();
                  struct.authorizations = new java.util.ArrayList<java.nio.ByteBuffer>(_list276.size);
                  @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem277;
                  for (int _i278 = 0; _i278 < _list276.size; ++_i278)
                  {
                    _elem277 = iprot.readBinary();
                    struct.authorizations.add(_elem277);
                  }
                  iprot.readListEnd();
                }
                struct.setAuthorizationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableID = iprot.readString();
                struct.setTableIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // DURABILITY
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
                struct.setDurabilityIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // CLASS_LOADER_CONTEXT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.classLoaderContext = iprot.readString();
                struct.setClassLoaderContextIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.authorizations != null) {
          oprot.writeFieldBegin(AUTHORIZATIONS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.authorizations.size()));
            for (java.nio.ByteBuffer _iter279 : struct.authorizations)
            {
              oprot.writeBinary(_iter279);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.tableID != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableID);
          oprot.writeFieldEnd();
        }
        if (struct.durability != null) {
          oprot.writeFieldBegin(DURABILITY_FIELD_DESC);
          oprot.writeI32(struct.durability.getValue());
          oprot.writeFieldEnd();
        }
        if (struct.classLoaderContext != null) {
          oprot.writeFieldBegin(CLASS_LOADER_CONTEXT_FIELD_DESC);
          oprot.writeString(struct.classLoaderContext);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startConditionalUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startConditionalUpdate_argsTupleScheme getScheme() {
        return new startConditionalUpdate_argsTupleScheme();
      }
    }

    private static class startConditionalUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<startConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetAuthorizations()) {
          optionals.set(2);
        }
        if (struct.isSetTableID()) {
          optionals.set(3);
        }
        if (struct.isSetDurability()) {
          optionals.set(4);
        }
        if (struct.isSetClassLoaderContext()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetAuthorizations()) {
          {
            oprot.writeI32(struct.authorizations.size());
            for (java.nio.ByteBuffer _iter280 : struct.authorizations)
            {
              oprot.writeBinary(_iter280);
            }
          }
        }
        if (struct.isSetTableID()) {
          oprot.writeString(struct.tableID);
        }
        if (struct.isSetDurability()) {
          oprot.writeI32(struct.durability.getValue());
        }
        if (struct.isSetClassLoaderContext()) {
          oprot.writeString(struct.classLoaderContext);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TList _list281 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRING);
            struct.authorizations = new java.util.ArrayList<java.nio.ByteBuffer>(_list281.size);
            @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer _elem282;
            for (int _i283 = 0; _i283 < _list281.size; ++_i283)
            {
              _elem282 = iprot.readBinary();
              struct.authorizations.add(_elem282);
            }
          }
          struct.setAuthorizationsIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableID = iprot.readString();
          struct.setTableIDIsSet(true);
        }
        if (incoming.get(4)) {
          struct.durability = org.apache.accumulo.core.tabletserver.thrift.TDurability.findByValue(iprot.readI32());
          struct.setDurabilityIsSet(true);
        }
        if (incoming.get(5)) {
          struct.classLoaderContext = iprot.readString();
          struct.setClassLoaderContextIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class startConditionalUpdate_result implements org.apache.thrift.TBase<startConditionalUpdate_result, startConditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<startConditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("startConditionalUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new startConditionalUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new startConditionalUpdate_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TConditionalSession success; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TConditionalSession.class)));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(startConditionalUpdate_result.class, metaDataMap);
    }

    public startConditionalUpdate_result() {
    }

    public startConditionalUpdate_result(
      org.apache.accumulo.core.dataImpl.thrift.TConditionalSession success,
      org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public startConditionalUpdate_result(startConditionalUpdate_result other) {
      if (other.isSetSuccess()) {
        this.success = new org.apache.accumulo.core.dataImpl.thrift.TConditionalSession(other.success);
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException(other.sec);
      }
    }

    @Override
    public startConditionalUpdate_result deepCopy() {
      return new startConditionalUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TConditionalSession getSuccess() {
      return this.success;
    }

    public startConditionalUpdate_result setSuccess(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TConditionalSession success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public startConditionalUpdate_result setSec(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((org.apache.accumulo.core.dataImpl.thrift.TConditionalSession)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof startConditionalUpdate_result)
        return this.equals((startConditionalUpdate_result)that);
      return false;
    }

    public boolean equals(startConditionalUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetSec()) ? 131071 : 524287);
      if (isSetSec())
        hashCode = hashCode * 8191 + sec.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(startConditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSec(), other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("startConditionalUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class startConditionalUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startConditionalUpdate_resultStandardScheme getScheme() {
        return new startConditionalUpdate_resultStandardScheme();
      }
    }

    private static class startConditionalUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<startConditionalUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new org.apache.accumulo.core.dataImpl.thrift.TConditionalSession();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class startConditionalUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public startConditionalUpdate_resultTupleScheme getScheme() {
        return new startConditionalUpdate_resultTupleScheme();
      }
    }

    private static class startConditionalUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<startConditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, startConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new org.apache.accumulo.core.dataImpl.thrift.TConditionalSession();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class conditionalUpdate_args implements org.apache.thrift.TBase<conditionalUpdate_args, conditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<conditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("conditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);
    private static final org.apache.thrift.protocol.TField MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("mutations", org.apache.thrift.protocol.TType.MAP, (short)3);
    private static final org.apache.thrift.protocol.TField SYMBOLS_FIELD_DESC = new org.apache.thrift.protocol.TField("symbols", org.apache.thrift.protocol.TType.LIST, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new conditionalUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new conditionalUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required
    public @org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations; // required
    public @org.apache.thrift.annotation.Nullable java.util.List<java.lang.String> symbols; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID"),
      MUTATIONS((short)3, "mutations"),
      SYMBOLS((short)4, "symbols");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          case 3: // MUTATIONS
            return MUTATIONS;
          case 4: // SYMBOLS
            return SYMBOLS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      tmpMap.put(_Fields.MUTATIONS, new org.apache.thrift.meta_data.FieldMetaData("mutations", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.MAP          , "CMBatch")));
      tmpMap.put(_Fields.SYMBOLS, new org.apache.thrift.meta_data.FieldMetaData("symbols", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(conditionalUpdate_args.class, metaDataMap);
    }

    public conditionalUpdate_args() {
    }

    public conditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID,
      java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations,
      java.util.List<java.lang.String> symbols)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
      this.mutations = mutations;
      this.symbols = symbols;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public conditionalUpdate_args(conditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
      if (other.isSetMutations()) {
        java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> __this__mutations = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>>(other.mutations.size());
        for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> other_element : other.mutations.entrySet()) {

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent other_element_key = other_element.getKey();
          java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation> other_element_value = other_element.getValue();

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent __this__mutations_copy_key = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other_element_key);

          java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation> __this__mutations_copy_value = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>(other_element_value.size());
          for (org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation other_element_value_element : other_element_value) {
            __this__mutations_copy_value.add(new org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation(other_element_value_element));
          }

          __this__mutations.put(__this__mutations_copy_key, __this__mutations_copy_value);
        }
        this.mutations = __this__mutations;
      }
      if (other.isSetSymbols()) {
        java.util.List<java.lang.String> __this__symbols = new java.util.ArrayList<java.lang.String>(other.symbols);
        this.symbols = __this__symbols;
      }
    }

    @Override
    public conditionalUpdate_args deepCopy() {
      return new conditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
      this.mutations = null;
      this.symbols = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public conditionalUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public conditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    public int getMutationsSize() {
      return (this.mutations == null) ? 0 : this.mutations.size();
    }

    public void putToMutations(org.apache.accumulo.core.dataImpl.thrift.TKeyExtent key, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation> val) {
      if (this.mutations == null) {
        this.mutations = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>>();
      }
      this.mutations.put(key, val);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> getMutations() {
      return this.mutations;
    }

    public conditionalUpdate_args setMutations(@org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> mutations) {
      this.mutations = mutations;
      return this;
    }

    public void unsetMutations() {
      this.mutations = null;
    }

    /** Returns true if field mutations is set (has been assigned a value) and false otherwise */
    public boolean isSetMutations() {
      return this.mutations != null;
    }

    public void setMutationsIsSet(boolean value) {
      if (!value) {
        this.mutations = null;
      }
    }

    public int getSymbolsSize() {
      return (this.symbols == null) ? 0 : this.symbols.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.lang.String> getSymbolsIterator() {
      return (this.symbols == null) ? null : this.symbols.iterator();
    }

    public void addToSymbols(java.lang.String elem) {
      if (this.symbols == null) {
        this.symbols = new java.util.ArrayList<java.lang.String>();
      }
      this.symbols.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.lang.String> getSymbols() {
      return this.symbols;
    }

    public conditionalUpdate_args setSymbols(@org.apache.thrift.annotation.Nullable java.util.List<java.lang.String> symbols) {
      this.symbols = symbols;
      return this;
    }

    public void unsetSymbols() {
      this.symbols = null;
    }

    /** Returns true if field symbols is set (has been assigned a value) and false otherwise */
    public boolean isSetSymbols() {
      return this.symbols != null;
    }

    public void setSymbolsIsSet(boolean value) {
      if (!value) {
        this.symbols = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((java.lang.Long)value);
        }
        break;

      case MUTATIONS:
        if (value == null) {
          unsetMutations();
        } else {
          setMutations((java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>>)value);
        }
        break;

      case SYMBOLS:
        if (value == null) {
          unsetSymbols();
        } else {
          setSymbols((java.util.List<java.lang.String>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      case MUTATIONS:
        return getMutations();

      case SYMBOLS:
        return getSymbols();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      case MUTATIONS:
        return isSetMutations();
      case SYMBOLS:
        return isSetSymbols();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof conditionalUpdate_args)
        return this.equals((conditionalUpdate_args)that);
      return false;
    }

    public boolean equals(conditionalUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      boolean this_present_mutations = true && this.isSetMutations();
      boolean that_present_mutations = true && that.isSetMutations();
      if (this_present_mutations || that_present_mutations) {
        if (!(this_present_mutations && that_present_mutations))
          return false;
        if (!this.mutations.equals(that.mutations))
          return false;
      }

      boolean this_present_symbols = true && this.isSetSymbols();
      boolean that_present_symbols = true && that.isSetSymbols();
      if (this_present_symbols || that_present_symbols) {
        if (!(this_present_symbols && that_present_symbols))
          return false;
        if (!this.symbols.equals(that.symbols))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(sessID);

      hashCode = hashCode * 8191 + ((isSetMutations()) ? 131071 : 524287);
      if (isSetMutations())
        hashCode = hashCode * 8191 + mutations.hashCode();

      hashCode = hashCode * 8191 + ((isSetSymbols()) ? 131071 : 524287);
      if (isSetSymbols())
        hashCode = hashCode * 8191 + symbols.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(conditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSessID(), other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetMutations(), other.isSetMutations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetMutations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.mutations, other.mutations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSymbols(), other.isSetSymbols());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSymbols()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.symbols, other.symbols);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("conditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      if (!first) sb.append(", ");
      sb.append("mutations:");
      if (this.mutations == null) {
        sb.append("null");
      } else {
        sb.append(this.mutations);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("symbols:");
      if (this.symbols == null) {
        sb.append("null");
      } else {
        sb.append(this.symbols);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class conditionalUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public conditionalUpdate_argsStandardScheme getScheme() {
        return new conditionalUpdate_argsStandardScheme();
      }
    }

    private static class conditionalUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<conditionalUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // MUTATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map284 = iprot.readMapBegin();
                  struct.mutations = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>>(2*_map284.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key285;
                  @org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation> _val286;
                  for (int _i287 = 0; _i287 < _map284.size; ++_i287)
                  {
                    _key285 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                    _key285.read(iprot);
                    {
                      org.apache.thrift.protocol.TList _list288 = iprot.readListBegin();
                      _val286 = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>(_list288.size);
                      @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation _elem289;
                      for (int _i290 = 0; _i290 < _list288.size; ++_i290)
                      {
                        _elem289 = new org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation();
                        _elem289.read(iprot);
                        _val286.add(_elem289);
                      }
                      iprot.readListEnd();
                    }
                    struct.mutations.put(_key285, _val286);
                  }
                  iprot.readMapEnd();
                }
                struct.setMutationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // SYMBOLS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list291 = iprot.readListBegin();
                  struct.symbols = new java.util.ArrayList<java.lang.String>(_list291.size);
                  @org.apache.thrift.annotation.Nullable java.lang.String _elem292;
                  for (int _i293 = 0; _i293 < _list291.size; ++_i293)
                  {
                    _elem292 = iprot.readString();
                    struct.symbols.add(_elem292);
                  }
                  iprot.readListEnd();
                }
                struct.setSymbolsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        if (struct.mutations != null) {
          oprot.writeFieldBegin(MUTATIONS_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST, struct.mutations.size()));
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> _iter294 : struct.mutations.entrySet())
            {
              _iter294.getKey().write(oprot);
              {
                oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, _iter294.getValue().size()));
                for (org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation _iter295 : _iter294.getValue())
                {
                  _iter295.write(oprot);
                }
                oprot.writeListEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.symbols != null) {
          oprot.writeFieldBegin(SYMBOLS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRING, struct.symbols.size()));
            for (java.lang.String _iter296 : struct.symbols)
            {
              oprot.writeString(_iter296);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class conditionalUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public conditionalUpdate_argsTupleScheme getScheme() {
        return new conditionalUpdate_argsTupleScheme();
      }
    }

    private static class conditionalUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<conditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        if (struct.isSetMutations()) {
          optionals.set(2);
        }
        if (struct.isSetSymbols()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
        if (struct.isSetMutations()) {
          {
            oprot.writeI32(struct.mutations.size());
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>> _iter297 : struct.mutations.entrySet())
            {
              _iter297.getKey().write(oprot);
              {
                oprot.writeI32(_iter297.getValue().size());
                for (org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation _iter298 : _iter297.getValue())
                {
                  _iter298.write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSymbols()) {
          {
            oprot.writeI32(struct.symbols.size());
            for (java.lang.String _iter299 : struct.symbols)
            {
              oprot.writeString(_iter299);
            }
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
        if (incoming.get(2)) {
          {
            org.apache.thrift.protocol.TMap _map300 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.LIST); 
            struct.mutations = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>>(2*_map300.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key301;
            @org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation> _val302;
            for (int _i303 = 0; _i303 < _map300.size; ++_i303)
            {
              _key301 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
              _key301.read(iprot);
              {
                org.apache.thrift.protocol.TList _list304 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
                _val302 = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation>(_list304.size);
                @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation _elem305;
                for (int _i306 = 0; _i306 < _list304.size; ++_i306)
                {
                  _elem305 = new org.apache.accumulo.core.dataImpl.thrift.TConditionalMutation();
                  _elem305.read(iprot);
                  _val302.add(_elem305);
                }
              }
              struct.mutations.put(_key301, _val302);
            }
          }
          struct.setMutationsIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TList _list307 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRING);
            struct.symbols = new java.util.ArrayList<java.lang.String>(_list307.size);
            @org.apache.thrift.annotation.Nullable java.lang.String _elem308;
            for (int _i309 = 0; _i309 < _list307.size; ++_i309)
            {
              _elem308 = iprot.readString();
              struct.symbols.add(_elem308);
            }
          }
          struct.setSymbolsIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class conditionalUpdate_result implements org.apache.thrift.TBase<conditionalUpdate_result, conditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<conditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("conditionalUpdate_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField NSSI_FIELD_DESC = new org.apache.thrift.protocol.TField("nssi", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new conditionalUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new conditionalUpdate_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> success; // required
    public @org.apache.thrift.annotation.Nullable NoSuchScanIDException nssi; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      NSSI((short)1, "nssi");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // NSSI
            return NSSI;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TCMResult.class))));
      tmpMap.put(_Fields.NSSI, new org.apache.thrift.meta_data.FieldMetaData("nssi", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NoSuchScanIDException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(conditionalUpdate_result.class, metaDataMap);
    }

    public conditionalUpdate_result() {
    }

    public conditionalUpdate_result(
      java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> success,
      NoSuchScanIDException nssi)
    {
      this();
      this.success = success;
      this.nssi = nssi;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public conditionalUpdate_result(conditionalUpdate_result other) {
      if (other.isSetSuccess()) {
        java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> __this__success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TCMResult>(other.success.size());
        for (org.apache.accumulo.core.dataImpl.thrift.TCMResult other_element : other.success) {
          __this__success.add(new org.apache.accumulo.core.dataImpl.thrift.TCMResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetNssi()) {
        this.nssi = new NoSuchScanIDException(other.nssi);
      }
    }

    @Override
    public conditionalUpdate_result deepCopy() {
      return new conditionalUpdate_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.nssi = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<org.apache.accumulo.core.dataImpl.thrift.TCMResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.accumulo.core.dataImpl.thrift.TCMResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TCMResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> getSuccess() {
      return this.success;
    }

    public conditionalUpdate_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public NoSuchScanIDException getNssi() {
      return this.nssi;
    }

    public conditionalUpdate_result setNssi(@org.apache.thrift.annotation.Nullable NoSuchScanIDException nssi) {
      this.nssi = nssi;
      return this;
    }

    public void unsetNssi() {
      this.nssi = null;
    }

    /** Returns true if field nssi is set (has been assigned a value) and false otherwise */
    public boolean isSetNssi() {
      return this.nssi != null;
    }

    public void setNssiIsSet(boolean value) {
      if (!value) {
        this.nssi = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<org.apache.accumulo.core.dataImpl.thrift.TCMResult>)value);
        }
        break;

      case NSSI:
        if (value == null) {
          unsetNssi();
        } else {
          setNssi((NoSuchScanIDException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case NSSI:
        return getNssi();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case NSSI:
        return isSetNssi();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof conditionalUpdate_result)
        return this.equals((conditionalUpdate_result)that);
      return false;
    }

    public boolean equals(conditionalUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_nssi = true && this.isSetNssi();
      boolean that_present_nssi = true && that.isSetNssi();
      if (this_present_nssi || that_present_nssi) {
        if (!(this_present_nssi && that_present_nssi))
          return false;
        if (!this.nssi.equals(that.nssi))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetNssi()) ? 131071 : 524287);
      if (isSetNssi())
        hashCode = hashCode * 8191 + nssi.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(conditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNssi(), other.isSetNssi());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNssi()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nssi, other.nssi);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("conditionalUpdate_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nssi:");
      if (this.nssi == null) {
        sb.append("null");
      } else {
        sb.append(this.nssi);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class conditionalUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public conditionalUpdate_resultStandardScheme getScheme() {
        return new conditionalUpdate_resultStandardScheme();
      }
    }

    private static class conditionalUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<conditionalUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list310 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TCMResult>(_list310.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TCMResult _elem311;
                  for (int _i312 = 0; _i312 < _list310.size; ++_i312)
                  {
                    _elem311 = new org.apache.accumulo.core.dataImpl.thrift.TCMResult();
                    _elem311.read(iprot);
                    struct.success.add(_elem311);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // NSSI
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nssi = new NoSuchScanIDException();
                struct.nssi.read(iprot);
                struct.setNssiIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.accumulo.core.dataImpl.thrift.TCMResult _iter313 : struct.success)
            {
              _iter313.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.nssi != null) {
          oprot.writeFieldBegin(NSSI_FIELD_DESC);
          struct.nssi.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class conditionalUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public conditionalUpdate_resultTupleScheme getScheme() {
        return new conditionalUpdate_resultTupleScheme();
      }
    }

    private static class conditionalUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<conditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetNssi()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.accumulo.core.dataImpl.thrift.TCMResult _iter314 : struct.success)
            {
              _iter314.write(oprot);
            }
          }
        }
        if (struct.isSetNssi()) {
          struct.nssi.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, conditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list315 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TCMResult>(_list315.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TCMResult _elem316;
            for (int _i317 = 0; _i317 < _list315.size; ++_i317)
            {
              _elem316 = new org.apache.accumulo.core.dataImpl.thrift.TCMResult();
              _elem316.read(iprot);
              struct.success.add(_elem316);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nssi = new NoSuchScanIDException();
          struct.nssi.read(iprot);
          struct.setNssiIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class invalidateConditionalUpdate_args implements org.apache.thrift.TBase<invalidateConditionalUpdate_args, invalidateConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<invalidateConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new invalidateConditionalUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new invalidateConditionalUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateConditionalUpdate_args.class, metaDataMap);
    }

    public invalidateConditionalUpdate_args() {
    }

    public invalidateConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateConditionalUpdate_args(invalidateConditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
    }

    @Override
    public invalidateConditionalUpdate_args deepCopy() {
      return new invalidateConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public invalidateConditionalUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public invalidateConditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((java.lang.Long)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof invalidateConditionalUpdate_args)
        return this.equals((invalidateConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(invalidateConditionalUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(sessID);

      return hashCode;
    }

    @Override
    public int compareTo(invalidateConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSessID(), other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("invalidateConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateConditionalUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public invalidateConditionalUpdate_argsStandardScheme getScheme() {
        return new invalidateConditionalUpdate_argsStandardScheme();
      }
    }

    private static class invalidateConditionalUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<invalidateConditionalUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateConditionalUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public invalidateConditionalUpdate_argsTupleScheme getScheme() {
        return new invalidateConditionalUpdate_argsTupleScheme();
      }
    }

    private static class invalidateConditionalUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<invalidateConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class invalidateConditionalUpdate_result implements org.apache.thrift.TBase<invalidateConditionalUpdate_result, invalidateConditionalUpdate_result._Fields>, java.io.Serializable, Cloneable, Comparable<invalidateConditionalUpdate_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("invalidateConditionalUpdate_result");


    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new invalidateConditionalUpdate_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new invalidateConditionalUpdate_resultTupleSchemeFactory();


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(invalidateConditionalUpdate_result.class, metaDataMap);
    }

    public invalidateConditionalUpdate_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public invalidateConditionalUpdate_result(invalidateConditionalUpdate_result other) {
    }

    @Override
    public invalidateConditionalUpdate_result deepCopy() {
      return new invalidateConditionalUpdate_result(this);
    }

    @Override
    public void clear() {
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof invalidateConditionalUpdate_result)
        return this.equals((invalidateConditionalUpdate_result)that);
      return false;
    }

    public boolean equals(invalidateConditionalUpdate_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      return hashCode;
    }

    @Override
    public int compareTo(invalidateConditionalUpdate_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("invalidateConditionalUpdate_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class invalidateConditionalUpdate_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public invalidateConditionalUpdate_resultStandardScheme getScheme() {
        return new invalidateConditionalUpdate_resultStandardScheme();
      }
    }

    private static class invalidateConditionalUpdate_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<invalidateConditionalUpdate_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class invalidateConditionalUpdate_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public invalidateConditionalUpdate_resultTupleScheme getScheme() {
        return new invalidateConditionalUpdate_resultTupleScheme();
      }
    }

    private static class invalidateConditionalUpdate_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<invalidateConditionalUpdate_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, invalidateConditionalUpdate_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class closeConditionalUpdate_args implements org.apache.thrift.TBase<closeConditionalUpdate_args, closeConditionalUpdate_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeConditionalUpdate_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeConditionalUpdate_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField SESS_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("sessID", org.apache.thrift.protocol.TType.I64, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new closeConditionalUpdate_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new closeConditionalUpdate_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public long sessID; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      SESS_ID((short)2, "sessID");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // SESS_ID
            return SESS_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SESSID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.SESS_ID, new org.apache.thrift.meta_data.FieldMetaData("sessID", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64          , "UpdateID")));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeConditionalUpdate_args.class, metaDataMap);
    }

    public closeConditionalUpdate_args() {
    }

    public closeConditionalUpdate_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      long sessID)
    {
      this();
      this.tinfo = tinfo;
      this.sessID = sessID;
      setSessIDIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeConditionalUpdate_args(closeConditionalUpdate_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      this.sessID = other.sessID;
    }

    @Override
    public closeConditionalUpdate_args deepCopy() {
      return new closeConditionalUpdate_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      setSessIDIsSet(false);
      this.sessID = 0;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public closeConditionalUpdate_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    public long getSessID() {
      return this.sessID;
    }

    public closeConditionalUpdate_args setSessID(long sessID) {
      this.sessID = sessID;
      setSessIDIsSet(true);
      return this;
    }

    public void unsetSessID() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    /** Returns true if field sessID is set (has been assigned a value) and false otherwise */
    public boolean isSetSessID() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SESSID_ISSET_ID);
    }

    public void setSessIDIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SESSID_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case SESS_ID:
        if (value == null) {
          unsetSessID();
        } else {
          setSessID((java.lang.Long)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case SESS_ID:
        return getSessID();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case SESS_ID:
        return isSetSessID();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof closeConditionalUpdate_args)
        return this.equals((closeConditionalUpdate_args)that);
      return false;
    }

    public boolean equals(closeConditionalUpdate_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_sessID = true;
      boolean that_present_sessID = true;
      if (this_present_sessID || that_present_sessID) {
        if (!(this_present_sessID && that_present_sessID))
          return false;
        if (this.sessID != that.sessID)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(sessID);

      return hashCode;
    }

    @Override
    public int compareTo(closeConditionalUpdate_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSessID(), other.isSetSessID());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSessID()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sessID, other.sessID);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("closeConditionalUpdate_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sessID:");
      sb.append(this.sessID);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeConditionalUpdate_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeConditionalUpdate_argsStandardScheme getScheme() {
        return new closeConditionalUpdate_argsStandardScheme();
      }
    }

    private static class closeConditionalUpdate_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<closeConditionalUpdate_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // SESS_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.sessID = iprot.readI64();
                struct.setSessIDIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SESS_ID_FIELD_DESC);
        oprot.writeI64(struct.sessID);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeConditionalUpdate_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public closeConditionalUpdate_argsTupleScheme getScheme() {
        return new closeConditionalUpdate_argsTupleScheme();
      }
    }

    private static class closeConditionalUpdate_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<closeConditionalUpdate_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetSessID()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetSessID()) {
          oprot.writeI64(struct.sessID);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeConditionalUpdate_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sessID = iprot.readI64();
          struct.setSessIDIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class bulkImport_args implements org.apache.thrift.TBase<bulkImport_args, bulkImport_args._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImport_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImport_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)4);
    private static final org.apache.thrift.protocol.TField FILES_FIELD_DESC = new org.apache.thrift.protocol.TField("files", org.apache.thrift.protocol.TType.MAP, (short)2);
    private static final org.apache.thrift.protocol.TField SET_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("setTime", org.apache.thrift.protocol.TType.BOOL, (short)5);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new bulkImport_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new bulkImport_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public long tid; // required
    public @org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files; // required
    public boolean setTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)3, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      TID((short)4, "tid"),
      FILES((short)2, "files"),
      SET_TIME((short)5, "setTime");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // TID
            return TID;
          case 2: // FILES
            return FILES;
          case 5: // SET_TIME
            return SET_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private static final int __SETTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.FILES, new org.apache.thrift.meta_data.FieldMetaData("files", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.MAP          , "TabletFiles")));
      tmpMap.put(_Fields.SET_TIME, new org.apache.thrift.meta_data.FieldMetaData("setTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImport_args.class, metaDataMap);
    }

    public bulkImport_args() {
    }

    public bulkImport_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      long tid,
      java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files,
      boolean setTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.tid = tid;
      setTidIsSet(true);
      this.files = files;
      this.setTime = setTime;
      setSetTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImport_args(bulkImport_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      this.tid = other.tid;
      if (other.isSetFiles()) {
        java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> __this__files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(other.files.size());
        for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> other_element : other.files.entrySet()) {

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent other_element_key = other_element.getKey();
          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value = other_element.getValue();

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent __this__files_copy_key = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other_element_key);

          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> __this__files_copy_value = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(other_element_value.size());
          for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value_element : other_element_value.entrySet()) {

            java.lang.String other_element_value_element_key = other_element_value_element.getKey();
            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo other_element_value_element_value = other_element_value_element.getValue();

            java.lang.String __this__files_copy_value_copy_key = other_element_value_element_key;

            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo __this__files_copy_value_copy_value = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo(other_element_value_element_value);

            __this__files_copy_value.put(__this__files_copy_value_copy_key, __this__files_copy_value_copy_value);
          }

          __this__files.put(__this__files_copy_key, __this__files_copy_value);
        }
        this.files = __this__files;
      }
      this.setTime = other.setTime;
    }

    @Override
    public bulkImport_args deepCopy() {
      return new bulkImport_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      setTidIsSet(false);
      this.tid = 0;
      this.files = null;
      setSetTimeIsSet(false);
      this.setTime = false;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public bulkImport_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public bulkImport_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public bulkImport_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    public int getFilesSize() {
      return (this.files == null) ? 0 : this.files.size();
    }

    public void putToFiles(org.apache.accumulo.core.dataImpl.thrift.TKeyExtent key, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> val) {
      if (this.files == null) {
        this.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>();
      }
      this.files.put(key, val);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> getFiles() {
      return this.files;
    }

    public bulkImport_args setFiles(@org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files) {
      this.files = files;
      return this;
    }

    public void unsetFiles() {
      this.files = null;
    }

    /** Returns true if field files is set (has been assigned a value) and false otherwise */
    public boolean isSetFiles() {
      return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
      if (!value) {
        this.files = null;
      }
    }

    public boolean isSetTime() {
      return this.setTime;
    }

    public bulkImport_args setSetTime(boolean setTime) {
      this.setTime = setTime;
      setSetTimeIsSet(true);
      return this;
    }

    public void unsetSetTime() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    /** Returns true if field setTime is set (has been assigned a value) and false otherwise */
    public boolean isSetSetTime() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    public void setSetTimeIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SETTIME_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((java.lang.Long)value);
        }
        break;

      case FILES:
        if (value == null) {
          unsetFiles();
        } else {
          setFiles((java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>)value);
        }
        break;

      case SET_TIME:
        if (value == null) {
          unsetSetTime();
        } else {
          setSetTime((java.lang.Boolean)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TID:
        return getTid();

      case FILES:
        return getFiles();

      case SET_TIME:
        return isSetTime();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TID:
        return isSetTid();
      case FILES:
        return isSetFiles();
      case SET_TIME:
        return isSetSetTime();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof bulkImport_args)
        return this.equals((bulkImport_args)that);
      return false;
    }

    public boolean equals(bulkImport_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      boolean this_present_files = true && this.isSetFiles();
      boolean that_present_files = true && that.isSetFiles();
      if (this_present_files || that_present_files) {
        if (!(this_present_files && that_present_files))
          return false;
        if (!this.files.equals(that.files))
          return false;
      }

      boolean this_present_setTime = true;
      boolean that_present_setTime = true;
      if (this_present_setTime || that_present_setTime) {
        if (!(this_present_setTime && that_present_setTime))
          return false;
        if (this.setTime != that.setTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(tid);

      hashCode = hashCode * 8191 + ((isSetFiles()) ? 131071 : 524287);
      if (isSetFiles())
        hashCode = hashCode * 8191 + files.hashCode();

      hashCode = hashCode * 8191 + ((setTime) ? 131071 : 524287);

      return hashCode;
    }

    @Override
    public int compareTo(bulkImport_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTid(), other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetFiles(), other.isSetFiles());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFiles()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.files, other.files);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSetTime(), other.isSetSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setTime, other.setTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("bulkImport_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      if (!first) sb.append(", ");
      sb.append("files:");
      if (this.files == null) {
        sb.append("null");
      } else {
        sb.append(this.files);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setTime:");
      sb.append(this.setTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImport_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public bulkImport_argsStandardScheme getScheme() {
        return new bulkImport_argsStandardScheme();
      }
    }

    private static class bulkImport_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<bulkImport_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImport_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 3: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // FILES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map318 = iprot.readMapBegin();
                  struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map318.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key319;
                  @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val320;
                  for (int _i321 = 0; _i321 < _map318.size; ++_i321)
                  {
                    _key319 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                    _key319.read(iprot);
                    {
                      org.apache.thrift.protocol.TMap _map322 = iprot.readMapBegin();
                      _val320 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map322.size);
                      @org.apache.thrift.annotation.Nullable java.lang.String _key323;
                      @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val324;
                      for (int _i325 = 0; _i325 < _map322.size; ++_i325)
                      {
                        _key323 = iprot.readString();
                        _val324 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                        _val324.read(iprot);
                        _val320.put(_key323, _val324);
                      }
                      iprot.readMapEnd();
                    }
                    struct.files.put(_key319, _val320);
                  }
                  iprot.readMapEnd();
                }
                struct.setFilesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // SET_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.setTime = iprot.readBool();
                struct.setSetTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImport_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.files != null) {
          oprot.writeFieldBegin(FILES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP, struct.files.size()));
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter326 : struct.files.entrySet())
            {
              _iter326.getKey().write(oprot);
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, _iter326.getValue().size()));
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter327 : _iter326.getValue().entrySet())
                {
                  oprot.writeString(_iter327.getKey());
                  _iter327.getValue().write(oprot);
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(SET_TIME_FIELD_DESC);
        oprot.writeBool(struct.setTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImport_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public bulkImport_argsTupleScheme getScheme() {
        return new bulkImport_argsTupleScheme();
      }
    }

    private static class bulkImport_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<bulkImport_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImport_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetTid()) {
          optionals.set(2);
        }
        if (struct.isSetFiles()) {
          optionals.set(3);
        }
        if (struct.isSetSetTime()) {
          optionals.set(4);
        }
        oprot.writeBitSet(optionals, 5);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
        if (struct.isSetFiles()) {
          {
            oprot.writeI32(struct.files.size());
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter328 : struct.files.entrySet())
            {
              _iter328.getKey().write(oprot);
              {
                oprot.writeI32(_iter328.getValue().size());
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter329 : _iter328.getValue().entrySet())
                {
                  oprot.writeString(_iter329.getKey());
                  _iter329.getValue().write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSetTime()) {
          oprot.writeBool(struct.setTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImport_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(5);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
        if (incoming.get(3)) {
          {
            org.apache.thrift.protocol.TMap _map330 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP); 
            struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map330.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key331;
            @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val332;
            for (int _i333 = 0; _i333 < _map330.size; ++_i333)
            {
              _key331 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
              _key331.read(iprot);
              {
                org.apache.thrift.protocol.TMap _map334 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT); 
                _val332 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map334.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _key335;
                @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val336;
                for (int _i337 = 0; _i337 < _map334.size; ++_i337)
                {
                  _key335 = iprot.readString();
                  _val336 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                  _val336.read(iprot);
                  _val332.put(_key335, _val336);
                }
              }
              struct.files.put(_key331, _val332);
            }
          }
          struct.setFilesIsSet(true);
        }
        if (incoming.get(4)) {
          struct.setTime = iprot.readBool();
          struct.setSetTimeIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class bulkImport_result implements org.apache.thrift.TBase<bulkImport_result, bulkImport_result._Fields>, java.io.Serializable, Cloneable, Comparable<bulkImport_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("bulkImport_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new bulkImport_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new bulkImport_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> success; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      SEC((short)1, "sec");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // SEC
            return SEC;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class))));
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(bulkImport_result.class, metaDataMap);
    }

    public bulkImport_result() {
    }

    public bulkImport_result(
      java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> success,
      org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec)
    {
      this();
      this.success = success;
      this.sec = sec;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public bulkImport_result(bulkImport_result other) {
      if (other.isSetSuccess()) {
        java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> __this__success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>(other.success.size());
        for (org.apache.accumulo.core.dataImpl.thrift.TKeyExtent other_element : other.success) {
          __this__success.add(new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException(other.sec);
      }
    }

    @Override
    public bulkImport_result deepCopy() {
      return new bulkImport_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.sec = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(org.apache.accumulo.core.dataImpl.thrift.TKeyExtent elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> getSuccess() {
      return this.success;
    }

    public bulkImport_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public bulkImport_result setSec(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>)value);
        }
        break;

      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case SEC:
        return getSec();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case SEC:
        return isSetSec();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof bulkImport_result)
        return this.equals((bulkImport_result)that);
      return false;
    }

    public boolean equals(bulkImport_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetSec()) ? 131071 : 524287);
      if (isSetSec())
        hashCode = hashCode * 8191 + sec.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(bulkImport_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSec(), other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("bulkImport_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class bulkImport_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public bulkImport_resultStandardScheme getScheme() {
        return new bulkImport_resultStandardScheme();
      }
    }

    private static class bulkImport_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<bulkImport_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, bulkImport_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list338 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>(_list338.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _elem339;
                  for (int _i340 = 0; _i340 < _list338.size; ++_i340)
                  {
                    _elem339 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                    _elem339.read(iprot);
                    struct.success.add(_elem339);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, bulkImport_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _iter341 : struct.success)
            {
              _iter341.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class bulkImport_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public bulkImport_resultTupleScheme getScheme() {
        return new bulkImport_resultTupleScheme();
      }
    }

    private static class bulkImport_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<bulkImport_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, bulkImport_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetSec()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _iter342 : struct.success)
            {
              _iter342.write(oprot);
            }
          }
        }
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, bulkImport_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list343 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent>(_list343.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _elem344;
            for (int _i345 = 0; _i345 < _list343.size; ++_i345)
            {
              _elem344 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
              _elem344.read(iprot);
              struct.success.add(_elem344);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class loadFiles_args implements org.apache.thrift.TBase<loadFiles_args, loadFiles_args._Fields>, java.io.Serializable, Cloneable, Comparable<loadFiles_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("loadFiles_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField DIR_FIELD_DESC = new org.apache.thrift.protocol.TField("dir", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField FILES_FIELD_DESC = new org.apache.thrift.protocol.TField("files", org.apache.thrift.protocol.TType.MAP, (short)5);
    private static final org.apache.thrift.protocol.TField SET_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("setTime", org.apache.thrift.protocol.TType.BOOL, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new loadFiles_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new loadFiles_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public long tid; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String dir; // required
    public @org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files; // required
    public boolean setTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      TID((short)3, "tid"),
      DIR((short)4, "dir"),
      FILES((short)5, "files"),
      SET_TIME((short)6, "setTime");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // TID
            return TID;
          case 4: // DIR
            return DIR;
          case 5: // FILES
            return FILES;
          case 6: // SET_TIME
            return SET_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private static final int __SETTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.DIR, new org.apache.thrift.meta_data.FieldMetaData("dir", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FILES, new org.apache.thrift.meta_data.FieldMetaData("files", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class), 
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
                  new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo.class)))));
      tmpMap.put(_Fields.SET_TIME, new org.apache.thrift.meta_data.FieldMetaData("setTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(loadFiles_args.class, metaDataMap);
    }

    public loadFiles_args() {
    }

    public loadFiles_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      long tid,
      java.lang.String dir,
      java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files,
      boolean setTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.tid = tid;
      setTidIsSet(true);
      this.dir = dir;
      this.files = files;
      this.setTime = setTime;
      setSetTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public loadFiles_args(loadFiles_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      this.tid = other.tid;
      if (other.isSetDir()) {
        this.dir = other.dir;
      }
      if (other.isSetFiles()) {
        java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> __this__files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(other.files.size());
        for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> other_element : other.files.entrySet()) {

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent other_element_key = other_element.getKey();
          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value = other_element.getValue();

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent __this__files_copy_key = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other_element_key);

          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> __this__files_copy_value = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(other_element_value.size());
          for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value_element : other_element_value.entrySet()) {

            java.lang.String other_element_value_element_key = other_element_value_element.getKey();
            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo other_element_value_element_value = other_element_value_element.getValue();

            java.lang.String __this__files_copy_value_copy_key = other_element_value_element_key;

            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo __this__files_copy_value_copy_value = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo(other_element_value_element_value);

            __this__files_copy_value.put(__this__files_copy_value_copy_key, __this__files_copy_value_copy_value);
          }

          __this__files.put(__this__files_copy_key, __this__files_copy_value);
        }
        this.files = __this__files;
      }
      this.setTime = other.setTime;
    }

    @Override
    public loadFiles_args deepCopy() {
      return new loadFiles_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      setTidIsSet(false);
      this.tid = 0;
      this.dir = null;
      this.files = null;
      setSetTimeIsSet(false);
      this.setTime = false;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public loadFiles_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public loadFiles_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public loadFiles_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getDir() {
      return this.dir;
    }

    public loadFiles_args setDir(@org.apache.thrift.annotation.Nullable java.lang.String dir) {
      this.dir = dir;
      return this;
    }

    public void unsetDir() {
      this.dir = null;
    }

    /** Returns true if field dir is set (has been assigned a value) and false otherwise */
    public boolean isSetDir() {
      return this.dir != null;
    }

    public void setDirIsSet(boolean value) {
      if (!value) {
        this.dir = null;
      }
    }

    public int getFilesSize() {
      return (this.files == null) ? 0 : this.files.size();
    }

    public void putToFiles(org.apache.accumulo.core.dataImpl.thrift.TKeyExtent key, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> val) {
      if (this.files == null) {
        this.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>();
      }
      this.files.put(key, val);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> getFiles() {
      return this.files;
    }

    public loadFiles_args setFiles(@org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files) {
      this.files = files;
      return this;
    }

    public void unsetFiles() {
      this.files = null;
    }

    /** Returns true if field files is set (has been assigned a value) and false otherwise */
    public boolean isSetFiles() {
      return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
      if (!value) {
        this.files = null;
      }
    }

    public boolean isSetTime() {
      return this.setTime;
    }

    public loadFiles_args setSetTime(boolean setTime) {
      this.setTime = setTime;
      setSetTimeIsSet(true);
      return this;
    }

    public void unsetSetTime() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    /** Returns true if field setTime is set (has been assigned a value) and false otherwise */
    public boolean isSetSetTime() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    public void setSetTimeIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SETTIME_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((java.lang.Long)value);
        }
        break;

      case DIR:
        if (value == null) {
          unsetDir();
        } else {
          setDir((java.lang.String)value);
        }
        break;

      case FILES:
        if (value == null) {
          unsetFiles();
        } else {
          setFiles((java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>)value);
        }
        break;

      case SET_TIME:
        if (value == null) {
          unsetSetTime();
        } else {
          setSetTime((java.lang.Boolean)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TID:
        return getTid();

      case DIR:
        return getDir();

      case FILES:
        return getFiles();

      case SET_TIME:
        return isSetTime();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TID:
        return isSetTid();
      case DIR:
        return isSetDir();
      case FILES:
        return isSetFiles();
      case SET_TIME:
        return isSetSetTime();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof loadFiles_args)
        return this.equals((loadFiles_args)that);
      return false;
    }

    public boolean equals(loadFiles_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      boolean this_present_dir = true && this.isSetDir();
      boolean that_present_dir = true && that.isSetDir();
      if (this_present_dir || that_present_dir) {
        if (!(this_present_dir && that_present_dir))
          return false;
        if (!this.dir.equals(that.dir))
          return false;
      }

      boolean this_present_files = true && this.isSetFiles();
      boolean that_present_files = true && that.isSetFiles();
      if (this_present_files || that_present_files) {
        if (!(this_present_files && that_present_files))
          return false;
        if (!this.files.equals(that.files))
          return false;
      }

      boolean this_present_setTime = true;
      boolean that_present_setTime = true;
      if (this_present_setTime || that_present_setTime) {
        if (!(this_present_setTime && that_present_setTime))
          return false;
        if (this.setTime != that.setTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(tid);

      hashCode = hashCode * 8191 + ((isSetDir()) ? 131071 : 524287);
      if (isSetDir())
        hashCode = hashCode * 8191 + dir.hashCode();

      hashCode = hashCode * 8191 + ((isSetFiles()) ? 131071 : 524287);
      if (isSetFiles())
        hashCode = hashCode * 8191 + files.hashCode();

      hashCode = hashCode * 8191 + ((setTime) ? 131071 : 524287);

      return hashCode;
    }

    @Override
    public int compareTo(loadFiles_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTid(), other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetDir(), other.isSetDir());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDir()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dir, other.dir);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetFiles(), other.isSetFiles());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFiles()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.files, other.files);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSetTime(), other.isSetSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setTime, other.setTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("loadFiles_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      if (!first) sb.append(", ");
      sb.append("dir:");
      if (this.dir == null) {
        sb.append("null");
      } else {
        sb.append(this.dir);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("files:");
      if (this.files == null) {
        sb.append("null");
      } else {
        sb.append(this.files);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setTime:");
      sb.append(this.setTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class loadFiles_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFiles_argsStandardScheme getScheme() {
        return new loadFiles_argsStandardScheme();
      }
    }

    private static class loadFiles_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<loadFiles_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, loadFiles_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // DIR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.dir = iprot.readString();
                struct.setDirIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // FILES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map346 = iprot.readMapBegin();
                  struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map346.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key347;
                  @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val348;
                  for (int _i349 = 0; _i349 < _map346.size; ++_i349)
                  {
                    _key347 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                    _key347.read(iprot);
                    {
                      org.apache.thrift.protocol.TMap _map350 = iprot.readMapBegin();
                      _val348 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map350.size);
                      @org.apache.thrift.annotation.Nullable java.lang.String _key351;
                      @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val352;
                      for (int _i353 = 0; _i353 < _map350.size; ++_i353)
                      {
                        _key351 = iprot.readString();
                        _val352 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                        _val352.read(iprot);
                        _val348.put(_key351, _val352);
                      }
                      iprot.readMapEnd();
                    }
                    struct.files.put(_key347, _val348);
                  }
                  iprot.readMapEnd();
                }
                struct.setFilesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // SET_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.setTime = iprot.readBool();
                struct.setSetTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, loadFiles_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        if (struct.dir != null) {
          oprot.writeFieldBegin(DIR_FIELD_DESC);
          oprot.writeString(struct.dir);
          oprot.writeFieldEnd();
        }
        if (struct.files != null) {
          oprot.writeFieldBegin(FILES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP, struct.files.size()));
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter354 : struct.files.entrySet())
            {
              _iter354.getKey().write(oprot);
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, _iter354.getValue().size()));
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter355 : _iter354.getValue().entrySet())
                {
                  oprot.writeString(_iter355.getKey());
                  _iter355.getValue().write(oprot);
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SET_TIME_FIELD_DESC);
        oprot.writeBool(struct.setTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class loadFiles_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFiles_argsTupleScheme getScheme() {
        return new loadFiles_argsTupleScheme();
      }
    }

    private static class loadFiles_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<loadFiles_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, loadFiles_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetTid()) {
          optionals.set(2);
        }
        if (struct.isSetDir()) {
          optionals.set(3);
        }
        if (struct.isSetFiles()) {
          optionals.set(4);
        }
        if (struct.isSetSetTime()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
        if (struct.isSetDir()) {
          oprot.writeString(struct.dir);
        }
        if (struct.isSetFiles()) {
          {
            oprot.writeI32(struct.files.size());
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter356 : struct.files.entrySet())
            {
              _iter356.getKey().write(oprot);
              {
                oprot.writeI32(_iter356.getValue().size());
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter357 : _iter356.getValue().entrySet())
                {
                  oprot.writeString(_iter357.getKey());
                  _iter357.getValue().write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSetTime()) {
          oprot.writeBool(struct.setTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, loadFiles_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
        if (incoming.get(3)) {
          struct.dir = iprot.readString();
          struct.setDirIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map358 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP); 
            struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map358.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key359;
            @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val360;
            for (int _i361 = 0; _i361 < _map358.size; ++_i361)
            {
              _key359 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
              _key359.read(iprot);
              {
                org.apache.thrift.protocol.TMap _map362 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT); 
                _val360 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map362.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _key363;
                @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val364;
                for (int _i365 = 0; _i365 < _map362.size; ++_i365)
                {
                  _key363 = iprot.readString();
                  _val364 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                  _val364.read(iprot);
                  _val360.put(_key363, _val364);
                }
              }
              struct.files.put(_key359, _val360);
            }
          }
          struct.setFilesIsSet(true);
        }
        if (incoming.get(5)) {
          struct.setTime = iprot.readBool();
          struct.setSetTimeIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class loadFilesV2_args implements org.apache.thrift.TBase<loadFilesV2_args, loadFilesV2_args._Fields>, java.io.Serializable, Cloneable, Comparable<loadFilesV2_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("loadFilesV2_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField TID_FIELD_DESC = new org.apache.thrift.protocol.TField("tid", org.apache.thrift.protocol.TType.I64, (short)3);
    private static final org.apache.thrift.protocol.TField DIR_FIELD_DESC = new org.apache.thrift.protocol.TField("dir", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField FILES_FIELD_DESC = new org.apache.thrift.protocol.TField("files", org.apache.thrift.protocol.TType.MAP, (short)5);
    private static final org.apache.thrift.protocol.TField SET_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("setTime", org.apache.thrift.protocol.TType.BOOL, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new loadFilesV2_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new loadFilesV2_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public long tid; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String dir; // required
    public @org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files; // required
    public boolean setTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      TID((short)3, "tid"),
      DIR((short)4, "dir"),
      FILES((short)5, "files"),
      SET_TIME((short)6, "setTime");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // TID
            return TID;
          case 4: // DIR
            return DIR;
          case 5: // FILES
            return FILES;
          case 6: // SET_TIME
            return SET_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __TID_ISSET_ID = 0;
    private static final int __SETTIME_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.TID, new org.apache.thrift.meta_data.FieldMetaData("tid", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      tmpMap.put(_Fields.DIR, new org.apache.thrift.meta_data.FieldMetaData("dir", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.FILES, new org.apache.thrift.meta_data.FieldMetaData("files", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class), 
              new org.apache.thrift.meta_data.MapMetaData(org.apache.thrift.protocol.TType.MAP, 
                  new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING), 
                  new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo.class)))));
      tmpMap.put(_Fields.SET_TIME, new org.apache.thrift.meta_data.FieldMetaData("setTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(loadFilesV2_args.class, metaDataMap);
    }

    public loadFilesV2_args() {
    }

    public loadFilesV2_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      long tid,
      java.lang.String dir,
      java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files,
      boolean setTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.tid = tid;
      setTidIsSet(true);
      this.dir = dir;
      this.files = files;
      this.setTime = setTime;
      setSetTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public loadFilesV2_args(loadFilesV2_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      this.tid = other.tid;
      if (other.isSetDir()) {
        this.dir = other.dir;
      }
      if (other.isSetFiles()) {
        java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> __this__files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(other.files.size());
        for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> other_element : other.files.entrySet()) {

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent other_element_key = other_element.getKey();
          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value = other_element.getValue();

          org.apache.accumulo.core.dataImpl.thrift.TKeyExtent __this__files_copy_key = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other_element_key);

          java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> __this__files_copy_value = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(other_element_value.size());
          for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> other_element_value_element : other_element_value.entrySet()) {

            java.lang.String other_element_value_element_key = other_element_value_element.getKey();
            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo other_element_value_element_value = other_element_value_element.getValue();

            java.lang.String __this__files_copy_value_copy_key = other_element_value_element_key;

            org.apache.accumulo.core.dataImpl.thrift.MapFileInfo __this__files_copy_value_copy_value = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo(other_element_value_element_value);

            __this__files_copy_value.put(__this__files_copy_value_copy_key, __this__files_copy_value_copy_value);
          }

          __this__files.put(__this__files_copy_key, __this__files_copy_value);
        }
        this.files = __this__files;
      }
      this.setTime = other.setTime;
    }

    @Override
    public loadFilesV2_args deepCopy() {
      return new loadFilesV2_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      setTidIsSet(false);
      this.tid = 0;
      this.dir = null;
      this.files = null;
      setSetTimeIsSet(false);
      this.setTime = false;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public loadFilesV2_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public loadFilesV2_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    public long getTid() {
      return this.tid;
    }

    public loadFilesV2_args setTid(long tid) {
      this.tid = tid;
      setTidIsSet(true);
      return this;
    }

    public void unsetTid() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TID_ISSET_ID);
    }

    /** Returns true if field tid is set (has been assigned a value) and false otherwise */
    public boolean isSetTid() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TID_ISSET_ID);
    }

    public void setTidIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TID_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getDir() {
      return this.dir;
    }

    public loadFilesV2_args setDir(@org.apache.thrift.annotation.Nullable java.lang.String dir) {
      this.dir = dir;
      return this;
    }

    public void unsetDir() {
      this.dir = null;
    }

    /** Returns true if field dir is set (has been assigned a value) and false otherwise */
    public boolean isSetDir() {
      return this.dir != null;
    }

    public void setDirIsSet(boolean value) {
      if (!value) {
        this.dir = null;
      }
    }

    public int getFilesSize() {
      return (this.files == null) ? 0 : this.files.size();
    }

    public void putToFiles(org.apache.accumulo.core.dataImpl.thrift.TKeyExtent key, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> val) {
      if (this.files == null) {
        this.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>();
      }
      this.files.put(key, val);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> getFiles() {
      return this.files;
    }

    public loadFilesV2_args setFiles(@org.apache.thrift.annotation.Nullable java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> files) {
      this.files = files;
      return this;
    }

    public void unsetFiles() {
      this.files = null;
    }

    /** Returns true if field files is set (has been assigned a value) and false otherwise */
    public boolean isSetFiles() {
      return this.files != null;
    }

    public void setFilesIsSet(boolean value) {
      if (!value) {
        this.files = null;
      }
    }

    public boolean isSetTime() {
      return this.setTime;
    }

    public loadFilesV2_args setSetTime(boolean setTime) {
      this.setTime = setTime;
      setSetTimeIsSet(true);
      return this;
    }

    public void unsetSetTime() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    /** Returns true if field setTime is set (has been assigned a value) and false otherwise */
    public boolean isSetSetTime() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SETTIME_ISSET_ID);
    }

    public void setSetTimeIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SETTIME_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case TID:
        if (value == null) {
          unsetTid();
        } else {
          setTid((java.lang.Long)value);
        }
        break;

      case DIR:
        if (value == null) {
          unsetDir();
        } else {
          setDir((java.lang.String)value);
        }
        break;

      case FILES:
        if (value == null) {
          unsetFiles();
        } else {
          setFiles((java.util.Map<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>)value);
        }
        break;

      case SET_TIME:
        if (value == null) {
          unsetSetTime();
        } else {
          setSetTime((java.lang.Boolean)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case TID:
        return getTid();

      case DIR:
        return getDir();

      case FILES:
        return getFiles();

      case SET_TIME:
        return isSetTime();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case TID:
        return isSetTid();
      case DIR:
        return isSetDir();
      case FILES:
        return isSetFiles();
      case SET_TIME:
        return isSetSetTime();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof loadFilesV2_args)
        return this.equals((loadFilesV2_args)that);
      return false;
    }

    public boolean equals(loadFilesV2_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_tid = true;
      boolean that_present_tid = true;
      if (this_present_tid || that_present_tid) {
        if (!(this_present_tid && that_present_tid))
          return false;
        if (this.tid != that.tid)
          return false;
      }

      boolean this_present_dir = true && this.isSetDir();
      boolean that_present_dir = true && that.isSetDir();
      if (this_present_dir || that_present_dir) {
        if (!(this_present_dir && that_present_dir))
          return false;
        if (!this.dir.equals(that.dir))
          return false;
      }

      boolean this_present_files = true && this.isSetFiles();
      boolean that_present_files = true && that.isSetFiles();
      if (this_present_files || that_present_files) {
        if (!(this_present_files && that_present_files))
          return false;
        if (!this.files.equals(that.files))
          return false;
      }

      boolean this_present_setTime = true;
      boolean that_present_setTime = true;
      if (this_present_setTime || that_present_setTime) {
        if (!(this_present_setTime && that_present_setTime))
          return false;
        if (this.setTime != that.setTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(tid);

      hashCode = hashCode * 8191 + ((isSetDir()) ? 131071 : 524287);
      if (isSetDir())
        hashCode = hashCode * 8191 + dir.hashCode();

      hashCode = hashCode * 8191 + ((isSetFiles()) ? 131071 : 524287);
      if (isSetFiles())
        hashCode = hashCode * 8191 + files.hashCode();

      hashCode = hashCode * 8191 + ((setTime) ? 131071 : 524287);

      return hashCode;
    }

    @Override
    public int compareTo(loadFilesV2_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTid(), other.isSetTid());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTid()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tid, other.tid);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetDir(), other.isSetDir());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetDir()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.dir, other.dir);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetFiles(), other.isSetFiles());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFiles()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.files, other.files);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSetTime(), other.isSetSetTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSetTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.setTime, other.setTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("loadFilesV2_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tid:");
      sb.append(this.tid);
      first = false;
      if (!first) sb.append(", ");
      sb.append("dir:");
      if (this.dir == null) {
        sb.append("null");
      } else {
        sb.append(this.dir);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("files:");
      if (this.files == null) {
        sb.append("null");
      } else {
        sb.append(this.files);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("setTime:");
      sb.append(this.setTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class loadFilesV2_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFilesV2_argsStandardScheme getScheme() {
        return new loadFilesV2_argsStandardScheme();
      }
    }

    private static class loadFilesV2_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<loadFilesV2_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, loadFilesV2_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // TID
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.tid = iprot.readI64();
                struct.setTidIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // DIR
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.dir = iprot.readString();
                struct.setDirIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // FILES
              if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
                {
                  org.apache.thrift.protocol.TMap _map366 = iprot.readMapBegin();
                  struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map366.size);
                  @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key367;
                  @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val368;
                  for (int _i369 = 0; _i369 < _map366.size; ++_i369)
                  {
                    _key367 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                    _key367.read(iprot);
                    {
                      org.apache.thrift.protocol.TMap _map370 = iprot.readMapBegin();
                      _val368 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map370.size);
                      @org.apache.thrift.annotation.Nullable java.lang.String _key371;
                      @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val372;
                      for (int _i373 = 0; _i373 < _map370.size; ++_i373)
                      {
                        _key371 = iprot.readString();
                        _val372 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                        _val372.read(iprot);
                        _val368.put(_key371, _val372);
                      }
                      iprot.readMapEnd();
                    }
                    struct.files.put(_key367, _val368);
                  }
                  iprot.readMapEnd();
                }
                struct.setFilesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // SET_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.setTime = iprot.readBool();
                struct.setSetTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, loadFilesV2_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TID_FIELD_DESC);
        oprot.writeI64(struct.tid);
        oprot.writeFieldEnd();
        if (struct.dir != null) {
          oprot.writeFieldBegin(DIR_FIELD_DESC);
          oprot.writeString(struct.dir);
          oprot.writeFieldEnd();
        }
        if (struct.files != null) {
          oprot.writeFieldBegin(FILES_FIELD_DESC);
          {
            oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP, struct.files.size()));
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter374 : struct.files.entrySet())
            {
              _iter374.getKey().write(oprot);
              {
                oprot.writeMapBegin(new org.apache.thrift.protocol.TMap(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT, _iter374.getValue().size()));
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter375 : _iter374.getValue().entrySet())
                {
                  oprot.writeString(_iter375.getKey());
                  _iter375.getValue().write(oprot);
                }
                oprot.writeMapEnd();
              }
            }
            oprot.writeMapEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(SET_TIME_FIELD_DESC);
        oprot.writeBool(struct.setTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class loadFilesV2_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFilesV2_argsTupleScheme getScheme() {
        return new loadFilesV2_argsTupleScheme();
      }
    }

    private static class loadFilesV2_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<loadFilesV2_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, loadFilesV2_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetTid()) {
          optionals.set(2);
        }
        if (struct.isSetDir()) {
          optionals.set(3);
        }
        if (struct.isSetFiles()) {
          optionals.set(4);
        }
        if (struct.isSetSetTime()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetTid()) {
          oprot.writeI64(struct.tid);
        }
        if (struct.isSetDir()) {
          oprot.writeString(struct.dir);
        }
        if (struct.isSetFiles()) {
          {
            oprot.writeI32(struct.files.size());
            for (java.util.Map.Entry<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent, java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>> _iter376 : struct.files.entrySet())
            {
              _iter376.getKey().write(oprot);
              {
                oprot.writeI32(_iter376.getValue().size());
                for (java.util.Map.Entry<java.lang.String, org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _iter377 : _iter376.getValue().entrySet())
                {
                  oprot.writeString(_iter377.getKey());
                  _iter377.getValue().write(oprot);
                }
              }
            }
          }
        }
        if (struct.isSetSetTime()) {
          oprot.writeBool(struct.setTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, loadFilesV2_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.tid = iprot.readI64();
          struct.setTidIsSet(true);
        }
        if (incoming.get(3)) {
          struct.dir = iprot.readString();
          struct.setDirIsSet(true);
        }
        if (incoming.get(4)) {
          {
            org.apache.thrift.protocol.TMap _map378 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRUCT, org.apache.thrift.protocol.TType.MAP); 
            struct.files = new java.util.HashMap<org.apache.accumulo.core.dataImpl.thrift.TKeyExtent,java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>>(2*_map378.size);
            @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent _key379;
            @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo> _val380;
            for (int _i381 = 0; _i381 < _map378.size; ++_i381)
            {
              _key379 = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
              _key379.read(iprot);
              {
                org.apache.thrift.protocol.TMap _map382 = iprot.readMapBegin(org.apache.thrift.protocol.TType.STRING, org.apache.thrift.protocol.TType.STRUCT); 
                _val380 = new java.util.HashMap<java.lang.String,org.apache.accumulo.core.dataImpl.thrift.MapFileInfo>(2*_map382.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _key383;
                @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.MapFileInfo _val384;
                for (int _i385 = 0; _i385 < _map382.size; ++_i385)
                {
                  _key383 = iprot.readString();
                  _val384 = new org.apache.accumulo.core.dataImpl.thrift.MapFileInfo();
                  _val384.read(iprot);
                  _val380.put(_key383, _val384);
                }
              }
              struct.files.put(_key379, _val380);
            }
          }
          struct.setFilesIsSet(true);
        }
        if (incoming.get(5)) {
          struct.setTime = iprot.readBool();
          struct.setSetTimeIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class loadFilesV2_result implements org.apache.thrift.TBase<loadFilesV2_result, loadFilesV2_result._Fields>, java.io.Serializable, Cloneable, Comparable<loadFilesV2_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("loadFilesV2_result");


    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new loadFilesV2_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new loadFilesV2_resultTupleSchemeFactory();


    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
;

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(loadFilesV2_result.class, metaDataMap);
    }

    public loadFilesV2_result() {
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public loadFilesV2_result(loadFilesV2_result other) {
    }

    @Override
    public loadFilesV2_result deepCopy() {
      return new loadFilesV2_result(this);
    }

    @Override
    public void clear() {
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof loadFilesV2_result)
        return this.equals((loadFilesV2_result)that);
      return false;
    }

    public boolean equals(loadFilesV2_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      return hashCode;
    }

    @Override
    public int compareTo(loadFilesV2_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("loadFilesV2_result(");
      boolean first = true;

      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class loadFilesV2_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFilesV2_resultStandardScheme getScheme() {
        return new loadFilesV2_resultStandardScheme();
      }
    }

    private static class loadFilesV2_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<loadFilesV2_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, loadFilesV2_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, loadFilesV2_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class loadFilesV2_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadFilesV2_resultTupleScheme getScheme() {
        return new loadFilesV2_resultTupleScheme();
      }
    }

    private static class loadFilesV2_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<loadFilesV2_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, loadFilesV2_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, loadFilesV2_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class splitTablet_args implements org.apache.thrift.TBase<splitTablet_args, splitTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<splitTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("splitTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField SPLIT_POINT_FIELD_DESC = new org.apache.thrift.protocol.TField("splitPoint", org.apache.thrift.protocol.TType.STRING, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new splitTablet_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new splitTablet_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer splitPoint; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      EXTENT((short)2, "extent"),
      SPLIT_POINT((short)3, "splitPoint");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 2: // EXTENT
            return EXTENT;
          case 3: // SPLIT_POINT
            return SPLIT_POINT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.SPLIT_POINT, new org.apache.thrift.meta_data.FieldMetaData("splitPoint", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(splitTablet_args.class, metaDataMap);
    }

    public splitTablet_args() {
    }

    public splitTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent,
      java.nio.ByteBuffer splitPoint)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.extent = extent;
      this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public splitTablet_args(splitTablet_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.extent);
      }
      if (other.isSetSplitPoint()) {
        this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(other.splitPoint);
      }
    }

    @Override
    public splitTablet_args deepCopy() {
      return new splitTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.extent = null;
      this.splitPoint = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public splitTablet_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public splitTablet_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public splitTablet_args setExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    public byte[] getSplitPoint() {
      setSplitPoint(org.apache.thrift.TBaseHelper.rightSize(splitPoint));
      return splitPoint == null ? null : splitPoint.array();
    }

    public java.nio.ByteBuffer bufferForSplitPoint() {
      return org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
    }

    public splitTablet_args setSplitPoint(byte[] splitPoint) {
      this.splitPoint = splitPoint == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(splitPoint.clone());
      return this;
    }

    public splitTablet_args setSplitPoint(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer splitPoint) {
      this.splitPoint = org.apache.thrift.TBaseHelper.copyBinary(splitPoint);
      return this;
    }

    public void unsetSplitPoint() {
      this.splitPoint = null;
    }

    /** Returns true if field splitPoint is set (has been assigned a value) and false otherwise */
    public boolean isSetSplitPoint() {
      return this.splitPoint != null;
    }

    public void setSplitPointIsSet(boolean value) {
      if (!value) {
        this.splitPoint = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      case SPLIT_POINT:
        if (value == null) {
          unsetSplitPoint();
        } else {
          if (value instanceof byte[]) {
            setSplitPoint((byte[])value);
          } else {
            setSplitPoint((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case EXTENT:
        return getExtent();

      case SPLIT_POINT:
        return getSplitPoint();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case EXTENT:
        return isSetExtent();
      case SPLIT_POINT:
        return isSetSplitPoint();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof splitTablet_args)
        return this.equals((splitTablet_args)that);
      return false;
    }

    public boolean equals(splitTablet_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      boolean this_present_splitPoint = true && this.isSetSplitPoint();
      boolean that_present_splitPoint = true && that.isSetSplitPoint();
      if (this_present_splitPoint || that_present_splitPoint) {
        if (!(this_present_splitPoint && that_present_splitPoint))
          return false;
        if (!this.splitPoint.equals(that.splitPoint))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetExtent()) ? 131071 : 524287);
      if (isSetExtent())
        hashCode = hashCode * 8191 + extent.hashCode();

      hashCode = hashCode * 8191 + ((isSetSplitPoint()) ? 131071 : 524287);
      if (isSetSplitPoint())
        hashCode = hashCode * 8191 + splitPoint.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(splitTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetExtent(), other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetSplitPoint(), other.isSetSplitPoint());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSplitPoint()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.splitPoint, other.splitPoint);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("splitTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("splitPoint:");
      if (this.splitPoint == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.splitPoint, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class splitTablet_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public splitTablet_argsStandardScheme getScheme() {
        return new splitTablet_argsStandardScheme();
      }
    }

    private static class splitTablet_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<splitTablet_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, splitTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // SPLIT_POINT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.splitPoint = iprot.readBinary();
                struct.setSplitPointIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, splitTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.splitPoint != null) {
          oprot.writeFieldBegin(SPLIT_POINT_FIELD_DESC);
          oprot.writeBinary(struct.splitPoint);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class splitTablet_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public splitTablet_argsTupleScheme getScheme() {
        return new splitTablet_argsTupleScheme();
      }
    }

    private static class splitTablet_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<splitTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, splitTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetExtent()) {
          optionals.set(2);
        }
        if (struct.isSetSplitPoint()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
        if (struct.isSetSplitPoint()) {
          oprot.writeBinary(struct.splitPoint);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, splitTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
        if (incoming.get(3)) {
          struct.splitPoint = iprot.readBinary();
          struct.setSplitPointIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class splitTablet_result implements org.apache.thrift.TBase<splitTablet_result, splitTablet_result._Fields>, java.io.Serializable, Cloneable, Comparable<splitTablet_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("splitTablet_result");

    private static final org.apache.thrift.protocol.TField SEC_FIELD_DESC = new org.apache.thrift.protocol.TField("sec", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField NSTE_FIELD_DESC = new org.apache.thrift.protocol.TField("nste", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new splitTablet_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new splitTablet_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec; // required
    public @org.apache.thrift.annotation.Nullable NotServingTabletException nste; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SEC((short)1, "sec"),
      NSTE((short)2, "nste");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SEC
            return SEC;
          case 2: // NSTE
            return NSTE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SEC, new org.apache.thrift.meta_data.FieldMetaData("sec", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException.class)));
      tmpMap.put(_Fields.NSTE, new org.apache.thrift.meta_data.FieldMetaData("nste", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, NotServingTabletException.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(splitTablet_result.class, metaDataMap);
    }

    public splitTablet_result() {
    }

    public splitTablet_result(
      org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec,
      NotServingTabletException nste)
    {
      this();
      this.sec = sec;
      this.nste = nste;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public splitTablet_result(splitTablet_result other) {
      if (other.isSetSec()) {
        this.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException(other.sec);
      }
      if (other.isSetNste()) {
        this.nste = new NotServingTabletException(other.nste);
      }
    }

    @Override
    public splitTablet_result deepCopy() {
      return new splitTablet_result(this);
    }

    @Override
    public void clear() {
      this.sec = null;
      this.nste = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException getSec() {
      return this.sec;
    }

    public splitTablet_result setSec(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException sec) {
      this.sec = sec;
      return this;
    }

    public void unsetSec() {
      this.sec = null;
    }

    /** Returns true if field sec is set (has been assigned a value) and false otherwise */
    public boolean isSetSec() {
      return this.sec != null;
    }

    public void setSecIsSet(boolean value) {
      if (!value) {
        this.sec = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public NotServingTabletException getNste() {
      return this.nste;
    }

    public splitTablet_result setNste(@org.apache.thrift.annotation.Nullable NotServingTabletException nste) {
      this.nste = nste;
      return this;
    }

    public void unsetNste() {
      this.nste = null;
    }

    /** Returns true if field nste is set (has been assigned a value) and false otherwise */
    public boolean isSetNste() {
      return this.nste != null;
    }

    public void setNsteIsSet(boolean value) {
      if (!value) {
        this.nste = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SEC:
        if (value == null) {
          unsetSec();
        } else {
          setSec((org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException)value);
        }
        break;

      case NSTE:
        if (value == null) {
          unsetNste();
        } else {
          setNste((NotServingTabletException)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SEC:
        return getSec();

      case NSTE:
        return getNste();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SEC:
        return isSetSec();
      case NSTE:
        return isSetNste();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof splitTablet_result)
        return this.equals((splitTablet_result)that);
      return false;
    }

    public boolean equals(splitTablet_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_sec = true && this.isSetSec();
      boolean that_present_sec = true && that.isSetSec();
      if (this_present_sec || that_present_sec) {
        if (!(this_present_sec && that_present_sec))
          return false;
        if (!this.sec.equals(that.sec))
          return false;
      }

      boolean this_present_nste = true && this.isSetNste();
      boolean that_present_nste = true && that.isSetNste();
      if (this_present_nste || that_present_nste) {
        if (!(this_present_nste && that_present_nste))
          return false;
        if (!this.nste.equals(that.nste))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSec()) ? 131071 : 524287);
      if (isSetSec())
        hashCode = hashCode * 8191 + sec.hashCode();

      hashCode = hashCode * 8191 + ((isSetNste()) ? 131071 : 524287);
      if (isSetNste())
        hashCode = hashCode * 8191 + nste.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(splitTablet_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSec(), other.isSetSec());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSec()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.sec, other.sec);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNste(), other.isSetNste());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNste()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.nste, other.nste);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("splitTablet_result(");
      boolean first = true;

      sb.append("sec:");
      if (this.sec == null) {
        sb.append("null");
      } else {
        sb.append(this.sec);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("nste:");
      if (this.nste == null) {
        sb.append("null");
      } else {
        sb.append(this.nste);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class splitTablet_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public splitTablet_resultStandardScheme getScheme() {
        return new splitTablet_resultStandardScheme();
      }
    }

    private static class splitTablet_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<splitTablet_result> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, splitTablet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SEC
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
                struct.sec.read(iprot);
                struct.setSecIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NSTE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.nste = new NotServingTabletException();
                struct.nste.read(iprot);
                struct.setNsteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, splitTablet_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.sec != null) {
          oprot.writeFieldBegin(SEC_FIELD_DESC);
          struct.sec.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.nste != null) {
          oprot.writeFieldBegin(NSTE_FIELD_DESC);
          struct.nste.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class splitTablet_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public splitTablet_resultTupleScheme getScheme() {
        return new splitTablet_resultTupleScheme();
      }
    }

    private static class splitTablet_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<splitTablet_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, splitTablet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSec()) {
          optionals.set(0);
        }
        if (struct.isSetNste()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSec()) {
          struct.sec.write(oprot);
        }
        if (struct.isSetNste()) {
          struct.nste.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, splitTablet_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.sec = new org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException();
          struct.sec.read(iprot);
          struct.setSecIsSet(true);
        }
        if (incoming.get(1)) {
          struct.nste = new NotServingTabletException();
          struct.nste.read(iprot);
          struct.setNsteIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class loadTablet_args implements org.apache.thrift.TBase<loadTablet_args, loadTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<loadTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("loadTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new loadTablet_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new loadTablet_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)4, "lock"),
      EXTENT((short)2, "extent");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // LOCK
            return LOCK;
          case 2: // EXTENT
            return EXTENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(loadTablet_args.class, metaDataMap);
    }

    public loadTablet_args() {
    }

    public loadTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public loadTablet_args(loadTablet_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.extent);
      }
    }

    @Override
    public loadTablet_args deepCopy() {
      return new loadTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public loadTablet_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public loadTablet_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public loadTablet_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public loadTablet_args setExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof loadTablet_args)
        return this.equals((loadTablet_args)that);
      return false;
    }

    public boolean equals(loadTablet_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetExtent()) ? 131071 : 524287);
      if (isSetExtent())
        hashCode = hashCode * 8191 + extent.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(loadTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetExtent(), other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("loadTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class loadTablet_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadTablet_argsStandardScheme getScheme() {
        return new loadTablet_argsStandardScheme();
      }
    }

    private static class loadTablet_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<loadTablet_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, loadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, loadTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class loadTablet_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public loadTablet_argsTupleScheme getScheme() {
        return new loadTablet_argsTupleScheme();
      }
    }

    private static class loadTablet_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<loadTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, loadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, loadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class unloadTablet_args implements org.apache.thrift.TBase<unloadTablet_args, unloadTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<unloadTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("unloadTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)5);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField GOAL_FIELD_DESC = new org.apache.thrift.protocol.TField("goal", org.apache.thrift.protocol.TType.I32, (short)6);
    private static final org.apache.thrift.protocol.TField REQUEST_TIME_FIELD_DESC = new org.apache.thrift.protocol.TField("requestTime", org.apache.thrift.protocol.TType.I64, (short)7);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new unloadTablet_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new unloadTablet_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent; // required
    /**
     * 
     * @see TUnloadTabletGoal
     */
    public @org.apache.thrift.annotation.Nullable TUnloadTabletGoal goal; // required
    public long requestTime; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)5, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)4, "lock"),
      EXTENT((short)2, "extent"),
      /**
       * 
       * @see TUnloadTabletGoal
       */
      GOAL((short)6, "goal"),
      REQUEST_TIME((short)7, "requestTime");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 5: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 4: // LOCK
            return LOCK;
          case 2: // EXTENT
            return EXTENT;
          case 6: // GOAL
            return GOAL;
          case 7: // REQUEST_TIME
            return REQUEST_TIME;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __REQUESTTIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      tmpMap.put(_Fields.GOAL, new org.apache.thrift.meta_data.FieldMetaData("goal", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, TUnloadTabletGoal.class)));
      tmpMap.put(_Fields.REQUEST_TIME, new org.apache.thrift.meta_data.FieldMetaData("requestTime", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I64)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(unloadTablet_args.class, metaDataMap);
    }

    public unloadTablet_args() {
    }

    public unloadTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent,
      TUnloadTabletGoal goal,
      long requestTime)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
      this.goal = goal;
      this.requestTime = requestTime;
      setRequestTimeIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public unloadTablet_args(unloadTablet_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.extent);
      }
      if (other.isSetGoal()) {
        this.goal = other.goal;
      }
      this.requestTime = other.requestTime;
    }

    @Override
    public unloadTablet_args deepCopy() {
      return new unloadTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
      this.goal = null;
      setRequestTimeIsSet(false);
      this.requestTime = 0;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public unloadTablet_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public unloadTablet_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public unloadTablet_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public unloadTablet_args setExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    /**
     * 
     * @see TUnloadTabletGoal
     */
    @org.apache.thrift.annotation.Nullable
    public TUnloadTabletGoal getGoal() {
      return this.goal;
    }

    /**
     * 
     * @see TUnloadTabletGoal
     */
    public unloadTablet_args setGoal(@org.apache.thrift.annotation.Nullable TUnloadTabletGoal goal) {
      this.goal = goal;
      return this;
    }

    public void unsetGoal() {
      this.goal = null;
    }

    /** Returns true if field goal is set (has been assigned a value) and false otherwise */
    public boolean isSetGoal() {
      return this.goal != null;
    }

    public void setGoalIsSet(boolean value) {
      if (!value) {
        this.goal = null;
      }
    }

    public long getRequestTime() {
      return this.requestTime;
    }

    public unloadTablet_args setRequestTime(long requestTime) {
      this.requestTime = requestTime;
      setRequestTimeIsSet(true);
      return this;
    }

    public void unsetRequestTime() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __REQUESTTIME_ISSET_ID);
    }

    /** Returns true if field requestTime is set (has been assigned a value) and false otherwise */
    public boolean isSetRequestTime() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __REQUESTTIME_ISSET_ID);
    }

    public void setRequestTimeIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __REQUESTTIME_ISSET_ID, value);
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      case GOAL:
        if (value == null) {
          unsetGoal();
        } else {
          setGoal((TUnloadTabletGoal)value);
        }
        break;

      case REQUEST_TIME:
        if (value == null) {
          unsetRequestTime();
        } else {
          setRequestTime((java.lang.Long)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      case GOAL:
        return getGoal();

      case REQUEST_TIME:
        return getRequestTime();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      case GOAL:
        return isSetGoal();
      case REQUEST_TIME:
        return isSetRequestTime();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof unloadTablet_args)
        return this.equals((unloadTablet_args)that);
      return false;
    }

    public boolean equals(unloadTablet_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      boolean this_present_goal = true && this.isSetGoal();
      boolean that_present_goal = true && that.isSetGoal();
      if (this_present_goal || that_present_goal) {
        if (!(this_present_goal && that_present_goal))
          return false;
        if (!this.goal.equals(that.goal))
          return false;
      }

      boolean this_present_requestTime = true;
      boolean that_present_requestTime = true;
      if (this_present_requestTime || that_present_requestTime) {
        if (!(this_present_requestTime && that_present_requestTime))
          return false;
        if (this.requestTime != that.requestTime)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetExtent()) ? 131071 : 524287);
      if (isSetExtent())
        hashCode = hashCode * 8191 + extent.hashCode();

      hashCode = hashCode * 8191 + ((isSetGoal()) ? 131071 : 524287);
      if (isSetGoal())
        hashCode = hashCode * 8191 + goal.getValue();

      hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(requestTime);

      return hashCode;
    }

    @Override
    public int compareTo(unloadTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetExtent(), other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetGoal(), other.isSetGoal());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetGoal()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.goal, other.goal);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetRequestTime(), other.isSetRequestTime());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRequestTime()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.requestTime, other.requestTime);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("unloadTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("goal:");
      if (this.goal == null) {
        sb.append("null");
      } else {
        sb.append(this.goal);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("requestTime:");
      sb.append(this.requestTime);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class unloadTablet_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public unloadTablet_argsStandardScheme getScheme() {
        return new unloadTablet_argsStandardScheme();
      }
    }

    private static class unloadTablet_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<unloadTablet_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, unloadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 5: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // GOAL
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.goal = org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal.findByValue(iprot.readI32());
                struct.setGoalIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 7: // REQUEST_TIME
              if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
                struct.requestTime = iprot.readI64();
                struct.setRequestTimeIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, unloadTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.goal != null) {
          oprot.writeFieldBegin(GOAL_FIELD_DESC);
          oprot.writeI32(struct.goal.getValue());
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(REQUEST_TIME_FIELD_DESC);
        oprot.writeI64(struct.requestTime);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class unloadTablet_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public unloadTablet_argsTupleScheme getScheme() {
        return new unloadTablet_argsTupleScheme();
      }
    }

    private static class unloadTablet_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<unloadTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, unloadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        if (struct.isSetGoal()) {
          optionals.set(4);
        }
        if (struct.isSetRequestTime()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
        if (struct.isSetGoal()) {
          oprot.writeI32(struct.goal.getValue());
        }
        if (struct.isSetRequestTime()) {
          oprot.writeI64(struct.requestTime);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, unloadTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
        if (incoming.get(4)) {
          struct.goal = org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal.findByValue(iprot.readI32());
          struct.setGoalIsSet(true);
        }
        if (incoming.get(5)) {
          struct.requestTime = iprot.readI64();
          struct.setRequestTimeIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class flush_args implements org.apache.thrift.TBase<flush_args, flush_args._Fields>, java.io.Serializable, Cloneable, Comparable<flush_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("flush_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)4);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableId", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField START_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("startRow", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField END_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("endRow", org.apache.thrift.protocol.TType.STRING, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new flush_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new flush_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String tableId; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer startRow; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer endRow; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)4, "tinfo"),
      CREDENTIALS((short)1, "credentials"),
      LOCK((short)3, "lock"),
      TABLE_ID((short)2, "tableId"),
      START_ROW((short)5, "startRow"),
      END_ROW((short)6, "endRow");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 4: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 2: // TABLE_ID
            return TABLE_ID;
          case 5: // START_ROW
            return START_ROW;
          case 6: // END_ROW
            return END_ROW;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.START_ROW, new org.apache.thrift.meta_data.FieldMetaData("startRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.END_ROW, new org.apache.thrift.meta_data.FieldMetaData("endRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(flush_args.class, metaDataMap);
    }

    public flush_args() {
    }

    public flush_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      java.lang.String tableId,
      java.nio.ByteBuffer startRow,
      java.nio.ByteBuffer endRow)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.tableId = tableId;
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public flush_args(flush_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetTableId()) {
        this.tableId = other.tableId;
      }
      if (other.isSetStartRow()) {
        this.startRow = org.apache.thrift.TBaseHelper.copyBinary(other.startRow);
      }
      if (other.isSetEndRow()) {
        this.endRow = org.apache.thrift.TBaseHelper.copyBinary(other.endRow);
      }
    }

    @Override
    public flush_args deepCopy() {
      return new flush_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.tableId = null;
      this.startRow = null;
      this.endRow = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public flush_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public flush_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public flush_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getTableId() {
      return this.tableId;
    }

    public flush_args setTableId(@org.apache.thrift.annotation.Nullable java.lang.String tableId) {
      this.tableId = tableId;
      return this;
    }

    public void unsetTableId() {
      this.tableId = null;
    }

    /** Returns true if field tableId is set (has been assigned a value) and false otherwise */
    public boolean isSetTableId() {
      return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
      if (!value) {
        this.tableId = null;
      }
    }

    public byte[] getStartRow() {
      setStartRow(org.apache.thrift.TBaseHelper.rightSize(startRow));
      return startRow == null ? null : startRow.array();
    }

    public java.nio.ByteBuffer bufferForStartRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(startRow);
    }

    public flush_args setStartRow(byte[] startRow) {
      this.startRow = startRow == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(startRow.clone());
      return this;
    }

    public flush_args setStartRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer startRow) {
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      return this;
    }

    public void unsetStartRow() {
      this.startRow = null;
    }

    /** Returns true if field startRow is set (has been assigned a value) and false otherwise */
    public boolean isSetStartRow() {
      return this.startRow != null;
    }

    public void setStartRowIsSet(boolean value) {
      if (!value) {
        this.startRow = null;
      }
    }

    public byte[] getEndRow() {
      setEndRow(org.apache.thrift.TBaseHelper.rightSize(endRow));
      return endRow == null ? null : endRow.array();
    }

    public java.nio.ByteBuffer bufferForEndRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    public flush_args setEndRow(byte[] endRow) {
      this.endRow = endRow == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(endRow.clone());
      return this;
    }

    public flush_args setEndRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer endRow) {
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
      return this;
    }

    public void unsetEndRow() {
      this.endRow = null;
    }

    /** Returns true if field endRow is set (has been assigned a value) and false otherwise */
    public boolean isSetEndRow() {
      return this.endRow != null;
    }

    public void setEndRowIsSet(boolean value) {
      if (!value) {
        this.endRow = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableId();
        } else {
          setTableId((java.lang.String)value);
        }
        break;

      case START_ROW:
        if (value == null) {
          unsetStartRow();
        } else {
          if (value instanceof byte[]) {
            setStartRow((byte[])value);
          } else {
            setStartRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case END_ROW:
        if (value == null) {
          unsetEndRow();
        } else {
          if (value instanceof byte[]) {
            setEndRow((byte[])value);
          } else {
            setEndRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case TABLE_ID:
        return getTableId();

      case START_ROW:
        return getStartRow();

      case END_ROW:
        return getEndRow();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case TABLE_ID:
        return isSetTableId();
      case START_ROW:
        return isSetStartRow();
      case END_ROW:
        return isSetEndRow();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof flush_args)
        return this.equals((flush_args)that);
      return false;
    }

    public boolean equals(flush_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_tableId = true && this.isSetTableId();
      boolean that_present_tableId = true && that.isSetTableId();
      if (this_present_tableId || that_present_tableId) {
        if (!(this_present_tableId && that_present_tableId))
          return false;
        if (!this.tableId.equals(that.tableId))
          return false;
      }

      boolean this_present_startRow = true && this.isSetStartRow();
      boolean that_present_startRow = true && that.isSetStartRow();
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!this.startRow.equals(that.startRow))
          return false;
      }

      boolean this_present_endRow = true && this.isSetEndRow();
      boolean that_present_endRow = true && that.isSetEndRow();
      if (this_present_endRow || that_present_endRow) {
        if (!(this_present_endRow && that_present_endRow))
          return false;
        if (!this.endRow.equals(that.endRow))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetTableId()) ? 131071 : 524287);
      if (isSetTableId())
        hashCode = hashCode * 8191 + tableId.hashCode();

      hashCode = hashCode * 8191 + ((isSetStartRow()) ? 131071 : 524287);
      if (isSetStartRow())
        hashCode = hashCode * 8191 + startRow.hashCode();

      hashCode = hashCode * 8191 + ((isSetEndRow()) ? 131071 : 524287);
      if (isSetEndRow())
        hashCode = hashCode * 8191 + endRow.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(flush_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTableId(), other.isSetTableId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableId, other.tableId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetStartRow(), other.isSetStartRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStartRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.startRow, other.startRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetEndRow(), other.isSetEndRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEndRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.endRow, other.endRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("flush_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableId:");
      if (this.tableId == null) {
        sb.append("null");
      } else {
        sb.append(this.tableId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("startRow:");
      if (this.startRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.startRow, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("endRow:");
      if (this.endRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.endRow, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class flush_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public flush_argsStandardScheme getScheme() {
        return new flush_argsStandardScheme();
      }
    }

    private static class flush_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<flush_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, flush_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 4: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // START_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.startRow = iprot.readBinary();
                struct.setStartRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // END_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.endRow = iprot.readBinary();
                struct.setEndRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, flush_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.tableId != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableId);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.startRow != null) {
          oprot.writeFieldBegin(START_ROW_FIELD_DESC);
          oprot.writeBinary(struct.startRow);
          oprot.writeFieldEnd();
        }
        if (struct.endRow != null) {
          oprot.writeFieldBegin(END_ROW_FIELD_DESC);
          oprot.writeBinary(struct.endRow);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class flush_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public flush_argsTupleScheme getScheme() {
        return new flush_argsTupleScheme();
      }
    }

    private static class flush_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<flush_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, flush_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetTableId()) {
          optionals.set(3);
        }
        if (struct.isSetStartRow()) {
          optionals.set(4);
        }
        if (struct.isSetEndRow()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetTableId()) {
          oprot.writeString(struct.tableId);
        }
        if (struct.isSetStartRow()) {
          oprot.writeBinary(struct.startRow);
        }
        if (struct.isSetEndRow()) {
          oprot.writeBinary(struct.endRow);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, flush_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableId = iprot.readString();
          struct.setTableIdIsSet(true);
        }
        if (incoming.get(4)) {
          struct.startRow = iprot.readBinary();
          struct.setStartRowIsSet(true);
        }
        if (incoming.get(5)) {
          struct.endRow = iprot.readBinary();
          struct.setEndRowIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class flushTablet_args implements org.apache.thrift.TBase<flushTablet_args, flushTablet_args._Fields>, java.io.Serializable, Cloneable, Comparable<flushTablet_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("flushTablet_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new flushTablet_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new flushTablet_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      LOCK((short)3, "lock"),
      EXTENT((short)4, "extent");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 4: // EXTENT
            return EXTENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(flushTablet_args.class, metaDataMap);
    }

    public flushTablet_args() {
    }

    public flushTablet_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public flushTablet_args(flushTablet_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.extent);
      }
    }

    @Override
    public flushTablet_args deepCopy() {
      return new flushTablet_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public flushTablet_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public flushTablet_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public flushTablet_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public flushTablet_args setExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof flushTablet_args)
        return this.equals((flushTablet_args)that);
      return false;
    }

    public boolean equals(flushTablet_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetExtent()) ? 131071 : 524287);
      if (isSetExtent())
        hashCode = hashCode * 8191 + extent.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(flushTablet_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetExtent(), other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("flushTablet_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class flushTablet_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public flushTablet_argsStandardScheme getScheme() {
        return new flushTablet_argsStandardScheme();
      }
    }

    private static class flushTablet_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<flushTablet_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, flushTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, flushTablet_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class flushTablet_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public flushTablet_argsTupleScheme getScheme() {
        return new flushTablet_argsTupleScheme();
      }
    }

    private static class flushTablet_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<flushTablet_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, flushTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, flushTablet_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class chop_args implements org.apache.thrift.TBase<chop_args, chop_args._Fields>, java.io.Serializable, Cloneable, Comparable<chop_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("chop_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField EXTENT_FIELD_DESC = new org.apache.thrift.protocol.TField("extent", org.apache.thrift.protocol.TType.STRUCT, (short)4);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new chop_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new chop_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      LOCK((short)3, "lock"),
      EXTENT((short)4, "extent");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 4: // EXTENT
            return EXTENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.EXTENT, new org.apache.thrift.meta_data.FieldMetaData("extent", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.dataImpl.thrift.TKeyExtent.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(chop_args.class, metaDataMap);
    }

    public chop_args() {
    }

    public chop_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.extent = extent;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public chop_args(chop_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetExtent()) {
        this.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent(other.extent);
      }
    }

    @Override
    public chop_args deepCopy() {
      return new chop_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.extent = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public chop_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public chop_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public chop_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.dataImpl.thrift.TKeyExtent getExtent() {
      return this.extent;
    }

    public chop_args setExtent(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.dataImpl.thrift.TKeyExtent extent) {
      this.extent = extent;
      return this;
    }

    public void unsetExtent() {
      this.extent = null;
    }

    /** Returns true if field extent is set (has been assigned a value) and false otherwise */
    public boolean isSetExtent() {
      return this.extent != null;
    }

    public void setExtentIsSet(boolean value) {
      if (!value) {
        this.extent = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case EXTENT:
        if (value == null) {
          unsetExtent();
        } else {
          setExtent((org.apache.accumulo.core.dataImpl.thrift.TKeyExtent)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case EXTENT:
        return getExtent();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case EXTENT:
        return isSetExtent();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof chop_args)
        return this.equals((chop_args)that);
      return false;
    }

    public boolean equals(chop_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_extent = true && this.isSetExtent();
      boolean that_present_extent = true && that.isSetExtent();
      if (this_present_extent || that_present_extent) {
        if (!(this_present_extent && that_present_extent))
          return false;
        if (!this.extent.equals(that.extent))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetExtent()) ? 131071 : 524287);
      if (isSetExtent())
        hashCode = hashCode * 8191 + extent.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(chop_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetExtent(), other.isSetExtent());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetExtent()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.extent, other.extent);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("chop_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("extent:");
      if (this.extent == null) {
        sb.append("null");
      } else {
        sb.append(this.extent);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
      if (extent != null) {
        extent.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class chop_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public chop_argsStandardScheme getScheme() {
        return new chop_argsStandardScheme();
      }
    }

    private static class chop_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<chop_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, chop_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // EXTENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
                struct.extent.read(iprot);
                struct.setExtentIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, chop_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.extent != null) {
          oprot.writeFieldBegin(EXTENT_FIELD_DESC);
          struct.extent.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class chop_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public chop_argsTupleScheme getScheme() {
        return new chop_argsTupleScheme();
      }
    }

    private static class chop_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<chop_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, chop_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetExtent()) {
          optionals.set(3);
        }
        oprot.writeBitSet(optionals, 4);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetExtent()) {
          struct.extent.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, chop_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(4);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.extent = new org.apache.accumulo.core.dataImpl.thrift.TKeyExtent();
          struct.extent.read(iprot);
          struct.setExtentIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class compact_args implements org.apache.thrift.TBase<compact_args, compact_args._Fields>, java.io.Serializable, Cloneable, Comparable<compact_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("compact_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField LOCK_FIELD_DESC = new org.apache.thrift.protocol.TField("lock", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField TABLE_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("tableId", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField START_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("startRow", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField END_ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("endRow", org.apache.thrift.protocol.TType.STRING, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new compact_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new compact_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String lock; // required
    public @org.apache.thrift.annotation.Nullable java.lang.String tableId; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer startRow; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer endRow; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)1, "tinfo"),
      CREDENTIALS((short)2, "credentials"),
      LOCK((short)3, "lock"),
      TABLE_ID((short)4, "tableId"),
      START_ROW((short)5, "startRow"),
      END_ROW((short)6, "endRow");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TINFO
            return TINFO;
          case 2: // CREDENTIALS
            return CREDENTIALS;
          case 3: // LOCK
            return LOCK;
          case 4: // TABLE_ID
            return TABLE_ID;
          case 5: // START_ROW
            return START_ROW;
          case 6: // END_ROW
            return END_ROW;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      tmpMap.put(_Fields.LOCK, new org.apache.thrift.meta_data.FieldMetaData("lock", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.TABLE_ID, new org.apache.thrift.meta_data.FieldMetaData("tableId", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
      tmpMap.put(_Fields.START_ROW, new org.apache.thrift.meta_data.FieldMetaData("startRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.END_ROW, new org.apache.thrift.meta_data.FieldMetaData("endRow", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(compact_args.class, metaDataMap);
    }

    public compact_args() {
    }

    public compact_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials,
      java.lang.String lock,
      java.lang.String tableId,
      java.nio.ByteBuffer startRow,
      java.nio.ByteBuffer endRow)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
      this.lock = lock;
      this.tableId = tableId;
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public compact_args(compact_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
      if (other.isSetLock()) {
        this.lock = other.lock;
      }
      if (other.isSetTableId()) {
        this.tableId = other.tableId;
      }
      if (other.isSetStartRow()) {
        this.startRow = org.apache.thrift.TBaseHelper.copyBinary(other.startRow);
      }
      if (other.isSetEndRow()) {
        this.endRow = org.apache.thrift.TBaseHelper.copyBinary(other.endRow);
      }
    }

    @Override
    public compact_args deepCopy() {
      return new compact_args(this);
    }

    @Override
    public void clear() {
      this.tinfo = null;
      this.credentials = null;
      this.lock = null;
      this.tableId = null;
      this.startRow = null;
      this.endRow = null;
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.trace.thrift.TInfo getTinfo() {
      return this.tinfo;
    }

    public compact_args setTinfo(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo) {
      this.tinfo = tinfo;
      return this;
    }

    public void unsetTinfo() {
      this.tinfo = null;
    }

    /** Returns true if field tinfo is set (has been assigned a value) and false otherwise */
    public boolean isSetTinfo() {
      return this.tinfo != null;
    }

    public void setTinfoIsSet(boolean value) {
      if (!value) {
        this.tinfo = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public org.apache.accumulo.core.securityImpl.thrift.TCredentials getCredentials() {
      return this.credentials;
    }

    public compact_args setCredentials(@org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials) {
      this.credentials = credentials;
      return this;
    }

    public void unsetCredentials() {
      this.credentials = null;
    }

    /** Returns true if field credentials is set (has been assigned a value) and false otherwise */
    public boolean isSetCredentials() {
      return this.credentials != null;
    }

    public void setCredentialsIsSet(boolean value) {
      if (!value) {
        this.credentials = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getLock() {
      return this.lock;
    }

    public compact_args setLock(@org.apache.thrift.annotation.Nullable java.lang.String lock) {
      this.lock = lock;
      return this;
    }

    public void unsetLock() {
      this.lock = null;
    }

    /** Returns true if field lock is set (has been assigned a value) and false otherwise */
    public boolean isSetLock() {
      return this.lock != null;
    }

    public void setLockIsSet(boolean value) {
      if (!value) {
        this.lock = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.String getTableId() {
      return this.tableId;
    }

    public compact_args setTableId(@org.apache.thrift.annotation.Nullable java.lang.String tableId) {
      this.tableId = tableId;
      return this;
    }

    public void unsetTableId() {
      this.tableId = null;
    }

    /** Returns true if field tableId is set (has been assigned a value) and false otherwise */
    public boolean isSetTableId() {
      return this.tableId != null;
    }

    public void setTableIdIsSet(boolean value) {
      if (!value) {
        this.tableId = null;
      }
    }

    public byte[] getStartRow() {
      setStartRow(org.apache.thrift.TBaseHelper.rightSize(startRow));
      return startRow == null ? null : startRow.array();
    }

    public java.nio.ByteBuffer bufferForStartRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(startRow);
    }

    public compact_args setStartRow(byte[] startRow) {
      this.startRow = startRow == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(startRow.clone());
      return this;
    }

    public compact_args setStartRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer startRow) {
      this.startRow = org.apache.thrift.TBaseHelper.copyBinary(startRow);
      return this;
    }

    public void unsetStartRow() {
      this.startRow = null;
    }

    /** Returns true if field startRow is set (has been assigned a value) and false otherwise */
    public boolean isSetStartRow() {
      return this.startRow != null;
    }

    public void setStartRowIsSet(boolean value) {
      if (!value) {
        this.startRow = null;
      }
    }

    public byte[] getEndRow() {
      setEndRow(org.apache.thrift.TBaseHelper.rightSize(endRow));
      return endRow == null ? null : endRow.array();
    }

    public java.nio.ByteBuffer bufferForEndRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(endRow);
    }

    public compact_args setEndRow(byte[] endRow) {
      this.endRow = endRow == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(endRow.clone());
      return this;
    }

    public compact_args setEndRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer endRow) {
      this.endRow = org.apache.thrift.TBaseHelper.copyBinary(endRow);
      return this;
    }

    public void unsetEndRow() {
      this.endRow = null;
    }

    /** Returns true if field endRow is set (has been assigned a value) and false otherwise */
    public boolean isSetEndRow() {
      return this.endRow != null;
    }

    public void setEndRowIsSet(boolean value) {
      if (!value) {
        this.endRow = null;
      }
    }

    @Override
    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TINFO:
        if (value == null) {
          unsetTinfo();
        } else {
          setTinfo((org.apache.accumulo.core.trace.thrift.TInfo)value);
        }
        break;

      case CREDENTIALS:
        if (value == null) {
          unsetCredentials();
        } else {
          setCredentials((org.apache.accumulo.core.securityImpl.thrift.TCredentials)value);
        }
        break;

      case LOCK:
        if (value == null) {
          unsetLock();
        } else {
          setLock((java.lang.String)value);
        }
        break;

      case TABLE_ID:
        if (value == null) {
          unsetTableId();
        } else {
          setTableId((java.lang.String)value);
        }
        break;

      case START_ROW:
        if (value == null) {
          unsetStartRow();
        } else {
          if (value instanceof byte[]) {
            setStartRow((byte[])value);
          } else {
            setStartRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case END_ROW:
        if (value == null) {
          unsetEndRow();
        } else {
          if (value instanceof byte[]) {
            setEndRow((byte[])value);
          } else {
            setEndRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TINFO:
        return getTinfo();

      case CREDENTIALS:
        return getCredentials();

      case LOCK:
        return getLock();

      case TABLE_ID:
        return getTableId();

      case START_ROW:
        return getStartRow();

      case END_ROW:
        return getEndRow();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    @Override
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TINFO:
        return isSetTinfo();
      case CREDENTIALS:
        return isSetCredentials();
      case LOCK:
        return isSetLock();
      case TABLE_ID:
        return isSetTableId();
      case START_ROW:
        return isSetStartRow();
      case END_ROW:
        return isSetEndRow();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof compact_args)
        return this.equals((compact_args)that);
      return false;
    }

    public boolean equals(compact_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_tinfo = true && this.isSetTinfo();
      boolean that_present_tinfo = true && that.isSetTinfo();
      if (this_present_tinfo || that_present_tinfo) {
        if (!(this_present_tinfo && that_present_tinfo))
          return false;
        if (!this.tinfo.equals(that.tinfo))
          return false;
      }

      boolean this_present_credentials = true && this.isSetCredentials();
      boolean that_present_credentials = true && that.isSetCredentials();
      if (this_present_credentials || that_present_credentials) {
        if (!(this_present_credentials && that_present_credentials))
          return false;
        if (!this.credentials.equals(that.credentials))
          return false;
      }

      boolean this_present_lock = true && this.isSetLock();
      boolean that_present_lock = true && that.isSetLock();
      if (this_present_lock || that_present_lock) {
        if (!(this_present_lock && that_present_lock))
          return false;
        if (!this.lock.equals(that.lock))
          return false;
      }

      boolean this_present_tableId = true && this.isSetTableId();
      boolean that_present_tableId = true && that.isSetTableId();
      if (this_present_tableId || that_present_tableId) {
        if (!(this_present_tableId && that_present_tableId))
          return false;
        if (!this.tableId.equals(that.tableId))
          return false;
      }

      boolean this_present_startRow = true && this.isSetStartRow();
      boolean that_present_startRow = true && that.isSetStartRow();
      if (this_present_startRow || that_present_startRow) {
        if (!(this_present_startRow && that_present_startRow))
          return false;
        if (!this.startRow.equals(that.startRow))
          return false;
      }

      boolean this_present_endRow = true && this.isSetEndRow();
      boolean that_present_endRow = true && that.isSetEndRow();
      if (this_present_endRow || that_present_endRow) {
        if (!(this_present_endRow && that_present_endRow))
          return false;
        if (!this.endRow.equals(that.endRow))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTinfo()) ? 131071 : 524287);
      if (isSetTinfo())
        hashCode = hashCode * 8191 + tinfo.hashCode();

      hashCode = hashCode * 8191 + ((isSetCredentials()) ? 131071 : 524287);
      if (isSetCredentials())
        hashCode = hashCode * 8191 + credentials.hashCode();

      hashCode = hashCode * 8191 + ((isSetLock()) ? 131071 : 524287);
      if (isSetLock())
        hashCode = hashCode * 8191 + lock.hashCode();

      hashCode = hashCode * 8191 + ((isSetTableId()) ? 131071 : 524287);
      if (isSetTableId())
        hashCode = hashCode * 8191 + tableId.hashCode();

      hashCode = hashCode * 8191 + ((isSetStartRow()) ? 131071 : 524287);
      if (isSetStartRow())
        hashCode = hashCode * 8191 + startRow.hashCode();

      hashCode = hashCode * 8191 + ((isSetEndRow()) ? 131071 : 524287);
      if (isSetEndRow())
        hashCode = hashCode * 8191 + endRow.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(compact_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTinfo(), other.isSetTinfo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTinfo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tinfo, other.tinfo);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetCredentials(), other.isSetCredentials());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetCredentials()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.credentials, other.credentials);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetLock(), other.isSetLock());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetLock()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.lock, other.lock);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTableId(), other.isSetTableId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTableId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tableId, other.tableId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetStartRow(), other.isSetStartRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetStartRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.startRow, other.startRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetEndRow(), other.isSetEndRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetEndRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.endRow, other.endRow);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    @Override
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("compact_args(");
      boolean first = true;

      sb.append("tinfo:");
      if (this.tinfo == null) {
        sb.append("null");
      } else {
        sb.append(this.tinfo);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("credentials:");
      if (this.credentials == null) {
        sb.append("null");
      } else {
        sb.append(this.credentials);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("lock:");
      if (this.lock == null) {
        sb.append("null");
      } else {
        sb.append(this.lock);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tableId:");
      if (this.tableId == null) {
        sb.append("null");
      } else {
        sb.append(this.tableId);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("startRow:");
      if (this.startRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.startRow, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("endRow:");
      if (this.endRow == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.endRow, sb);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (tinfo != null) {
        tinfo.validate();
      }
      if (credentials != null) {
        credentials.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class compact_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public compact_argsStandardScheme getScheme() {
        return new compact_argsStandardScheme();
      }
    }

    private static class compact_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<compact_args> {

      @Override
      public void read(org.apache.thrift.protocol.TProtocol iprot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TINFO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
                struct.tinfo.read(iprot);
                struct.setTinfoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // CREDENTIALS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
                struct.credentials.read(iprot);
                struct.setCredentialsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // LOCK
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.lock = iprot.readString();
                struct.setLockIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // TABLE_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.tableId = iprot.readString();
                struct.setTableIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // START_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.startRow = iprot.readBinary();
                struct.setStartRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // END_ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.endRow = iprot.readBinary();
                struct.setEndRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      @Override
      public void write(org.apache.thrift.protocol.TProtocol oprot, compact_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.tinfo != null) {
          oprot.writeFieldBegin(TINFO_FIELD_DESC);
          struct.tinfo.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.credentials != null) {
          oprot.writeFieldBegin(CREDENTIALS_FIELD_DESC);
          struct.credentials.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.lock != null) {
          oprot.writeFieldBegin(LOCK_FIELD_DESC);
          oprot.writeString(struct.lock);
          oprot.writeFieldEnd();
        }
        if (struct.tableId != null) {
          oprot.writeFieldBegin(TABLE_ID_FIELD_DESC);
          oprot.writeString(struct.tableId);
          oprot.writeFieldEnd();
        }
        if (struct.startRow != null) {
          oprot.writeFieldBegin(START_ROW_FIELD_DESC);
          oprot.writeBinary(struct.startRow);
          oprot.writeFieldEnd();
        }
        if (struct.endRow != null) {
          oprot.writeFieldBegin(END_ROW_FIELD_DESC);
          oprot.writeBinary(struct.endRow);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class compact_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      @Override
      public compact_argsTupleScheme getScheme() {
        return new compact_argsTupleScheme();
      }
    }

    private static class compact_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<compact_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetTinfo()) {
          optionals.set(0);
        }
        if (struct.isSetCredentials()) {
          optionals.set(1);
        }
        if (struct.isSetLock()) {
          optionals.set(2);
        }
        if (struct.isSetTableId()) {
          optionals.set(3);
        }
        if (struct.isSetStartRow()) {
          optionals.set(4);
        }
        if (struct.isSetEndRow()) {
          optionals.set(5);
        }
        oprot.writeBitSet(optionals, 6);
        if (struct.isSetTinfo()) {
          struct.tinfo.write(oprot);
        }
        if (struct.isSetCredentials()) {
          struct.credentials.write(oprot);
        }
        if (struct.isSetLock()) {
          oprot.writeString(struct.lock);
        }
        if (struct.isSetTableId()) {
          oprot.writeString(struct.tableId);
        }
        if (struct.isSetStartRow()) {
          oprot.writeBinary(struct.startRow);
        }
        if (struct.isSetEndRow()) {
          oprot.writeBinary(struct.endRow);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, compact_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(6);
        if (incoming.get(0)) {
          struct.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo();
          struct.tinfo.read(iprot);
          struct.setTinfoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials();
          struct.credentials.read(iprot);
          struct.setCredentialsIsSet(true);
        }
        if (incoming.get(2)) {
          struct.lock = iprot.readString();
          struct.setLockIsSet(true);
        }
        if (incoming.get(3)) {
          struct.tableId = iprot.readString();
          struct.setTableIdIsSet(true);
        }
        if (incoming.get(4)) {
          struct.startRow = iprot.readBinary();
          struct.setStartRowIsSet(true);
        }
        if (incoming.get(5)) {
          struct.endRow = iprot.readBinary();
          struct.setEndRowIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  @SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
  public static class getTabletServerStatus_args implements org.apache.thrift.TBase<getTabletServerStatus_args, getTabletServerStatus_args._Fields>, java.io.Serializable, Cloneable, Comparable<getTabletServerStatus_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getTabletServerStatus_args");

    private static final org.apache.thrift.protocol.TField TINFO_FIELD_DESC = new org.apache.thrift.protocol.TField("tinfo", org.apache.thrift.protocol.TType.STRUCT, (short)3);
    private static final org.apache.thrift.protocol.TField CREDENTIALS_FIELD_DESC = new org.apache.thrift.protocol.TField("credentials", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getTabletServerStatus_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getTabletServerStatus_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.trace.thrift.TInfo tinfo; // required
    public @org.apache.thrift.annotation.Nullable org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TINFO((short)3, "tinfo"),
      CREDENTIALS((short)1, "credentials");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 3: // TINFO
            return TINFO;
          case 1: // CREDENTIALS
            return CREDENTIALS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      @Override
      public short getThriftFieldId() {
        return _thriftId;
      }

      @Override
      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TINFO, new org.apache.thrift.meta_data.FieldMetaData("tinfo", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.trace.thrift.TInfo.class)));
      tmpMap.put(_Fields.CREDENTIALS, new org.apache.thrift.meta_data.FieldMetaData("credentials", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, org.apache.accumulo.core.securityImpl.thrift.TCredentials.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getTabletServerStatus_args.class, metaDataMap);
    }

    public getTabletServerStatus_args() {
    }

    public getTabletServerStatus_args(
      org.apache.accumulo.core.trace.thrift.TInfo tinfo,
      org.apache.accumulo.core.securityImpl.thrift.TCredentials credentials)
    {
      this();
      this.tinfo = tinfo;
      this.credentials = credentials;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getTabletServerStatus_args(getTabletServerStatus_args other) {
      if (other.isSetTinfo()) {
        this.tinfo = new org.apache.accumulo.core.trace.thrift.TInfo(other.tinfo);
      }
      if (other.isSetCredentials()) {
        this.credentials = new org.apache.accumulo.core.securityImpl.thrift.TCredentials(other.credentials);
      }
    }

    @Override
    public getTabletServerStatus_args deepCopy(